
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataDimensionItemType",
    "dataElement",
    "dataElementOperand",
    "expressionDimensionItem",
    "indicator",
    "programAttribute",
    "programDataElement",
    "programIndicator",
    "reportingRate",
    "subexpressionDimensionItem"
})
@Generated("jsonschema2pojo")
public class DataDimensionItem implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionItemType")
    private DataDimensionItem.DataDimensionItemTypeRef dataDimensionItemType;
    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID reference to a DataElement  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private DataElementRef dataElement;
    @JsonProperty("dataElementOperand")
    private DataElementOperand dataElementOperand;
    /**
     * A UID reference to a ExpressionDimensionItem  
     * (Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`)
     * 
     */
    @JsonProperty("expressionDimensionItem")
    @JsonPropertyDescription("A UID reference to a ExpressionDimensionItem  \n(Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`)")
    private ExpressionDimensionItemRef expressionDimensionItem;
    /**
     * A UID reference to a Indicator  
     * (Java name `org.hisp.dhis.indicator.Indicator`)
     * 
     */
    @JsonProperty("indicator")
    @JsonPropertyDescription("A UID reference to a Indicator  \n(Java name `org.hisp.dhis.indicator.Indicator`)")
    private IndicatorRef indicator;
    @JsonProperty("programAttribute")
    private ProgramTrackedEntityAttributeDimensionItem programAttribute;
    @JsonProperty("programDataElement")
    private ProgramDataElementDimensionItem programDataElement;
    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    @JsonPropertyDescription("A UID reference to a ProgramIndicator  \n(Java name `org.hisp.dhis.program.ProgramIndicator`)")
    private ProgramIndicatorRef programIndicator;
    @JsonProperty("reportingRate")
    private ReportingRate reportingRate;
    /**
     * A UID reference to a SubexpressionDimensionItem  
     * (Java name `org.hisp.dhis.subexpression.SubexpressionDimensionItem`)
     * 
     */
    @JsonProperty("subexpressionDimensionItem")
    @JsonPropertyDescription("A UID reference to a SubexpressionDimensionItem  \n(Java name `org.hisp.dhis.subexpression.SubexpressionDimensionItem`)")
    private SubexpressionDimensionItemRef subexpressionDimensionItem;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 383974067978052095L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataDimensionItem() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataDimensionItem(DataDimensionItem source) {
        super();
        this.dataDimensionItemType = source.dataDimensionItemType;
        this.dataElement = source.dataElement;
        this.dataElementOperand = source.dataElementOperand;
        this.expressionDimensionItem = source.expressionDimensionItem;
        this.indicator = source.indicator;
        this.programAttribute = source.programAttribute;
        this.programDataElement = source.programDataElement;
        this.programIndicator = source.programIndicator;
        this.reportingRate = source.reportingRate;
        this.subexpressionDimensionItem = source.subexpressionDimensionItem;
    }

    /**
     * 
     * @param indicator
     *     A UID reference to a Indicator  
     *     (Java name `org.hisp.dhis.indicator.Indicator`).
     * @param programIndicator
     *     A UID reference to a ProgramIndicator  
     *     (Java name `org.hisp.dhis.program.ProgramIndicator`).
     * @param dataElement
     *     A UID reference to a DataElement  
     *     (Java name `org.hisp.dhis.dataelement.DataElement`).
     * @param subexpressionDimensionItem
     *     A UID reference to a SubexpressionDimensionItem  
     *     (Java name `org.hisp.dhis.subexpression.SubexpressionDimensionItem`).
     * @param expressionDimensionItem
     *     A UID reference to a ExpressionDimensionItem  
     *     (Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`).
     */
    public DataDimensionItem(DataDimensionItem.DataDimensionItemTypeRef dataDimensionItemType, DataElementRef dataElement, DataElementOperand dataElementOperand, ExpressionDimensionItemRef expressionDimensionItem, IndicatorRef indicator, ProgramTrackedEntityAttributeDimensionItem programAttribute, ProgramDataElementDimensionItem programDataElement, ProgramIndicatorRef programIndicator, ReportingRate reportingRate, SubexpressionDimensionItemRef subexpressionDimensionItem) {
        super();
        this.dataDimensionItemType = dataDimensionItemType;
        this.dataElement = dataElement;
        this.dataElementOperand = dataElementOperand;
        this.expressionDimensionItem = expressionDimensionItem;
        this.indicator = indicator;
        this.programAttribute = programAttribute;
        this.programDataElement = programDataElement;
        this.programIndicator = programIndicator;
        this.reportingRate = reportingRate;
        this.subexpressionDimensionItem = subexpressionDimensionItem;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionItemType")
    public DataDimensionItem.DataDimensionItemTypeRef getDataDimensionItemType() {
        return dataDimensionItemType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionItemType")
    public void setDataDimensionItemType(DataDimensionItem.DataDimensionItemTypeRef dataDimensionItemType) {
        this.dataDimensionItemType = dataDimensionItemType;
    }

    public DataDimensionItem withDataDimensionItemType(DataDimensionItem.DataDimensionItemTypeRef dataDimensionItemType) {
        this.dataDimensionItemType = dataDimensionItemType;
        return this;
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<DataElementRef> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(DataElementRef dataElement) {
        this.dataElement = dataElement;
    }

    public DataDimensionItem withDataElement(DataElementRef dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("dataElementOperand")
    public Optional<DataElementOperand> getDataElementOperand() {
        return Optional.ofNullable(dataElementOperand);
    }

    @JsonProperty("dataElementOperand")
    public void setDataElementOperand(DataElementOperand dataElementOperand) {
        this.dataElementOperand = dataElementOperand;
    }

    public DataDimensionItem withDataElementOperand(DataElementOperand dataElementOperand) {
        this.dataElementOperand = dataElementOperand;
        return this;
    }

    /**
     * A UID reference to a ExpressionDimensionItem  
     * (Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`)
     * 
     */
    @JsonProperty("expressionDimensionItem")
    public Optional<ExpressionDimensionItemRef> getExpressionDimensionItem() {
        return Optional.ofNullable(expressionDimensionItem);
    }

    /**
     * A UID reference to a ExpressionDimensionItem  
     * (Java name `org.hisp.dhis.expressiondimensionitem.ExpressionDimensionItem`)
     * 
     */
    @JsonProperty("expressionDimensionItem")
    public void setExpressionDimensionItem(ExpressionDimensionItemRef expressionDimensionItem) {
        this.expressionDimensionItem = expressionDimensionItem;
    }

    public DataDimensionItem withExpressionDimensionItem(ExpressionDimensionItemRef expressionDimensionItem) {
        this.expressionDimensionItem = expressionDimensionItem;
        return this;
    }

    /**
     * A UID reference to a Indicator  
     * (Java name `org.hisp.dhis.indicator.Indicator`)
     * 
     */
    @JsonProperty("indicator")
    public Optional<IndicatorRef> getIndicator() {
        return Optional.ofNullable(indicator);
    }

    /**
     * A UID reference to a Indicator  
     * (Java name `org.hisp.dhis.indicator.Indicator`)
     * 
     */
    @JsonProperty("indicator")
    public void setIndicator(IndicatorRef indicator) {
        this.indicator = indicator;
    }

    public DataDimensionItem withIndicator(IndicatorRef indicator) {
        this.indicator = indicator;
        return this;
    }

    @JsonProperty("programAttribute")
    public Optional<ProgramTrackedEntityAttributeDimensionItem> getProgramAttribute() {
        return Optional.ofNullable(programAttribute);
    }

    @JsonProperty("programAttribute")
    public void setProgramAttribute(ProgramTrackedEntityAttributeDimensionItem programAttribute) {
        this.programAttribute = programAttribute;
    }

    public DataDimensionItem withProgramAttribute(ProgramTrackedEntityAttributeDimensionItem programAttribute) {
        this.programAttribute = programAttribute;
        return this;
    }

    @JsonProperty("programDataElement")
    public Optional<ProgramDataElementDimensionItem> getProgramDataElement() {
        return Optional.ofNullable(programDataElement);
    }

    @JsonProperty("programDataElement")
    public void setProgramDataElement(ProgramDataElementDimensionItem programDataElement) {
        this.programDataElement = programDataElement;
    }

    public DataDimensionItem withProgramDataElement(ProgramDataElementDimensionItem programDataElement) {
        this.programDataElement = programDataElement;
        return this;
    }

    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    public Optional<ProgramIndicatorRef> getProgramIndicator() {
        return Optional.ofNullable(programIndicator);
    }

    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    public void setProgramIndicator(ProgramIndicatorRef programIndicator) {
        this.programIndicator = programIndicator;
    }

    public DataDimensionItem withProgramIndicator(ProgramIndicatorRef programIndicator) {
        this.programIndicator = programIndicator;
        return this;
    }

    @JsonProperty("reportingRate")
    public Optional<ReportingRate> getReportingRate() {
        return Optional.ofNullable(reportingRate);
    }

    @JsonProperty("reportingRate")
    public void setReportingRate(ReportingRate reportingRate) {
        this.reportingRate = reportingRate;
    }

    public DataDimensionItem withReportingRate(ReportingRate reportingRate) {
        this.reportingRate = reportingRate;
        return this;
    }

    /**
     * A UID reference to a SubexpressionDimensionItem  
     * (Java name `org.hisp.dhis.subexpression.SubexpressionDimensionItem`)
     * 
     */
    @JsonProperty("subexpressionDimensionItem")
    public Optional<SubexpressionDimensionItemRef> getSubexpressionDimensionItem() {
        return Optional.ofNullable(subexpressionDimensionItem);
    }

    /**
     * A UID reference to a SubexpressionDimensionItem  
     * (Java name `org.hisp.dhis.subexpression.SubexpressionDimensionItem`)
     * 
     */
    @JsonProperty("subexpressionDimensionItem")
    public void setSubexpressionDimensionItem(SubexpressionDimensionItemRef subexpressionDimensionItem) {
        this.subexpressionDimensionItem = subexpressionDimensionItem;
    }

    public DataDimensionItem withSubexpressionDimensionItem(SubexpressionDimensionItemRef subexpressionDimensionItem) {
        this.subexpressionDimensionItem = subexpressionDimensionItem;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataDimensionItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataDimensionItemType".equals(name)) {
            if (value instanceof DataDimensionItem.DataDimensionItemTypeRef) {
                setDataDimensionItemType(((DataDimensionItem.DataDimensionItemTypeRef) value));
            } else {
                throw new IllegalArgumentException(("property \"dataDimensionItemType\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataDimensionItem.DataDimensionItemTypeRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataElement".equals(name)) {
                if (value instanceof DataElementRef) {
                    setDataElement(((DataElementRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataElementRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataElementOperand".equals(name)) {
                    if (value instanceof DataElementOperand) {
                        setDataElementOperand(((DataElementOperand) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataElementOperand\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataElementOperand\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("expressionDimensionItem".equals(name)) {
                        if (value instanceof ExpressionDimensionItemRef) {
                            setExpressionDimensionItem(((ExpressionDimensionItemRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"expressionDimensionItem\" is of type \"org.hisp.dhis.api.model.v40_2_2.ExpressionDimensionItemRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("indicator".equals(name)) {
                            if (value instanceof IndicatorRef) {
                                setIndicator(((IndicatorRef) value));
                            } else {
                                throw new IllegalArgumentException(("property \"indicator\" is of type \"org.hisp.dhis.api.model.v40_2_2.IndicatorRef\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("programAttribute".equals(name)) {
                                if (value instanceof ProgramTrackedEntityAttributeDimensionItem) {
                                    setProgramAttribute(((ProgramTrackedEntityAttributeDimensionItem) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"programAttribute\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramTrackedEntityAttributeDimensionItem\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("programDataElement".equals(name)) {
                                    if (value instanceof ProgramDataElementDimensionItem) {
                                        setProgramDataElement(((ProgramDataElementDimensionItem) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"programDataElement\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramDataElementDimensionItem\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("programIndicator".equals(name)) {
                                        if (value instanceof ProgramIndicatorRef) {
                                            setProgramIndicator(((ProgramIndicatorRef) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"programIndicator\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramIndicatorRef\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("reportingRate".equals(name)) {
                                            if (value instanceof ReportingRate) {
                                                setReportingRate(((ReportingRate) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"reportingRate\" is of type \"org.hisp.dhis.api.model.v40_2_2.ReportingRate\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("subexpressionDimensionItem".equals(name)) {
                                                if (value instanceof SubexpressionDimensionItemRef) {
                                                    setSubexpressionDimensionItem(((SubexpressionDimensionItemRef) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"subexpressionDimensionItem\" is of type \"org.hisp.dhis.api.model.v40_2_2.SubexpressionDimensionItemRef\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataDimensionItemType".equals(name)) {
            return getDataDimensionItemType();
        } else {
            if ("dataElement".equals(name)) {
                return getDataElement();
            } else {
                if ("dataElementOperand".equals(name)) {
                    return getDataElementOperand();
                } else {
                    if ("expressionDimensionItem".equals(name)) {
                        return getExpressionDimensionItem();
                    } else {
                        if ("indicator".equals(name)) {
                            return getIndicator();
                        } else {
                            if ("programAttribute".equals(name)) {
                                return getProgramAttribute();
                            } else {
                                if ("programDataElement".equals(name)) {
                                    return getProgramDataElement();
                                } else {
                                    if ("programIndicator".equals(name)) {
                                        return getProgramIndicator();
                                    } else {
                                        if ("reportingRate".equals(name)) {
                                            return getReportingRate();
                                        } else {
                                            if ("subexpressionDimensionItem".equals(name)) {
                                                return getSubexpressionDimensionItem();
                                            } else {
                                                return notFoundValue;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataDimensionItem.NOT_FOUND_VALUE);
        if (DataDimensionItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataDimensionItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataDimensionItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataDimensionItemType");
        sb.append('=');
        sb.append(((this.dataDimensionItemType == null)?"<null>":this.dataDimensionItemType));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("dataElementOperand");
        sb.append('=');
        sb.append(((this.dataElementOperand == null)?"<null>":this.dataElementOperand));
        sb.append(',');
        sb.append("expressionDimensionItem");
        sb.append('=');
        sb.append(((this.expressionDimensionItem == null)?"<null>":this.expressionDimensionItem));
        sb.append(',');
        sb.append("indicator");
        sb.append('=');
        sb.append(((this.indicator == null)?"<null>":this.indicator));
        sb.append(',');
        sb.append("programAttribute");
        sb.append('=');
        sb.append(((this.programAttribute == null)?"<null>":this.programAttribute));
        sb.append(',');
        sb.append("programDataElement");
        sb.append('=');
        sb.append(((this.programDataElement == null)?"<null>":this.programDataElement));
        sb.append(',');
        sb.append("programIndicator");
        sb.append('=');
        sb.append(((this.programIndicator == null)?"<null>":this.programIndicator));
        sb.append(',');
        sb.append("reportingRate");
        sb.append('=');
        sb.append(((this.reportingRate == null)?"<null>":this.reportingRate));
        sb.append(',');
        sb.append("subexpressionDimensionItem");
        sb.append('=');
        sb.append(((this.subexpressionDimensionItem == null)?"<null>":this.subexpressionDimensionItem));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.indicator == null)? 0 :this.indicator.hashCode()));
        result = ((result* 31)+((this.programDataElement == null)? 0 :this.programDataElement.hashCode()));
        result = ((result* 31)+((this.reportingRate == null)? 0 :this.reportingRate.hashCode()));
        result = ((result* 31)+((this.dataElementOperand == null)? 0 :this.dataElementOperand.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.expressionDimensionItem == null)? 0 :this.expressionDimensionItem.hashCode()));
        result = ((result* 31)+((this.programAttribute == null)? 0 :this.programAttribute.hashCode()));
        result = ((result* 31)+((this.dataDimensionItemType == null)? 0 :this.dataDimensionItemType.hashCode()));
        result = ((result* 31)+((this.programIndicator == null)? 0 :this.programIndicator.hashCode()));
        result = ((result* 31)+((this.subexpressionDimensionItem == null)? 0 :this.subexpressionDimensionItem.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataDimensionItem) == false) {
            return false;
        }
        DataDimensionItem rhs = ((DataDimensionItem) other);
        return ((((((((((((this.indicator == rhs.indicator)||((this.indicator!= null)&&this.indicator.equals(rhs.indicator)))&&((this.programDataElement == rhs.programDataElement)||((this.programDataElement!= null)&&this.programDataElement.equals(rhs.programDataElement))))&&((this.reportingRate == rhs.reportingRate)||((this.reportingRate!= null)&&this.reportingRate.equals(rhs.reportingRate))))&&((this.dataElementOperand == rhs.dataElementOperand)||((this.dataElementOperand!= null)&&this.dataElementOperand.equals(rhs.dataElementOperand))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.expressionDimensionItem == rhs.expressionDimensionItem)||((this.expressionDimensionItem!= null)&&this.expressionDimensionItem.equals(rhs.expressionDimensionItem))))&&((this.programAttribute == rhs.programAttribute)||((this.programAttribute!= null)&&this.programAttribute.equals(rhs.programAttribute))))&&((this.dataDimensionItemType == rhs.dataDimensionItemType)||((this.dataDimensionItemType!= null)&&this.dataDimensionItemType.equals(rhs.dataDimensionItemType))))&&((this.programIndicator == rhs.programIndicator)||((this.programIndicator!= null)&&this.programIndicator.equals(rhs.programIndicator))))&&((this.subexpressionDimensionItem == rhs.subexpressionDimensionItem)||((this.subexpressionDimensionItem!= null)&&this.subexpressionDimensionItem.equals(rhs.subexpressionDimensionItem))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum DataDimensionItemTypeRef {

        INDICATOR("INDICATOR"),
        DATA_ELEMENT("DATA_ELEMENT"),
        DATA_ELEMENT_OPERAND("DATA_ELEMENT_OPERAND"),
        REPORTING_RATE("REPORTING_RATE"),
        PROGRAM_INDICATOR("PROGRAM_INDICATOR"),
        PROGRAM_DATA_ELEMENT("PROGRAM_DATA_ELEMENT"),
        PROGRAM_ATTRIBUTE("PROGRAM_ATTRIBUTE"),
        EXPRESSION_DIMENSION_ITEM("EXPRESSION_DIMENSION_ITEM"),
        SUBEXPRESSION_DIMENSION_ITEM("SUBEXPRESSION_DIMENSION_ITEM"),
        VALIDATION_RULE("VALIDATION_RULE");
        private final String value;
        private final static Map<String, DataDimensionItem.DataDimensionItemTypeRef> CONSTANTS = new HashMap<String, DataDimensionItem.DataDimensionItemTypeRef>();

        static {
            for (DataDimensionItem.DataDimensionItemTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataDimensionItemTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataDimensionItem.DataDimensionItemTypeRef fromValue(String value) {
            DataDimensionItem.DataDimensionItemTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
