
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "unreadInterpretations",
    "unreadMessageConversations"
})
@Generated("jsonschema2pojo")
public class DashboardInfo implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unreadInterpretations")
    private Long unreadInterpretations;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unreadMessageConversations")
    private Long unreadMessageConversations;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8630913612537276260L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DashboardInfo() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DashboardInfo(DashboardInfo source) {
        super();
        this.unreadInterpretations = source.unreadInterpretations;
        this.unreadMessageConversations = source.unreadMessageConversations;
    }

    public DashboardInfo(Long unreadInterpretations, Long unreadMessageConversations) {
        super();
        this.unreadInterpretations = unreadInterpretations;
        this.unreadMessageConversations = unreadMessageConversations;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unreadInterpretations")
    public Long getUnreadInterpretations() {
        return unreadInterpretations;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unreadInterpretations")
    public void setUnreadInterpretations(Long unreadInterpretations) {
        this.unreadInterpretations = unreadInterpretations;
    }

    public DashboardInfo withUnreadInterpretations(Long unreadInterpretations) {
        this.unreadInterpretations = unreadInterpretations;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unreadMessageConversations")
    public Long getUnreadMessageConversations() {
        return unreadMessageConversations;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("unreadMessageConversations")
    public void setUnreadMessageConversations(Long unreadMessageConversations) {
        this.unreadMessageConversations = unreadMessageConversations;
    }

    public DashboardInfo withUnreadMessageConversations(Long unreadMessageConversations) {
        this.unreadMessageConversations = unreadMessageConversations;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DashboardInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("unreadInterpretations".equals(name)) {
            if (value instanceof Long) {
                setUnreadInterpretations(((Long) value));
            } else {
                throw new IllegalArgumentException(("property \"unreadInterpretations\" is of type \"java.lang.Long\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("unreadMessageConversations".equals(name)) {
                if (value instanceof Long) {
                    setUnreadMessageConversations(((Long) value));
                } else {
                    throw new IllegalArgumentException(("property \"unreadMessageConversations\" is of type \"java.lang.Long\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("unreadInterpretations".equals(name)) {
            return getUnreadInterpretations();
        } else {
            if ("unreadMessageConversations".equals(name)) {
                return getUnreadMessageConversations();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DashboardInfo.NOT_FOUND_VALUE);
        if (DashboardInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DashboardInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DashboardInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("unreadInterpretations");
        sb.append('=');
        sb.append(((this.unreadInterpretations == null)?"<null>":this.unreadInterpretations));
        sb.append(',');
        sb.append("unreadMessageConversations");
        sb.append('=');
        sb.append(((this.unreadMessageConversations == null)?"<null>":this.unreadMessageConversations));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.unreadMessageConversations == null)? 0 :this.unreadMessageConversations.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.unreadInterpretations == null)? 0 :this.unreadInterpretations.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DashboardInfo) == false) {
            return false;
        }
        DashboardInfo rhs = ((DashboardInfo) other);
        return ((((this.unreadMessageConversations == rhs.unreadMessageConversations)||((this.unreadMessageConversations!= null)&&this.unreadMessageConversations.equals(rhs.unreadMessageConversations)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.unreadInterpretations == rhs.unreadInterpretations)||((this.unreadInterpretations!= null)&&this.unreadInterpretations.equals(rhs.unreadInterpretations))));
    }

}
