
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "inclusionStrategy",
    "properties"
})
@Generated("jsonschema2pojo")
public class Config implements Serializable
{

    @JsonProperty("inclusionStrategy")
    private Config.InclusionStrategyRef inclusionStrategy;
    @JsonProperty("properties")
    private PropertiesRef properties;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8229166290397207754L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Config() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Config(Config source) {
        super();
        this.inclusionStrategy = source.inclusionStrategy;
        this.properties = source.properties;
    }

    public Config(Config.InclusionStrategyRef inclusionStrategy, PropertiesRef properties) {
        super();
        this.inclusionStrategy = inclusionStrategy;
        this.properties = properties;
    }

    @JsonProperty("inclusionStrategy")
    public Optional<Config.InclusionStrategyRef> getInclusionStrategy() {
        return Optional.ofNullable(inclusionStrategy);
    }

    @JsonProperty("inclusionStrategy")
    public void setInclusionStrategy(Config.InclusionStrategyRef inclusionStrategy) {
        this.inclusionStrategy = inclusionStrategy;
    }

    public Config withInclusionStrategy(Config.InclusionStrategyRef inclusionStrategy) {
        this.inclusionStrategy = inclusionStrategy;
        return this;
    }

    @JsonProperty("properties")
    public Optional<PropertiesRef> getProperties() {
        return Optional.ofNullable(properties);
    }

    @JsonProperty("properties")
    public void setProperties(PropertiesRef properties) {
        this.properties = properties;
    }

    public Config withProperties(PropertiesRef properties) {
        this.properties = properties;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Config withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("inclusionStrategy".equals(name)) {
            if (value instanceof Config.InclusionStrategyRef) {
                setInclusionStrategy(((Config.InclusionStrategyRef) value));
            } else {
                throw new IllegalArgumentException(("property \"inclusionStrategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.Config.InclusionStrategyRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("properties".equals(name)) {
                if (value instanceof PropertiesRef) {
                    setProperties(((PropertiesRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"properties\" is of type \"org.hisp.dhis.api.model.v40_2_2.PropertiesRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("inclusionStrategy".equals(name)) {
            return getInclusionStrategy();
        } else {
            if ("properties".equals(name)) {
                return getProperties();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Config.NOT_FOUND_VALUE);
        if (Config.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Config with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Config.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("inclusionStrategy");
        sb.append('=');
        sb.append(((this.inclusionStrategy == null)?"<null>":this.inclusionStrategy));
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(((this.properties == null)?"<null>":this.properties));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.inclusionStrategy == null)? 0 :this.inclusionStrategy.hashCode()));
        result = ((result* 31)+((this.properties == null)? 0 :this.properties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Config) == false) {
            return false;
        }
        Config rhs = ((Config) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.inclusionStrategy == rhs.inclusionStrategy)||((this.inclusionStrategy!= null)&&this.inclusionStrategy.equals(rhs.inclusionStrategy))))&&((this.properties == rhs.properties)||((this.properties!= null)&&this.properties.equals(rhs.properties))));
    }

    @Generated("jsonschema2pojo")
    public enum InclusionStrategyRef {

        ALWAYS("ALWAYS"),
        NON_NULL("NON_NULL"),
        NON_EMPTY("NON_EMPTY");
        private final String value;
        private final static Map<String, Config.InclusionStrategyRef> CONSTANTS = new HashMap<String, Config.InclusionStrategyRef>();

        static {
            for (Config.InclusionStrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        InclusionStrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Config.InclusionStrategyRef fromValue(String value) {
            Config.InclusionStrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
