
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "enrollments",
    "events",
    "relationships",
    "trackedEntities"
})
@Generated("jsonschema2pojo")
public class Body implements Serializable
{

    @JsonProperty("enrollments")
    private List<EnrollmentInfo> enrollments;
    @JsonProperty("events")
    private List<EventInfo> events;
    @JsonProperty("relationships")
    private List<RelationshipInfo> relationships;
    @JsonProperty("trackedEntities")
    private List<TrackedEntityInfo> trackedEntities;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -9050976663196196875L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Body() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Body(Body source) {
        super();
        this.enrollments = source.enrollments;
        this.events = source.events;
        this.relationships = source.relationships;
        this.trackedEntities = source.trackedEntities;
    }

    public Body(List<EnrollmentInfo> enrollments, List<EventInfo> events, List<RelationshipInfo> relationships, List<TrackedEntityInfo> trackedEntities) {
        super();
        this.enrollments = enrollments;
        this.events = events;
        this.relationships = relationships;
        this.trackedEntities = trackedEntities;
    }

    @JsonProperty("enrollments")
    public Optional<List<EnrollmentInfo>> getEnrollments() {
        return Optional.ofNullable(enrollments);
    }

    @JsonProperty("enrollments")
    public void setEnrollments(List<EnrollmentInfo> enrollments) {
        this.enrollments = enrollments;
    }

    public Body withEnrollments(List<EnrollmentInfo> enrollments) {
        this.enrollments = enrollments;
        return this;
    }

    @JsonProperty("events")
    public Optional<List<EventInfo>> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(List<EventInfo> events) {
        this.events = events;
    }

    public Body withEvents(List<EventInfo> events) {
        this.events = events;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<RelationshipInfo>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<RelationshipInfo> relationships) {
        this.relationships = relationships;
    }

    public Body withRelationships(List<RelationshipInfo> relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("trackedEntities")
    public Optional<List<TrackedEntityInfo>> getTrackedEntities() {
        return Optional.ofNullable(trackedEntities);
    }

    @JsonProperty("trackedEntities")
    public void setTrackedEntities(List<TrackedEntityInfo> trackedEntities) {
        this.trackedEntities = trackedEntities;
    }

    public Body withTrackedEntities(List<TrackedEntityInfo> trackedEntities) {
        this.trackedEntities = trackedEntities;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Body withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("enrollments".equals(name)) {
            if (value instanceof List) {
                setEnrollments(((List<EnrollmentInfo> ) value));
            } else {
                throw new IllegalArgumentException(("property \"enrollments\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.EnrollmentInfo>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("events".equals(name)) {
                if (value instanceof List) {
                    setEvents(((List<EventInfo> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"events\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.EventInfo>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("relationships".equals(name)) {
                    if (value instanceof List) {
                        setRelationships(((List<RelationshipInfo> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.RelationshipInfo>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("trackedEntities".equals(name)) {
                        if (value instanceof List) {
                            setTrackedEntities(((List<TrackedEntityInfo> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"trackedEntities\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.TrackedEntityInfo>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("enrollments".equals(name)) {
            return getEnrollments();
        } else {
            if ("events".equals(name)) {
                return getEvents();
            } else {
                if ("relationships".equals(name)) {
                    return getRelationships();
                } else {
                    if ("trackedEntities".equals(name)) {
                        return getTrackedEntities();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Body.NOT_FOUND_VALUE);
        if (Body.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Body with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Body.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enrollments");
        sb.append('=');
        sb.append(((this.enrollments == null)?"<null>":this.enrollments));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("trackedEntities");
        sb.append('=');
        sb.append(((this.trackedEntities == null)?"<null>":this.trackedEntities));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.trackedEntities == null)? 0 :this.trackedEntities.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.enrollments == null)? 0 :this.enrollments.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Body) == false) {
            return false;
        }
        Body rhs = ((Body) other);
        return ((((((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships)))&&((this.trackedEntities == rhs.trackedEntities)||((this.trackedEntities!= null)&&this.trackedEntities.equals(rhs.trackedEntities))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.enrollments == rhs.enrollments)||((this.enrollments!= null)&&this.enrollments.equals(rhs.enrollments))));
    }

}
