
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "data",
    "delete",
    "externalize",
    "manage",
    "read",
    "update",
    "write"
})
@Generated("jsonschema2pojo")
public class Access implements Serializable
{

    @JsonProperty("data")
    private AccessData data;
    @JsonProperty("delete")
    private Boolean delete;
    @JsonProperty("externalize")
    private Boolean externalize;
    @JsonProperty("manage")
    private Boolean manage;
    @JsonProperty("read")
    private Boolean read;
    @JsonProperty("update")
    private Boolean update;
    @JsonProperty("write")
    private Boolean write;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1676210128731754845L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Access() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Access(Access source) {
        super();
        this.data = source.data;
        this.delete = source.delete;
        this.externalize = source.externalize;
        this.manage = source.manage;
        this.read = source.read;
        this.update = source.update;
        this.write = source.write;
    }

    public Access(AccessData data, Boolean delete, Boolean externalize, Boolean manage, Boolean read, Boolean update, Boolean write) {
        super();
        this.data = data;
        this.delete = delete;
        this.externalize = externalize;
        this.manage = manage;
        this.read = read;
        this.update = update;
        this.write = write;
    }

    @JsonProperty("data")
    public Optional<AccessData> getData() {
        return Optional.ofNullable(data);
    }

    @JsonProperty("data")
    public void setData(AccessData data) {
        this.data = data;
    }

    public Access withData(AccessData data) {
        this.data = data;
        return this;
    }

    @JsonProperty("delete")
    public Optional<Boolean> getDelete() {
        return Optional.ofNullable(delete);
    }

    @JsonProperty("delete")
    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public Access withDelete(Boolean delete) {
        this.delete = delete;
        return this;
    }

    @JsonProperty("externalize")
    public Optional<Boolean> getExternalize() {
        return Optional.ofNullable(externalize);
    }

    @JsonProperty("externalize")
    public void setExternalize(Boolean externalize) {
        this.externalize = externalize;
    }

    public Access withExternalize(Boolean externalize) {
        this.externalize = externalize;
        return this;
    }

    @JsonProperty("manage")
    public Optional<Boolean> getManage() {
        return Optional.ofNullable(manage);
    }

    @JsonProperty("manage")
    public void setManage(Boolean manage) {
        this.manage = manage;
    }

    public Access withManage(Boolean manage) {
        this.manage = manage;
        return this;
    }

    @JsonProperty("read")
    public Optional<Boolean> getRead() {
        return Optional.ofNullable(read);
    }

    @JsonProperty("read")
    public void setRead(Boolean read) {
        this.read = read;
    }

    public Access withRead(Boolean read) {
        this.read = read;
        return this;
    }

    @JsonProperty("update")
    public Optional<Boolean> getUpdate() {
        return Optional.ofNullable(update);
    }

    @JsonProperty("update")
    public void setUpdate(Boolean update) {
        this.update = update;
    }

    public Access withUpdate(Boolean update) {
        this.update = update;
        return this;
    }

    @JsonProperty("write")
    public Optional<Boolean> getWrite() {
        return Optional.ofNullable(write);
    }

    @JsonProperty("write")
    public void setWrite(Boolean write) {
        this.write = write;
    }

    public Access withWrite(Boolean write) {
        this.write = write;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Access withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("data".equals(name)) {
            if (value instanceof AccessData) {
                setData(((AccessData) value));
            } else {
                throw new IllegalArgumentException(("property \"data\" is of type \"org.hisp.dhis.api.model.v40_2_2.AccessData\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("delete".equals(name)) {
                if (value instanceof Boolean) {
                    setDelete(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"delete\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("externalize".equals(name)) {
                    if (value instanceof Boolean) {
                        setExternalize(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"externalize\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("manage".equals(name)) {
                        if (value instanceof Boolean) {
                            setManage(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"manage\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("read".equals(name)) {
                            if (value instanceof Boolean) {
                                setRead(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"read\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("update".equals(name)) {
                                if (value instanceof Boolean) {
                                    setUpdate(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"update\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("write".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setWrite(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"write\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("data".equals(name)) {
            return getData();
        } else {
            if ("delete".equals(name)) {
                return getDelete();
            } else {
                if ("externalize".equals(name)) {
                    return getExternalize();
                } else {
                    if ("manage".equals(name)) {
                        return getManage();
                    } else {
                        if ("read".equals(name)) {
                            return getRead();
                        } else {
                            if ("update".equals(name)) {
                                return getUpdate();
                            } else {
                                if ("write".equals(name)) {
                                    return getWrite();
                                } else {
                                    return notFoundValue;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Access.NOT_FOUND_VALUE);
        if (Access.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Access with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Access.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("data");
        sb.append('=');
        sb.append(((this.data == null)?"<null>":this.data));
        sb.append(',');
        sb.append("delete");
        sb.append('=');
        sb.append(((this.delete == null)?"<null>":this.delete));
        sb.append(',');
        sb.append("externalize");
        sb.append('=');
        sb.append(((this.externalize == null)?"<null>":this.externalize));
        sb.append(',');
        sb.append("manage");
        sb.append('=');
        sb.append(((this.manage == null)?"<null>":this.manage));
        sb.append(',');
        sb.append("read");
        sb.append('=');
        sb.append(((this.read == null)?"<null>":this.read));
        sb.append(',');
        sb.append("update");
        sb.append('=');
        sb.append(((this.update == null)?"<null>":this.update));
        sb.append(',');
        sb.append("write");
        sb.append('=');
        sb.append(((this.write == null)?"<null>":this.write));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.read == null)? 0 :this.read.hashCode()));
        result = ((result* 31)+((this.data == null)? 0 :this.data.hashCode()));
        result = ((result* 31)+((this.update == null)? 0 :this.update.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.externalize == null)? 0 :this.externalize.hashCode()));
        result = ((result* 31)+((this.delete == null)? 0 :this.delete.hashCode()));
        result = ((result* 31)+((this.write == null)? 0 :this.write.hashCode()));
        result = ((result* 31)+((this.manage == null)? 0 :this.manage.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Access) == false) {
            return false;
        }
        Access rhs = ((Access) other);
        return (((((((((this.read == rhs.read)||((this.read!= null)&&this.read.equals(rhs.read)))&&((this.data == rhs.data)||((this.data!= null)&&this.data.equals(rhs.data))))&&((this.update == rhs.update)||((this.update!= null)&&this.update.equals(rhs.update))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.externalize == rhs.externalize)||((this.externalize!= null)&&this.externalize.equals(rhs.externalize))))&&((this.delete == rhs.delete)||((this.delete!= null)&&this.delete.equals(rhs.delete))))&&((this.write == rhs.write)||((this.write!= null)&&this.write.equals(rhs.write))))&&((this.manage == rhs.manage)||((this.manage!= null)&&this.manage.equals(rhs.manage))));
    }

}
