
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "auth",
    "clientId",
    "contentType",
    "headers",
    "type",
    "url"
})
@Generated("jsonschema2pojo")
public class WebhookTarget implements Serializable
{

    @JsonProperty("auth")
    private Object auth;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    private String clientId;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentType")
    private String contentType;
    @JsonProperty("headers")
    private Headers__1 headers;
    @JsonProperty("type")
    private String type;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    private String url;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4958503859843734701L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public WebhookTarget() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public WebhookTarget(WebhookTarget source) {
        super();
        this.auth = source.auth;
        this.clientId = source.clientId;
        this.contentType = source.contentType;
        this.headers = source.headers;
        this.type = source.type;
        this.url = source.url;
    }

    public WebhookTarget(Object auth, String clientId, String contentType, Headers__1 headers, String type, String url) {
        super();
        this.auth = auth;
        this.clientId = clientId;
        this.contentType = contentType;
        this.headers = headers;
        this.type = type;
        this.url = url;
    }

    @JsonProperty("auth")
    public Optional<Object> getAuth() {
        return Optional.ofNullable(auth);
    }

    @JsonProperty("auth")
    public void setAuth(Object auth) {
        this.auth = auth;
    }

    public WebhookTarget withAuth(Object auth) {
        this.auth = auth;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    public String getClientId() {
        return clientId;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public WebhookTarget withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentType")
    public String getContentType() {
        return contentType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentType")
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public WebhookTarget withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @JsonProperty("headers")
    public Optional<Headers__1> getHeaders() {
        return Optional.ofNullable(headers);
    }

    @JsonProperty("headers")
    public void setHeaders(Headers__1 headers) {
        this.headers = headers;
    }

    public WebhookTarget withHeaders(Headers__1 headers) {
        this.headers = headers;
        return this;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    public WebhookTarget withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    public WebhookTarget withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public WebhookTarget withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("auth".equals(name)) {
            if (value instanceof Object) {
                setAuth(((Object) value));
            } else {
                throw new IllegalArgumentException(("property \"auth\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("clientId".equals(name)) {
                if (value instanceof String) {
                    setClientId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"clientId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("contentType".equals(name)) {
                    if (value instanceof String) {
                        setContentType(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"contentType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("headers".equals(name)) {
                        if (value instanceof Headers__1) {
                            setHeaders(((Headers__1) value));
                        } else {
                            throw new IllegalArgumentException(("property \"headers\" is of type \"org.hisp.dhis.api.model.v40_0.Headers__1\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("type".equals(name)) {
                            if (value instanceof String) {
                                setType(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"type\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("url".equals(name)) {
                                if (value instanceof String) {
                                    setUrl(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"url\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("auth".equals(name)) {
            return getAuth();
        } else {
            if ("clientId".equals(name)) {
                return getClientId();
            } else {
                if ("contentType".equals(name)) {
                    return getContentType();
                } else {
                    if ("headers".equals(name)) {
                        return getHeaders();
                    } else {
                        if ("type".equals(name)) {
                            return getType();
                        } else {
                            if ("url".equals(name)) {
                                return getUrl();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, WebhookTarget.NOT_FOUND_VALUE);
        if (WebhookTarget.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public WebhookTarget with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(WebhookTarget.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("auth");
        sb.append('=');
        sb.append(((this.auth == null)?"<null>":this.auth));
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(((this.clientId == null)?"<null>":this.clientId));
        sb.append(',');
        sb.append("contentType");
        sb.append('=');
        sb.append(((this.contentType == null)?"<null>":this.contentType));
        sb.append(',');
        sb.append("headers");
        sb.append('=');
        sb.append(((this.headers == null)?"<null>":this.headers));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.headers == null)? 0 :this.headers.hashCode()));
        result = ((result* 31)+((this.clientId == null)? 0 :this.clientId.hashCode()));
        result = ((result* 31)+((this.auth == null)? 0 :this.auth.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.contentType == null)? 0 :this.contentType.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof WebhookTarget) == false) {
            return false;
        }
        WebhookTarget rhs = ((WebhookTarget) other);
        return ((((((((this.headers == rhs.headers)||((this.headers!= null)&&this.headers.equals(rhs.headers)))&&((this.clientId == rhs.clientId)||((this.clientId!= null)&&this.clientId.equals(rhs.clientId))))&&((this.auth == rhs.auth)||((this.auth!= null)&&this.auth.equals(rhs.auth))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.contentType == rhs.contentType)||((this.contentType!= null)&&this.contentType.equals(rhs.contentType))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))));
    }

}
