
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "assignedUser",
    "attributeCategoryOptions",
    "attributeOptionCombo",
    "completedAt",
    "completedBy",
    "createdAt",
    "createdAtClient",
    "createdBy",
    "dataValues",
    "deleted",
    "enrollment",
    "event",
    "followup",
    "geometry",
    "notes",
    "occurredAt",
    "orgUnit",
    "orgUnitName",
    "program",
    "programStage",
    "scheduledAt",
    "status",
    "storedBy",
    "updatedAt",
    "updatedAtClient",
    "updatedBy"
})
@Generated("jsonschema2pojo")
public class WebapiControllerTrackerViewRelationshipItemEvent implements Serializable
{

    @JsonProperty("assignedUser")
    private WebapiControllerTrackerViewUser assignedUser;
    @JsonProperty("attributeCategoryOptions")
    private String attributeCategoryOptions;
    @JsonProperty("attributeOptionCombo")
    private String attributeOptionCombo;
    @JsonProperty("completedAt")
    private Object completedAt;
    @JsonProperty("completedBy")
    private String completedBy;
    @JsonProperty("createdAt")
    private Object createdAt;
    @JsonProperty("createdAtClient")
    private Object createdAtClient;
    @JsonProperty("createdBy")
    private WebapiControllerTrackerViewUser createdBy;
    @JsonProperty("dataValues")
    private List<WebapiControllerTrackerViewDataValue> dataValues;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    private Boolean deleted;
    @JsonProperty("enrollment")
    private String enrollment;
    @JsonProperty("event")
    private String event;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    private Boolean followup;
    @JsonProperty("geometry")
    private Geometry__1 geometry;
    @JsonProperty("notes")
    private List<WebapiControllerTrackerViewNote> notes;
    @JsonProperty("occurredAt")
    private Object occurredAt;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("orgUnitName")
    private String orgUnitName;
    @JsonProperty("program")
    private String program;
    @JsonProperty("programStage")
    private String programStage;
    @JsonProperty("scheduledAt")
    private Object scheduledAt;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private WebapiControllerTrackerViewRelationshipItemEvent.Status status;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("updatedAt")
    private Object updatedAt;
    @JsonProperty("updatedAtClient")
    private Object updatedAtClient;
    @JsonProperty("updatedBy")
    private WebapiControllerTrackerViewUser updatedBy;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -636252634576751108L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public WebapiControllerTrackerViewRelationshipItemEvent() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public WebapiControllerTrackerViewRelationshipItemEvent(WebapiControllerTrackerViewRelationshipItemEvent source) {
        super();
        this.assignedUser = source.assignedUser;
        this.attributeCategoryOptions = source.attributeCategoryOptions;
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.completedAt = source.completedAt;
        this.completedBy = source.completedBy;
        this.createdAt = source.createdAt;
        this.createdAtClient = source.createdAtClient;
        this.createdBy = source.createdBy;
        this.dataValues = source.dataValues;
        this.deleted = source.deleted;
        this.enrollment = source.enrollment;
        this.event = source.event;
        this.followup = source.followup;
        this.geometry = source.geometry;
        this.notes = source.notes;
        this.occurredAt = source.occurredAt;
        this.orgUnit = source.orgUnit;
        this.orgUnitName = source.orgUnitName;
        this.program = source.program;
        this.programStage = source.programStage;
        this.scheduledAt = source.scheduledAt;
        this.status = source.status;
        this.storedBy = source.storedBy;
        this.updatedAt = source.updatedAt;
        this.updatedAtClient = source.updatedAtClient;
        this.updatedBy = source.updatedBy;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent(WebapiControllerTrackerViewUser assignedUser, String attributeCategoryOptions, String attributeOptionCombo, Object completedAt, String completedBy, Object createdAt, Object createdAtClient, WebapiControllerTrackerViewUser createdBy, List<WebapiControllerTrackerViewDataValue> dataValues, Boolean deleted, String enrollment, String event, Boolean followup, Geometry__1 geometry, List<WebapiControllerTrackerViewNote> notes, Object occurredAt, String orgUnit, String orgUnitName, String program, String programStage, Object scheduledAt, WebapiControllerTrackerViewRelationshipItemEvent.Status status, String storedBy, Object updatedAt, Object updatedAtClient, WebapiControllerTrackerViewUser updatedBy) {
        super();
        this.assignedUser = assignedUser;
        this.attributeCategoryOptions = attributeCategoryOptions;
        this.attributeOptionCombo = attributeOptionCombo;
        this.completedAt = completedAt;
        this.completedBy = completedBy;
        this.createdAt = createdAt;
        this.createdAtClient = createdAtClient;
        this.createdBy = createdBy;
        this.dataValues = dataValues;
        this.deleted = deleted;
        this.enrollment = enrollment;
        this.event = event;
        this.followup = followup;
        this.geometry = geometry;
        this.notes = notes;
        this.occurredAt = occurredAt;
        this.orgUnit = orgUnit;
        this.orgUnitName = orgUnitName;
        this.program = program;
        this.programStage = programStage;
        this.scheduledAt = scheduledAt;
        this.status = status;
        this.storedBy = storedBy;
        this.updatedAt = updatedAt;
        this.updatedAtClient = updatedAtClient;
        this.updatedBy = updatedBy;
    }

    @JsonProperty("assignedUser")
    public Optional<WebapiControllerTrackerViewUser> getAssignedUser() {
        return Optional.ofNullable(assignedUser);
    }

    @JsonProperty("assignedUser")
    public void setAssignedUser(WebapiControllerTrackerViewUser assignedUser) {
        this.assignedUser = assignedUser;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withAssignedUser(WebapiControllerTrackerViewUser assignedUser) {
        this.assignedUser = assignedUser;
        return this;
    }

    @JsonProperty("attributeCategoryOptions")
    public Optional<String> getAttributeCategoryOptions() {
        return Optional.ofNullable(attributeCategoryOptions);
    }

    @JsonProperty("attributeCategoryOptions")
    public void setAttributeCategoryOptions(String attributeCategoryOptions) {
        this.attributeCategoryOptions = attributeCategoryOptions;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withAttributeCategoryOptions(String attributeCategoryOptions) {
        this.attributeCategoryOptions = attributeCategoryOptions;
        return this;
    }

    @JsonProperty("attributeOptionCombo")
    public Optional<String> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("completedAt")
    public Optional<Object> getCompletedAt() {
        return Optional.ofNullable(completedAt);
    }

    @JsonProperty("completedAt")
    public void setCompletedAt(Object completedAt) {
        this.completedAt = completedAt;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withCompletedAt(Object completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @JsonProperty("completedBy")
    public Optional<String> getCompletedBy() {
        return Optional.ofNullable(completedBy);
    }

    @JsonProperty("completedBy")
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withCompletedBy(String completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    @JsonProperty("createdAt")
    public Optional<Object> getCreatedAt() {
        return Optional.ofNullable(createdAt);
    }

    @JsonProperty("createdAt")
    public void setCreatedAt(Object createdAt) {
        this.createdAt = createdAt;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withCreatedAt(Object createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty("createdAtClient")
    public Optional<Object> getCreatedAtClient() {
        return Optional.ofNullable(createdAtClient);
    }

    @JsonProperty("createdAtClient")
    public void setCreatedAtClient(Object createdAtClient) {
        this.createdAtClient = createdAtClient;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withCreatedAtClient(Object createdAtClient) {
        this.createdAtClient = createdAtClient;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<WebapiControllerTrackerViewUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(WebapiControllerTrackerViewUser createdBy) {
        this.createdBy = createdBy;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withCreatedBy(WebapiControllerTrackerViewUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("dataValues")
    public Optional<List<WebapiControllerTrackerViewDataValue>> getDataValues() {
        return Optional.ofNullable(dataValues);
    }

    @JsonProperty("dataValues")
    public void setDataValues(List<WebapiControllerTrackerViewDataValue> dataValues) {
        this.dataValues = dataValues;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withDataValues(List<WebapiControllerTrackerViewDataValue> dataValues) {
        this.dataValues = dataValues;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    public Boolean getDeleted() {
        return deleted;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("enrollment")
    public Optional<String> getEnrollment() {
        return Optional.ofNullable(enrollment);
    }

    @JsonProperty("enrollment")
    public void setEnrollment(String enrollment) {
        this.enrollment = enrollment;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withEnrollment(String enrollment) {
        this.enrollment = enrollment;
        return this;
    }

    @JsonProperty("event")
    public Optional<String> getEvent() {
        return Optional.ofNullable(event);
    }

    @JsonProperty("event")
    public void setEvent(String event) {
        this.event = event;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withEvent(String event) {
        this.event = event;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    public Boolean getFollowup() {
        return followup;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    @JsonProperty("geometry")
    public Optional<Geometry__1> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    @JsonProperty("geometry")
    public void setGeometry(Geometry__1 geometry) {
        this.geometry = geometry;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withGeometry(Geometry__1 geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("notes")
    public Optional<List<WebapiControllerTrackerViewNote>> getNotes() {
        return Optional.ofNullable(notes);
    }

    @JsonProperty("notes")
    public void setNotes(List<WebapiControllerTrackerViewNote> notes) {
        this.notes = notes;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withNotes(List<WebapiControllerTrackerViewNote> notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty("occurredAt")
    public Optional<Object> getOccurredAt() {
        return Optional.ofNullable(occurredAt);
    }

    @JsonProperty("occurredAt")
    public void setOccurredAt(Object occurredAt) {
        this.occurredAt = occurredAt;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withOccurredAt(Object occurredAt) {
        this.occurredAt = occurredAt;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("orgUnitName")
    public Optional<String> getOrgUnitName() {
        return Optional.ofNullable(orgUnitName);
    }

    @JsonProperty("orgUnitName")
    public void setOrgUnitName(String orgUnitName) {
        this.orgUnitName = orgUnitName;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withOrgUnitName(String orgUnitName) {
        this.orgUnitName = orgUnitName;
        return this;
    }

    @JsonProperty("program")
    public Optional<String> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(String program) {
        this.program = program;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withProgram(String program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<String> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withProgramStage(String programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("scheduledAt")
    public Optional<Object> getScheduledAt() {
        return Optional.ofNullable(scheduledAt);
    }

    @JsonProperty("scheduledAt")
    public void setScheduledAt(Object scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withScheduledAt(Object scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public WebapiControllerTrackerViewRelationshipItemEvent.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(WebapiControllerTrackerViewRelationshipItemEvent.Status status) {
        this.status = status;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withStatus(WebapiControllerTrackerViewRelationshipItemEvent.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("updatedAt")
    public Optional<Object> getUpdatedAt() {
        return Optional.ofNullable(updatedAt);
    }

    @JsonProperty("updatedAt")
    public void setUpdatedAt(Object updatedAt) {
        this.updatedAt = updatedAt;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withUpdatedAt(Object updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty("updatedAtClient")
    public Optional<Object> getUpdatedAtClient() {
        return Optional.ofNullable(updatedAtClient);
    }

    @JsonProperty("updatedAtClient")
    public void setUpdatedAtClient(Object updatedAtClient) {
        this.updatedAtClient = updatedAtClient;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withUpdatedAtClient(Object updatedAtClient) {
        this.updatedAtClient = updatedAtClient;
        return this;
    }

    @JsonProperty("updatedBy")
    public Optional<WebapiControllerTrackerViewUser> getUpdatedBy() {
        return Optional.ofNullable(updatedBy);
    }

    @JsonProperty("updatedBy")
    public void setUpdatedBy(WebapiControllerTrackerViewUser updatedBy) {
        this.updatedBy = updatedBy;
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withUpdatedBy(WebapiControllerTrackerViewUser updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public WebapiControllerTrackerViewRelationshipItemEvent withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assignedUser".equals(name)) {
            if (value instanceof WebapiControllerTrackerViewUser) {
                setAssignedUser(((WebapiControllerTrackerViewUser) value));
            } else {
                throw new IllegalArgumentException(("property \"assignedUser\" is of type \"org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewUser\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeCategoryOptions".equals(name)) {
                if (value instanceof String) {
                    setAttributeCategoryOptions(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeCategoryOptions\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeOptionCombo".equals(name)) {
                    if (value instanceof String) {
                        setAttributeOptionCombo(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("completedAt".equals(name)) {
                        if (value instanceof Object) {
                            setCompletedAt(((Object) value));
                        } else {
                            throw new IllegalArgumentException(("property \"completedAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("completedBy".equals(name)) {
                            if (value instanceof String) {
                                setCompletedBy(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"completedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdAt".equals(name)) {
                                if (value instanceof Object) {
                                    setCreatedAt(((Object) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("createdAtClient".equals(name)) {
                                    if (value instanceof Object) {
                                        setCreatedAtClient(((Object) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"createdAtClient\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("createdBy".equals(name)) {
                                        if (value instanceof WebapiControllerTrackerViewUser) {
                                            setCreatedBy(((WebapiControllerTrackerViewUser) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewUser\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("dataValues".equals(name)) {
                                            if (value instanceof List) {
                                                setDataValues(((List<WebapiControllerTrackerViewDataValue> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"dataValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewDataValue>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("deleted".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setDeleted(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("enrollment".equals(name)) {
                                                    if (value instanceof String) {
                                                        setEnrollment(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"enrollment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("event".equals(name)) {
                                                        if (value instanceof String) {
                                                            setEvent(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"event\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("followup".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFollowup(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("geometry".equals(name)) {
                                                                if (value instanceof Geometry__1) {
                                                                    setGeometry(((Geometry__1) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"geometry\" is of type \"org.hisp.dhis.api.model.v40_0.Geometry__1\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("notes".equals(name)) {
                                                                    if (value instanceof List) {
                                                                        setNotes(((List<WebapiControllerTrackerViewNote> ) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"notes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewNote>\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("occurredAt".equals(name)) {
                                                                        if (value instanceof Object) {
                                                                            setOccurredAt(((Object) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"occurredAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("orgUnit".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setOrgUnit(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("orgUnitName".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setOrgUnitName(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"orgUnitName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("program".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setProgram(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"program\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("programStage".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setProgramStage(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"programStage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("scheduledAt".equals(name)) {
                                                                                            if (value instanceof Object) {
                                                                                                setScheduledAt(((Object) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"scheduledAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("status".equals(name)) {
                                                                                                if (value instanceof WebapiControllerTrackerViewRelationshipItemEvent.Status) {
                                                                                                    setStatus(((WebapiControllerTrackerViewRelationshipItemEvent.Status) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewRelationshipItemEvent.Status\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("storedBy".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setStoredBy(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("updatedAt".equals(name)) {
                                                                                                        if (value instanceof Object) {
                                                                                                            setUpdatedAt(((Object) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"updatedAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("updatedAtClient".equals(name)) {
                                                                                                            if (value instanceof Object) {
                                                                                                                setUpdatedAtClient(((Object) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"updatedAtClient\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("updatedBy".equals(name)) {
                                                                                                                if (value instanceof WebapiControllerTrackerViewUser) {
                                                                                                                    setUpdatedBy(((WebapiControllerTrackerViewUser) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"updatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewUser\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                return false;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assignedUser".equals(name)) {
            return getAssignedUser();
        } else {
            if ("attributeCategoryOptions".equals(name)) {
                return getAttributeCategoryOptions();
            } else {
                if ("attributeOptionCombo".equals(name)) {
                    return getAttributeOptionCombo();
                } else {
                    if ("completedAt".equals(name)) {
                        return getCompletedAt();
                    } else {
                        if ("completedBy".equals(name)) {
                            return getCompletedBy();
                        } else {
                            if ("createdAt".equals(name)) {
                                return getCreatedAt();
                            } else {
                                if ("createdAtClient".equals(name)) {
                                    return getCreatedAtClient();
                                } else {
                                    if ("createdBy".equals(name)) {
                                        return getCreatedBy();
                                    } else {
                                        if ("dataValues".equals(name)) {
                                            return getDataValues();
                                        } else {
                                            if ("deleted".equals(name)) {
                                                return getDeleted();
                                            } else {
                                                if ("enrollment".equals(name)) {
                                                    return getEnrollment();
                                                } else {
                                                    if ("event".equals(name)) {
                                                        return getEvent();
                                                    } else {
                                                        if ("followup".equals(name)) {
                                                            return getFollowup();
                                                        } else {
                                                            if ("geometry".equals(name)) {
                                                                return getGeometry();
                                                            } else {
                                                                if ("notes".equals(name)) {
                                                                    return getNotes();
                                                                } else {
                                                                    if ("occurredAt".equals(name)) {
                                                                        return getOccurredAt();
                                                                    } else {
                                                                        if ("orgUnit".equals(name)) {
                                                                            return getOrgUnit();
                                                                        } else {
                                                                            if ("orgUnitName".equals(name)) {
                                                                                return getOrgUnitName();
                                                                            } else {
                                                                                if ("program".equals(name)) {
                                                                                    return getProgram();
                                                                                } else {
                                                                                    if ("programStage".equals(name)) {
                                                                                        return getProgramStage();
                                                                                    } else {
                                                                                        if ("scheduledAt".equals(name)) {
                                                                                            return getScheduledAt();
                                                                                        } else {
                                                                                            if ("status".equals(name)) {
                                                                                                return getStatus();
                                                                                            } else {
                                                                                                if ("storedBy".equals(name)) {
                                                                                                    return getStoredBy();
                                                                                                } else {
                                                                                                    if ("updatedAt".equals(name)) {
                                                                                                        return getUpdatedAt();
                                                                                                    } else {
                                                                                                        if ("updatedAtClient".equals(name)) {
                                                                                                            return getUpdatedAtClient();
                                                                                                        } else {
                                                                                                            if ("updatedBy".equals(name)) {
                                                                                                                return getUpdatedBy();
                                                                                                            } else {
                                                                                                                return notFoundValue;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, WebapiControllerTrackerViewRelationshipItemEvent.NOT_FOUND_VALUE);
        if (WebapiControllerTrackerViewRelationshipItemEvent.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public WebapiControllerTrackerViewRelationshipItemEvent with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(WebapiControllerTrackerViewRelationshipItemEvent.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assignedUser");
        sb.append('=');
        sb.append(((this.assignedUser == null)?"<null>":this.assignedUser));
        sb.append(',');
        sb.append("attributeCategoryOptions");
        sb.append('=');
        sb.append(((this.attributeCategoryOptions == null)?"<null>":this.attributeCategoryOptions));
        sb.append(',');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("completedAt");
        sb.append('=');
        sb.append(((this.completedAt == null)?"<null>":this.completedAt));
        sb.append(',');
        sb.append("completedBy");
        sb.append('=');
        sb.append(((this.completedBy == null)?"<null>":this.completedBy));
        sb.append(',');
        sb.append("createdAt");
        sb.append('=');
        sb.append(((this.createdAt == null)?"<null>":this.createdAt));
        sb.append(',');
        sb.append("createdAtClient");
        sb.append('=');
        sb.append(((this.createdAtClient == null)?"<null>":this.createdAtClient));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataValues");
        sb.append('=');
        sb.append(((this.dataValues == null)?"<null>":this.dataValues));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("enrollment");
        sb.append('=');
        sb.append(((this.enrollment == null)?"<null>":this.enrollment));
        sb.append(',');
        sb.append("event");
        sb.append('=');
        sb.append(((this.event == null)?"<null>":this.event));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(((this.notes == null)?"<null>":this.notes));
        sb.append(',');
        sb.append("occurredAt");
        sb.append('=');
        sb.append(((this.occurredAt == null)?"<null>":this.occurredAt));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("orgUnitName");
        sb.append('=');
        sb.append(((this.orgUnitName == null)?"<null>":this.orgUnitName));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("scheduledAt");
        sb.append('=');
        sb.append(((this.scheduledAt == null)?"<null>":this.scheduledAt));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(((this.updatedAt == null)?"<null>":this.updatedAt));
        sb.append(',');
        sb.append("updatedAtClient");
        sb.append('=');
        sb.append(((this.updatedAtClient == null)?"<null>":this.updatedAtClient));
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(((this.updatedBy == null)?"<null>":this.updatedBy));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataValues == null)? 0 :this.dataValues.hashCode()));
        result = ((result* 31)+((this.notes == null)? 0 :this.notes.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.attributeCategoryOptions == null)? 0 :this.attributeCategoryOptions.hashCode()));
        result = ((result* 31)+((this.createdAtClient == null)? 0 :this.createdAtClient.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.createdAt == null)? 0 :this.createdAt.hashCode()));
        result = ((result* 31)+((this.event == null)? 0 :this.event.hashCode()));
        result = ((result* 31)+((this.assignedUser == null)? 0 :this.assignedUser.hashCode()));
        result = ((result* 31)+((this.updatedAt == null)? 0 :this.updatedAt.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.completedAt == null)? 0 :this.completedAt.hashCode()));
        result = ((result* 31)+((this.occurredAt == null)? 0 :this.occurredAt.hashCode()));
        result = ((result* 31)+((this.updatedAtClient == null)? 0 :this.updatedAtClient.hashCode()));
        result = ((result* 31)+((this.updatedBy == null)? 0 :this.updatedBy.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.enrollment == null)? 0 :this.enrollment.hashCode()));
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.completedBy == null)? 0 :this.completedBy.hashCode()));
        result = ((result* 31)+((this.scheduledAt == null)? 0 :this.scheduledAt.hashCode()));
        result = ((result* 31)+((this.orgUnitName == null)? 0 :this.orgUnitName.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof WebapiControllerTrackerViewRelationshipItemEvent) == false) {
            return false;
        }
        WebapiControllerTrackerViewRelationshipItemEvent rhs = ((WebapiControllerTrackerViewRelationshipItemEvent) other);
        return ((((((((((((((((((((((((((((this.dataValues == rhs.dataValues)||((this.dataValues!= null)&&this.dataValues.equals(rhs.dataValues)))&&((this.notes == rhs.notes)||((this.notes!= null)&&this.notes.equals(rhs.notes))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.attributeCategoryOptions == rhs.attributeCategoryOptions)||((this.attributeCategoryOptions!= null)&&this.attributeCategoryOptions.equals(rhs.attributeCategoryOptions))))&&((this.createdAtClient == rhs.createdAtClient)||((this.createdAtClient!= null)&&this.createdAtClient.equals(rhs.createdAtClient))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.createdAt == rhs.createdAt)||((this.createdAt!= null)&&this.createdAt.equals(rhs.createdAt))))&&((this.event == rhs.event)||((this.event!= null)&&this.event.equals(rhs.event))))&&((this.assignedUser == rhs.assignedUser)||((this.assignedUser!= null)&&this.assignedUser.equals(rhs.assignedUser))))&&((this.updatedAt == rhs.updatedAt)||((this.updatedAt!= null)&&this.updatedAt.equals(rhs.updatedAt))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.completedAt == rhs.completedAt)||((this.completedAt!= null)&&this.completedAt.equals(rhs.completedAt))))&&((this.occurredAt == rhs.occurredAt)||((this.occurredAt!= null)&&this.occurredAt.equals(rhs.occurredAt))))&&((this.updatedAtClient == rhs.updatedAtClient)||((this.updatedAtClient!= null)&&this.updatedAtClient.equals(rhs.updatedAtClient))))&&((this.updatedBy == rhs.updatedBy)||((this.updatedBy!= null)&&this.updatedBy.equals(rhs.updatedBy))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.enrollment == rhs.enrollment)||((this.enrollment!= null)&&this.enrollment.equals(rhs.enrollment))))&&((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.completedBy == rhs.completedBy)||((this.completedBy!= null)&&this.completedBy.equals(rhs.completedBy))))&&((this.scheduledAt == rhs.scheduledAt)||((this.scheduledAt!= null)&&this.scheduledAt.equals(rhs.scheduledAt))))&&((this.orgUnitName == rhs.orgUnitName)||((this.orgUnitName!= null)&&this.orgUnitName.equals(rhs.orgUnitName))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum Status {

        ACTIVE("ACTIVE"),
        COMPLETED("COMPLETED"),
        VISITED("VISITED"),
        SCHEDULE("SCHEDULE"),
        OVERDUE("OVERDUE"),
        SKIPPED("SKIPPED");
        private final String value;
        private final static Map<String, WebapiControllerTrackerViewRelationshipItemEvent.Status> CONSTANTS = new HashMap<String, WebapiControllerTrackerViewRelationshipItemEvent.Status>();

        static {
            for (WebapiControllerTrackerViewRelationshipItemEvent.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static WebapiControllerTrackerViewRelationshipItemEvent.Status fromValue(String value) {
            WebapiControllerTrackerViewRelationshipItemEvent.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
