
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "klass",
    "objectReports",
    "stats"
})
@Generated("jsonschema2pojo")
public class TypeReport implements Serializable
{

    @JsonProperty("klass")
    private String klass;
    @JsonProperty("objectReports")
    private List<ObjectReport> objectReports;
    @JsonProperty("stats")
    private Stats stats;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1185581350588800943L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TypeReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TypeReport(TypeReport source) {
        super();
        this.klass = source.klass;
        this.objectReports = source.objectReports;
        this.stats = source.stats;
    }

    public TypeReport(String klass, List<ObjectReport> objectReports, Stats stats) {
        super();
        this.klass = klass;
        this.objectReports = objectReports;
        this.stats = stats;
    }

    @JsonProperty("klass")
    public Optional<String> getKlass() {
        return Optional.ofNullable(klass);
    }

    @JsonProperty("klass")
    public void setKlass(String klass) {
        this.klass = klass;
    }

    public TypeReport withKlass(String klass) {
        this.klass = klass;
        return this;
    }

    @JsonProperty("objectReports")
    public Optional<List<ObjectReport>> getObjectReports() {
        return Optional.ofNullable(objectReports);
    }

    @JsonProperty("objectReports")
    public void setObjectReports(List<ObjectReport> objectReports) {
        this.objectReports = objectReports;
    }

    public TypeReport withObjectReports(List<ObjectReport> objectReports) {
        this.objectReports = objectReports;
        return this;
    }

    @JsonProperty("stats")
    public Optional<Stats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public TypeReport withStats(Stats stats) {
        this.stats = stats;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TypeReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("klass".equals(name)) {
            if (value instanceof String) {
                setKlass(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"klass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("objectReports".equals(name)) {
                if (value instanceof List) {
                    setObjectReports(((List<ObjectReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"objectReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.ObjectReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("stats".equals(name)) {
                    if (value instanceof Stats) {
                        setStats(((Stats) value));
                    } else {
                        throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v40_0.Stats\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("klass".equals(name)) {
            return getKlass();
        } else {
            if ("objectReports".equals(name)) {
                return getObjectReports();
            } else {
                if ("stats".equals(name)) {
                    return getStats();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TypeReport.NOT_FOUND_VALUE);
        if (TypeReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TypeReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TypeReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("klass");
        sb.append('=');
        sb.append(((this.klass == null)?"<null>":this.klass));
        sb.append(',');
        sb.append("objectReports");
        sb.append('=');
        sb.append(((this.objectReports == null)?"<null>":this.objectReports));
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.objectReports == null)? 0 :this.objectReports.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        result = ((result* 31)+((this.klass == null)? 0 :this.klass.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TypeReport) == false) {
            return false;
        }
        TypeReport rhs = ((TypeReport) other);
        return (((((this.objectReports == rhs.objectReports)||((this.objectReports!= null)&&this.objectReports.equals(rhs.objectReports)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))))&&((this.klass == rhs.klass)||((this.klass!= null)&&this.klass.equals(rhs.klass))));
    }

}
