
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "indexableAttributes",
    "indexedAttributes",
    "obsoleteIndexedAttributes"
})
@Generated("jsonschema2pojo")
public class TrigramSummary implements Serializable
{

    @JsonProperty("indexableAttributes")
    private List<IndexableAttribute> indexableAttributes;
    @JsonProperty("indexedAttributes")
    private List<IndexedAttribute> indexedAttributes;
    @JsonProperty("obsoleteIndexedAttributes")
    private List<ObsoleteIndexedAttribute> obsoleteIndexedAttributes;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2395753266665335312L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrigramSummary() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrigramSummary(TrigramSummary source) {
        super();
        this.indexableAttributes = source.indexableAttributes;
        this.indexedAttributes = source.indexedAttributes;
        this.obsoleteIndexedAttributes = source.obsoleteIndexedAttributes;
    }

    public TrigramSummary(List<IndexableAttribute> indexableAttributes, List<IndexedAttribute> indexedAttributes, List<ObsoleteIndexedAttribute> obsoleteIndexedAttributes) {
        super();
        this.indexableAttributes = indexableAttributes;
        this.indexedAttributes = indexedAttributes;
        this.obsoleteIndexedAttributes = obsoleteIndexedAttributes;
    }

    @JsonProperty("indexableAttributes")
    public Optional<List<IndexableAttribute>> getIndexableAttributes() {
        return Optional.ofNullable(indexableAttributes);
    }

    @JsonProperty("indexableAttributes")
    public void setIndexableAttributes(List<IndexableAttribute> indexableAttributes) {
        this.indexableAttributes = indexableAttributes;
    }

    public TrigramSummary withIndexableAttributes(List<IndexableAttribute> indexableAttributes) {
        this.indexableAttributes = indexableAttributes;
        return this;
    }

    @JsonProperty("indexedAttributes")
    public Optional<List<IndexedAttribute>> getIndexedAttributes() {
        return Optional.ofNullable(indexedAttributes);
    }

    @JsonProperty("indexedAttributes")
    public void setIndexedAttributes(List<IndexedAttribute> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public TrigramSummary withIndexedAttributes(List<IndexedAttribute> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
        return this;
    }

    @JsonProperty("obsoleteIndexedAttributes")
    public Optional<List<ObsoleteIndexedAttribute>> getObsoleteIndexedAttributes() {
        return Optional.ofNullable(obsoleteIndexedAttributes);
    }

    @JsonProperty("obsoleteIndexedAttributes")
    public void setObsoleteIndexedAttributes(List<ObsoleteIndexedAttribute> obsoleteIndexedAttributes) {
        this.obsoleteIndexedAttributes = obsoleteIndexedAttributes;
    }

    public TrigramSummary withObsoleteIndexedAttributes(List<ObsoleteIndexedAttribute> obsoleteIndexedAttributes) {
        this.obsoleteIndexedAttributes = obsoleteIndexedAttributes;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrigramSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("indexableAttributes".equals(name)) {
            if (value instanceof List) {
                setIndexableAttributes(((List<IndexableAttribute> ) value));
            } else {
                throw new IllegalArgumentException(("property \"indexableAttributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.IndexableAttribute>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("indexedAttributes".equals(name)) {
                if (value instanceof List) {
                    setIndexedAttributes(((List<IndexedAttribute> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indexedAttributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.IndexedAttribute>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("obsoleteIndexedAttributes".equals(name)) {
                    if (value instanceof List) {
                        setObsoleteIndexedAttributes(((List<ObsoleteIndexedAttribute> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"obsoleteIndexedAttributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.ObsoleteIndexedAttribute>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("indexableAttributes".equals(name)) {
            return getIndexableAttributes();
        } else {
            if ("indexedAttributes".equals(name)) {
                return getIndexedAttributes();
            } else {
                if ("obsoleteIndexedAttributes".equals(name)) {
                    return getObsoleteIndexedAttributes();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrigramSummary.NOT_FOUND_VALUE);
        if (TrigramSummary.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrigramSummary with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrigramSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("indexableAttributes");
        sb.append('=');
        sb.append(((this.indexableAttributes == null)?"<null>":this.indexableAttributes));
        sb.append(',');
        sb.append("indexedAttributes");
        sb.append('=');
        sb.append(((this.indexedAttributes == null)?"<null>":this.indexedAttributes));
        sb.append(',');
        sb.append("obsoleteIndexedAttributes");
        sb.append('=');
        sb.append(((this.obsoleteIndexedAttributes == null)?"<null>":this.obsoleteIndexedAttributes));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.indexableAttributes == null)? 0 :this.indexableAttributes.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.obsoleteIndexedAttributes == null)? 0 :this.obsoleteIndexedAttributes.hashCode()));
        result = ((result* 31)+((this.indexedAttributes == null)? 0 :this.indexedAttributes.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrigramSummary) == false) {
            return false;
        }
        TrigramSummary rhs = ((TrigramSummary) other);
        return (((((this.indexableAttributes == rhs.indexableAttributes)||((this.indexableAttributes!= null)&&this.indexableAttributes.equals(rhs.indexableAttributes)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.obsoleteIndexedAttributes == rhs.obsoleteIndexedAttributes)||((this.obsoleteIndexedAttributes!= null)&&this.obsoleteIndexedAttributes.equals(rhs.obsoleteIndexedAttributes))))&&((this.indexedAttributes == rhs.indexedAttributes)||((this.indexedAttributes!= null)&&this.indexedAttributes.equals(rhs.indexedAttributes))));
    }

}
