
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dx",
    "filters",
    "inputIdScheme",
    "name",
    "ou",
    "outputDataElementIdScheme",
    "outputIdScheme",
    "outputOrgUnitIdScheme",
    "pe",
    "visualization"
})
@Generated("jsonschema2pojo")
public class SourceRequest implements Serializable
{

    @JsonProperty("dx")
    private List<String> dx;
    @JsonProperty("filters")
    private List<Filter> filters;
    @JsonProperty("inputIdScheme")
    private String inputIdScheme;
    @JsonProperty("name")
    private String name;
    @JsonProperty("ou")
    private List<String> ou;
    @JsonProperty("outputDataElementIdScheme")
    private String outputDataElementIdScheme;
    @JsonProperty("outputIdScheme")
    private String outputIdScheme;
    @JsonProperty("outputOrgUnitIdScheme")
    private String outputOrgUnitIdScheme;
    @JsonProperty("pe")
    private List<String> pe;
    @JsonProperty("visualization")
    private String visualization;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 9066456208324798318L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SourceRequest() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SourceRequest(SourceRequest source) {
        super();
        this.dx = source.dx;
        this.filters = source.filters;
        this.inputIdScheme = source.inputIdScheme;
        this.name = source.name;
        this.ou = source.ou;
        this.outputDataElementIdScheme = source.outputDataElementIdScheme;
        this.outputIdScheme = source.outputIdScheme;
        this.outputOrgUnitIdScheme = source.outputOrgUnitIdScheme;
        this.pe = source.pe;
        this.visualization = source.visualization;
    }

    public SourceRequest(List<String> dx, List<Filter> filters, String inputIdScheme, String name, List<String> ou, String outputDataElementIdScheme, String outputIdScheme, String outputOrgUnitIdScheme, List<String> pe, String visualization) {
        super();
        this.dx = dx;
        this.filters = filters;
        this.inputIdScheme = inputIdScheme;
        this.name = name;
        this.ou = ou;
        this.outputDataElementIdScheme = outputDataElementIdScheme;
        this.outputIdScheme = outputIdScheme;
        this.outputOrgUnitIdScheme = outputOrgUnitIdScheme;
        this.pe = pe;
        this.visualization = visualization;
    }

    @JsonProperty("dx")
    public Optional<List<String>> getDx() {
        return Optional.ofNullable(dx);
    }

    @JsonProperty("dx")
    public void setDx(List<String> dx) {
        this.dx = dx;
    }

    public SourceRequest withDx(List<String> dx) {
        this.dx = dx;
        return this;
    }

    @JsonProperty("filters")
    public Optional<List<Filter>> getFilters() {
        return Optional.ofNullable(filters);
    }

    @JsonProperty("filters")
    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public SourceRequest withFilters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    @JsonProperty("inputIdScheme")
    public Optional<String> getInputIdScheme() {
        return Optional.ofNullable(inputIdScheme);
    }

    @JsonProperty("inputIdScheme")
    public void setInputIdScheme(String inputIdScheme) {
        this.inputIdScheme = inputIdScheme;
    }

    public SourceRequest withInputIdScheme(String inputIdScheme) {
        this.inputIdScheme = inputIdScheme;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public SourceRequest withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("ou")
    public Optional<List<String>> getOu() {
        return Optional.ofNullable(ou);
    }

    @JsonProperty("ou")
    public void setOu(List<String> ou) {
        this.ou = ou;
    }

    public SourceRequest withOu(List<String> ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty("outputDataElementIdScheme")
    public Optional<String> getOutputDataElementIdScheme() {
        return Optional.ofNullable(outputDataElementIdScheme);
    }

    @JsonProperty("outputDataElementIdScheme")
    public void setOutputDataElementIdScheme(String outputDataElementIdScheme) {
        this.outputDataElementIdScheme = outputDataElementIdScheme;
    }

    public SourceRequest withOutputDataElementIdScheme(String outputDataElementIdScheme) {
        this.outputDataElementIdScheme = outputDataElementIdScheme;
        return this;
    }

    @JsonProperty("outputIdScheme")
    public Optional<String> getOutputIdScheme() {
        return Optional.ofNullable(outputIdScheme);
    }

    @JsonProperty("outputIdScheme")
    public void setOutputIdScheme(String outputIdScheme) {
        this.outputIdScheme = outputIdScheme;
    }

    public SourceRequest withOutputIdScheme(String outputIdScheme) {
        this.outputIdScheme = outputIdScheme;
        return this;
    }

    @JsonProperty("outputOrgUnitIdScheme")
    public Optional<String> getOutputOrgUnitIdScheme() {
        return Optional.ofNullable(outputOrgUnitIdScheme);
    }

    @JsonProperty("outputOrgUnitIdScheme")
    public void setOutputOrgUnitIdScheme(String outputOrgUnitIdScheme) {
        this.outputOrgUnitIdScheme = outputOrgUnitIdScheme;
    }

    public SourceRequest withOutputOrgUnitIdScheme(String outputOrgUnitIdScheme) {
        this.outputOrgUnitIdScheme = outputOrgUnitIdScheme;
        return this;
    }

    @JsonProperty("pe")
    public Optional<List<String>> getPe() {
        return Optional.ofNullable(pe);
    }

    @JsonProperty("pe")
    public void setPe(List<String> pe) {
        this.pe = pe;
    }

    public SourceRequest withPe(List<String> pe) {
        this.pe = pe;
        return this;
    }

    @JsonProperty("visualization")
    public Optional<String> getVisualization() {
        return Optional.ofNullable(visualization);
    }

    @JsonProperty("visualization")
    public void setVisualization(String visualization) {
        this.visualization = visualization;
    }

    public SourceRequest withVisualization(String visualization) {
        this.visualization = visualization;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SourceRequest withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dx".equals(name)) {
            if (value instanceof List) {
                setDx(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"dx\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("filters".equals(name)) {
                if (value instanceof List) {
                    setFilters(((List<Filter> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"filters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Filter>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("inputIdScheme".equals(name)) {
                    if (value instanceof String) {
                        setInputIdScheme(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"inputIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("name".equals(name)) {
                        if (value instanceof String) {
                            setName(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("ou".equals(name)) {
                            if (value instanceof List) {
                                setOu(((List<String> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"ou\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("outputDataElementIdScheme".equals(name)) {
                                if (value instanceof String) {
                                    setOutputDataElementIdScheme(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"outputDataElementIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("outputIdScheme".equals(name)) {
                                    if (value instanceof String) {
                                        setOutputIdScheme(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"outputIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("outputOrgUnitIdScheme".equals(name)) {
                                        if (value instanceof String) {
                                            setOutputOrgUnitIdScheme(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"outputOrgUnitIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("pe".equals(name)) {
                                            if (value instanceof List) {
                                                setPe(((List<String> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"pe\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("visualization".equals(name)) {
                                                if (value instanceof String) {
                                                    setVisualization(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"visualization\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dx".equals(name)) {
            return getDx();
        } else {
            if ("filters".equals(name)) {
                return getFilters();
            } else {
                if ("inputIdScheme".equals(name)) {
                    return getInputIdScheme();
                } else {
                    if ("name".equals(name)) {
                        return getName();
                    } else {
                        if ("ou".equals(name)) {
                            return getOu();
                        } else {
                            if ("outputDataElementIdScheme".equals(name)) {
                                return getOutputDataElementIdScheme();
                            } else {
                                if ("outputIdScheme".equals(name)) {
                                    return getOutputIdScheme();
                                } else {
                                    if ("outputOrgUnitIdScheme".equals(name)) {
                                        return getOutputOrgUnitIdScheme();
                                    } else {
                                        if ("pe".equals(name)) {
                                            return getPe();
                                        } else {
                                            if ("visualization".equals(name)) {
                                                return getVisualization();
                                            } else {
                                                return notFoundValue;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SourceRequest.NOT_FOUND_VALUE);
        if (SourceRequest.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SourceRequest with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SourceRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dx");
        sb.append('=');
        sb.append(((this.dx == null)?"<null>":this.dx));
        sb.append(',');
        sb.append("filters");
        sb.append('=');
        sb.append(((this.filters == null)?"<null>":this.filters));
        sb.append(',');
        sb.append("inputIdScheme");
        sb.append('=');
        sb.append(((this.inputIdScheme == null)?"<null>":this.inputIdScheme));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(((this.ou == null)?"<null>":this.ou));
        sb.append(',');
        sb.append("outputDataElementIdScheme");
        sb.append('=');
        sb.append(((this.outputDataElementIdScheme == null)?"<null>":this.outputDataElementIdScheme));
        sb.append(',');
        sb.append("outputIdScheme");
        sb.append('=');
        sb.append(((this.outputIdScheme == null)?"<null>":this.outputIdScheme));
        sb.append(',');
        sb.append("outputOrgUnitIdScheme");
        sb.append('=');
        sb.append(((this.outputOrgUnitIdScheme == null)?"<null>":this.outputOrgUnitIdScheme));
        sb.append(',');
        sb.append("pe");
        sb.append('=');
        sb.append(((this.pe == null)?"<null>":this.pe));
        sb.append(',');
        sb.append("visualization");
        sb.append('=');
        sb.append(((this.visualization == null)?"<null>":this.visualization));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.visualization == null)? 0 :this.visualization.hashCode()));
        result = ((result* 31)+((this.ou == null)? 0 :this.ou.hashCode()));
        result = ((result* 31)+((this.filters == null)? 0 :this.filters.hashCode()));
        result = ((result* 31)+((this.outputOrgUnitIdScheme == null)? 0 :this.outputOrgUnitIdScheme.hashCode()));
        result = ((result* 31)+((this.dx == null)? 0 :this.dx.hashCode()));
        result = ((result* 31)+((this.inputIdScheme == null)? 0 :this.inputIdScheme.hashCode()));
        result = ((result* 31)+((this.pe == null)? 0 :this.pe.hashCode()));
        result = ((result* 31)+((this.outputIdScheme == null)? 0 :this.outputIdScheme.hashCode()));
        result = ((result* 31)+((this.outputDataElementIdScheme == null)? 0 :this.outputDataElementIdScheme.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SourceRequest) == false) {
            return false;
        }
        SourceRequest rhs = ((SourceRequest) other);
        return ((((((((((((this.visualization == rhs.visualization)||((this.visualization!= null)&&this.visualization.equals(rhs.visualization)))&&((this.ou == rhs.ou)||((this.ou!= null)&&this.ou.equals(rhs.ou))))&&((this.filters == rhs.filters)||((this.filters!= null)&&this.filters.equals(rhs.filters))))&&((this.outputOrgUnitIdScheme == rhs.outputOrgUnitIdScheme)||((this.outputOrgUnitIdScheme!= null)&&this.outputOrgUnitIdScheme.equals(rhs.outputOrgUnitIdScheme))))&&((this.dx == rhs.dx)||((this.dx!= null)&&this.dx.equals(rhs.dx))))&&((this.inputIdScheme == rhs.inputIdScheme)||((this.inputIdScheme!= null)&&this.inputIdScheme.equals(rhs.inputIdScheme))))&&((this.pe == rhs.pe)||((this.pe!= null)&&this.pe.equals(rhs.pe))))&&((this.outputIdScheme == rhs.outputIdScheme)||((this.outputIdScheme!= null)&&this.outputIdScheme.equals(rhs.outputIdScheme))))&&((this.outputDataElementIdScheme == rhs.outputDataElementIdScheme)||((this.outputDataElementIdScheme!= null)&&this.outputDataElementIdScheme.equals(rhs.outputDataElementIdScheme))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
