
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregateExportAttributeOptionCombo",
    "aggregateExportCategoryOptionCombo",
    "aggregationType",
    "analyticsPeriodBoundaries",
    "analyticsType",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "decimals",
    "description",
    "dimensionItem",
    "displayDescription",
    "displayFormName",
    "displayInForm",
    "displayName",
    "displayShortName",
    "expression",
    "externalAccess",
    "favorite",
    "favorites",
    "filter",
    "formName",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "legendSets",
    "name",
    "orgUnitField",
    "program",
    "programIndicatorGroups",
    "publicAccess",
    "queryMods",
    "sharing",
    "shortName",
    "style",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramIndicator implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregateExportAttributeOptionCombo")
    private String aggregateExportAttributeOptionCombo;
    @JsonProperty("aggregateExportCategoryOptionCombo")
    private String aggregateExportCategoryOptionCombo;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    private ProgramIndicator.AggregationType aggregationType;
    @JsonProperty("analyticsPeriodBoundaries")
    private List<RefAnalyticsPeriodBoundary> analyticsPeriodBoundaries;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("analyticsType")
    private ProgramIndicator.AnalyticsType analyticsType;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser createdBy;
    @JsonProperty("decimals")
    private Integer decimals;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayInForm")
    private Boolean displayInForm;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("expression")
    private String expression;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("filter")
    private String filter;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser lastUpdatedBy;
    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    @JsonPropertyDescription("A UID reference to a LegendSet  \n(Java name `org.hisp.dhis.legend.LegendSet`)")
    private RefLegendSet legendSet;
    @JsonProperty("legendSets")
    private List<RefLegendSet> legendSets;
    @JsonProperty("name")
    private String name;
    @JsonProperty("orgUnitField")
    private String orgUnitField;
    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    @JsonPropertyDescription("A UID reference to a Program  \n(Java name `org.hisp.dhis.program.Program`)")
    private RefProgram program;
    @JsonProperty("programIndicatorGroups")
    private List<RefProgramIndicatorGroup> programIndicatorGroups;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("queryMods")
    private QueryModifiers queryMods;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private RefUser user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7250509216578862497L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramIndicator() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramIndicator(ProgramIndicator source) {
        super();
        this.access = source.access;
        this.aggregateExportAttributeOptionCombo = source.aggregateExportAttributeOptionCombo;
        this.aggregateExportCategoryOptionCombo = source.aggregateExportCategoryOptionCombo;
        this.aggregationType = source.aggregationType;
        this.analyticsPeriodBoundaries = source.analyticsPeriodBoundaries;
        this.analyticsType = source.analyticsType;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.decimals = source.decimals;
        this.description = source.description;
        this.dimensionItem = source.dimensionItem;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayInForm = source.displayInForm;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.expression = source.expression;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filter = source.filter;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.name = source.name;
        this.orgUnitField = source.orgUnitField;
        this.program = source.program;
        this.programIndicatorGroups = source.programIndicatorGroups;
        this.publicAccess = source.publicAccess;
        this.queryMods = source.queryMods;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.style = source.style;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public ProgramIndicator(Access access, String aggregateExportAttributeOptionCombo, String aggregateExportCategoryOptionCombo, ProgramIndicator.AggregationType aggregationType, List<RefAnalyticsPeriodBoundary> analyticsPeriodBoundaries, ProgramIndicator.AnalyticsType analyticsType, List<AttributeValue> attributeValues, String code, Date created, RefUser createdBy, Integer decimals, String description, String dimensionItem, String displayDescription, String displayFormName, Boolean displayInForm, String displayName, String displayShortName, String expression, Boolean externalAccess, Boolean favorite, List<String> favorites, String filter, String formName, String href, String id, Date lastUpdated, RefUser lastUpdatedBy, RefLegendSet legendSet, List<RefLegendSet> legendSets, String name, String orgUnitField, RefProgram program, List<RefProgramIndicatorGroup> programIndicatorGroups, String publicAccess, QueryModifiers queryMods, Sharing sharing, String shortName, ObjectStyle style, List<Translation> translations, RefUser user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
        this.aggregationType = aggregationType;
        this.analyticsPeriodBoundaries = analyticsPeriodBoundaries;
        this.analyticsType = analyticsType;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.decimals = decimals;
        this.description = description;
        this.dimensionItem = dimensionItem;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayInForm = displayInForm;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.expression = expression;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filter = filter;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.name = name;
        this.orgUnitField = orgUnitField;
        this.program = program;
        this.programIndicatorGroups = programIndicatorGroups;
        this.publicAccess = publicAccess;
        this.queryMods = queryMods;
        this.sharing = sharing;
        this.shortName = shortName;
        this.style = style;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramIndicator withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregateExportAttributeOptionCombo")
    public Optional<String> getAggregateExportAttributeOptionCombo() {
        return Optional.ofNullable(aggregateExportAttributeOptionCombo);
    }

    @JsonProperty("aggregateExportAttributeOptionCombo")
    public void setAggregateExportAttributeOptionCombo(String aggregateExportAttributeOptionCombo) {
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
    }

    public ProgramIndicator withAggregateExportAttributeOptionCombo(String aggregateExportAttributeOptionCombo) {
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
        return this;
    }

    @JsonProperty("aggregateExportCategoryOptionCombo")
    public Optional<String> getAggregateExportCategoryOptionCombo() {
        return Optional.ofNullable(aggregateExportCategoryOptionCombo);
    }

    @JsonProperty("aggregateExportCategoryOptionCombo")
    public void setAggregateExportCategoryOptionCombo(String aggregateExportCategoryOptionCombo) {
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
    }

    public ProgramIndicator withAggregateExportCategoryOptionCombo(String aggregateExportCategoryOptionCombo) {
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public ProgramIndicator.AggregationType getAggregationType() {
        return aggregationType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public void setAggregationType(ProgramIndicator.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public ProgramIndicator withAggregationType(ProgramIndicator.AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("analyticsPeriodBoundaries")
    public Optional<List<RefAnalyticsPeriodBoundary>> getAnalyticsPeriodBoundaries() {
        return Optional.ofNullable(analyticsPeriodBoundaries);
    }

    @JsonProperty("analyticsPeriodBoundaries")
    public void setAnalyticsPeriodBoundaries(List<RefAnalyticsPeriodBoundary> analyticsPeriodBoundaries) {
        this.analyticsPeriodBoundaries = analyticsPeriodBoundaries;
    }

    public ProgramIndicator withAnalyticsPeriodBoundaries(List<RefAnalyticsPeriodBoundary> analyticsPeriodBoundaries) {
        this.analyticsPeriodBoundaries = analyticsPeriodBoundaries;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("analyticsType")
    public ProgramIndicator.AnalyticsType getAnalyticsType() {
        return analyticsType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("analyticsType")
    public void setAnalyticsType(ProgramIndicator.AnalyticsType analyticsType) {
        this.analyticsType = analyticsType;
    }

    public ProgramIndicator withAnalyticsType(ProgramIndicator.AnalyticsType analyticsType) {
        this.analyticsType = analyticsType;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramIndicator withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramIndicator withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramIndicator withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<RefUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramIndicator withCreatedBy(RefUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("decimals")
    public Optional<Integer> getDecimals() {
        return Optional.ofNullable(decimals);
    }

    @JsonProperty("decimals")
    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public ProgramIndicator withDecimals(Integer decimals) {
        this.decimals = decimals;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ProgramIndicator withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public ProgramIndicator withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public ProgramIndicator withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public ProgramIndicator withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayInForm")
    public Optional<Boolean> getDisplayInForm() {
        return Optional.ofNullable(displayInForm);
    }

    @JsonProperty("displayInForm")
    public void setDisplayInForm(Boolean displayInForm) {
        this.displayInForm = displayInForm;
    }

    public ProgramIndicator withDisplayInForm(Boolean displayInForm) {
        this.displayInForm = displayInForm;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramIndicator withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public ProgramIndicator withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("expression")
    public Optional<String> getExpression() {
        return Optional.ofNullable(expression);
    }

    @JsonProperty("expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ProgramIndicator withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public Boolean getExternalAccess() {
        return externalAccess;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramIndicator withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public Boolean getFavorite() {
        return favorite;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramIndicator withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramIndicator withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filter")
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    @JsonProperty("filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public ProgramIndicator withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public ProgramIndicator withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramIndicator withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramIndicator withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramIndicator withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<RefUser> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramIndicator withLastUpdatedBy(RefUser lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public Optional<RefLegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public void setLegendSet(RefLegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public ProgramIndicator withLegendSet(RefLegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<RefLegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<RefLegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public ProgramIndicator withLegendSets(List<RefLegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramIndicator withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("orgUnitField")
    public Optional<String> getOrgUnitField() {
        return Optional.ofNullable(orgUnitField);
    }

    @JsonProperty("orgUnitField")
    public void setOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
    }

    public ProgramIndicator withOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
        return this;
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public Optional<RefProgram> getProgram() {
        return Optional.ofNullable(program);
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public void setProgram(RefProgram program) {
        this.program = program;
    }

    public ProgramIndicator withProgram(RefProgram program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programIndicatorGroups")
    public Optional<List<RefProgramIndicatorGroup>> getProgramIndicatorGroups() {
        return Optional.ofNullable(programIndicatorGroups);
    }

    @JsonProperty("programIndicatorGroups")
    public void setProgramIndicatorGroups(List<RefProgramIndicatorGroup> programIndicatorGroups) {
        this.programIndicatorGroups = programIndicatorGroups;
    }

    public ProgramIndicator withProgramIndicatorGroups(List<RefProgramIndicatorGroup> programIndicatorGroups) {
        this.programIndicatorGroups = programIndicatorGroups;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramIndicator withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("queryMods")
    public Optional<QueryModifiers> getQueryMods() {
        return Optional.ofNullable(queryMods);
    }

    @JsonProperty("queryMods")
    public void setQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
    }

    public ProgramIndicator withQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramIndicator withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public ProgramIndicator withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public ProgramIndicator withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramIndicator withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<RefUser> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(RefUser user) {
        this.user = user;
    }

    public ProgramIndicator withUser(RefUser user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramIndicator withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramIndicator withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramIndicator withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_0.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("aggregateExportAttributeOptionCombo".equals(name)) {
                if (value instanceof String) {
                    setAggregateExportAttributeOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregateExportAttributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("aggregateExportCategoryOptionCombo".equals(name)) {
                    if (value instanceof String) {
                        setAggregateExportCategoryOptionCombo(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"aggregateExportCategoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("aggregationType".equals(name)) {
                        if (value instanceof ProgramIndicator.AggregationType) {
                            setAggregationType(((ProgramIndicator.AggregationType) value));
                        } else {
                            throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramIndicator.AggregationType\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("analyticsPeriodBoundaries".equals(name)) {
                            if (value instanceof List) {
                                setAnalyticsPeriodBoundaries(((List<RefAnalyticsPeriodBoundary> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"analyticsPeriodBoundaries\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefAnalyticsPeriodBoundary>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("analyticsType".equals(name)) {
                                if (value instanceof ProgramIndicator.AnalyticsType) {
                                    setAnalyticsType(((ProgramIndicator.AnalyticsType) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"analyticsType\" is of type \"org.hisp.dhis.api.model.v40_0.ProgramIndicator.AnalyticsType\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("attributeValues".equals(name)) {
                                    if (value instanceof List) {
                                        setAttributeValues(((List<AttributeValue> ) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.AttributeValue>\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("code".equals(name)) {
                                        if (value instanceof String) {
                                            setCode(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("created".equals(name)) {
                                            if (value instanceof Date) {
                                                setCreated(((Date) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("createdBy".equals(name)) {
                                                if (value instanceof RefUser) {
                                                    setCreatedBy(((RefUser) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("decimals".equals(name)) {
                                                    if (value instanceof Integer) {
                                                        setDecimals(((Integer) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"decimals\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("description".equals(name)) {
                                                        if (value instanceof String) {
                                                            setDescription(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("dimensionItem".equals(name)) {
                                                            if (value instanceof String) {
                                                                setDimensionItem(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("displayDescription".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setDisplayDescription(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("displayFormName".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setDisplayFormName(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("displayInForm".equals(name)) {
                                                                        if (value instanceof Boolean) {
                                                                            setDisplayInForm(((Boolean) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"displayInForm\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("displayName".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setDisplayName(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("displayShortName".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setDisplayShortName(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("expression".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setExpression(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"expression\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("externalAccess".equals(name)) {
                                                                                        if (value instanceof Boolean) {
                                                                                            setExternalAccess(((Boolean) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("favorite".equals(name)) {
                                                                                            if (value instanceof Boolean) {
                                                                                                setFavorite(((Boolean) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("favorites".equals(name)) {
                                                                                                if (value instanceof List) {
                                                                                                    setFavorites(((List<String> ) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("filter".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setFilter(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"filter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("formName".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setFormName(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("href".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setHref(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("id".equals(name)) {
                                                                                                                if (value instanceof String) {
                                                                                                                    setId(((String) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                                    if (value instanceof Date) {
                                                                                                                        setLastUpdated(((Date) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                                                        if (value instanceof RefUser) {
                                                                                                                            setLastUpdatedBy(((RefUser) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("legendSet".equals(name)) {
                                                                                                                            if (value instanceof RefLegendSet) {
                                                                                                                                setLegendSet(((RefLegendSet) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v40_0.RefLegendSet\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("legendSets".equals(name)) {
                                                                                                                                if (value instanceof List) {
                                                                                                                                    setLegendSets(((List<RefLegendSet> ) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefLegendSet>\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("name".equals(name)) {
                                                                                                                                    if (value instanceof String) {
                                                                                                                                        setName(((String) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("orgUnitField".equals(name)) {
                                                                                                                                        if (value instanceof String) {
                                                                                                                                            setOrgUnitField(((String) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"orgUnitField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("program".equals(name)) {
                                                                                                                                            if (value instanceof RefProgram) {
                                                                                                                                                setProgram(((RefProgram) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgram\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("programIndicatorGroups".equals(name)) {
                                                                                                                                                if (value instanceof List) {
                                                                                                                                                    setProgramIndicatorGroups(((List<RefProgramIndicatorGroup> ) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"programIndicatorGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.RefProgramIndicatorGroup>\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("publicAccess".equals(name)) {
                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                        setPublicAccess(((String) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("queryMods".equals(name)) {
                                                                                                                                                        if (value instanceof QueryModifiers) {
                                                                                                                                                            setQueryMods(((QueryModifiers) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"queryMods\" is of type \"org.hisp.dhis.api.model.v40_0.QueryModifiers\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("sharing".equals(name)) {
                                                                                                                                                            if (value instanceof Sharing) {
                                                                                                                                                                setSharing(((Sharing) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_0.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("shortName".equals(name)) {
                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                    setShortName(((String) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("style".equals(name)) {
                                                                                                                                                                    if (value instanceof ObjectStyle) {
                                                                                                                                                                        setStyle(((ObjectStyle) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v40_0.ObjectStyle\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                                                            if (value instanceof RefUser) {
                                                                                                                                                                                setUser(((RefUser) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_0.RefUser\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                    setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                        setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("aggregateExportAttributeOptionCombo".equals(name)) {
                return getAggregateExportAttributeOptionCombo();
            } else {
                if ("aggregateExportCategoryOptionCombo".equals(name)) {
                    return getAggregateExportCategoryOptionCombo();
                } else {
                    if ("aggregationType".equals(name)) {
                        return getAggregationType();
                    } else {
                        if ("analyticsPeriodBoundaries".equals(name)) {
                            return getAnalyticsPeriodBoundaries();
                        } else {
                            if ("analyticsType".equals(name)) {
                                return getAnalyticsType();
                            } else {
                                if ("attributeValues".equals(name)) {
                                    return getAttributeValues();
                                } else {
                                    if ("code".equals(name)) {
                                        return getCode();
                                    } else {
                                        if ("created".equals(name)) {
                                            return getCreated();
                                        } else {
                                            if ("createdBy".equals(name)) {
                                                return getCreatedBy();
                                            } else {
                                                if ("decimals".equals(name)) {
                                                    return getDecimals();
                                                } else {
                                                    if ("description".equals(name)) {
                                                        return getDescription();
                                                    } else {
                                                        if ("dimensionItem".equals(name)) {
                                                            return getDimensionItem();
                                                        } else {
                                                            if ("displayDescription".equals(name)) {
                                                                return getDisplayDescription();
                                                            } else {
                                                                if ("displayFormName".equals(name)) {
                                                                    return getDisplayFormName();
                                                                } else {
                                                                    if ("displayInForm".equals(name)) {
                                                                        return getDisplayInForm();
                                                                    } else {
                                                                        if ("displayName".equals(name)) {
                                                                            return getDisplayName();
                                                                        } else {
                                                                            if ("displayShortName".equals(name)) {
                                                                                return getDisplayShortName();
                                                                            } else {
                                                                                if ("expression".equals(name)) {
                                                                                    return getExpression();
                                                                                } else {
                                                                                    if ("externalAccess".equals(name)) {
                                                                                        return getExternalAccess();
                                                                                    } else {
                                                                                        if ("favorite".equals(name)) {
                                                                                            return getFavorite();
                                                                                        } else {
                                                                                            if ("favorites".equals(name)) {
                                                                                                return getFavorites();
                                                                                            } else {
                                                                                                if ("filter".equals(name)) {
                                                                                                    return getFilter();
                                                                                                } else {
                                                                                                    if ("formName".equals(name)) {
                                                                                                        return getFormName();
                                                                                                    } else {
                                                                                                        if ("href".equals(name)) {
                                                                                                            return getHref();
                                                                                                        } else {
                                                                                                            if ("id".equals(name)) {
                                                                                                                return getId();
                                                                                                            } else {
                                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                                    return getLastUpdated();
                                                                                                                } else {
                                                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                                                        return getLastUpdatedBy();
                                                                                                                    } else {
                                                                                                                        if ("legendSet".equals(name)) {
                                                                                                                            return getLegendSet();
                                                                                                                        } else {
                                                                                                                            if ("legendSets".equals(name)) {
                                                                                                                                return getLegendSets();
                                                                                                                            } else {
                                                                                                                                if ("name".equals(name)) {
                                                                                                                                    return getName();
                                                                                                                                } else {
                                                                                                                                    if ("orgUnitField".equals(name)) {
                                                                                                                                        return getOrgUnitField();
                                                                                                                                    } else {
                                                                                                                                        if ("program".equals(name)) {
                                                                                                                                            return getProgram();
                                                                                                                                        } else {
                                                                                                                                            if ("programIndicatorGroups".equals(name)) {
                                                                                                                                                return getProgramIndicatorGroups();
                                                                                                                                            } else {
                                                                                                                                                if ("publicAccess".equals(name)) {
                                                                                                                                                    return getPublicAccess();
                                                                                                                                                } else {
                                                                                                                                                    if ("queryMods".equals(name)) {
                                                                                                                                                        return getQueryMods();
                                                                                                                                                    } else {
                                                                                                                                                        if ("sharing".equals(name)) {
                                                                                                                                                            return getSharing();
                                                                                                                                                        } else {
                                                                                                                                                            if ("shortName".equals(name)) {
                                                                                                                                                                return getShortName();
                                                                                                                                                            } else {
                                                                                                                                                                if ("style".equals(name)) {
                                                                                                                                                                    return getStyle();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                                                        return getTranslations();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                                                            return getUser();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                                                return getUserAccesses();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                    return getUserGroupAccesses();
                                                                                                                                                                                } else {
                                                                                                                                                                                    return notFoundValue;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramIndicator.NOT_FOUND_VALUE);
        if (ProgramIndicator.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramIndicator with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramIndicator.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregateExportAttributeOptionCombo");
        sb.append('=');
        sb.append(((this.aggregateExportAttributeOptionCombo == null)?"<null>":this.aggregateExportAttributeOptionCombo));
        sb.append(',');
        sb.append("aggregateExportCategoryOptionCombo");
        sb.append('=');
        sb.append(((this.aggregateExportCategoryOptionCombo == null)?"<null>":this.aggregateExportCategoryOptionCombo));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("analyticsPeriodBoundaries");
        sb.append('=');
        sb.append(((this.analyticsPeriodBoundaries == null)?"<null>":this.analyticsPeriodBoundaries));
        sb.append(',');
        sb.append("analyticsType");
        sb.append('=');
        sb.append(((this.analyticsType == null)?"<null>":this.analyticsType));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("decimals");
        sb.append('=');
        sb.append(((this.decimals == null)?"<null>":this.decimals));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayInForm");
        sb.append('=');
        sb.append(((this.displayInForm == null)?"<null>":this.displayInForm));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("expression");
        sb.append('=');
        sb.append(((this.expression == null)?"<null>":this.expression));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filter");
        sb.append('=');
        sb.append(((this.filter == null)?"<null>":this.filter));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("orgUnitField");
        sb.append('=');
        sb.append(((this.orgUnitField == null)?"<null>":this.orgUnitField));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programIndicatorGroups");
        sb.append('=');
        sb.append(((this.programIndicatorGroups == null)?"<null>":this.programIndicatorGroups));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("queryMods");
        sb.append('=');
        sb.append(((this.queryMods == null)?"<null>":this.queryMods));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.orgUnitField == null)? 0 :this.orgUnitField.hashCode()));
        result = ((result* 31)+((this.displayInForm == null)? 0 :this.displayInForm.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.aggregateExportCategoryOptionCombo == null)? 0 :this.aggregateExportCategoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.queryMods == null)? 0 :this.queryMods.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.programIndicatorGroups == null)? 0 :this.programIndicatorGroups.hashCode()));
        result = ((result* 31)+((this.analyticsPeriodBoundaries == null)? 0 :this.analyticsPeriodBoundaries.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.expression == null)? 0 :this.expression.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.filter == null)? 0 :this.filter.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.decimals == null)? 0 :this.decimals.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.analyticsType == null)? 0 :this.analyticsType.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.aggregateExportAttributeOptionCombo == null)? 0 :this.aggregateExportAttributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramIndicator) == false) {
            return false;
        }
        ProgramIndicator rhs = ((ProgramIndicator) other);
        return (((((((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.orgUnitField == rhs.orgUnitField)||((this.orgUnitField!= null)&&this.orgUnitField.equals(rhs.orgUnitField))))&&((this.displayInForm == rhs.displayInForm)||((this.displayInForm!= null)&&this.displayInForm.equals(rhs.displayInForm))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.aggregateExportCategoryOptionCombo == rhs.aggregateExportCategoryOptionCombo)||((this.aggregateExportCategoryOptionCombo!= null)&&this.aggregateExportCategoryOptionCombo.equals(rhs.aggregateExportCategoryOptionCombo))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.queryMods == rhs.queryMods)||((this.queryMods!= null)&&this.queryMods.equals(rhs.queryMods))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.programIndicatorGroups == rhs.programIndicatorGroups)||((this.programIndicatorGroups!= null)&&this.programIndicatorGroups.equals(rhs.programIndicatorGroups))))&&((this.analyticsPeriodBoundaries == rhs.analyticsPeriodBoundaries)||((this.analyticsPeriodBoundaries!= null)&&this.analyticsPeriodBoundaries.equals(rhs.analyticsPeriodBoundaries))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.expression == rhs.expression)||((this.expression!= null)&&this.expression.equals(rhs.expression))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.filter == rhs.filter)||((this.filter!= null)&&this.filter.equals(rhs.filter))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.decimals == rhs.decimals)||((this.decimals!= null)&&this.decimals.equals(rhs.decimals))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.analyticsType == rhs.analyticsType)||((this.analyticsType!= null)&&this.analyticsType.equals(rhs.analyticsType))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.aggregateExportAttributeOptionCombo == rhs.aggregateExportAttributeOptionCombo)||((this.aggregateExportAttributeOptionCombo!= null)&&this.aggregateExportAttributeOptionCombo.equals(rhs.aggregateExportAttributeOptionCombo))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum AggregationType {

        SUM("SUM"),
        AVERAGE("AVERAGE"),
        AVERAGE_SUM_ORG_UNIT("AVERAGE_SUM_ORG_UNIT"),
        LAST("LAST"),
        LAST_AVERAGE_ORG_UNIT("LAST_AVERAGE_ORG_UNIT"),
        LAST_LAST_ORG_UNIT("LAST_LAST_ORG_UNIT"),
        LAST_IN_PERIOD("LAST_IN_PERIOD"),
        LAST_IN_PERIOD_AVERAGE_ORG_UNIT("LAST_IN_PERIOD_AVERAGE_ORG_UNIT"),
        FIRST("FIRST"),
        FIRST_AVERAGE_ORG_UNIT("FIRST_AVERAGE_ORG_UNIT"),
        FIRST_FIRST_ORG_UNIT("FIRST_FIRST_ORG_UNIT"),
        COUNT("COUNT"),
        STDDEV("STDDEV"),
        VARIANCE("VARIANCE"),
        MIN("MIN"),
        MAX("MAX"),
        MIN_SUM_ORG_UNIT("MIN_SUM_ORG_UNIT"),
        MAX_SUM_ORG_UNIT("MAX_SUM_ORG_UNIT"),
        NONE("NONE"),
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");
        private final String value;
        private final static Map<String, ProgramIndicator.AggregationType> CONSTANTS = new HashMap<String, ProgramIndicator.AggregationType>();

        static {
            for (ProgramIndicator.AggregationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AggregationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramIndicator.AggregationType fromValue(String value) {
            ProgramIndicator.AggregationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AnalyticsType {

        EVENT("EVENT"),
        ENROLLMENT("ENROLLMENT");
        private final String value;
        private final static Map<String, ProgramIndicator.AnalyticsType> CONSTANTS = new HashMap<String, ProgramIndicator.AnalyticsType>();

        static {
            for (ProgramIndicator.AnalyticsType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AnalyticsType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramIndicator.AnalyticsType fromValue(String value) {
            ProgramIndicator.AnalyticsType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
