
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "metadata",
    "outlierValues"
})
@Generated("jsonschema2pojo")
public class OutlierDetectionResponse implements Serializable
{

    @JsonProperty("metadata")
    private OutlierDetectionMetadata metadata;
    @JsonProperty("outlierValues")
    private List<OutlierValue> outlierValues;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6209760027951368731L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OutlierDetectionResponse() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OutlierDetectionResponse(OutlierDetectionResponse source) {
        super();
        this.metadata = source.metadata;
        this.outlierValues = source.outlierValues;
    }

    public OutlierDetectionResponse(OutlierDetectionMetadata metadata, List<OutlierValue> outlierValues) {
        super();
        this.metadata = metadata;
        this.outlierValues = outlierValues;
    }

    @JsonProperty("metadata")
    public Optional<OutlierDetectionMetadata> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    @JsonProperty("metadata")
    public void setMetadata(OutlierDetectionMetadata metadata) {
        this.metadata = metadata;
    }

    public OutlierDetectionResponse withMetadata(OutlierDetectionMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty("outlierValues")
    public Optional<List<OutlierValue>> getOutlierValues() {
        return Optional.ofNullable(outlierValues);
    }

    @JsonProperty("outlierValues")
    public void setOutlierValues(List<OutlierValue> outlierValues) {
        this.outlierValues = outlierValues;
    }

    public OutlierDetectionResponse withOutlierValues(List<OutlierValue> outlierValues) {
        this.outlierValues = outlierValues;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutlierDetectionResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("metadata".equals(name)) {
            if (value instanceof OutlierDetectionMetadata) {
                setMetadata(((OutlierDetectionMetadata) value));
            } else {
                throw new IllegalArgumentException(("property \"metadata\" is of type \"org.hisp.dhis.api.model.v40_0.OutlierDetectionMetadata\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("outlierValues".equals(name)) {
                if (value instanceof List) {
                    setOutlierValues(((List<OutlierValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"outlierValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.OutlierValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("metadata".equals(name)) {
            return getMetadata();
        } else {
            if ("outlierValues".equals(name)) {
                return getOutlierValues();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OutlierDetectionResponse.NOT_FOUND_VALUE);
        if (OutlierDetectionResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OutlierDetectionResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutlierDetectionResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("outlierValues");
        sb.append('=');
        sb.append(((this.outlierValues == null)?"<null>":this.outlierValues));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.outlierValues == null)? 0 :this.outlierValues.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OutlierDetectionResponse) == false) {
            return false;
        }
        OutlierDetectionResponse rhs = ((OutlierDetectionResponse) other);
        return ((((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.outlierValues == rhs.outlierValues)||((this.outlierValues!= null)&&this.outlierValues.equals(rhs.outlierValues))));
    }

}
