
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributes",
    "dataItems",
    "groupSets"
})
@Generated("jsonschema2pojo")
public class OrgUnitProfile implements Serializable
{

    @JsonProperty("attributes")
    private List<String> attributes;
    @JsonProperty("dataItems")
    private List<String> dataItems;
    @JsonProperty("groupSets")
    private List<String> groupSets;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4651841044015005829L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrgUnitProfile() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OrgUnitProfile(OrgUnitProfile source) {
        super();
        this.attributes = source.attributes;
        this.dataItems = source.dataItems;
        this.groupSets = source.groupSets;
    }

    public OrgUnitProfile(List<String> attributes, List<String> dataItems, List<String> groupSets) {
        super();
        this.attributes = attributes;
        this.dataItems = dataItems;
        this.groupSets = groupSets;
    }

    @JsonProperty("attributes")
    public Optional<List<String>> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    @JsonProperty("attributes")
    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public OrgUnitProfile withAttributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("dataItems")
    public Optional<List<String>> getDataItems() {
        return Optional.ofNullable(dataItems);
    }

    @JsonProperty("dataItems")
    public void setDataItems(List<String> dataItems) {
        this.dataItems = dataItems;
    }

    public OrgUnitProfile withDataItems(List<String> dataItems) {
        this.dataItems = dataItems;
        return this;
    }

    @JsonProperty("groupSets")
    public Optional<List<String>> getGroupSets() {
        return Optional.ofNullable(groupSets);
    }

    @JsonProperty("groupSets")
    public void setGroupSets(List<String> groupSets) {
        this.groupSets = groupSets;
    }

    public OrgUnitProfile withGroupSets(List<String> groupSets) {
        this.groupSets = groupSets;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrgUnitProfile withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributes".equals(name)) {
            if (value instanceof List) {
                setAttributes(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"attributes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataItems".equals(name)) {
                if (value instanceof List) {
                    setDataItems(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataItems\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("groupSets".equals(name)) {
                    if (value instanceof List) {
                        setGroupSets(((List<String> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"groupSets\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributes".equals(name)) {
            return getAttributes();
        } else {
            if ("dataItems".equals(name)) {
                return getDataItems();
            } else {
                if ("groupSets".equals(name)) {
                    return getGroupSets();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrgUnitProfile.NOT_FOUND_VALUE);
        if (OrgUnitProfile.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrgUnitProfile with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrgUnitProfile.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("dataItems");
        sb.append('=');
        sb.append(((this.dataItems == null)?"<null>":this.dataItems));
        sb.append(',');
        sb.append("groupSets");
        sb.append('=');
        sb.append(((this.groupSets == null)?"<null>":this.groupSets));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.groupSets == null)? 0 :this.groupSets.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataItems == null)? 0 :this.dataItems.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrgUnitProfile) == false) {
            return false;
        }
        OrgUnitProfile rhs = ((OrgUnitProfile) other);
        return (((((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes)))&&((this.groupSets == rhs.groupSets)||((this.groupSets!= null)&&this.groupSets.equals(rhs.groupSets))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataItems == rhs.dataItems)||((this.dataItems!= null)&&this.dataItems.equals(rhs.dataItems))));
    }

}
