
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "displayName",
    "errorReports",
    "index",
    "klass",
    "uid"
})
@Generated("jsonschema2pojo")
public class ObjectReport implements Serializable
{

    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("errorReports")
    private List<ErrorReport> errorReports;
    @JsonProperty("index")
    private Integer index;
    @JsonProperty("klass")
    private String klass;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -79927835405280251L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ObjectReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ObjectReport(ObjectReport source) {
        super();
        this.displayName = source.displayName;
        this.errorReports = source.errorReports;
        this.index = source.index;
        this.klass = source.klass;
        this.uid = source.uid;
    }

    public ObjectReport(String displayName, List<ErrorReport> errorReports, Integer index, String klass, String uid) {
        super();
        this.displayName = displayName;
        this.errorReports = errorReports;
        this.index = index;
        this.klass = klass;
        this.uid = uid;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ObjectReport withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("errorReports")
    public Optional<List<ErrorReport>> getErrorReports() {
        return Optional.ofNullable(errorReports);
    }

    @JsonProperty("errorReports")
    public void setErrorReports(List<ErrorReport> errorReports) {
        this.errorReports = errorReports;
    }

    public ObjectReport withErrorReports(List<ErrorReport> errorReports) {
        this.errorReports = errorReports;
        return this;
    }

    @JsonProperty("index")
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(index);
    }

    @JsonProperty("index")
    public void setIndex(Integer index) {
        this.index = index;
    }

    public ObjectReport withIndex(Integer index) {
        this.index = index;
        return this;
    }

    @JsonProperty("klass")
    public Optional<String> getKlass() {
        return Optional.ofNullable(klass);
    }

    @JsonProperty("klass")
    public void setKlass(String klass) {
        this.klass = klass;
    }

    public ObjectReport withKlass(String klass) {
        this.klass = klass;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public ObjectReport withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ObjectReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("displayName".equals(name)) {
            if (value instanceof String) {
                setDisplayName(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("errorReports".equals(name)) {
                if (value instanceof List) {
                    setErrorReports(((List<ErrorReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"errorReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.ErrorReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("index".equals(name)) {
                    if (value instanceof Integer) {
                        setIndex(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"index\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("klass".equals(name)) {
                        if (value instanceof String) {
                            setKlass(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"klass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("uid".equals(name)) {
                            if (value instanceof String) {
                                setUid(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("displayName".equals(name)) {
            return getDisplayName();
        } else {
            if ("errorReports".equals(name)) {
                return getErrorReports();
            } else {
                if ("index".equals(name)) {
                    return getIndex();
                } else {
                    if ("klass".equals(name)) {
                        return getKlass();
                    } else {
                        if ("uid".equals(name)) {
                            return getUid();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ObjectReport.NOT_FOUND_VALUE);
        if (ObjectReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ObjectReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ObjectReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("errorReports");
        sb.append('=');
        sb.append(((this.errorReports == null)?"<null>":this.errorReports));
        sb.append(',');
        sb.append("index");
        sb.append('=');
        sb.append(((this.index == null)?"<null>":this.index));
        sb.append(',');
        sb.append("klass");
        sb.append('=');
        sb.append(((this.klass == null)?"<null>":this.klass));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.klass == null)? 0 :this.klass.hashCode()));
        result = ((result* 31)+((this.index == null)? 0 :this.index.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.errorReports == null)? 0 :this.errorReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ObjectReport) == false) {
            return false;
        }
        ObjectReport rhs = ((ObjectReport) other);
        return (((((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.klass == rhs.klass)||((this.klass!= null)&&this.klass.equals(rhs.klass))))&&((this.index == rhs.index)||((this.index!= null)&&this.index.equals(rhs.index))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.errorReports == rhs.errorReports)||((this.errorReports!= null)&&this.errorReports.equals(rhs.errorReports))));
    }

}
