
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "atomicMode",
    "flushMode",
    "identifier",
    "importMode",
    "importReportMode",
    "importStrategy",
    "mergeMode",
    "metadataSyncImport",
    "preheatMode",
    "skipSharing",
    "skipTranslation",
    "skipValidation",
    "userOverrideMode"
})
@Generated("jsonschema2pojo")
public class MetadataImportParams implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("atomicMode")
    private MetadataImportParams.AtomicMode atomicMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("flushMode")
    private MetadataImportParams.FlushMode flushMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    private MetadataImportParams.Identifier identifier;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importMode")
    private MetadataImportParams.ImportMode importMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importReportMode")
    private MetadataImportParams.ImportReportMode importReportMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    private MetadataImportParams.ImportStrategy importStrategy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    private MetadataImportParams.MergeMode mergeMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("metadataSyncImport")
    private Boolean metadataSyncImport;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("preheatMode")
    private MetadataImportParams.PreheatMode preheatMode;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipSharing")
    private Boolean skipSharing;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipTranslation")
    private Boolean skipTranslation;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipValidation")
    private Boolean skipValidation;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOverrideMode")
    private MetadataImportParams.UserOverrideMode userOverrideMode;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2287438484847861608L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataImportParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MetadataImportParams(MetadataImportParams source) {
        super();
        this.atomicMode = source.atomicMode;
        this.flushMode = source.flushMode;
        this.identifier = source.identifier;
        this.importMode = source.importMode;
        this.importReportMode = source.importReportMode;
        this.importStrategy = source.importStrategy;
        this.mergeMode = source.mergeMode;
        this.metadataSyncImport = source.metadataSyncImport;
        this.preheatMode = source.preheatMode;
        this.skipSharing = source.skipSharing;
        this.skipTranslation = source.skipTranslation;
        this.skipValidation = source.skipValidation;
        this.userOverrideMode = source.userOverrideMode;
    }

    public MetadataImportParams(MetadataImportParams.AtomicMode atomicMode, MetadataImportParams.FlushMode flushMode, MetadataImportParams.Identifier identifier, MetadataImportParams.ImportMode importMode, MetadataImportParams.ImportReportMode importReportMode, MetadataImportParams.ImportStrategy importStrategy, MetadataImportParams.MergeMode mergeMode, Boolean metadataSyncImport, MetadataImportParams.PreheatMode preheatMode, Boolean skipSharing, Boolean skipTranslation, Boolean skipValidation, MetadataImportParams.UserOverrideMode userOverrideMode) {
        super();
        this.atomicMode = atomicMode;
        this.flushMode = flushMode;
        this.identifier = identifier;
        this.importMode = importMode;
        this.importReportMode = importReportMode;
        this.importStrategy = importStrategy;
        this.mergeMode = mergeMode;
        this.metadataSyncImport = metadataSyncImport;
        this.preheatMode = preheatMode;
        this.skipSharing = skipSharing;
        this.skipTranslation = skipTranslation;
        this.skipValidation = skipValidation;
        this.userOverrideMode = userOverrideMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("atomicMode")
    public MetadataImportParams.AtomicMode getAtomicMode() {
        return atomicMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("atomicMode")
    public void setAtomicMode(MetadataImportParams.AtomicMode atomicMode) {
        this.atomicMode = atomicMode;
    }

    public MetadataImportParams withAtomicMode(MetadataImportParams.AtomicMode atomicMode) {
        this.atomicMode = atomicMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("flushMode")
    public MetadataImportParams.FlushMode getFlushMode() {
        return flushMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("flushMode")
    public void setFlushMode(MetadataImportParams.FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public MetadataImportParams withFlushMode(MetadataImportParams.FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    public MetadataImportParams.Identifier getIdentifier() {
        return identifier;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    public void setIdentifier(MetadataImportParams.Identifier identifier) {
        this.identifier = identifier;
    }

    public MetadataImportParams withIdentifier(MetadataImportParams.Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importMode")
    public MetadataImportParams.ImportMode getImportMode() {
        return importMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importMode")
    public void setImportMode(MetadataImportParams.ImportMode importMode) {
        this.importMode = importMode;
    }

    public MetadataImportParams withImportMode(MetadataImportParams.ImportMode importMode) {
        this.importMode = importMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importReportMode")
    public MetadataImportParams.ImportReportMode getImportReportMode() {
        return importReportMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importReportMode")
    public void setImportReportMode(MetadataImportParams.ImportReportMode importReportMode) {
        this.importReportMode = importReportMode;
    }

    public MetadataImportParams withImportReportMode(MetadataImportParams.ImportReportMode importReportMode) {
        this.importReportMode = importReportMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    public MetadataImportParams.ImportStrategy getImportStrategy() {
        return importStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("importStrategy")
    public void setImportStrategy(MetadataImportParams.ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
    }

    public MetadataImportParams withImportStrategy(MetadataImportParams.ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    public MetadataImportParams.MergeMode getMergeMode() {
        return mergeMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("mergeMode")
    public void setMergeMode(MetadataImportParams.MergeMode mergeMode) {
        this.mergeMode = mergeMode;
    }

    public MetadataImportParams withMergeMode(MetadataImportParams.MergeMode mergeMode) {
        this.mergeMode = mergeMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("metadataSyncImport")
    public Boolean getMetadataSyncImport() {
        return metadataSyncImport;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("metadataSyncImport")
    public void setMetadataSyncImport(Boolean metadataSyncImport) {
        this.metadataSyncImport = metadataSyncImport;
    }

    public MetadataImportParams withMetadataSyncImport(Boolean metadataSyncImport) {
        this.metadataSyncImport = metadataSyncImport;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("preheatMode")
    public MetadataImportParams.PreheatMode getPreheatMode() {
        return preheatMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("preheatMode")
    public void setPreheatMode(MetadataImportParams.PreheatMode preheatMode) {
        this.preheatMode = preheatMode;
    }

    public MetadataImportParams withPreheatMode(MetadataImportParams.PreheatMode preheatMode) {
        this.preheatMode = preheatMode;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipSharing")
    public Boolean getSkipSharing() {
        return skipSharing;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipSharing")
    public void setSkipSharing(Boolean skipSharing) {
        this.skipSharing = skipSharing;
    }

    public MetadataImportParams withSkipSharing(Boolean skipSharing) {
        this.skipSharing = skipSharing;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipTranslation")
    public Boolean getSkipTranslation() {
        return skipTranslation;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipTranslation")
    public void setSkipTranslation(Boolean skipTranslation) {
        this.skipTranslation = skipTranslation;
    }

    public MetadataImportParams withSkipTranslation(Boolean skipTranslation) {
        this.skipTranslation = skipTranslation;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipValidation")
    public Boolean getSkipValidation() {
        return skipValidation;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("skipValidation")
    public void setSkipValidation(Boolean skipValidation) {
        this.skipValidation = skipValidation;
    }

    public MetadataImportParams withSkipValidation(Boolean skipValidation) {
        this.skipValidation = skipValidation;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOverrideMode")
    public MetadataImportParams.UserOverrideMode getUserOverrideMode() {
        return userOverrideMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("userOverrideMode")
    public void setUserOverrideMode(MetadataImportParams.UserOverrideMode userOverrideMode) {
        this.userOverrideMode = userOverrideMode;
    }

    public MetadataImportParams withUserOverrideMode(MetadataImportParams.UserOverrideMode userOverrideMode) {
        this.userOverrideMode = userOverrideMode;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataImportParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("atomicMode".equals(name)) {
            if (value instanceof MetadataImportParams.AtomicMode) {
                setAtomicMode(((MetadataImportParams.AtomicMode) value));
            } else {
                throw new IllegalArgumentException(("property \"atomicMode\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.AtomicMode\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("flushMode".equals(name)) {
                if (value instanceof MetadataImportParams.FlushMode) {
                    setFlushMode(((MetadataImportParams.FlushMode) value));
                } else {
                    throw new IllegalArgumentException(("property \"flushMode\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.FlushMode\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("identifier".equals(name)) {
                    if (value instanceof MetadataImportParams.Identifier) {
                        setIdentifier(((MetadataImportParams.Identifier) value));
                    } else {
                        throw new IllegalArgumentException(("property \"identifier\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.Identifier\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("importMode".equals(name)) {
                        if (value instanceof MetadataImportParams.ImportMode) {
                            setImportMode(((MetadataImportParams.ImportMode) value));
                        } else {
                            throw new IllegalArgumentException(("property \"importMode\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.ImportMode\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("importReportMode".equals(name)) {
                            if (value instanceof MetadataImportParams.ImportReportMode) {
                                setImportReportMode(((MetadataImportParams.ImportReportMode) value));
                            } else {
                                throw new IllegalArgumentException(("property \"importReportMode\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.ImportReportMode\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("importStrategy".equals(name)) {
                                if (value instanceof MetadataImportParams.ImportStrategy) {
                                    setImportStrategy(((MetadataImportParams.ImportStrategy) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"importStrategy\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.ImportStrategy\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("mergeMode".equals(name)) {
                                    if (value instanceof MetadataImportParams.MergeMode) {
                                        setMergeMode(((MetadataImportParams.MergeMode) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"mergeMode\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.MergeMode\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("metadataSyncImport".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setMetadataSyncImport(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"metadataSyncImport\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("preheatMode".equals(name)) {
                                            if (value instanceof MetadataImportParams.PreheatMode) {
                                                setPreheatMode(((MetadataImportParams.PreheatMode) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"preheatMode\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.PreheatMode\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("skipSharing".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setSkipSharing(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"skipSharing\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("skipTranslation".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setSkipTranslation(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"skipTranslation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("skipValidation".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setSkipValidation(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"skipValidation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("userOverrideMode".equals(name)) {
                                                            if (value instanceof MetadataImportParams.UserOverrideMode) {
                                                                setUserOverrideMode(((MetadataImportParams.UserOverrideMode) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"userOverrideMode\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams.UserOverrideMode\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            return false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("atomicMode".equals(name)) {
            return getAtomicMode();
        } else {
            if ("flushMode".equals(name)) {
                return getFlushMode();
            } else {
                if ("identifier".equals(name)) {
                    return getIdentifier();
                } else {
                    if ("importMode".equals(name)) {
                        return getImportMode();
                    } else {
                        if ("importReportMode".equals(name)) {
                            return getImportReportMode();
                        } else {
                            if ("importStrategy".equals(name)) {
                                return getImportStrategy();
                            } else {
                                if ("mergeMode".equals(name)) {
                                    return getMergeMode();
                                } else {
                                    if ("metadataSyncImport".equals(name)) {
                                        return getMetadataSyncImport();
                                    } else {
                                        if ("preheatMode".equals(name)) {
                                            return getPreheatMode();
                                        } else {
                                            if ("skipSharing".equals(name)) {
                                                return getSkipSharing();
                                            } else {
                                                if ("skipTranslation".equals(name)) {
                                                    return getSkipTranslation();
                                                } else {
                                                    if ("skipValidation".equals(name)) {
                                                        return getSkipValidation();
                                                    } else {
                                                        if ("userOverrideMode".equals(name)) {
                                                            return getUserOverrideMode();
                                                        } else {
                                                            return notFoundValue;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataImportParams.NOT_FOUND_VALUE);
        if (MetadataImportParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataImportParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataImportParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("atomicMode");
        sb.append('=');
        sb.append(((this.atomicMode == null)?"<null>":this.atomicMode));
        sb.append(',');
        sb.append("flushMode");
        sb.append('=');
        sb.append(((this.flushMode == null)?"<null>":this.flushMode));
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(((this.identifier == null)?"<null>":this.identifier));
        sb.append(',');
        sb.append("importMode");
        sb.append('=');
        sb.append(((this.importMode == null)?"<null>":this.importMode));
        sb.append(',');
        sb.append("importReportMode");
        sb.append('=');
        sb.append(((this.importReportMode == null)?"<null>":this.importReportMode));
        sb.append(',');
        sb.append("importStrategy");
        sb.append('=');
        sb.append(((this.importStrategy == null)?"<null>":this.importStrategy));
        sb.append(',');
        sb.append("mergeMode");
        sb.append('=');
        sb.append(((this.mergeMode == null)?"<null>":this.mergeMode));
        sb.append(',');
        sb.append("metadataSyncImport");
        sb.append('=');
        sb.append(((this.metadataSyncImport == null)?"<null>":this.metadataSyncImport));
        sb.append(',');
        sb.append("preheatMode");
        sb.append('=');
        sb.append(((this.preheatMode == null)?"<null>":this.preheatMode));
        sb.append(',');
        sb.append("skipSharing");
        sb.append('=');
        sb.append(((this.skipSharing == null)?"<null>":this.skipSharing));
        sb.append(',');
        sb.append("skipTranslation");
        sb.append('=');
        sb.append(((this.skipTranslation == null)?"<null>":this.skipTranslation));
        sb.append(',');
        sb.append("skipValidation");
        sb.append('=');
        sb.append(((this.skipValidation == null)?"<null>":this.skipValidation));
        sb.append(',');
        sb.append("userOverrideMode");
        sb.append('=');
        sb.append(((this.userOverrideMode == null)?"<null>":this.userOverrideMode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.identifier == null)? 0 :this.identifier.hashCode()));
        result = ((result* 31)+((this.importMode == null)? 0 :this.importMode.hashCode()));
        result = ((result* 31)+((this.preheatMode == null)? 0 :this.preheatMode.hashCode()));
        result = ((result* 31)+((this.atomicMode == null)? 0 :this.atomicMode.hashCode()));
        result = ((result* 31)+((this.metadataSyncImport == null)? 0 :this.metadataSyncImport.hashCode()));
        result = ((result* 31)+((this.userOverrideMode == null)? 0 :this.userOverrideMode.hashCode()));
        result = ((result* 31)+((this.mergeMode == null)? 0 :this.mergeMode.hashCode()));
        result = ((result* 31)+((this.flushMode == null)? 0 :this.flushMode.hashCode()));
        result = ((result* 31)+((this.skipSharing == null)? 0 :this.skipSharing.hashCode()));
        result = ((result* 31)+((this.skipValidation == null)? 0 :this.skipValidation.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importStrategy == null)? 0 :this.importStrategy.hashCode()));
        result = ((result* 31)+((this.importReportMode == null)? 0 :this.importReportMode.hashCode()));
        result = ((result* 31)+((this.skipTranslation == null)? 0 :this.skipTranslation.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataImportParams) == false) {
            return false;
        }
        MetadataImportParams rhs = ((MetadataImportParams) other);
        return (((((((((((((((this.identifier == rhs.identifier)||((this.identifier!= null)&&this.identifier.equals(rhs.identifier)))&&((this.importMode == rhs.importMode)||((this.importMode!= null)&&this.importMode.equals(rhs.importMode))))&&((this.preheatMode == rhs.preheatMode)||((this.preheatMode!= null)&&this.preheatMode.equals(rhs.preheatMode))))&&((this.atomicMode == rhs.atomicMode)||((this.atomicMode!= null)&&this.atomicMode.equals(rhs.atomicMode))))&&((this.metadataSyncImport == rhs.metadataSyncImport)||((this.metadataSyncImport!= null)&&this.metadataSyncImport.equals(rhs.metadataSyncImport))))&&((this.userOverrideMode == rhs.userOverrideMode)||((this.userOverrideMode!= null)&&this.userOverrideMode.equals(rhs.userOverrideMode))))&&((this.mergeMode == rhs.mergeMode)||((this.mergeMode!= null)&&this.mergeMode.equals(rhs.mergeMode))))&&((this.flushMode == rhs.flushMode)||((this.flushMode!= null)&&this.flushMode.equals(rhs.flushMode))))&&((this.skipSharing == rhs.skipSharing)||((this.skipSharing!= null)&&this.skipSharing.equals(rhs.skipSharing))))&&((this.skipValidation == rhs.skipValidation)||((this.skipValidation!= null)&&this.skipValidation.equals(rhs.skipValidation))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importStrategy == rhs.importStrategy)||((this.importStrategy!= null)&&this.importStrategy.equals(rhs.importStrategy))))&&((this.importReportMode == rhs.importReportMode)||((this.importReportMode!= null)&&this.importReportMode.equals(rhs.importReportMode))))&&((this.skipTranslation == rhs.skipTranslation)||((this.skipTranslation!= null)&&this.skipTranslation.equals(rhs.skipTranslation))));
    }

    @Generated("jsonschema2pojo")
    public enum AtomicMode {

        ALL("ALL"),
        NONE("NONE");
        private final String value;
        private final static Map<String, MetadataImportParams.AtomicMode> CONSTANTS = new HashMap<String, MetadataImportParams.AtomicMode>();

        static {
            for (MetadataImportParams.AtomicMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AtomicMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.AtomicMode fromValue(String value) {
            MetadataImportParams.AtomicMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum FlushMode {

        OBJECT("OBJECT"),
        AUTO("AUTO");
        private final String value;
        private final static Map<String, MetadataImportParams.FlushMode> CONSTANTS = new HashMap<String, MetadataImportParams.FlushMode>();

        static {
            for (MetadataImportParams.FlushMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FlushMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.FlushMode fromValue(String value) {
            MetadataImportParams.FlushMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Identifier {

        UID("UID"),
        CODE("CODE");
        private final String value;
        private final static Map<String, MetadataImportParams.Identifier> CONSTANTS = new HashMap<String, MetadataImportParams.Identifier>();

        static {
            for (MetadataImportParams.Identifier c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Identifier(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.Identifier fromValue(String value) {
            MetadataImportParams.Identifier constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ImportMode {

        COMMIT("COMMIT"),
        VALIDATE("VALIDATE");
        private final String value;
        private final static Map<String, MetadataImportParams.ImportMode> CONSTANTS = new HashMap<String, MetadataImportParams.ImportMode>();

        static {
            for (MetadataImportParams.ImportMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.ImportMode fromValue(String value) {
            MetadataImportParams.ImportMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ImportReportMode {

        FULL("FULL"),
        ERRORS("ERRORS"),
        ERRORS_NOT_OWNER("ERRORS_NOT_OWNER"),
        DEBUG("DEBUG");
        private final String value;
        private final static Map<String, MetadataImportParams.ImportReportMode> CONSTANTS = new HashMap<String, MetadataImportParams.ImportReportMode>();

        static {
            for (MetadataImportParams.ImportReportMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportReportMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.ImportReportMode fromValue(String value) {
            MetadataImportParams.ImportReportMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ImportStrategy {

        CREATE("CREATE"),
        UPDATE("UPDATE"),
        CREATE_AND_UPDATE("CREATE_AND_UPDATE"),
        DELETE("DELETE"),
        SYNC("SYNC"),
        NEW_AND_UPDATES("NEW_AND_UPDATES"),
        NEW("NEW"),
        UPDATES("UPDATES"),
        DELETES("DELETES");
        private final String value;
        private final static Map<String, MetadataImportParams.ImportStrategy> CONSTANTS = new HashMap<String, MetadataImportParams.ImportStrategy>();

        static {
            for (MetadataImportParams.ImportStrategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ImportStrategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.ImportStrategy fromValue(String value) {
            MetadataImportParams.ImportStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MergeMode {

        MERGE_ALWAYS("MERGE_ALWAYS"),
        MERGE_IF_NOT_NULL("MERGE_IF_NOT_NULL"),
        MERGE("MERGE"),
        REPLACE("REPLACE"),
        NONE("NONE");
        private final String value;
        private final static Map<String, MetadataImportParams.MergeMode> CONSTANTS = new HashMap<String, MetadataImportParams.MergeMode>();

        static {
            for (MetadataImportParams.MergeMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MergeMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.MergeMode fromValue(String value) {
            MetadataImportParams.MergeMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum PreheatMode {

        REFERENCE("REFERENCE"),
        ALL("ALL"),
        NONE("NONE");
        private final String value;
        private final static Map<String, MetadataImportParams.PreheatMode> CONSTANTS = new HashMap<String, MetadataImportParams.PreheatMode>();

        static {
            for (MetadataImportParams.PreheatMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PreheatMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.PreheatMode fromValue(String value) {
            MetadataImportParams.PreheatMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum UserOverrideMode {

        NONE("NONE"),
        CURRENT("CURRENT"),
        SELECTED("SELECTED");
        private final String value;
        private final static Map<String, MetadataImportParams.UserOverrideMode> CONSTANTS = new HashMap<String, MetadataImportParams.UserOverrideMode>();

        static {
            for (MetadataImportParams.UserOverrideMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        UserOverrideMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataImportParams.UserOverrideMode fromValue(String value) {
            MetadataImportParams.UserOverrideMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
