
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataSet",
    "orgUnit",
    "period"
})
@Generated("jsonschema2pojo")
public class LockExceptionDto implements Serializable
{

    @JsonProperty("dataSet")
    private String dataSet;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("period")
    private String period;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1904363925849985085L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LockExceptionDto() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public LockExceptionDto(LockExceptionDto source) {
        super();
        this.dataSet = source.dataSet;
        this.orgUnit = source.orgUnit;
        this.period = source.period;
    }

    public LockExceptionDto(String dataSet, String orgUnit, String period) {
        super();
        this.dataSet = dataSet;
        this.orgUnit = orgUnit;
        this.period = period;
    }

    @JsonProperty("dataSet")
    public Optional<String> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public LockExceptionDto withDataSet(String dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public LockExceptionDto withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public LockExceptionDto withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public LockExceptionDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataSet".equals(name)) {
            if (value instanceof String) {
                setDataSet(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"dataSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("orgUnit".equals(name)) {
                if (value instanceof String) {
                    setOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("period".equals(name)) {
                    if (value instanceof String) {
                        setPeriod(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataSet".equals(name)) {
            return getDataSet();
        } else {
            if ("orgUnit".equals(name)) {
                return getOrgUnit();
            } else {
                if ("period".equals(name)) {
                    return getPeriod();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, LockExceptionDto.NOT_FOUND_VALUE);
        if (LockExceptionDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public LockExceptionDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LockExceptionDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LockExceptionDto) == false) {
            return false;
        }
        LockExceptionDto rhs = ((LockExceptionDto) other);
        return (((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))));
    }

}
