
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "importParams",
    "stats",
    "status",
    "typeReports"
})
@Generated("jsonschema2pojo")
public class ImportReport implements Serializable
{

    @JsonProperty("importParams")
    private MetadataImportParams importParams;
    @JsonProperty("stats")
    private Stats stats;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private ImportReport.Status status;
    @JsonProperty("typeReports")
    private List<TypeReport> typeReports;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1274532910337140005L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportReport(ImportReport source) {
        super();
        this.importParams = source.importParams;
        this.stats = source.stats;
        this.status = source.status;
        this.typeReports = source.typeReports;
    }

    public ImportReport(MetadataImportParams importParams, Stats stats, ImportReport.Status status, List<TypeReport> typeReports) {
        super();
        this.importParams = importParams;
        this.stats = stats;
        this.status = status;
        this.typeReports = typeReports;
    }

    @JsonProperty("importParams")
    public Optional<MetadataImportParams> getImportParams() {
        return Optional.ofNullable(importParams);
    }

    @JsonProperty("importParams")
    public void setImportParams(MetadataImportParams importParams) {
        this.importParams = importParams;
    }

    public ImportReport withImportParams(MetadataImportParams importParams) {
        this.importParams = importParams;
        return this;
    }

    @JsonProperty("stats")
    public Optional<Stats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public ImportReport withStats(Stats stats) {
        this.stats = stats;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public ImportReport.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(ImportReport.Status status) {
        this.status = status;
    }

    public ImportReport withStatus(ImportReport.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("typeReports")
    public Optional<List<TypeReport>> getTypeReports() {
        return Optional.ofNullable(typeReports);
    }

    @JsonProperty("typeReports")
    public void setTypeReports(List<TypeReport> typeReports) {
        this.typeReports = typeReports;
    }

    public ImportReport withTypeReports(List<TypeReport> typeReports) {
        this.typeReports = typeReports;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("importParams".equals(name)) {
            if (value instanceof MetadataImportParams) {
                setImportParams(((MetadataImportParams) value));
            } else {
                throw new IllegalArgumentException(("property \"importParams\" is of type \"org.hisp.dhis.api.model.v40_0.MetadataImportParams\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("stats".equals(name)) {
                if (value instanceof Stats) {
                    setStats(((Stats) value));
                } else {
                    throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v40_0.Stats\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("status".equals(name)) {
                    if (value instanceof ImportReport.Status) {
                        setStatus(((ImportReport.Status) value));
                    } else {
                        throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_0.ImportReport.Status\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("typeReports".equals(name)) {
                        if (value instanceof List) {
                            setTypeReports(((List<TypeReport> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"typeReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.TypeReport>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("importParams".equals(name)) {
            return getImportParams();
        } else {
            if ("stats".equals(name)) {
                return getStats();
            } else {
                if ("status".equals(name)) {
                    return getStatus();
                } else {
                    if ("typeReports".equals(name)) {
                        return getTypeReports();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportReport.NOT_FOUND_VALUE);
        if (ImportReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("importParams");
        sb.append('=');
        sb.append(((this.importParams == null)?"<null>":this.importParams));
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("typeReports");
        sb.append('=');
        sb.append(((this.typeReports == null)?"<null>":this.typeReports));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.typeReports == null)? 0 :this.typeReports.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        result = ((result* 31)+((this.importParams == null)? 0 :this.importParams.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportReport) == false) {
            return false;
        }
        ImportReport rhs = ((ImportReport) other);
        return ((((((this.typeReports == rhs.typeReports)||((this.typeReports!= null)&&this.typeReports.equals(rhs.typeReports)))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))))&&((this.importParams == rhs.importParams)||((this.importParams!= null)&&this.importParams.equals(rhs.importParams))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum Status {

        OK("OK"),
        WARNING("WARNING"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, ImportReport.Status> CONSTANTS = new HashMap<String, ImportReport.Status>();

        static {
            for (ImportReport.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportReport.Status fromValue(String value) {
            ImportReport.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
