
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attribute",
    "identifiableProperty",
    "identifiableString",
    "notNull",
    "null"
})
@Generated("jsonschema2pojo")
public class IdScheme implements Serializable
{

    @JsonProperty("attribute")
    private String attribute;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifiableProperty")
    private IdScheme.IdentifiableProperty identifiableProperty;
    @JsonProperty("identifiableString")
    private String identifiableString;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notNull")
    private Boolean notNull;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("null")
    private Boolean _null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7476122036428141401L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public IdScheme() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public IdScheme(IdScheme source) {
        super();
        this.attribute = source.attribute;
        this.identifiableProperty = source.identifiableProperty;
        this.identifiableString = source.identifiableString;
        this.notNull = source.notNull;
        this._null = source._null;
    }

    public IdScheme(String attribute, IdScheme.IdentifiableProperty identifiableProperty, String identifiableString, Boolean notNull, Boolean _null) {
        super();
        this.attribute = attribute;
        this.identifiableProperty = identifiableProperty;
        this.identifiableString = identifiableString;
        this.notNull = notNull;
        this._null = _null;
    }

    @JsonProperty("attribute")
    public Optional<String> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public IdScheme withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifiableProperty")
    public IdScheme.IdentifiableProperty getIdentifiableProperty() {
        return identifiableProperty;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("identifiableProperty")
    public void setIdentifiableProperty(IdScheme.IdentifiableProperty identifiableProperty) {
        this.identifiableProperty = identifiableProperty;
    }

    public IdScheme withIdentifiableProperty(IdScheme.IdentifiableProperty identifiableProperty) {
        this.identifiableProperty = identifiableProperty;
        return this;
    }

    @JsonProperty("identifiableString")
    public Optional<String> getIdentifiableString() {
        return Optional.ofNullable(identifiableString);
    }

    @JsonProperty("identifiableString")
    public void setIdentifiableString(String identifiableString) {
        this.identifiableString = identifiableString;
    }

    public IdScheme withIdentifiableString(String identifiableString) {
        this.identifiableString = identifiableString;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notNull")
    public Boolean getNotNull() {
        return notNull;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("notNull")
    public void setNotNull(Boolean notNull) {
        this.notNull = notNull;
    }

    public IdScheme withNotNull(Boolean notNull) {
        this.notNull = notNull;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("null")
    public Boolean getNull() {
        return _null;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("null")
    public void setNull(Boolean _null) {
        this._null = _null;
    }

    public IdScheme withNull(Boolean _null) {
        this._null = _null;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public IdScheme withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attribute".equals(name)) {
            if (value instanceof String) {
                setAttribute(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"attribute\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("identifiableProperty".equals(name)) {
                if (value instanceof IdScheme.IdentifiableProperty) {
                    setIdentifiableProperty(((IdScheme.IdentifiableProperty) value));
                } else {
                    throw new IllegalArgumentException(("property \"identifiableProperty\" is of type \"org.hisp.dhis.api.model.v40_0.IdScheme.IdentifiableProperty\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("identifiableString".equals(name)) {
                    if (value instanceof String) {
                        setIdentifiableString(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"identifiableString\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("notNull".equals(name)) {
                        if (value instanceof Boolean) {
                            setNotNull(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"notNull\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("null".equals(name)) {
                            if (value instanceof Boolean) {
                                setNull(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"null\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attribute".equals(name)) {
            return getAttribute();
        } else {
            if ("identifiableProperty".equals(name)) {
                return getIdentifiableProperty();
            } else {
                if ("identifiableString".equals(name)) {
                    return getIdentifiableString();
                } else {
                    if ("notNull".equals(name)) {
                        return getNotNull();
                    } else {
                        if ("null".equals(name)) {
                            return getNull();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, IdScheme.NOT_FOUND_VALUE);
        if (IdScheme.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public IdScheme with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IdScheme.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("identifiableProperty");
        sb.append('=');
        sb.append(((this.identifiableProperty == null)?"<null>":this.identifiableProperty));
        sb.append(',');
        sb.append("identifiableString");
        sb.append('=');
        sb.append(((this.identifiableString == null)?"<null>":this.identifiableString));
        sb.append(',');
        sb.append("notNull");
        sb.append('=');
        sb.append(((this.notNull == null)?"<null>":this.notNull));
        sb.append(',');
        sb.append("_null");
        sb.append('=');
        sb.append(((this._null == null)?"<null>":this._null));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.notNull == null)? 0 :this.notNull.hashCode()));
        result = ((result* 31)+((this.identifiableProperty == null)? 0 :this.identifiableProperty.hashCode()));
        result = ((result* 31)+((this._null == null)? 0 :this._null.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.identifiableString == null)? 0 :this.identifiableString.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof IdScheme) == false) {
            return false;
        }
        IdScheme rhs = ((IdScheme) other);
        return (((((((this.notNull == rhs.notNull)||((this.notNull!= null)&&this.notNull.equals(rhs.notNull)))&&((this.identifiableProperty == rhs.identifiableProperty)||((this.identifiableProperty!= null)&&this.identifiableProperty.equals(rhs.identifiableProperty))))&&((this._null == rhs._null)||((this._null!= null)&&this._null.equals(rhs._null))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.identifiableString == rhs.identifiableString)||((this.identifiableString!= null)&&this.identifiableString.equals(rhs.identifiableString))));
    }

    @Generated("jsonschema2pojo")
    public enum IdentifiableProperty {

        ID("ID"),
        UID("UID"),
        UUID("UUID"),
        NAME("NAME"),
        CODE("CODE"),
        ATTRIBUTE("ATTRIBUTE");
        private final String value;
        private final static Map<String, IdScheme.IdentifiableProperty> CONSTANTS = new HashMap<String, IdScheme.IdentifiableProperty>();

        static {
            for (IdScheme.IdentifiableProperty c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        IdentifiableProperty(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static IdScheme.IdentifiableProperty fromValue(String value) {
            IdScheme.IdentifiableProperty constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
