
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "categoryOptionCombo",
    "comment",
    "dataElement",
    "label",
    "optionSet",
    "type",
    "value"
})
@Generated("jsonschema2pojo")
public class Field implements Serializable
{

    @JsonProperty("categoryOptionCombo")
    private String categoryOptionCombo;
    @JsonProperty("comment")
    private String comment;
    @JsonProperty("dataElement")
    private String dataElement;
    @JsonProperty("label")
    private String label;
    @JsonProperty("optionSet")
    private String optionSet;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private Field.Type type;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3636651648207119189L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Field() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Field(Field source) {
        super();
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.comment = source.comment;
        this.dataElement = source.dataElement;
        this.label = source.label;
        this.optionSet = source.optionSet;
        this.type = source.type;
        this.value = source.value;
    }

    public Field(String categoryOptionCombo, String comment, String dataElement, String label, String optionSet, Field.Type type, String value) {
        super();
        this.categoryOptionCombo = categoryOptionCombo;
        this.comment = comment;
        this.dataElement = dataElement;
        this.label = label;
        this.optionSet = optionSet;
        this.type = type;
        this.value = value;
    }

    @JsonProperty("categoryOptionCombo")
    public Optional<String> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public Field withCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    @JsonProperty("comment")
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    @JsonProperty("comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    public Field withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public Field withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("label")
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    @JsonProperty("label")
    public void setLabel(String label) {
        this.label = label;
    }

    public Field withLabel(String label) {
        this.label = label;
        return this;
    }

    @JsonProperty("optionSet")
    public Optional<String> getOptionSet() {
        return Optional.ofNullable(optionSet);
    }

    @JsonProperty("optionSet")
    public void setOptionSet(String optionSet) {
        this.optionSet = optionSet;
    }

    public Field withOptionSet(String optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public Field.Type getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(Field.Type type) {
        this.type = type;
    }

    public Field withType(Field.Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public Field withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Field withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("categoryOptionCombo".equals(name)) {
            if (value instanceof String) {
                setCategoryOptionCombo(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("comment".equals(name)) {
                if (value instanceof String) {
                    setComment(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"comment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataElement".equals(name)) {
                    if (value instanceof String) {
                        setDataElement(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataElement\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("label".equals(name)) {
                        if (value instanceof String) {
                            setLabel(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"label\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("optionSet".equals(name)) {
                            if (value instanceof String) {
                                setOptionSet(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"optionSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("type".equals(name)) {
                                if (value instanceof Field.Type) {
                                    setType(((Field.Type) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_0.Field.Type\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("value".equals(name)) {
                                    if (value instanceof String) {
                                        setValue(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("categoryOptionCombo".equals(name)) {
            return getCategoryOptionCombo();
        } else {
            if ("comment".equals(name)) {
                return getComment();
            } else {
                if ("dataElement".equals(name)) {
                    return getDataElement();
                } else {
                    if ("label".equals(name)) {
                        return getLabel();
                    } else {
                        if ("optionSet".equals(name)) {
                            return getOptionSet();
                        } else {
                            if ("type".equals(name)) {
                                return getType();
                            } else {
                                if ("value".equals(name)) {
                                    return getValue();
                                } else {
                                    return notFoundValue;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Field.NOT_FOUND_VALUE);
        if (Field.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Field with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Field.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("comment");
        sb.append('=');
        sb.append(((this.comment == null)?"<null>":this.comment));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("label");
        sb.append('=');
        sb.append(((this.label == null)?"<null>":this.label));
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(((this.optionSet == null)?"<null>":this.optionSet));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.optionSet == null)? 0 :this.optionSet.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.comment == null)? 0 :this.comment.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.label == null)? 0 :this.label.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Field) == false) {
            return false;
        }
        Field rhs = ((Field) other);
        return (((((((((this.optionSet == rhs.optionSet)||((this.optionSet!= null)&&this.optionSet.equals(rhs.optionSet)))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.comment == rhs.comment)||((this.comment!= null)&&this.comment.equals(rhs.comment))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.label == rhs.label)||((this.label!= null)&&this.label.equals(rhs.label))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

    @Generated("jsonschema2pojo")
    public enum Type {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, Field.Type> CONSTANTS = new HashMap<String, Field.Type>();

        static {
            for (Field.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Field.Type fromValue(String value) {
            Field.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
