
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "eventRows",
    "pager"
})
@Generated("jsonschema2pojo")
public class EventRows implements Serializable
{

    @JsonProperty("eventRows")
    private List<EventRow> eventRows;
    @JsonProperty("pager")
    private Pager pager;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6314598162425140928L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventRows() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EventRows(EventRows source) {
        super();
        this.eventRows = source.eventRows;
        this.pager = source.pager;
    }

    public EventRows(List<EventRow> eventRows, Pager pager) {
        super();
        this.eventRows = eventRows;
        this.pager = pager;
    }

    @JsonProperty("eventRows")
    public Optional<List<EventRow>> getEventRows() {
        return Optional.ofNullable(eventRows);
    }

    @JsonProperty("eventRows")
    public void setEventRows(List<EventRow> eventRows) {
        this.eventRows = eventRows;
    }

    public EventRows withEventRows(List<EventRow> eventRows) {
        this.eventRows = eventRows;
        return this;
    }

    @JsonProperty("pager")
    public Optional<Pager> getPager() {
        return Optional.ofNullable(pager);
    }

    @JsonProperty("pager")
    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public EventRows withPager(Pager pager) {
        this.pager = pager;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EventRows withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("eventRows".equals(name)) {
            if (value instanceof List) {
                setEventRows(((List<EventRow> ) value));
            } else {
                throw new IllegalArgumentException(("property \"eventRows\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.EventRow>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("pager".equals(name)) {
                if (value instanceof Pager) {
                    setPager(((Pager) value));
                } else {
                    throw new IllegalArgumentException(("property \"pager\" is of type \"org.hisp.dhis.api.model.v40_0.Pager\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("eventRows".equals(name)) {
            return getEventRows();
        } else {
            if ("pager".equals(name)) {
                return getPager();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EventRows.NOT_FOUND_VALUE);
        if (EventRows.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EventRows with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventRows.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("eventRows");
        sb.append('=');
        sb.append(((this.eventRows == null)?"<null>":this.eventRows));
        sb.append(',');
        sb.append("pager");
        sb.append('=');
        sb.append(((this.pager == null)?"<null>":this.pager));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.pager == null)? 0 :this.pager.hashCode()));
        result = ((result* 31)+((this.eventRows == null)? 0 :this.eventRows.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EventRows) == false) {
            return false;
        }
        EventRows rhs = ((EventRows) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.pager == rhs.pager)||((this.pager!= null)&&this.pager.equals(rhs.pager))))&&((this.eventRows == rhs.eventRows)||((this.eventRows!= null)&&this.eventRows.equals(rhs.eventRows))));
    }

}
