
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code",
    "deletedAt",
    "deletedBy",
    "klass",
    "uid"
})
@Generated("jsonschema2pojo")
public class DeletedObject implements Serializable
{

    @JsonProperty("code")
    private String code;
    @JsonProperty("deletedAt")
    private Date deletedAt;
    @JsonProperty("deletedBy")
    private String deletedBy;
    @JsonProperty("klass")
    private String klass;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3688422245021263464L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DeletedObject() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DeletedObject(DeletedObject source) {
        super();
        this.code = source.code;
        this.deletedAt = source.deletedAt;
        this.deletedBy = source.deletedBy;
        this.klass = source.klass;
        this.uid = source.uid;
    }

    public DeletedObject(String code, Date deletedAt, String deletedBy, String klass, String uid) {
        super();
        this.code = code;
        this.deletedAt = deletedAt;
        this.deletedBy = deletedBy;
        this.klass = klass;
        this.uid = uid;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DeletedObject withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("deletedAt")
    public Optional<Date> getDeletedAt() {
        return Optional.ofNullable(deletedAt);
    }

    @JsonProperty("deletedAt")
    public void setDeletedAt(Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    public DeletedObject withDeletedAt(Date deletedAt) {
        this.deletedAt = deletedAt;
        return this;
    }

    @JsonProperty("deletedBy")
    public Optional<String> getDeletedBy() {
        return Optional.ofNullable(deletedBy);
    }

    @JsonProperty("deletedBy")
    public void setDeletedBy(String deletedBy) {
        this.deletedBy = deletedBy;
    }

    public DeletedObject withDeletedBy(String deletedBy) {
        this.deletedBy = deletedBy;
        return this;
    }

    @JsonProperty("klass")
    public Optional<String> getKlass() {
        return Optional.ofNullable(klass);
    }

    @JsonProperty("klass")
    public void setKlass(String klass) {
        this.klass = klass;
    }

    public DeletedObject withKlass(String klass) {
        this.klass = klass;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public DeletedObject withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DeletedObject withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("code".equals(name)) {
            if (value instanceof String) {
                setCode(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("deletedAt".equals(name)) {
                if (value instanceof Date) {
                    setDeletedAt(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"deletedAt\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("deletedBy".equals(name)) {
                    if (value instanceof String) {
                        setDeletedBy(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"deletedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("klass".equals(name)) {
                        if (value instanceof String) {
                            setKlass(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"klass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("uid".equals(name)) {
                            if (value instanceof String) {
                                setUid(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("code".equals(name)) {
            return getCode();
        } else {
            if ("deletedAt".equals(name)) {
                return getDeletedAt();
            } else {
                if ("deletedBy".equals(name)) {
                    return getDeletedBy();
                } else {
                    if ("klass".equals(name)) {
                        return getKlass();
                    } else {
                        if ("uid".equals(name)) {
                            return getUid();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DeletedObject.NOT_FOUND_VALUE);
        if (DeletedObject.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DeletedObject with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DeletedObject.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("deletedAt");
        sb.append('=');
        sb.append(((this.deletedAt == null)?"<null>":this.deletedAt));
        sb.append(',');
        sb.append("deletedBy");
        sb.append('=');
        sb.append(((this.deletedBy == null)?"<null>":this.deletedBy));
        sb.append(',');
        sb.append("klass");
        sb.append('=');
        sb.append(((this.klass == null)?"<null>":this.klass));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.deletedAt == null)? 0 :this.deletedAt.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.klass == null)? 0 :this.klass.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.deletedBy == null)? 0 :this.deletedBy.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DeletedObject) == false) {
            return false;
        }
        DeletedObject rhs = ((DeletedObject) other);
        return (((((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.deletedAt == rhs.deletedAt)||((this.deletedAt!= null)&&this.deletedAt.equals(rhs.deletedAt))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.klass == rhs.klass)||((this.klass!= null)&&this.klass.equals(rhs.klass))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.deletedBy == rhs.deletedBy)||((this.deletedBy!= null)&&this.deletedBy.equals(rhs.deletedBy))));
    }

}
