
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "checks",
    "type"
})
@Generated("jsonschema2pojo")
public class DataIntegrityJobParameters implements Serializable
{

    @JsonProperty("checks")
    private List<String> checks;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private DataIntegrityJobParameters.Type type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7070147555885500712L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataIntegrityJobParameters() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataIntegrityJobParameters(DataIntegrityJobParameters source) {
        super();
        this.checks = source.checks;
        this.type = source.type;
    }

    public DataIntegrityJobParameters(List<String> checks, DataIntegrityJobParameters.Type type) {
        super();
        this.checks = checks;
        this.type = type;
    }

    @JsonProperty("checks")
    public Optional<List<String>> getChecks() {
        return Optional.ofNullable(checks);
    }

    @JsonProperty("checks")
    public void setChecks(List<String> checks) {
        this.checks = checks;
    }

    public DataIntegrityJobParameters withChecks(List<String> checks) {
        this.checks = checks;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public DataIntegrityJobParameters.Type getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(DataIntegrityJobParameters.Type type) {
        this.type = type;
    }

    public DataIntegrityJobParameters withType(DataIntegrityJobParameters.Type type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataIntegrityJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("checks".equals(name)) {
            if (value instanceof List) {
                setChecks(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"checks\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("type".equals(name)) {
                if (value instanceof DataIntegrityJobParameters.Type) {
                    setType(((DataIntegrityJobParameters.Type) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_0.DataIntegrityJobParameters.Type\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("checks".equals(name)) {
            return getChecks();
        } else {
            if ("type".equals(name)) {
                return getType();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataIntegrityJobParameters.NOT_FOUND_VALUE);
        if (DataIntegrityJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataIntegrityJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataIntegrityJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("checks");
        sb.append('=');
        sb.append(((this.checks == null)?"<null>":this.checks));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.checks == null)? 0 :this.checks.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataIntegrityJobParameters) == false) {
            return false;
        }
        DataIntegrityJobParameters rhs = ((DataIntegrityJobParameters) other);
        return ((((this.checks == rhs.checks)||((this.checks!= null)&&this.checks.equals(rhs.checks)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))));
    }

    @Generated("jsonschema2pojo")
    public enum Type {

        REPORT("REPORT"),
        SUMMARY("SUMMARY"),
        DETAILS("DETAILS");
        private final String value;
        private final static Map<String, DataIntegrityJobParameters.Type> CONSTANTS = new HashMap<String, DataIntegrityJobParameters.Type>();

        static {
            for (DataIntegrityJobParameters.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataIntegrityJobParameters.Type fromValue(String value) {
            DataIntegrityJobParameters.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
