
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "error",
    "finishedTime",
    "issues",
    "startTime"
})
@Generated("jsonschema2pojo")
public class DataIntegrityDetails implements Serializable
{

    @JsonProperty("error")
    private String error;
    @JsonProperty("finishedTime")
    private Date finishedTime;
    @JsonProperty("issues")
    private List<DataIntegrityIssue> issues;
    @JsonProperty("startTime")
    private Date startTime;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3475712111784354781L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataIntegrityDetails() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataIntegrityDetails(DataIntegrityDetails source) {
        super();
        this.error = source.error;
        this.finishedTime = source.finishedTime;
        this.issues = source.issues;
        this.startTime = source.startTime;
    }

    public DataIntegrityDetails(String error, Date finishedTime, List<DataIntegrityIssue> issues, Date startTime) {
        super();
        this.error = error;
        this.finishedTime = finishedTime;
        this.issues = issues;
        this.startTime = startTime;
    }

    @JsonProperty("error")
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    @JsonProperty("error")
    public void setError(String error) {
        this.error = error;
    }

    public DataIntegrityDetails withError(String error) {
        this.error = error;
        return this;
    }

    @JsonProperty("finishedTime")
    public Optional<Date> getFinishedTime() {
        return Optional.ofNullable(finishedTime);
    }

    @JsonProperty("finishedTime")
    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public DataIntegrityDetails withFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
        return this;
    }

    @JsonProperty("issues")
    public Optional<List<DataIntegrityIssue>> getIssues() {
        return Optional.ofNullable(issues);
    }

    @JsonProperty("issues")
    public void setIssues(List<DataIntegrityIssue> issues) {
        this.issues = issues;
    }

    public DataIntegrityDetails withIssues(List<DataIntegrityIssue> issues) {
        this.issues = issues;
        return this;
    }

    @JsonProperty("startTime")
    public Optional<Date> getStartTime() {
        return Optional.ofNullable(startTime);
    }

    @JsonProperty("startTime")
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public DataIntegrityDetails withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataIntegrityDetails withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("error".equals(name)) {
            if (value instanceof String) {
                setError(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"error\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("finishedTime".equals(name)) {
                if (value instanceof Date) {
                    setFinishedTime(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"finishedTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("issues".equals(name)) {
                    if (value instanceof List) {
                        setIssues(((List<DataIntegrityIssue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"issues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.DataIntegrityIssue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("startTime".equals(name)) {
                        if (value instanceof Date) {
                            setStartTime(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"startTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("error".equals(name)) {
            return getError();
        } else {
            if ("finishedTime".equals(name)) {
                return getFinishedTime();
            } else {
                if ("issues".equals(name)) {
                    return getIssues();
                } else {
                    if ("startTime".equals(name)) {
                        return getStartTime();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataIntegrityDetails.NOT_FOUND_VALUE);
        if (DataIntegrityDetails.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataIntegrityDetails with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataIntegrityDetails.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("error");
        sb.append('=');
        sb.append(((this.error == null)?"<null>":this.error));
        sb.append(',');
        sb.append("finishedTime");
        sb.append('=');
        sb.append(((this.finishedTime == null)?"<null>":this.finishedTime));
        sb.append(',');
        sb.append("issues");
        sb.append('=');
        sb.append(((this.issues == null)?"<null>":this.issues));
        sb.append(',');
        sb.append("startTime");
        sb.append('=');
        sb.append(((this.startTime == null)?"<null>":this.startTime));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.finishedTime == null)? 0 :this.finishedTime.hashCode()));
        result = ((result* 31)+((this.startTime == null)? 0 :this.startTime.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.error == null)? 0 :this.error.hashCode()));
        result = ((result* 31)+((this.issues == null)? 0 :this.issues.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataIntegrityDetails) == false) {
            return false;
        }
        DataIntegrityDetails rhs = ((DataIntegrityDetails) other);
        return ((((((this.finishedTime == rhs.finishedTime)||((this.finishedTime!= null)&&this.finishedTime.equals(rhs.finishedTime)))&&((this.startTime == rhs.startTime)||((this.startTime!= null)&&this.startTime.equals(rhs.startTime))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.error == rhs.error)||((this.error!= null)&&this.error.equals(rhs.error))))&&((this.issues == rhs.issues)||((this.issues!= null)&&this.issues.equals(rhs.issues))));
    }

}
