
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataSetId",
    "displayDensity",
    "form",
    "id",
    "version"
})
@Generated("jsonschema2pojo")
public class CustomDataEntryFormDto implements Serializable
{

    @JsonProperty("dataSetId")
    private String dataSetId;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("displayDensity")
    private CustomDataEntryFormDto.DisplayDensity displayDensity;
    @JsonProperty("form")
    private String form;
    @JsonProperty("id")
    private String id;
    @JsonProperty("version")
    private Integer version;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6371859670222496199L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CustomDataEntryFormDto() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public CustomDataEntryFormDto(CustomDataEntryFormDto source) {
        super();
        this.dataSetId = source.dataSetId;
        this.displayDensity = source.displayDensity;
        this.form = source.form;
        this.id = source.id;
        this.version = source.version;
    }

    public CustomDataEntryFormDto(String dataSetId, CustomDataEntryFormDto.DisplayDensity displayDensity, String form, String id, Integer version) {
        super();
        this.dataSetId = dataSetId;
        this.displayDensity = displayDensity;
        this.form = form;
        this.id = id;
        this.version = version;
    }

    @JsonProperty("dataSetId")
    public Optional<String> getDataSetId() {
        return Optional.ofNullable(dataSetId);
    }

    @JsonProperty("dataSetId")
    public void setDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
    }

    public CustomDataEntryFormDto withDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("displayDensity")
    public CustomDataEntryFormDto.DisplayDensity getDisplayDensity() {
        return displayDensity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("displayDensity")
    public void setDisplayDensity(CustomDataEntryFormDto.DisplayDensity displayDensity) {
        this.displayDensity = displayDensity;
    }

    public CustomDataEntryFormDto withDisplayDensity(CustomDataEntryFormDto.DisplayDensity displayDensity) {
        this.displayDensity = displayDensity;
        return this;
    }

    @JsonProperty("form")
    public Optional<String> getForm() {
        return Optional.ofNullable(form);
    }

    @JsonProperty("form")
    public void setForm(String form) {
        this.form = form;
    }

    public CustomDataEntryFormDto withForm(String form) {
        this.form = form;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public CustomDataEntryFormDto withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("version")
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    @JsonProperty("version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    public CustomDataEntryFormDto withVersion(Integer version) {
        this.version = version;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CustomDataEntryFormDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataSetId".equals(name)) {
            if (value instanceof String) {
                setDataSetId(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"dataSetId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("displayDensity".equals(name)) {
                if (value instanceof CustomDataEntryFormDto.DisplayDensity) {
                    setDisplayDensity(((CustomDataEntryFormDto.DisplayDensity) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDensity\" is of type \"org.hisp.dhis.api.model.v40_0.CustomDataEntryFormDto.DisplayDensity\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("form".equals(name)) {
                    if (value instanceof String) {
                        setForm(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"form\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("id".equals(name)) {
                        if (value instanceof String) {
                            setId(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("version".equals(name)) {
                            if (value instanceof Integer) {
                                setVersion(((Integer) value));
                            } else {
                                throw new IllegalArgumentException(("property \"version\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataSetId".equals(name)) {
            return getDataSetId();
        } else {
            if ("displayDensity".equals(name)) {
                return getDisplayDensity();
            } else {
                if ("form".equals(name)) {
                    return getForm();
                } else {
                    if ("id".equals(name)) {
                        return getId();
                    } else {
                        if ("version".equals(name)) {
                            return getVersion();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CustomDataEntryFormDto.NOT_FOUND_VALUE);
        if (CustomDataEntryFormDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CustomDataEntryFormDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CustomDataEntryFormDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataSetId");
        sb.append('=');
        sb.append(((this.dataSetId == null)?"<null>":this.dataSetId));
        sb.append(',');
        sb.append("displayDensity");
        sb.append('=');
        sb.append(((this.displayDensity == null)?"<null>":this.displayDensity));
        sb.append(',');
        sb.append("form");
        sb.append('=');
        sb.append(((this.form == null)?"<null>":this.form));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataSetId == null)? 0 :this.dataSetId.hashCode()));
        result = ((result* 31)+((this.form == null)? 0 :this.form.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        result = ((result* 31)+((this.displayDensity == null)? 0 :this.displayDensity.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CustomDataEntryFormDto) == false) {
            return false;
        }
        CustomDataEntryFormDto rhs = ((CustomDataEntryFormDto) other);
        return (((((((this.dataSetId == rhs.dataSetId)||((this.dataSetId!= null)&&this.dataSetId.equals(rhs.dataSetId)))&&((this.form == rhs.form)||((this.form!= null)&&this.form.equals(rhs.form))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))))&&((this.displayDensity == rhs.displayDensity)||((this.displayDensity!= null)&&this.displayDensity.equals(rhs.displayDensity))));
    }

    @Generated("jsonschema2pojo")
    public enum DisplayDensity {

        COMFORTABLE("COMFORTABLE"),
        NORMAL("NORMAL"),
        COMPACT("COMPACT"),
        NONE("NONE");
        private final String value;
        private final static Map<String, CustomDataEntryFormDto.DisplayDensity> CONSTANTS = new HashMap<String, CustomDataEntryFormDto.DisplayDensity>();

        static {
            for (CustomDataEntryFormDto.DisplayDensity c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DisplayDensity(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CustomDataEntryFormDto.DisplayDensity fromValue(String value) {
            CustomDataEntryFormDto.DisplayDensity constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
