
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "countUpdatedDashboardItems",
    "errorReports",
    "updateObjects"
})
@Generated("jsonschema2pojo")
public class CascadeSharingReport implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("countUpdatedDashboardItems")
    private Integer countUpdatedDashboardItems;
    @JsonProperty("errorReports")
    private List<ErrorReport> errorReports;
    @JsonProperty("updateObjects")
    private UpdateObjects updateObjects;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7052517254128765561L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CascadeSharingReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public CascadeSharingReport(CascadeSharingReport source) {
        super();
        this.countUpdatedDashboardItems = source.countUpdatedDashboardItems;
        this.errorReports = source.errorReports;
        this.updateObjects = source.updateObjects;
    }

    public CascadeSharingReport(Integer countUpdatedDashboardItems, List<ErrorReport> errorReports, UpdateObjects updateObjects) {
        super();
        this.countUpdatedDashboardItems = countUpdatedDashboardItems;
        this.errorReports = errorReports;
        this.updateObjects = updateObjects;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("countUpdatedDashboardItems")
    public Integer getCountUpdatedDashboardItems() {
        return countUpdatedDashboardItems;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("countUpdatedDashboardItems")
    public void setCountUpdatedDashboardItems(Integer countUpdatedDashboardItems) {
        this.countUpdatedDashboardItems = countUpdatedDashboardItems;
    }

    public CascadeSharingReport withCountUpdatedDashboardItems(Integer countUpdatedDashboardItems) {
        this.countUpdatedDashboardItems = countUpdatedDashboardItems;
        return this;
    }

    @JsonProperty("errorReports")
    public Optional<List<ErrorReport>> getErrorReports() {
        return Optional.ofNullable(errorReports);
    }

    @JsonProperty("errorReports")
    public void setErrorReports(List<ErrorReport> errorReports) {
        this.errorReports = errorReports;
    }

    public CascadeSharingReport withErrorReports(List<ErrorReport> errorReports) {
        this.errorReports = errorReports;
        return this;
    }

    @JsonProperty("updateObjects")
    public Optional<UpdateObjects> getUpdateObjects() {
        return Optional.ofNullable(updateObjects);
    }

    @JsonProperty("updateObjects")
    public void setUpdateObjects(UpdateObjects updateObjects) {
        this.updateObjects = updateObjects;
    }

    public CascadeSharingReport withUpdateObjects(UpdateObjects updateObjects) {
        this.updateObjects = updateObjects;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CascadeSharingReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("countUpdatedDashboardItems".equals(name)) {
            if (value instanceof Integer) {
                setCountUpdatedDashboardItems(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"countUpdatedDashboardItems\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("errorReports".equals(name)) {
                if (value instanceof List) {
                    setErrorReports(((List<ErrorReport> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"errorReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.ErrorReport>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("updateObjects".equals(name)) {
                    if (value instanceof UpdateObjects) {
                        setUpdateObjects(((UpdateObjects) value));
                    } else {
                        throw new IllegalArgumentException(("property \"updateObjects\" is of type \"org.hisp.dhis.api.model.v40_0.UpdateObjects\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("countUpdatedDashboardItems".equals(name)) {
            return getCountUpdatedDashboardItems();
        } else {
            if ("errorReports".equals(name)) {
                return getErrorReports();
            } else {
                if ("updateObjects".equals(name)) {
                    return getUpdateObjects();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CascadeSharingReport.NOT_FOUND_VALUE);
        if (CascadeSharingReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CascadeSharingReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CascadeSharingReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("countUpdatedDashboardItems");
        sb.append('=');
        sb.append(((this.countUpdatedDashboardItems == null)?"<null>":this.countUpdatedDashboardItems));
        sb.append(',');
        sb.append("errorReports");
        sb.append('=');
        sb.append(((this.errorReports == null)?"<null>":this.errorReports));
        sb.append(',');
        sb.append("updateObjects");
        sb.append('=');
        sb.append(((this.updateObjects == null)?"<null>":this.updateObjects));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.countUpdatedDashboardItems == null)? 0 :this.countUpdatedDashboardItems.hashCode()));
        result = ((result* 31)+((this.updateObjects == null)? 0 :this.updateObjects.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.errorReports == null)? 0 :this.errorReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CascadeSharingReport) == false) {
            return false;
        }
        CascadeSharingReport rhs = ((CascadeSharingReport) other);
        return (((((this.countUpdatedDashboardItems == rhs.countUpdatedDashboardItems)||((this.countUpdatedDashboardItems!= null)&&this.countUpdatedDashboardItems.equals(rhs.countUpdatedDashboardItems)))&&((this.updateObjects == rhs.updateObjects)||((this.updateObjects!= null)&&this.updateObjects.equals(rhs.updateObjects))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.errorReports == rhs.errorReports)||((this.errorReports!= null)&&this.errorReports.equals(rhs.errorReports))));
    }

}
