
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "displayName",
    "userGroupUid"
})
@Generated("jsonschema2pojo")
public class UserGroupAccess implements Serializable
{

    @JsonProperty("access")
    private String access;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("userGroupUid")
    private String userGroupUid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3750529653792504599L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public UserGroupAccess() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public UserGroupAccess(UserGroupAccess source) {
        super();
        this.access = source.access;
        this.displayName = source.displayName;
        this.userGroupUid = source.userGroupUid;
    }

    public UserGroupAccess(String access, String displayName, String userGroupUid) {
        super();
        this.access = access;
        this.displayName = displayName;
        this.userGroupUid = userGroupUid;
    }

    @JsonProperty("access")
    public Optional<String> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(String access) {
        this.access = access;
    }

    public UserGroupAccess withAccess(String access) {
        this.access = access;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserGroupAccess withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("userGroupUid")
    public Optional<String> getUserGroupUid() {
        return Optional.ofNullable(userGroupUid);
    }

    @JsonProperty("userGroupUid")
    public void setUserGroupUid(String userGroupUid) {
        this.userGroupUid = userGroupUid;
    }

    public UserGroupAccess withUserGroupUid(String userGroupUid) {
        this.userGroupUid = userGroupUid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public UserGroupAccess withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof String) {
                setAccess(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("displayName".equals(name)) {
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("userGroupUid".equals(name)) {
                    if (value instanceof String) {
                        setUserGroupUid(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"userGroupUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("displayName".equals(name)) {
                return getDisplayName();
            } else {
                if ("userGroupUid".equals(name)) {
                    return getUserGroupUid();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, UserGroupAccess.NOT_FOUND_VALUE);
        if (UserGroupAccess.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public UserGroupAccess with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UserGroupAccess.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("userGroupUid");
        sb.append('=');
        sb.append(((this.userGroupUid == null)?"<null>":this.userGroupUid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.userGroupUid == null)? 0 :this.userGroupUid.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof UserGroupAccess) == false) {
            return false;
        }
        UserGroupAccess rhs = ((UserGroupAccess) other);
        return (((((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.userGroupUid == rhs.userGroupUid)||((this.userGroupUid!= null)&&this.userGroupUid.equals(rhs.userGroupUid))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))));
    }

}
