
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorCode",
    "message",
    "trackerType",
    "uid"
})
@Generated("jsonschema2pojo")
public class TrackerErrorReport implements Serializable
{

    @JsonProperty("errorCode")
    private TrackerErrorReport.TrackerErrorCode errorCode;
    @JsonProperty("message")
    private String message;
    @JsonProperty("trackerType")
    private TrackerErrorReport.TrackerType trackerType;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1490852207328720530L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerErrorReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerErrorReport(TrackerErrorReport source) {
        super();
        this.errorCode = source.errorCode;
        this.message = source.message;
        this.trackerType = source.trackerType;
        this.uid = source.uid;
    }

    public TrackerErrorReport(TrackerErrorReport.TrackerErrorCode errorCode, String message, TrackerErrorReport.TrackerType trackerType, String uid) {
        super();
        this.errorCode = errorCode;
        this.message = message;
        this.trackerType = trackerType;
        this.uid = uid;
    }

    @JsonProperty("errorCode")
    public Optional<TrackerErrorReport.TrackerErrorCode> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    @JsonProperty("errorCode")
    public void setErrorCode(TrackerErrorReport.TrackerErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public TrackerErrorReport withErrorCode(TrackerErrorReport.TrackerErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public TrackerErrorReport withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty("trackerType")
    public Optional<TrackerErrorReport.TrackerType> getTrackerType() {
        return Optional.ofNullable(trackerType);
    }

    @JsonProperty("trackerType")
    public void setTrackerType(TrackerErrorReport.TrackerType trackerType) {
        this.trackerType = trackerType;
    }

    public TrackerErrorReport withTrackerType(TrackerErrorReport.TrackerType trackerType) {
        this.trackerType = trackerType;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public TrackerErrorReport withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerErrorReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("errorCode".equals(name)) {
            if (value instanceof TrackerErrorReport.TrackerErrorCode) {
                setErrorCode(((TrackerErrorReport.TrackerErrorCode) value));
            } else {
                throw new IllegalArgumentException(("property \"errorCode\" is of type \"org.hisp.dhis.api.model.v2_39_1.TrackerErrorReport.TrackerErrorCode\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("message".equals(name)) {
                if (value instanceof String) {
                    setMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("trackerType".equals(name)) {
                    if (value instanceof TrackerErrorReport.TrackerType) {
                        setTrackerType(((TrackerErrorReport.TrackerType) value));
                    } else {
                        throw new IllegalArgumentException(("property \"trackerType\" is of type \"org.hisp.dhis.api.model.v2_39_1.TrackerErrorReport.TrackerType\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("uid".equals(name)) {
                        if (value instanceof String) {
                            setUid(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("errorCode".equals(name)) {
            return getErrorCode();
        } else {
            if ("message".equals(name)) {
                return getMessage();
            } else {
                if ("trackerType".equals(name)) {
                    return getTrackerType();
                } else {
                    if ("uid".equals(name)) {
                        return getUid();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerErrorReport.NOT_FOUND_VALUE);
        if (TrackerErrorReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerErrorReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerErrorReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorCode");
        sb.append('=');
        sb.append(((this.errorCode == null)?"<null>":this.errorCode));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("trackerType");
        sb.append('=');
        sb.append(((this.trackerType == null)?"<null>":this.trackerType));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.trackerType == null)? 0 :this.trackerType.hashCode()));
        result = ((result* 31)+((this.errorCode == null)? 0 :this.errorCode.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerErrorReport) == false) {
            return false;
        }
        TrackerErrorReport rhs = ((TrackerErrorReport) other);
        return ((((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.trackerType == rhs.trackerType)||((this.trackerType!= null)&&this.trackerType.equals(rhs.trackerType))))&&((this.errorCode == rhs.errorCode)||((this.errorCode!= null)&&this.errorCode.equals(rhs.errorCode))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))));
    }

    @Generated("jsonschema2pojo")
    public enum TrackerErrorCode {

        E_1000("E1000"),
        E_1001("E1001"),
        E_1002("E1002"),
        E_1003("E1003"),
        E_1005("E1005"),
        E_1006("E1006"),
        E_1007("E1007"),
        E_1008("E1008"),
        E_1009("E1009"),
        E_1010("E1010"),
        E_1011("E1011"),
        E_1012("E1012"),
        E_1013("E1013"),
        E_1014("E1014"),
        E_1015("E1015"),
        E_1016("E1016"),
        E_1018("E1018"),
        E_1019("E1019"),
        E_1020("E1020"),
        E_1021("E1021"),
        E_1022("E1022"),
        E_1023("E1023"),
        E_1025("E1025"),
        E_1029("E1029"),
        E_1030("E1030"),
        E_1031("E1031"),
        E_1032("E1032"),
        E_1033("E1033"),
        E_1035("E1035"),
        E_1039("E1039"),
        E_1041("E1041"),
        E_1042("E1042"),
        E_1048("E1048"),
        E_1049("E1049"),
        E_1050("E1050"),
        E_1054("E1054"),
        E_1055("E1055"),
        E_1056("E1056"),
        E_1057("E1057"),
        E_1063("E1063"),
        E_1064("E1064"),
        E_1068("E1068"),
        E_1069("E1069"),
        E_1070("E1070"),
        E_1074("E1074"),
        E_1075("E1075"),
        E_1076("E1076"),
        E_1077("E1077"),
        E_1079("E1079"),
        E_1080("E1080"),
        E_1081("E1081"),
        E_1082("E1082"),
        E_1083("E1083"),
        E_1084("E1084"),
        E_1085("E1085"),
        E_1086("E1086"),
        E_1087("E1087"),
        E_1088("E1088"),
        E_1089("E1089"),
        E_1090("E1090"),
        E_1091("E1091"),
        E_1095("E1095"),
        E_1096("E1096"),
        E_1099("E1099"),
        E_1100("E1100"),
        E_1102("E1102"),
        E_1103("E1103"),
        E_1104("E1104"),
        E_1112("E1112"),
        E_1113("E1113"),
        E_1114("E1114"),
        E_1115("E1115"),
        E_1116("E1116"),
        E_1117("E1117"),
        E_1118("E1118"),
        E_1119("E1119"),
        E_1120("E1120"),
        E_1121("E1121"),
        E_1122("E1122"),
        E_1123("E1123"),
        E_1124("E1124"),
        E_1125("E1125"),
        E_1126("E1126"),
        E_1127("E1127"),
        E_1128("E1128"),
        E_1094("E1094"),
        E_1110("E1110"),
        E_1045("E1045"),
        E_1043("E1043"),
        E_1044("E1044"),
        E_1046("E1046"),
        E_1047("E1047"),
        E_1300("E1300"),
        E_1301("E1301"),
        E_1302("E1302"),
        E_1303("E1303"),
        E_1304("E1304"),
        E_1305("E1305"),
        E_1306("E1306"),
        E_1307("E1307"),
        E_1308("E1308"),
        E_1309("E1309"),
        E_1310("E1310"),
        E_1311("E1311"),
        E_1312("E1312"),
        E_4000("E4000"),
        E_4001("E4001"),
        E_4003("E4003"),
        E_4004("E4004"),
        E_4005("E4005"),
        E_4006("E4006"),
        E_4007("E4007"),
        E_4008("E4008"),
        E_4009("E4009"),
        E_4010("E4010"),
        E_4011("E4011"),
        E_4012("E4012"),
        E_4013("E4013"),
        E_4014("E4014"),
        E_4015("E4015"),
        E_4016("E4016"),
        E_4017("E4017"),
        E_4018("E4018"),
        E_9999("E9999");
        private final String value;
        private final static Map<String, TrackerErrorReport.TrackerErrorCode> CONSTANTS = new HashMap<String, TrackerErrorReport.TrackerErrorCode>();

        static {
            for (TrackerErrorReport.TrackerErrorCode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TrackerErrorCode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerErrorReport.TrackerErrorCode fromValue(String value) {
            TrackerErrorReport.TrackerErrorCode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum TrackerType {

        TRACKED_ENTITY("TRACKED_ENTITY"),
        ENROLLMENT("ENROLLMENT"),
        EVENT("EVENT"),
        RELATIONSHIP("RELATIONSHIP");
        private final String value;
        private final static Map<String, TrackerErrorReport.TrackerType> CONSTANTS = new HashMap<String, TrackerErrorReport.TrackerType>();

        static {
            for (TrackerErrorReport.TrackerType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TrackerType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerErrorReport.TrackerType fromValue(String value) {
            TrackerErrorReport.TrackerType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
