
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "gatewayid",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "originator",
    "publicAccess",
    "receiveddate",
    "sentdate",
    "sharing",
    "smsencoding",
    "smsstatus",
    "text",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class IncomingSms implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("gatewayid")
    private String gatewayid;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("originator")
    private String originator;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("receiveddate")
    private Date receiveddate;
    @JsonProperty("sentdate")
    private Date sentdate;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("smsencoding")
    private IncomingSms.SmsMessageEncoding smsencoding;
    @JsonProperty("smsstatus")
    private IncomingSms.SmsMessageStatus smsstatus;
    @JsonProperty("text")
    private String text;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5510997208015591944L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public IncomingSms() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public IncomingSms(IncomingSms source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.gatewayid = source.gatewayid;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.originator = source.originator;
        this.publicAccess = source.publicAccess;
        this.receiveddate = source.receiveddate;
        this.sentdate = source.sentdate;
        this.sharing = source.sharing;
        this.smsencoding = source.smsencoding;
        this.smsstatus = source.smsstatus;
        this.text = source.text;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public IncomingSms(Access access, List<AttributeValue> attributeValues, String code, Date created, User createdBy, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String gatewayid, String href, String id, Date lastUpdated, User lastUpdatedBy, String name, String originator, String publicAccess, Date receiveddate, Date sentdate, Sharing sharing, IncomingSms.SmsMessageEncoding smsencoding, IncomingSms.SmsMessageStatus smsstatus, String text, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.gatewayid = gatewayid;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.originator = originator;
        this.publicAccess = publicAccess;
        this.receiveddate = receiveddate;
        this.sentdate = sentdate;
        this.sharing = sharing;
        this.smsencoding = smsencoding;
        this.smsstatus = smsstatus;
        this.text = text;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public IncomingSms withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public IncomingSms withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public IncomingSms withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public IncomingSms withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public IncomingSms withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public IncomingSms withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public IncomingSms withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public IncomingSms withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public IncomingSms withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("gatewayid")
    public Optional<String> getGatewayid() {
        return Optional.ofNullable(gatewayid);
    }

    @JsonProperty("gatewayid")
    public void setGatewayid(String gatewayid) {
        this.gatewayid = gatewayid;
    }

    public IncomingSms withGatewayid(String gatewayid) {
        this.gatewayid = gatewayid;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public IncomingSms withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public IncomingSms withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public IncomingSms withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public IncomingSms withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public IncomingSms withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("originator")
    public Optional<String> getOriginator() {
        return Optional.ofNullable(originator);
    }

    @JsonProperty("originator")
    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public IncomingSms withOriginator(String originator) {
        this.originator = originator;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public IncomingSms withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("receiveddate")
    public Optional<Date> getReceiveddate() {
        return Optional.ofNullable(receiveddate);
    }

    @JsonProperty("receiveddate")
    public void setReceiveddate(Date receiveddate) {
        this.receiveddate = receiveddate;
    }

    public IncomingSms withReceiveddate(Date receiveddate) {
        this.receiveddate = receiveddate;
        return this;
    }

    @JsonProperty("sentdate")
    public Optional<Date> getSentdate() {
        return Optional.ofNullable(sentdate);
    }

    @JsonProperty("sentdate")
    public void setSentdate(Date sentdate) {
        this.sentdate = sentdate;
    }

    public IncomingSms withSentdate(Date sentdate) {
        this.sentdate = sentdate;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public IncomingSms withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("smsencoding")
    public Optional<IncomingSms.SmsMessageEncoding> getSmsencoding() {
        return Optional.ofNullable(smsencoding);
    }

    @JsonProperty("smsencoding")
    public void setSmsencoding(IncomingSms.SmsMessageEncoding smsencoding) {
        this.smsencoding = smsencoding;
    }

    public IncomingSms withSmsencoding(IncomingSms.SmsMessageEncoding smsencoding) {
        this.smsencoding = smsencoding;
        return this;
    }

    @JsonProperty("smsstatus")
    public Optional<IncomingSms.SmsMessageStatus> getSmsstatus() {
        return Optional.ofNullable(smsstatus);
    }

    @JsonProperty("smsstatus")
    public void setSmsstatus(IncomingSms.SmsMessageStatus smsstatus) {
        this.smsstatus = smsstatus;
    }

    public IncomingSms withSmsstatus(IncomingSms.SmsMessageStatus smsstatus) {
        this.smsstatus = smsstatus;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public IncomingSms withText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public IncomingSms withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public IncomingSms withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public IncomingSms withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public IncomingSms withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public IncomingSms withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_39_1.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("created".equals(name)) {
                        if (value instanceof Date) {
                            setCreated(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("createdBy".equals(name)) {
                            if (value instanceof User) {
                                setCreatedBy(((User) value));
                            } else {
                                throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("displayName".equals(name)) {
                                if (value instanceof String) {
                                    setDisplayName(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("externalAccess".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setExternalAccess(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("favorite".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setFavorite(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("favorites".equals(name)) {
                                            if (value instanceof List) {
                                                setFavorites(((List<String> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("gatewayid".equals(name)) {
                                                if (value instanceof String) {
                                                    setGatewayid(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"gatewayid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("href".equals(name)) {
                                                    if (value instanceof String) {
                                                        setHref(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("id".equals(name)) {
                                                        if (value instanceof String) {
                                                            setId(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("lastUpdated".equals(name)) {
                                                            if (value instanceof Date) {
                                                                setLastUpdated(((Date) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("lastUpdatedBy".equals(name)) {
                                                                if (value instanceof User) {
                                                                    setLastUpdatedBy(((User) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("name".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setName(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("originator".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setOriginator(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"originator\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("publicAccess".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setPublicAccess(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("receiveddate".equals(name)) {
                                                                                if (value instanceof Date) {
                                                                                    setReceiveddate(((Date) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"receiveddate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("sentdate".equals(name)) {
                                                                                    if (value instanceof Date) {
                                                                                        setSentdate(((Date) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"sentdate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("sharing".equals(name)) {
                                                                                        if (value instanceof Sharing) {
                                                                                            setSharing(((Sharing) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_39_1.Sharing\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("smsencoding".equals(name)) {
                                                                                            if (value instanceof IncomingSms.SmsMessageEncoding) {
                                                                                                setSmsencoding(((IncomingSms.SmsMessageEncoding) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"smsencoding\" is of type \"org.hisp.dhis.api.model.v2_39_1.IncomingSms.SmsMessageEncoding\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("smsstatus".equals(name)) {
                                                                                                if (value instanceof IncomingSms.SmsMessageStatus) {
                                                                                                    setSmsstatus(((IncomingSms.SmsMessageStatus) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"smsstatus\" is of type \"org.hisp.dhis.api.model.v2_39_1.IncomingSms.SmsMessageStatus\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("text".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setText(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("translations".equals(name)) {
                                                                                                        if (value instanceof List) {
                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Translation>\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("user".equals(name)) {
                                                                                                            if (value instanceof User) {
                                                                                                                setUser(((User) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_39_1.User\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setUserAccesses(((List<UserAccess> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    return false;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("created".equals(name)) {
                        return getCreated();
                    } else {
                        if ("createdBy".equals(name)) {
                            return getCreatedBy();
                        } else {
                            if ("displayName".equals(name)) {
                                return getDisplayName();
                            } else {
                                if ("externalAccess".equals(name)) {
                                    return getExternalAccess();
                                } else {
                                    if ("favorite".equals(name)) {
                                        return getFavorite();
                                    } else {
                                        if ("favorites".equals(name)) {
                                            return getFavorites();
                                        } else {
                                            if ("gatewayid".equals(name)) {
                                                return getGatewayid();
                                            } else {
                                                if ("href".equals(name)) {
                                                    return getHref();
                                                } else {
                                                    if ("id".equals(name)) {
                                                        return getId();
                                                    } else {
                                                        if ("lastUpdated".equals(name)) {
                                                            return getLastUpdated();
                                                        } else {
                                                            if ("lastUpdatedBy".equals(name)) {
                                                                return getLastUpdatedBy();
                                                            } else {
                                                                if ("name".equals(name)) {
                                                                    return getName();
                                                                } else {
                                                                    if ("originator".equals(name)) {
                                                                        return getOriginator();
                                                                    } else {
                                                                        if ("publicAccess".equals(name)) {
                                                                            return getPublicAccess();
                                                                        } else {
                                                                            if ("receiveddate".equals(name)) {
                                                                                return getReceiveddate();
                                                                            } else {
                                                                                if ("sentdate".equals(name)) {
                                                                                    return getSentdate();
                                                                                } else {
                                                                                    if ("sharing".equals(name)) {
                                                                                        return getSharing();
                                                                                    } else {
                                                                                        if ("smsencoding".equals(name)) {
                                                                                            return getSmsencoding();
                                                                                        } else {
                                                                                            if ("smsstatus".equals(name)) {
                                                                                                return getSmsstatus();
                                                                                            } else {
                                                                                                if ("text".equals(name)) {
                                                                                                    return getText();
                                                                                                } else {
                                                                                                    if ("translations".equals(name)) {
                                                                                                        return getTranslations();
                                                                                                    } else {
                                                                                                        if ("user".equals(name)) {
                                                                                                            return getUser();
                                                                                                        } else {
                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                return getUserAccesses();
                                                                                                            } else {
                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                    return getUserGroupAccesses();
                                                                                                                } else {
                                                                                                                    return notFoundValue;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, IncomingSms.NOT_FOUND_VALUE);
        if (IncomingSms.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public IncomingSms with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IncomingSms.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("gatewayid");
        sb.append('=');
        sb.append(((this.gatewayid == null)?"<null>":this.gatewayid));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("originator");
        sb.append('=');
        sb.append(((this.originator == null)?"<null>":this.originator));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("receiveddate");
        sb.append('=');
        sb.append(((this.receiveddate == null)?"<null>":this.receiveddate));
        sb.append(',');
        sb.append("sentdate");
        sb.append('=');
        sb.append(((this.sentdate == null)?"<null>":this.sentdate));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("smsencoding");
        sb.append('=');
        sb.append(((this.smsencoding == null)?"<null>":this.smsencoding));
        sb.append(',');
        sb.append("smsstatus");
        sb.append('=');
        sb.append(((this.smsstatus == null)?"<null>":this.smsstatus));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.sentdate == null)? 0 :this.sentdate.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.originator == null)? 0 :this.originator.hashCode()));
        result = ((result* 31)+((this.receiveddate == null)? 0 :this.receiveddate.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.smsencoding == null)? 0 :this.smsencoding.hashCode()));
        result = ((result* 31)+((this.smsstatus == null)? 0 :this.smsstatus.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.gatewayid == null)? 0 :this.gatewayid.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof IncomingSms) == false) {
            return false;
        }
        IncomingSms rhs = ((IncomingSms) other);
        return (((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.sentdate == rhs.sentdate)||((this.sentdate!= null)&&this.sentdate.equals(rhs.sentdate))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.originator == rhs.originator)||((this.originator!= null)&&this.originator.equals(rhs.originator))))&&((this.receiveddate == rhs.receiveddate)||((this.receiveddate!= null)&&this.receiveddate.equals(rhs.receiveddate))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.smsencoding == rhs.smsencoding)||((this.smsencoding!= null)&&this.smsencoding.equals(rhs.smsencoding))))&&((this.smsstatus == rhs.smsstatus)||((this.smsstatus!= null)&&this.smsstatus.equals(rhs.smsstatus))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.gatewayid == rhs.gatewayid)||((this.gatewayid!= null)&&this.gatewayid.equals(rhs.gatewayid))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum SmsMessageEncoding {

        ENC_7_BIT("ENC7BIT"),
        ENC_8_BIT("ENC8BIT"),
        ENCUCS_2("ENCUCS2"),
        ENCCUSTOM("ENCCUSTOM");
        private final String value;
        private final static Map<String, IncomingSms.SmsMessageEncoding> CONSTANTS = new HashMap<String, IncomingSms.SmsMessageEncoding>();

        static {
            for (IncomingSms.SmsMessageEncoding c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        SmsMessageEncoding(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static IncomingSms.SmsMessageEncoding fromValue(String value) {
            IncomingSms.SmsMessageEncoding constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum SmsMessageStatus {

        INCOMING("INCOMING"),
        PROCESSING("PROCESSING"),
        UNHANDLED("UNHANDLED"),
        FAILED("FAILED"),
        PROCESSED("PROCESSED"),
        SENT("SENT");
        private final String value;
        private final static Map<String, IncomingSms.SmsMessageStatus> CONSTANTS = new HashMap<String, IncomingSms.SmsMessageStatus>();

        static {
            for (IncomingSms.SmsMessageStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        SmsMessageStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static IncomingSms.SmsMessageStatus fromValue(String value) {
            IncomingSms.SmsMessageStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
