
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "conflicts",
    "dataSetComplete",
    "description",
    "enrollments",
    "events",
    "href",
    "importConflicts",
    "importCount",
    "importOptions",
    "lastImported",
    "reference",
    "relationships",
    "responseType",
    "status",
    "type"
})
@Generated("jsonschema2pojo")
public class ImportTypeSummary implements Serializable
{

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    private List<Object> conflicts;
    @JsonProperty("dataSetComplete")
    private String dataSetComplete;
    @JsonProperty("description")
    private String description;
    @JsonProperty("enrollments")
    private ImportSummaries enrollments;
    @JsonProperty("events")
    private ImportSummaries events;
    @JsonProperty("href")
    private String href;
    @JsonProperty("importConflicts")
    private List<ImportConflict> importConflicts;
    @JsonProperty("importCount")
    private ImportCount importCount;
    @JsonProperty("importOptions")
    private ImportOptions importOptions;
    @JsonProperty("lastImported")
    private String lastImported;
    @JsonProperty("reference")
    private String reference;
    @JsonProperty("relationships")
    private ImportSummaries relationships;
    @JsonProperty("responseType")
    private String responseType;
    @JsonProperty("status")
    private org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus status;
    @JsonProperty("type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3825304380831081443L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportTypeSummary() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportTypeSummary(ImportTypeSummary source) {
        super();
        this.conflicts = source.conflicts;
        this.dataSetComplete = source.dataSetComplete;
        this.description = source.description;
        this.enrollments = source.enrollments;
        this.events = source.events;
        this.href = source.href;
        this.importConflicts = source.importConflicts;
        this.importCount = source.importCount;
        this.importOptions = source.importOptions;
        this.lastImported = source.lastImported;
        this.reference = source.reference;
        this.relationships = source.relationships;
        this.responseType = source.responseType;
        this.status = source.status;
        this.type = source.type;
    }

    public ImportTypeSummary(List<Object> conflicts, String dataSetComplete, String description, ImportSummaries enrollments, ImportSummaries events, String href, List<ImportConflict> importConflicts, ImportCount importCount, ImportOptions importOptions, String lastImported, String reference, ImportSummaries relationships, String responseType, org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus status, String type) {
        super();
        this.conflicts = conflicts;
        this.dataSetComplete = dataSetComplete;
        this.description = description;
        this.enrollments = enrollments;
        this.events = events;
        this.href = href;
        this.importConflicts = importConflicts;
        this.importCount = importCount;
        this.importOptions = importOptions;
        this.lastImported = lastImported;
        this.reference = reference;
        this.relationships = relationships;
        this.responseType = responseType;
        this.status = status;
        this.type = type;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    public Optional<List<Object>> getConflicts() {
        return Optional.ofNullable(conflicts);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    public void setConflicts(List<Object> conflicts) {
        this.conflicts = conflicts;
    }

    public ImportTypeSummary withConflicts(List<Object> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    @JsonProperty("dataSetComplete")
    public Optional<String> getDataSetComplete() {
        return Optional.ofNullable(dataSetComplete);
    }

    @JsonProperty("dataSetComplete")
    public void setDataSetComplete(String dataSetComplete) {
        this.dataSetComplete = dataSetComplete;
    }

    public ImportTypeSummary withDataSetComplete(String dataSetComplete) {
        this.dataSetComplete = dataSetComplete;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ImportTypeSummary withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("enrollments")
    public Optional<ImportSummaries> getEnrollments() {
        return Optional.ofNullable(enrollments);
    }

    @JsonProperty("enrollments")
    public void setEnrollments(ImportSummaries enrollments) {
        this.enrollments = enrollments;
    }

    public ImportTypeSummary withEnrollments(ImportSummaries enrollments) {
        this.enrollments = enrollments;
        return this;
    }

    @JsonProperty("events")
    public Optional<ImportSummaries> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(ImportSummaries events) {
        this.events = events;
    }

    public ImportTypeSummary withEvents(ImportSummaries events) {
        this.events = events;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ImportTypeSummary withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("importConflicts")
    public Optional<List<ImportConflict>> getImportConflicts() {
        return Optional.ofNullable(importConflicts);
    }

    @JsonProperty("importConflicts")
    public void setImportConflicts(List<ImportConflict> importConflicts) {
        this.importConflicts = importConflicts;
    }

    public ImportTypeSummary withImportConflicts(List<ImportConflict> importConflicts) {
        this.importConflicts = importConflicts;
        return this;
    }

    @JsonProperty("importCount")
    public Optional<ImportCount> getImportCount() {
        return Optional.ofNullable(importCount);
    }

    @JsonProperty("importCount")
    public void setImportCount(ImportCount importCount) {
        this.importCount = importCount;
    }

    public ImportTypeSummary withImportCount(ImportCount importCount) {
        this.importCount = importCount;
        return this;
    }

    @JsonProperty("importOptions")
    public Optional<ImportOptions> getImportOptions() {
        return Optional.ofNullable(importOptions);
    }

    @JsonProperty("importOptions")
    public void setImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
    }

    public ImportTypeSummary withImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
        return this;
    }

    @JsonProperty("lastImported")
    public Optional<String> getLastImported() {
        return Optional.ofNullable(lastImported);
    }

    @JsonProperty("lastImported")
    public void setLastImported(String lastImported) {
        this.lastImported = lastImported;
    }

    public ImportTypeSummary withLastImported(String lastImported) {
        this.lastImported = lastImported;
        return this;
    }

    @JsonProperty("reference")
    public Optional<String> getReference() {
        return Optional.ofNullable(reference);
    }

    @JsonProperty("reference")
    public void setReference(String reference) {
        this.reference = reference;
    }

    public ImportTypeSummary withReference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<ImportSummaries> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(ImportSummaries relationships) {
        this.relationships = relationships;
    }

    public ImportTypeSummary withRelationships(ImportSummaries relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public ImportTypeSummary withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonProperty("status")
    public Optional<org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus status) {
        this.status = status;
    }

    public ImportTypeSummary withStatus(org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    public ImportTypeSummary withType(String type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportTypeSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("conflicts".equals(name)) {
            if (value instanceof List) {
                setConflicts(((List<Object> ) value));
            } else {
                throw new IllegalArgumentException(("property \"conflicts\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataSetComplete".equals(name)) {
                if (value instanceof String) {
                    setDataSetComplete(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSetComplete\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("description".equals(name)) {
                    if (value instanceof String) {
                        setDescription(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("enrollments".equals(name)) {
                        if (value instanceof ImportSummaries) {
                            setEnrollments(((ImportSummaries) value));
                        } else {
                            throw new IllegalArgumentException(("property \"enrollments\" is of type \"org.hisp.dhis.api.model.v2_39_1.ImportSummaries\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("events".equals(name)) {
                            if (value instanceof ImportSummaries) {
                                setEvents(((ImportSummaries) value));
                            } else {
                                throw new IllegalArgumentException(("property \"events\" is of type \"org.hisp.dhis.api.model.v2_39_1.ImportSummaries\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("href".equals(name)) {
                                if (value instanceof String) {
                                    setHref(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("importConflicts".equals(name)) {
                                    if (value instanceof List) {
                                        setImportConflicts(((List<ImportConflict> ) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"importConflicts\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.ImportConflict>\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("importCount".equals(name)) {
                                        if (value instanceof ImportCount) {
                                            setImportCount(((ImportCount) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"importCount\" is of type \"org.hisp.dhis.api.model.v2_39_1.ImportCount\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("importOptions".equals(name)) {
                                            if (value instanceof ImportOptions) {
                                                setImportOptions(((ImportOptions) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"importOptions\" is of type \"org.hisp.dhis.api.model.v2_39_1.ImportOptions\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("lastImported".equals(name)) {
                                                if (value instanceof String) {
                                                    setLastImported(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"lastImported\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("reference".equals(name)) {
                                                    if (value instanceof String) {
                                                        setReference(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"reference\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("relationships".equals(name)) {
                                                        if (value instanceof ImportSummaries) {
                                                            setRelationships(((ImportSummaries) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"relationships\" is of type \"org.hisp.dhis.api.model.v2_39_1.ImportSummaries\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("responseType".equals(name)) {
                                                            if (value instanceof String) {
                                                                setResponseType(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("status".equals(name)) {
                                                                if (value instanceof org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus) {
                                                                    setStatus(((org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_39_1.GeoJsonImportReport.ImportStatus\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("type".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setType(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"type\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    return false;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("conflicts".equals(name)) {
            return getConflicts();
        } else {
            if ("dataSetComplete".equals(name)) {
                return getDataSetComplete();
            } else {
                if ("description".equals(name)) {
                    return getDescription();
                } else {
                    if ("enrollments".equals(name)) {
                        return getEnrollments();
                    } else {
                        if ("events".equals(name)) {
                            return getEvents();
                        } else {
                            if ("href".equals(name)) {
                                return getHref();
                            } else {
                                if ("importConflicts".equals(name)) {
                                    return getImportConflicts();
                                } else {
                                    if ("importCount".equals(name)) {
                                        return getImportCount();
                                    } else {
                                        if ("importOptions".equals(name)) {
                                            return getImportOptions();
                                        } else {
                                            if ("lastImported".equals(name)) {
                                                return getLastImported();
                                            } else {
                                                if ("reference".equals(name)) {
                                                    return getReference();
                                                } else {
                                                    if ("relationships".equals(name)) {
                                                        return getRelationships();
                                                    } else {
                                                        if ("responseType".equals(name)) {
                                                            return getResponseType();
                                                        } else {
                                                            if ("status".equals(name)) {
                                                                return getStatus();
                                                            } else {
                                                                if ("type".equals(name)) {
                                                                    return getType();
                                                                } else {
                                                                    return notFoundValue;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportTypeSummary.NOT_FOUND_VALUE);
        if (ImportTypeSummary.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportTypeSummary with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportTypeSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("conflicts");
        sb.append('=');
        sb.append(((this.conflicts == null)?"<null>":this.conflicts));
        sb.append(',');
        sb.append("dataSetComplete");
        sb.append('=');
        sb.append(((this.dataSetComplete == null)?"<null>":this.dataSetComplete));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("enrollments");
        sb.append('=');
        sb.append(((this.enrollments == null)?"<null>":this.enrollments));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("importConflicts");
        sb.append('=');
        sb.append(((this.importConflicts == null)?"<null>":this.importConflicts));
        sb.append(',');
        sb.append("importCount");
        sb.append('=');
        sb.append(((this.importCount == null)?"<null>":this.importCount));
        sb.append(',');
        sb.append("importOptions");
        sb.append('=');
        sb.append(((this.importOptions == null)?"<null>":this.importOptions));
        sb.append(',');
        sb.append("lastImported");
        sb.append('=');
        sb.append(((this.lastImported == null)?"<null>":this.lastImported));
        sb.append(',');
        sb.append("reference");
        sb.append('=');
        sb.append(((this.reference == null)?"<null>":this.reference));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.importCount == null)? 0 :this.importCount.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.importConflicts == null)? 0 :this.importConflicts.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.enrollments == null)? 0 :this.enrollments.hashCode()));
        result = ((result* 31)+((this.reference == null)? 0 :this.reference.hashCode()));
        result = ((result* 31)+((this.importOptions == null)? 0 :this.importOptions.hashCode()));
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.conflicts == null)? 0 :this.conflicts.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.lastImported == null)? 0 :this.lastImported.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.dataSetComplete == null)? 0 :this.dataSetComplete.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportTypeSummary) == false) {
            return false;
        }
        ImportTypeSummary rhs = ((ImportTypeSummary) other);
        return (((((((((((((((((this.importCount == rhs.importCount)||((this.importCount!= null)&&this.importCount.equals(rhs.importCount)))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.importConflicts == rhs.importConflicts)||((this.importConflicts!= null)&&this.importConflicts.equals(rhs.importConflicts))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.enrollments == rhs.enrollments)||((this.enrollments!= null)&&this.enrollments.equals(rhs.enrollments))))&&((this.reference == rhs.reference)||((this.reference!= null)&&this.reference.equals(rhs.reference))))&&((this.importOptions == rhs.importOptions)||((this.importOptions!= null)&&this.importOptions.equals(rhs.importOptions))))&&((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships))))&&((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType))))&&((this.conflicts == rhs.conflicts)||((this.conflicts!= null)&&this.conflicts.equals(rhs.conflicts))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.lastImported == rhs.lastImported)||((this.lastImported!= null)&&this.lastImported.equals(rhs.lastImported))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.dataSetComplete == rhs.dataSetComplete)||((this.dataSetComplete!= null)&&this.dataSetComplete.equals(rhs.dataSetComplete))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
