
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorCode",
    "indexes",
    "object",
    "objects",
    "property",
    "value"
})
@Generated("jsonschema2pojo")
public class ImportConflict implements Serializable
{

    @JsonProperty("errorCode")
    private org.hisp.dhis.api.model.v2_39_1.ErrorReport.ErrorCode errorCode;
    @JsonProperty("indexes")
    private List<Integer> indexes;
    @JsonProperty("object")
    private String object;
    /**
     * Undefined
     * 
     */
    @JsonProperty("objects")
    private Objects objects;
    @JsonProperty("property")
    private String property;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6078765062206821100L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportConflict() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportConflict(ImportConflict source) {
        super();
        this.errorCode = source.errorCode;
        this.indexes = source.indexes;
        this.object = source.object;
        this.objects = source.objects;
        this.property = source.property;
        this.value = source.value;
    }

    public ImportConflict(org.hisp.dhis.api.model.v2_39_1.ErrorReport.ErrorCode errorCode, List<Integer> indexes, String object, Objects objects, String property, String value) {
        super();
        this.errorCode = errorCode;
        this.indexes = indexes;
        this.object = object;
        this.objects = objects;
        this.property = property;
        this.value = value;
    }

    @JsonProperty("errorCode")
    public Optional<org.hisp.dhis.api.model.v2_39_1.ErrorReport.ErrorCode> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    @JsonProperty("errorCode")
    public void setErrorCode(org.hisp.dhis.api.model.v2_39_1.ErrorReport.ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public ImportConflict withErrorCode(org.hisp.dhis.api.model.v2_39_1.ErrorReport.ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @JsonProperty("indexes")
    public Optional<List<Integer>> getIndexes() {
        return Optional.ofNullable(indexes);
    }

    @JsonProperty("indexes")
    public void setIndexes(List<Integer> indexes) {
        this.indexes = indexes;
    }

    public ImportConflict withIndexes(List<Integer> indexes) {
        this.indexes = indexes;
        return this;
    }

    @JsonProperty("object")
    public Optional<String> getObject() {
        return Optional.ofNullable(object);
    }

    @JsonProperty("object")
    public void setObject(String object) {
        this.object = object;
    }

    public ImportConflict withObject(String object) {
        this.object = object;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("objects")
    public Optional<Objects> getObjects() {
        return Optional.ofNullable(objects);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("objects")
    public void setObjects(Objects objects) {
        this.objects = objects;
    }

    public ImportConflict withObjects(Objects objects) {
        this.objects = objects;
        return this;
    }

    @JsonProperty("property")
    public Optional<String> getProperty() {
        return Optional.ofNullable(property);
    }

    @JsonProperty("property")
    public void setProperty(String property) {
        this.property = property;
    }

    public ImportConflict withProperty(String property) {
        this.property = property;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public ImportConflict withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportConflict withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("errorCode".equals(name)) {
            if (value instanceof org.hisp.dhis.api.model.v2_39_1.ErrorReport.ErrorCode) {
                setErrorCode(((org.hisp.dhis.api.model.v2_39_1.ErrorReport.ErrorCode) value));
            } else {
                throw new IllegalArgumentException(("property \"errorCode\" is of type \"org.hisp.dhis.api.model.v2_39_1.ErrorReport.ErrorCode\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("indexes".equals(name)) {
                if (value instanceof List) {
                    setIndexes(((List<Integer> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indexes\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("object".equals(name)) {
                    if (value instanceof String) {
                        setObject(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"object\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("objects".equals(name)) {
                        if (value instanceof Objects) {
                            setObjects(((Objects) value));
                        } else {
                            throw new IllegalArgumentException(("property \"objects\" is of type \"org.hisp.dhis.api.model.v2_39_1.Objects\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("property".equals(name)) {
                            if (value instanceof String) {
                                setProperty(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"property\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("value".equals(name)) {
                                if (value instanceof String) {
                                    setValue(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("errorCode".equals(name)) {
            return getErrorCode();
        } else {
            if ("indexes".equals(name)) {
                return getIndexes();
            } else {
                if ("object".equals(name)) {
                    return getObject();
                } else {
                    if ("objects".equals(name)) {
                        return getObjects();
                    } else {
                        if ("property".equals(name)) {
                            return getProperty();
                        } else {
                            if ("value".equals(name)) {
                                return getValue();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportConflict.NOT_FOUND_VALUE);
        if (ImportConflict.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportConflict with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportConflict.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorCode");
        sb.append('=');
        sb.append(((this.errorCode == null)?"<null>":this.errorCode));
        sb.append(',');
        sb.append("indexes");
        sb.append('=');
        sb.append(((this.indexes == null)?"<null>":this.indexes));
        sb.append(',');
        sb.append("object");
        sb.append('=');
        sb.append(((this.object == null)?"<null>":this.object));
        sb.append(',');
        sb.append("objects");
        sb.append('=');
        sb.append(((this.objects == null)?"<null>":this.objects));
        sb.append(',');
        sb.append("property");
        sb.append('=');
        sb.append(((this.property == null)?"<null>":this.property));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.indexes == null)? 0 :this.indexes.hashCode()));
        result = ((result* 31)+((this.objects == null)? 0 :this.objects.hashCode()));
        result = ((result* 31)+((this.property == null)? 0 :this.property.hashCode()));
        result = ((result* 31)+((this.errorCode == null)? 0 :this.errorCode.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.object == null)? 0 :this.object.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportConflict) == false) {
            return false;
        }
        ImportConflict rhs = ((ImportConflict) other);
        return ((((((((this.indexes == rhs.indexes)||((this.indexes!= null)&&this.indexes.equals(rhs.indexes)))&&((this.objects == rhs.objects)||((this.objects!= null)&&this.objects.equals(rhs.objects))))&&((this.property == rhs.property)||((this.property!= null)&&this.property.equals(rhs.property))))&&((this.errorCode == rhs.errorCode)||((this.errorCode!= null)&&this.errorCode.equals(rhs.errorCode))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.object == rhs.object)||((this.object!= null)&&this.object.equals(rhs.object))));
    }

}
