
package org.hisp.dhis.api.model.v2_39_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "assignedUser",
    "assignedUserDisplayName",
    "assignedUserFirstName",
    "assignedUserSurname",
    "assignedUserUsername",
    "attributeCategoryOptions",
    "attributeOptionCombo",
    "completedBy",
    "completedDate",
    "created",
    "createdAtClient",
    "createdByUserInfo",
    "dataValues",
    "deleted",
    "dueDate",
    "enrollment",
    "enrollmentStatus",
    "event",
    "eventDate",
    "followup",
    "geometry",
    "href",
    "lastUpdated",
    "lastUpdatedAtClient",
    "lastUpdatedByUserInfo",
    "notes",
    "orgUnit",
    "orgUnitName",
    "program",
    "programStage",
    "programType",
    "relationships",
    "status",
    "storedBy",
    "trackedEntityInstance"
})
@Generated("jsonschema2pojo")
public class Event implements Serializable
{

    @JsonProperty("assignedUser")
    private String assignedUser;
    @JsonProperty("assignedUserDisplayName")
    private String assignedUserDisplayName;
    @JsonProperty("assignedUserFirstName")
    private String assignedUserFirstName;
    @JsonProperty("assignedUserSurname")
    private String assignedUserSurname;
    @JsonProperty("assignedUserUsername")
    private String assignedUserUsername;
    @JsonProperty("attributeCategoryOptions")
    private String attributeCategoryOptions;
    @JsonProperty("attributeOptionCombo")
    private String attributeOptionCombo;
    @JsonProperty("completedBy")
    private String completedBy;
    @JsonProperty("completedDate")
    private String completedDate;
    @JsonProperty("created")
    private String created;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    private String createdAtClient;
    @JsonProperty("createdByUserInfo")
    private UserInfoSnapshot createdByUserInfo;
    @JsonProperty("dataValues")
    private List<DataValue__2> dataValues;
    @JsonProperty("deleted")
    private Boolean deleted;
    @JsonProperty("dueDate")
    private String dueDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollment")
    private String enrollment;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    private Event.EnrollmentStatus enrollmentStatus;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("event")
    private String event;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventDate")
    private String eventDate;
    @JsonProperty("followup")
    private Boolean followup;
    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    private Object geometry;
    @JsonProperty("href")
    private String href;
    @JsonProperty("lastUpdated")
    private String lastUpdated;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    private String lastUpdatedAtClient;
    @JsonProperty("lastUpdatedByUserInfo")
    private UserInfoSnapshot lastUpdatedByUserInfo;
    @JsonProperty("notes")
    private List<Note> notes;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("orgUnitName")
    private String orgUnitName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("program")
    private String program;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programStage")
    private String programStage;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programType")
    private org.hisp.dhis.api.model.v2_39_1.Program.ProgramType programType;
    @JsonProperty("relationships")
    private List<Relationship> relationships;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private org.hisp.dhis.api.model.v2_39_1.EventChart.EventStatus status;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("trackedEntityInstance")
    private String trackedEntityInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2000840354461239844L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Event() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Event(Event source) {
        super();
        this.assignedUser = source.assignedUser;
        this.assignedUserDisplayName = source.assignedUserDisplayName;
        this.assignedUserFirstName = source.assignedUserFirstName;
        this.assignedUserSurname = source.assignedUserSurname;
        this.assignedUserUsername = source.assignedUserUsername;
        this.attributeCategoryOptions = source.attributeCategoryOptions;
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.completedBy = source.completedBy;
        this.completedDate = source.completedDate;
        this.created = source.created;
        this.createdAtClient = source.createdAtClient;
        this.createdByUserInfo = source.createdByUserInfo;
        this.dataValues = source.dataValues;
        this.deleted = source.deleted;
        this.dueDate = source.dueDate;
        this.enrollment = source.enrollment;
        this.enrollmentStatus = source.enrollmentStatus;
        this.event = source.event;
        this.eventDate = source.eventDate;
        this.followup = source.followup;
        this.geometry = source.geometry;
        this.href = source.href;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedAtClient = source.lastUpdatedAtClient;
        this.lastUpdatedByUserInfo = source.lastUpdatedByUserInfo;
        this.notes = source.notes;
        this.orgUnit = source.orgUnit;
        this.orgUnitName = source.orgUnitName;
        this.program = source.program;
        this.programStage = source.programStage;
        this.programType = source.programType;
        this.relationships = source.relationships;
        this.status = source.status;
        this.storedBy = source.storedBy;
        this.trackedEntityInstance = source.trackedEntityInstance;
    }

    public Event(String assignedUser, String assignedUserDisplayName, String assignedUserFirstName, String assignedUserSurname, String assignedUserUsername, String attributeCategoryOptions, String attributeOptionCombo, String completedBy, String completedDate, String created, String createdAtClient, UserInfoSnapshot createdByUserInfo, List<DataValue__2> dataValues, Boolean deleted, String dueDate, String enrollment, Event.EnrollmentStatus enrollmentStatus, String event, String eventDate, Boolean followup, Object geometry, String href, String lastUpdated, String lastUpdatedAtClient, UserInfoSnapshot lastUpdatedByUserInfo, List<Note> notes, String orgUnit, String orgUnitName, String program, String programStage, org.hisp.dhis.api.model.v2_39_1.Program.ProgramType programType, List<Relationship> relationships, org.hisp.dhis.api.model.v2_39_1.EventChart.EventStatus status, String storedBy, String trackedEntityInstance) {
        super();
        this.assignedUser = assignedUser;
        this.assignedUserDisplayName = assignedUserDisplayName;
        this.assignedUserFirstName = assignedUserFirstName;
        this.assignedUserSurname = assignedUserSurname;
        this.assignedUserUsername = assignedUserUsername;
        this.attributeCategoryOptions = attributeCategoryOptions;
        this.attributeOptionCombo = attributeOptionCombo;
        this.completedBy = completedBy;
        this.completedDate = completedDate;
        this.created = created;
        this.createdAtClient = createdAtClient;
        this.createdByUserInfo = createdByUserInfo;
        this.dataValues = dataValues;
        this.deleted = deleted;
        this.dueDate = dueDate;
        this.enrollment = enrollment;
        this.enrollmentStatus = enrollmentStatus;
        this.event = event;
        this.eventDate = eventDate;
        this.followup = followup;
        this.geometry = geometry;
        this.href = href;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        this.notes = notes;
        this.orgUnit = orgUnit;
        this.orgUnitName = orgUnitName;
        this.program = program;
        this.programStage = programStage;
        this.programType = programType;
        this.relationships = relationships;
        this.status = status;
        this.storedBy = storedBy;
        this.trackedEntityInstance = trackedEntityInstance;
    }

    @JsonProperty("assignedUser")
    public Optional<String> getAssignedUser() {
        return Optional.ofNullable(assignedUser);
    }

    @JsonProperty("assignedUser")
    public void setAssignedUser(String assignedUser) {
        this.assignedUser = assignedUser;
    }

    public Event withAssignedUser(String assignedUser) {
        this.assignedUser = assignedUser;
        return this;
    }

    @JsonProperty("assignedUserDisplayName")
    public Optional<String> getAssignedUserDisplayName() {
        return Optional.ofNullable(assignedUserDisplayName);
    }

    @JsonProperty("assignedUserDisplayName")
    public void setAssignedUserDisplayName(String assignedUserDisplayName) {
        this.assignedUserDisplayName = assignedUserDisplayName;
    }

    public Event withAssignedUserDisplayName(String assignedUserDisplayName) {
        this.assignedUserDisplayName = assignedUserDisplayName;
        return this;
    }

    @JsonProperty("assignedUserFirstName")
    public Optional<String> getAssignedUserFirstName() {
        return Optional.ofNullable(assignedUserFirstName);
    }

    @JsonProperty("assignedUserFirstName")
    public void setAssignedUserFirstName(String assignedUserFirstName) {
        this.assignedUserFirstName = assignedUserFirstName;
    }

    public Event withAssignedUserFirstName(String assignedUserFirstName) {
        this.assignedUserFirstName = assignedUserFirstName;
        return this;
    }

    @JsonProperty("assignedUserSurname")
    public Optional<String> getAssignedUserSurname() {
        return Optional.ofNullable(assignedUserSurname);
    }

    @JsonProperty("assignedUserSurname")
    public void setAssignedUserSurname(String assignedUserSurname) {
        this.assignedUserSurname = assignedUserSurname;
    }

    public Event withAssignedUserSurname(String assignedUserSurname) {
        this.assignedUserSurname = assignedUserSurname;
        return this;
    }

    @JsonProperty("assignedUserUsername")
    public Optional<String> getAssignedUserUsername() {
        return Optional.ofNullable(assignedUserUsername);
    }

    @JsonProperty("assignedUserUsername")
    public void setAssignedUserUsername(String assignedUserUsername) {
        this.assignedUserUsername = assignedUserUsername;
    }

    public Event withAssignedUserUsername(String assignedUserUsername) {
        this.assignedUserUsername = assignedUserUsername;
        return this;
    }

    @JsonProperty("attributeCategoryOptions")
    public Optional<String> getAttributeCategoryOptions() {
        return Optional.ofNullable(attributeCategoryOptions);
    }

    @JsonProperty("attributeCategoryOptions")
    public void setAttributeCategoryOptions(String attributeCategoryOptions) {
        this.attributeCategoryOptions = attributeCategoryOptions;
    }

    public Event withAttributeCategoryOptions(String attributeCategoryOptions) {
        this.attributeCategoryOptions = attributeCategoryOptions;
        return this;
    }

    @JsonProperty("attributeOptionCombo")
    public Optional<String> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public Event withAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("completedBy")
    public Optional<String> getCompletedBy() {
        return Optional.ofNullable(completedBy);
    }

    @JsonProperty("completedBy")
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public Event withCompletedBy(String completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    @JsonProperty("completedDate")
    public Optional<String> getCompletedDate() {
        return Optional.ofNullable(completedDate);
    }

    @JsonProperty("completedDate")
    public void setCompletedDate(String completedDate) {
        this.completedDate = completedDate;
    }

    public Event withCompletedDate(String completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    @JsonProperty("created")
    public Optional<String> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(String created) {
        this.created = created;
    }

    public Event withCreated(String created) {
        this.created = created;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    public String getCreatedAtClient() {
        return createdAtClient;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    public void setCreatedAtClient(String createdAtClient) {
        this.createdAtClient = createdAtClient;
    }

    public Event withCreatedAtClient(String createdAtClient) {
        this.createdAtClient = createdAtClient;
        return this;
    }

    @JsonProperty("createdByUserInfo")
    public Optional<UserInfoSnapshot> getCreatedByUserInfo() {
        return Optional.ofNullable(createdByUserInfo);
    }

    @JsonProperty("createdByUserInfo")
    public void setCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
    }

    public Event withCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
        return this;
    }

    @JsonProperty("dataValues")
    public Optional<List<DataValue__2>> getDataValues() {
        return Optional.ofNullable(dataValues);
    }

    @JsonProperty("dataValues")
    public void setDataValues(List<DataValue__2> dataValues) {
        this.dataValues = dataValues;
    }

    public Event withDataValues(List<DataValue__2> dataValues) {
        this.dataValues = dataValues;
        return this;
    }

    @JsonProperty("deleted")
    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Event withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("dueDate")
    public Optional<String> getDueDate() {
        return Optional.ofNullable(dueDate);
    }

    @JsonProperty("dueDate")
    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public Event withDueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollment")
    public String getEnrollment() {
        return enrollment;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollment")
    public void setEnrollment(String enrollment) {
        this.enrollment = enrollment;
    }

    public Event withEnrollment(String enrollment) {
        this.enrollment = enrollment;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    public Event.EnrollmentStatus getEnrollmentStatus() {
        return enrollmentStatus;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    public void setEnrollmentStatus(Event.EnrollmentStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public Event withEnrollmentStatus(Event.EnrollmentStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("event")
    public String getEvent() {
        return event;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("event")
    public void setEvent(String event) {
        this.event = event;
    }

    public Event withEvent(String event) {
        this.event = event;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventDate")
    public String getEventDate() {
        return eventDate;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventDate")
    public void setEventDate(String eventDate) {
        this.eventDate = eventDate;
    }

    public Event withEventDate(String eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @JsonProperty("followup")
    public Optional<Boolean> getFollowup() {
        return Optional.ofNullable(followup);
    }

    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public Event withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public Optional<Object> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public void setGeometry(Object geometry) {
        this.geometry = geometry;
    }

    public Event withGeometry(Object geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Event withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<String> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Event withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    public String getLastUpdatedAtClient() {
        return lastUpdatedAtClient;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    public void setLastUpdatedAtClient(String lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
    }

    public Event withLastUpdatedAtClient(String lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        return this;
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public Optional<UserInfoSnapshot> getLastUpdatedByUserInfo() {
        return Optional.ofNullable(lastUpdatedByUserInfo);
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public void setLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
    }

    public Event withLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        return this;
    }

    @JsonProperty("notes")
    public Optional<List<Note>> getNotes() {
        return Optional.ofNullable(notes);
    }

    @JsonProperty("notes")
    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public Event withNotes(List<Note> notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public Event withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("orgUnitName")
    public Optional<String> getOrgUnitName() {
        return Optional.ofNullable(orgUnitName);
    }

    @JsonProperty("orgUnitName")
    public void setOrgUnitName(String orgUnitName) {
        this.orgUnitName = orgUnitName;
    }

    public Event withOrgUnitName(String orgUnitName) {
        this.orgUnitName = orgUnitName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("program")
    public String getProgram() {
        return program;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("program")
    public void setProgram(String program) {
        this.program = program;
    }

    public Event withProgram(String program) {
        this.program = program;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programStage")
    public String getProgramStage() {
        return programStage;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programStage")
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    public Event withProgramStage(String programStage) {
        this.programStage = programStage;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programType")
    public org.hisp.dhis.api.model.v2_39_1.Program.ProgramType getProgramType() {
        return programType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("programType")
    public void setProgramType(org.hisp.dhis.api.model.v2_39_1.Program.ProgramType programType) {
        this.programType = programType;
    }

    public Event withProgramType(org.hisp.dhis.api.model.v2_39_1.Program.ProgramType programType) {
        this.programType = programType;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<Relationship>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    public Event withRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public org.hisp.dhis.api.model.v2_39_1.EventChart.EventStatus getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(org.hisp.dhis.api.model.v2_39_1.EventChart.EventStatus status) {
        this.status = status;
    }

    public Event withStatus(org.hisp.dhis.api.model.v2_39_1.EventChart.EventStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public Event withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<String> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public Event withTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Event withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assignedUser".equals(name)) {
            if (value instanceof String) {
                setAssignedUser(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"assignedUser\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("assignedUserDisplayName".equals(name)) {
                if (value instanceof String) {
                    setAssignedUserDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUserDisplayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("assignedUserFirstName".equals(name)) {
                    if (value instanceof String) {
                        setAssignedUserFirstName(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"assignedUserFirstName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("assignedUserSurname".equals(name)) {
                        if (value instanceof String) {
                            setAssignedUserSurname(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"assignedUserSurname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("assignedUserUsername".equals(name)) {
                            if (value instanceof String) {
                                setAssignedUserUsername(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"assignedUserUsername\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("attributeCategoryOptions".equals(name)) {
                                if (value instanceof String) {
                                    setAttributeCategoryOptions(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"attributeCategoryOptions\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("attributeOptionCombo".equals(name)) {
                                    if (value instanceof String) {
                                        setAttributeOptionCombo(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("completedBy".equals(name)) {
                                        if (value instanceof String) {
                                            setCompletedBy(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"completedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("completedDate".equals(name)) {
                                            if (value instanceof String) {
                                                setCompletedDate(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"completedDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("created".equals(name)) {
                                                if (value instanceof String) {
                                                    setCreated(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"created\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("createdAtClient".equals(name)) {
                                                    if (value instanceof String) {
                                                        setCreatedAtClient(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"createdAtClient\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("createdByUserInfo".equals(name)) {
                                                        if (value instanceof UserInfoSnapshot) {
                                                            setCreatedByUserInfo(((UserInfoSnapshot) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"createdByUserInfo\" is of type \"org.hisp.dhis.api.model.v2_39_1.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("dataValues".equals(name)) {
                                                            if (value instanceof List) {
                                                                setDataValues(((List<DataValue__2> ) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"dataValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.DataValue__2>\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("deleted".equals(name)) {
                                                                if (value instanceof Boolean) {
                                                                    setDeleted(((Boolean) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("dueDate".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setDueDate(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"dueDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("enrollment".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setEnrollment(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"enrollment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("enrollmentStatus".equals(name)) {
                                                                            if (value instanceof Event.EnrollmentStatus) {
                                                                                setEnrollmentStatus(((Event.EnrollmentStatus) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"enrollmentStatus\" is of type \"org.hisp.dhis.api.model.v2_39_1.Event.EnrollmentStatus\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("event".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setEvent(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"event\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("eventDate".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setEventDate(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"eventDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("followup".equals(name)) {
                                                                                        if (value instanceof Boolean) {
                                                                                            setFollowup(((Boolean) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("geometry".equals(name)) {
                                                                                            if (value instanceof Object) {
                                                                                                setGeometry(((Object) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"geometry\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("href".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setHref(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setLastUpdated(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("lastUpdatedAtClient".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setLastUpdatedAtClient(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"lastUpdatedAtClient\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("lastUpdatedByUserInfo".equals(name)) {
                                                                                                            if (value instanceof UserInfoSnapshot) {
                                                                                                                setLastUpdatedByUserInfo(((UserInfoSnapshot) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"lastUpdatedByUserInfo\" is of type \"org.hisp.dhis.api.model.v2_39_1.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("notes".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setNotes(((List<Note> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"notes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Note>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("orgUnit".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setOrgUnit(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("orgUnitName".equals(name)) {
                                                                                                                        if (value instanceof String) {
                                                                                                                            setOrgUnitName(((String) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"orgUnitName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("program".equals(name)) {
                                                                                                                            if (value instanceof String) {
                                                                                                                                setProgram(((String) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"program\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("programStage".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setProgramStage(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"programStage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("programType".equals(name)) {
                                                                                                                                    if (value instanceof org.hisp.dhis.api.model.v2_39_1.Program.ProgramType) {
                                                                                                                                        setProgramType(((org.hisp.dhis.api.model.v2_39_1.Program.ProgramType) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"programType\" is of type \"org.hisp.dhis.api.model.v2_39_1.Program.ProgramType\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("relationships".equals(name)) {
                                                                                                                                        if (value instanceof List) {
                                                                                                                                            setRelationships(((List<Relationship> ) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_39_1.Relationship>\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("status".equals(name)) {
                                                                                                                                            if (value instanceof org.hisp.dhis.api.model.v2_39_1.EventChart.EventStatus) {
                                                                                                                                                setStatus(((org.hisp.dhis.api.model.v2_39_1.EventChart.EventStatus) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_39_1.EventChart.EventStatus\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("storedBy".equals(name)) {
                                                                                                                                                if (value instanceof String) {
                                                                                                                                                    setStoredBy(((String) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("trackedEntityInstance".equals(name)) {
                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                        setTrackedEntityInstance(((String) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assignedUser".equals(name)) {
            return getAssignedUser();
        } else {
            if ("assignedUserDisplayName".equals(name)) {
                return getAssignedUserDisplayName();
            } else {
                if ("assignedUserFirstName".equals(name)) {
                    return getAssignedUserFirstName();
                } else {
                    if ("assignedUserSurname".equals(name)) {
                        return getAssignedUserSurname();
                    } else {
                        if ("assignedUserUsername".equals(name)) {
                            return getAssignedUserUsername();
                        } else {
                            if ("attributeCategoryOptions".equals(name)) {
                                return getAttributeCategoryOptions();
                            } else {
                                if ("attributeOptionCombo".equals(name)) {
                                    return getAttributeOptionCombo();
                                } else {
                                    if ("completedBy".equals(name)) {
                                        return getCompletedBy();
                                    } else {
                                        if ("completedDate".equals(name)) {
                                            return getCompletedDate();
                                        } else {
                                            if ("created".equals(name)) {
                                                return getCreated();
                                            } else {
                                                if ("createdAtClient".equals(name)) {
                                                    return getCreatedAtClient();
                                                } else {
                                                    if ("createdByUserInfo".equals(name)) {
                                                        return getCreatedByUserInfo();
                                                    } else {
                                                        if ("dataValues".equals(name)) {
                                                            return getDataValues();
                                                        } else {
                                                            if ("deleted".equals(name)) {
                                                                return getDeleted();
                                                            } else {
                                                                if ("dueDate".equals(name)) {
                                                                    return getDueDate();
                                                                } else {
                                                                    if ("enrollment".equals(name)) {
                                                                        return getEnrollment();
                                                                    } else {
                                                                        if ("enrollmentStatus".equals(name)) {
                                                                            return getEnrollmentStatus();
                                                                        } else {
                                                                            if ("event".equals(name)) {
                                                                                return getEvent();
                                                                            } else {
                                                                                if ("eventDate".equals(name)) {
                                                                                    return getEventDate();
                                                                                } else {
                                                                                    if ("followup".equals(name)) {
                                                                                        return getFollowup();
                                                                                    } else {
                                                                                        if ("geometry".equals(name)) {
                                                                                            return getGeometry();
                                                                                        } else {
                                                                                            if ("href".equals(name)) {
                                                                                                return getHref();
                                                                                            } else {
                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                    return getLastUpdated();
                                                                                                } else {
                                                                                                    if ("lastUpdatedAtClient".equals(name)) {
                                                                                                        return getLastUpdatedAtClient();
                                                                                                    } else {
                                                                                                        if ("lastUpdatedByUserInfo".equals(name)) {
                                                                                                            return getLastUpdatedByUserInfo();
                                                                                                        } else {
                                                                                                            if ("notes".equals(name)) {
                                                                                                                return getNotes();
                                                                                                            } else {
                                                                                                                if ("orgUnit".equals(name)) {
                                                                                                                    return getOrgUnit();
                                                                                                                } else {
                                                                                                                    if ("orgUnitName".equals(name)) {
                                                                                                                        return getOrgUnitName();
                                                                                                                    } else {
                                                                                                                        if ("program".equals(name)) {
                                                                                                                            return getProgram();
                                                                                                                        } else {
                                                                                                                            if ("programStage".equals(name)) {
                                                                                                                                return getProgramStage();
                                                                                                                            } else {
                                                                                                                                if ("programType".equals(name)) {
                                                                                                                                    return getProgramType();
                                                                                                                                } else {
                                                                                                                                    if ("relationships".equals(name)) {
                                                                                                                                        return getRelationships();
                                                                                                                                    } else {
                                                                                                                                        if ("status".equals(name)) {
                                                                                                                                            return getStatus();
                                                                                                                                        } else {
                                                                                                                                            if ("storedBy".equals(name)) {
                                                                                                                                                return getStoredBy();
                                                                                                                                            } else {
                                                                                                                                                if ("trackedEntityInstance".equals(name)) {
                                                                                                                                                    return getTrackedEntityInstance();
                                                                                                                                                } else {
                                                                                                                                                    return notFoundValue;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Event.NOT_FOUND_VALUE);
        if (Event.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Event with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Event.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assignedUser");
        sb.append('=');
        sb.append(((this.assignedUser == null)?"<null>":this.assignedUser));
        sb.append(',');
        sb.append("assignedUserDisplayName");
        sb.append('=');
        sb.append(((this.assignedUserDisplayName == null)?"<null>":this.assignedUserDisplayName));
        sb.append(',');
        sb.append("assignedUserFirstName");
        sb.append('=');
        sb.append(((this.assignedUserFirstName == null)?"<null>":this.assignedUserFirstName));
        sb.append(',');
        sb.append("assignedUserSurname");
        sb.append('=');
        sb.append(((this.assignedUserSurname == null)?"<null>":this.assignedUserSurname));
        sb.append(',');
        sb.append("assignedUserUsername");
        sb.append('=');
        sb.append(((this.assignedUserUsername == null)?"<null>":this.assignedUserUsername));
        sb.append(',');
        sb.append("attributeCategoryOptions");
        sb.append('=');
        sb.append(((this.attributeCategoryOptions == null)?"<null>":this.attributeCategoryOptions));
        sb.append(',');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("completedBy");
        sb.append('=');
        sb.append(((this.completedBy == null)?"<null>":this.completedBy));
        sb.append(',');
        sb.append("completedDate");
        sb.append('=');
        sb.append(((this.completedDate == null)?"<null>":this.completedDate));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdAtClient");
        sb.append('=');
        sb.append(((this.createdAtClient == null)?"<null>":this.createdAtClient));
        sb.append(',');
        sb.append("createdByUserInfo");
        sb.append('=');
        sb.append(((this.createdByUserInfo == null)?"<null>":this.createdByUserInfo));
        sb.append(',');
        sb.append("dataValues");
        sb.append('=');
        sb.append(((this.dataValues == null)?"<null>":this.dataValues));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("dueDate");
        sb.append('=');
        sb.append(((this.dueDate == null)?"<null>":this.dueDate));
        sb.append(',');
        sb.append("enrollment");
        sb.append('=');
        sb.append(((this.enrollment == null)?"<null>":this.enrollment));
        sb.append(',');
        sb.append("enrollmentStatus");
        sb.append('=');
        sb.append(((this.enrollmentStatus == null)?"<null>":this.enrollmentStatus));
        sb.append(',');
        sb.append("event");
        sb.append('=');
        sb.append(((this.event == null)?"<null>":this.event));
        sb.append(',');
        sb.append("eventDate");
        sb.append('=');
        sb.append(((this.eventDate == null)?"<null>":this.eventDate));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedAtClient");
        sb.append('=');
        sb.append(((this.lastUpdatedAtClient == null)?"<null>":this.lastUpdatedAtClient));
        sb.append(',');
        sb.append("lastUpdatedByUserInfo");
        sb.append('=');
        sb.append(((this.lastUpdatedByUserInfo == null)?"<null>":this.lastUpdatedByUserInfo));
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(((this.notes == null)?"<null>":this.notes));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("orgUnitName");
        sb.append('=');
        sb.append(((this.orgUnitName == null)?"<null>":this.orgUnitName));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("programType");
        sb.append('=');
        sb.append(((this.programType == null)?"<null>":this.programType));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataValues == null)? 0 :this.dataValues.hashCode()));
        result = ((result* 31)+((this.notes == null)? 0 :this.notes.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.attributeCategoryOptions == null)? 0 :this.attributeCategoryOptions.hashCode()));
        result = ((result* 31)+((this.dueDate == null)? 0 :this.dueDate.hashCode()));
        result = ((result* 31)+((this.assignedUserUsername == null)? 0 :this.assignedUserUsername.hashCode()));
        result = ((result* 31)+((this.createdAtClient == null)? 0 :this.createdAtClient.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.lastUpdatedByUserInfo == null)? 0 :this.lastUpdatedByUserInfo.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.event == null)? 0 :this.event.hashCode()));
        result = ((result* 31)+((this.assignedUser == null)? 0 :this.assignedUser.hashCode()));
        result = ((result* 31)+((this.createdByUserInfo == null)? 0 :this.createdByUserInfo.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.programType == null)? 0 :this.programType.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.completedDate == null)? 0 :this.completedDate.hashCode()));
        result = ((result* 31)+((this.enrollment == null)? 0 :this.enrollment.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.enrollmentStatus == null)? 0 :this.enrollmentStatus.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.assignedUserFirstName == null)? 0 :this.assignedUserFirstName.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.assignedUserDisplayName == null)? 0 :this.assignedUserDisplayName.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.completedBy == null)? 0 :this.completedBy.hashCode()));
        result = ((result* 31)+((this.assignedUserSurname == null)? 0 :this.assignedUserSurname.hashCode()));
        result = ((result* 31)+((this.eventDate == null)? 0 :this.eventDate.hashCode()));
        result = ((result* 31)+((this.lastUpdatedAtClient == null)? 0 :this.lastUpdatedAtClient.hashCode()));
        result = ((result* 31)+((this.orgUnitName == null)? 0 :this.orgUnitName.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Event) == false) {
            return false;
        }
        Event rhs = ((Event) other);
        return (((((((((((((((((((((((((((((((((((((this.dataValues == rhs.dataValues)||((this.dataValues!= null)&&this.dataValues.equals(rhs.dataValues)))&&((this.notes == rhs.notes)||((this.notes!= null)&&this.notes.equals(rhs.notes))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.attributeCategoryOptions == rhs.attributeCategoryOptions)||((this.attributeCategoryOptions!= null)&&this.attributeCategoryOptions.equals(rhs.attributeCategoryOptions))))&&((this.dueDate == rhs.dueDate)||((this.dueDate!= null)&&this.dueDate.equals(rhs.dueDate))))&&((this.assignedUserUsername == rhs.assignedUserUsername)||((this.assignedUserUsername!= null)&&this.assignedUserUsername.equals(rhs.assignedUserUsername))))&&((this.createdAtClient == rhs.createdAtClient)||((this.createdAtClient!= null)&&this.createdAtClient.equals(rhs.createdAtClient))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.lastUpdatedByUserInfo == rhs.lastUpdatedByUserInfo)||((this.lastUpdatedByUserInfo!= null)&&this.lastUpdatedByUserInfo.equals(rhs.lastUpdatedByUserInfo))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.event == rhs.event)||((this.event!= null)&&this.event.equals(rhs.event))))&&((this.assignedUser == rhs.assignedUser)||((this.assignedUser!= null)&&this.assignedUser.equals(rhs.assignedUser))))&&((this.createdByUserInfo == rhs.createdByUserInfo)||((this.createdByUserInfo!= null)&&this.createdByUserInfo.equals(rhs.createdByUserInfo))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.programType == rhs.programType)||((this.programType!= null)&&this.programType.equals(rhs.programType))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.completedDate == rhs.completedDate)||((this.completedDate!= null)&&this.completedDate.equals(rhs.completedDate))))&&((this.enrollment == rhs.enrollment)||((this.enrollment!= null)&&this.enrollment.equals(rhs.enrollment))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))))&&((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.enrollmentStatus == rhs.enrollmentStatus)||((this.enrollmentStatus!= null)&&this.enrollmentStatus.equals(rhs.enrollmentStatus))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.assignedUserFirstName == rhs.assignedUserFirstName)||((this.assignedUserFirstName!= null)&&this.assignedUserFirstName.equals(rhs.assignedUserFirstName))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.assignedUserDisplayName == rhs.assignedUserDisplayName)||((this.assignedUserDisplayName!= null)&&this.assignedUserDisplayName.equals(rhs.assignedUserDisplayName))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.completedBy == rhs.completedBy)||((this.completedBy!= null)&&this.completedBy.equals(rhs.completedBy))))&&((this.assignedUserSurname == rhs.assignedUserSurname)||((this.assignedUserSurname!= null)&&this.assignedUserSurname.equals(rhs.assignedUserSurname))))&&((this.eventDate == rhs.eventDate)||((this.eventDate!= null)&&this.eventDate.equals(rhs.eventDate))))&&((this.lastUpdatedAtClient == rhs.lastUpdatedAtClient)||((this.lastUpdatedAtClient!= null)&&this.lastUpdatedAtClient.equals(rhs.lastUpdatedAtClient))))&&((this.orgUnitName == rhs.orgUnitName)||((this.orgUnitName!= null)&&this.orgUnitName.equals(rhs.orgUnitName))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum EnrollmentStatus {

        ACTIVE("ACTIVE"),
        COMPLETED("COMPLETED"),
        CANCELLED("CANCELLED");
        private final String value;
        private final static Map<String, Event.EnrollmentStatus> CONSTANTS = new HashMap<String, Event.EnrollmentStatus>();

        static {
            for (Event.EnrollmentStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        EnrollmentStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Event.EnrollmentStatus fromValue(String value) {
            Event.EnrollmentStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
