
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code",
    "displayName",
    "id",
    "name",
    "username"
})
@Generated("jsonschema2pojo")
public class UserDto implements Serializable
{

    @JsonProperty("code")
    private String code;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("id")
    private String id;
    @JsonProperty("name")
    private String name;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -646980704944663149L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public UserDto() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public UserDto(UserDto source) {
        super();
        this.code = source.code;
        this.displayName = source.displayName;
        this.id = source.id;
        this.name = source.name;
        this.username = source.username;
    }

    public UserDto(String code, String displayName, String id, String name, String username) {
        super();
        this.code = code;
        this.displayName = displayName;
        this.id = id;
        this.name = name;
        this.username = username;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public UserDto withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserDto withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public UserDto withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public UserDto withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public UserDto withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public UserDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("code".equals(name)) {
            if (value instanceof String) {
                setCode(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("displayName".equals(name)) {
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("id".equals(name)) {
                    if (value instanceof String) {
                        setId(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("name".equals(name)) {
                        if (value instanceof String) {
                            setName(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("username".equals(name)) {
                            if (value instanceof String) {
                                setUsername(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("code".equals(name)) {
            return getCode();
        } else {
            if ("displayName".equals(name)) {
                return getDisplayName();
            } else {
                if ("id".equals(name)) {
                    return getId();
                } else {
                    if ("name".equals(name)) {
                        return getName();
                    } else {
                        if ("username".equals(name)) {
                            return getUsername();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, UserDto.NOT_FOUND_VALUE);
        if (UserDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public UserDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UserDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof UserDto) == false) {
            return false;
        }
        UserDto rhs = ((UserDto) other);
        return (((((((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code)))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

}
