
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "accessedBy",
    "enrollmentRuleEffects",
    "eventRuleEffects",
    "importStrategy",
    "jobConfiguration",
    "jobId",
    "klass",
    "messageType",
    "object",
    "program",
    "programInstance",
    "programStageInstance",
    "uid"
})
@Generated("jsonschema2pojo")
public class TrackerSideEffectDataBundle implements Serializable
{

    @JsonProperty("accessedBy")
    private String accessedBy;
    /**
     * Undefined
     * 
     */
    @JsonProperty("enrollmentRuleEffects")
    private EnrollmentRuleEffects enrollmentRuleEffects;
    /**
     * Undefined
     * 
     */
    @JsonProperty("eventRuleEffects")
    private EventRuleEffects eventRuleEffects;
    @JsonProperty("importStrategy")
    private org.hisp.dhis.api.model.v2_38_1.TrackerImportParams.TrackerImportStrategy importStrategy;
    @JsonProperty("jobConfiguration")
    private JobConfiguration jobConfiguration;
    @JsonProperty("jobId")
    private String jobId;
    @JsonProperty("klass")
    private String klass;
    @JsonProperty("messageType")
    private org.hisp.dhis.api.model.v2_38_1.Audit.MessageType messageType;
    @JsonProperty("object")
    private String object;
    @JsonProperty("program")
    private Program program;
    @JsonProperty("programInstance")
    private ProgramInstance programInstance;
    @JsonProperty("programStageInstance")
    private ProgramStageInstance programStageInstance;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 5105886509965009469L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerSideEffectDataBundle() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerSideEffectDataBundle(TrackerSideEffectDataBundle source) {
        super();
        this.accessedBy = source.accessedBy;
        this.enrollmentRuleEffects = source.enrollmentRuleEffects;
        this.eventRuleEffects = source.eventRuleEffects;
        this.importStrategy = source.importStrategy;
        this.jobConfiguration = source.jobConfiguration;
        this.jobId = source.jobId;
        this.klass = source.klass;
        this.messageType = source.messageType;
        this.object = source.object;
        this.program = source.program;
        this.programInstance = source.programInstance;
        this.programStageInstance = source.programStageInstance;
        this.uid = source.uid;
    }

    public TrackerSideEffectDataBundle(String accessedBy, EnrollmentRuleEffects enrollmentRuleEffects, EventRuleEffects eventRuleEffects, org.hisp.dhis.api.model.v2_38_1.TrackerImportParams.TrackerImportStrategy importStrategy, JobConfiguration jobConfiguration, String jobId, String klass, org.hisp.dhis.api.model.v2_38_1.Audit.MessageType messageType, String object, Program program, ProgramInstance programInstance, ProgramStageInstance programStageInstance, String uid) {
        super();
        this.accessedBy = accessedBy;
        this.enrollmentRuleEffects = enrollmentRuleEffects;
        this.eventRuleEffects = eventRuleEffects;
        this.importStrategy = importStrategy;
        this.jobConfiguration = jobConfiguration;
        this.jobId = jobId;
        this.klass = klass;
        this.messageType = messageType;
        this.object = object;
        this.program = program;
        this.programInstance = programInstance;
        this.programStageInstance = programStageInstance;
        this.uid = uid;
    }

    @JsonProperty("accessedBy")
    public Optional<String> getAccessedBy() {
        return Optional.ofNullable(accessedBy);
    }

    @JsonProperty("accessedBy")
    public void setAccessedBy(String accessedBy) {
        this.accessedBy = accessedBy;
    }

    public TrackerSideEffectDataBundle withAccessedBy(String accessedBy) {
        this.accessedBy = accessedBy;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("enrollmentRuleEffects")
    public Optional<EnrollmentRuleEffects> getEnrollmentRuleEffects() {
        return Optional.ofNullable(enrollmentRuleEffects);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("enrollmentRuleEffects")
    public void setEnrollmentRuleEffects(EnrollmentRuleEffects enrollmentRuleEffects) {
        this.enrollmentRuleEffects = enrollmentRuleEffects;
    }

    public TrackerSideEffectDataBundle withEnrollmentRuleEffects(EnrollmentRuleEffects enrollmentRuleEffects) {
        this.enrollmentRuleEffects = enrollmentRuleEffects;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("eventRuleEffects")
    public Optional<EventRuleEffects> getEventRuleEffects() {
        return Optional.ofNullable(eventRuleEffects);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("eventRuleEffects")
    public void setEventRuleEffects(EventRuleEffects eventRuleEffects) {
        this.eventRuleEffects = eventRuleEffects;
    }

    public TrackerSideEffectDataBundle withEventRuleEffects(EventRuleEffects eventRuleEffects) {
        this.eventRuleEffects = eventRuleEffects;
        return this;
    }

    @JsonProperty("importStrategy")
    public Optional<org.hisp.dhis.api.model.v2_38_1.TrackerImportParams.TrackerImportStrategy> getImportStrategy() {
        return Optional.ofNullable(importStrategy);
    }

    @JsonProperty("importStrategy")
    public void setImportStrategy(org.hisp.dhis.api.model.v2_38_1.TrackerImportParams.TrackerImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
    }

    public TrackerSideEffectDataBundle withImportStrategy(org.hisp.dhis.api.model.v2_38_1.TrackerImportParams.TrackerImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
        return this;
    }

    @JsonProperty("jobConfiguration")
    public Optional<JobConfiguration> getJobConfiguration() {
        return Optional.ofNullable(jobConfiguration);
    }

    @JsonProperty("jobConfiguration")
    public void setJobConfiguration(JobConfiguration jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    public TrackerSideEffectDataBundle withJobConfiguration(JobConfiguration jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
        return this;
    }

    @JsonProperty("jobId")
    public Optional<String> getJobId() {
        return Optional.ofNullable(jobId);
    }

    @JsonProperty("jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public TrackerSideEffectDataBundle withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @JsonProperty("klass")
    public Optional<String> getKlass() {
        return Optional.ofNullable(klass);
    }

    @JsonProperty("klass")
    public void setKlass(String klass) {
        this.klass = klass;
    }

    public TrackerSideEffectDataBundle withKlass(String klass) {
        this.klass = klass;
        return this;
    }

    @JsonProperty("messageType")
    public Optional<org.hisp.dhis.api.model.v2_38_1.Audit.MessageType> getMessageType() {
        return Optional.ofNullable(messageType);
    }

    @JsonProperty("messageType")
    public void setMessageType(org.hisp.dhis.api.model.v2_38_1.Audit.MessageType messageType) {
        this.messageType = messageType;
    }

    public TrackerSideEffectDataBundle withMessageType(org.hisp.dhis.api.model.v2_38_1.Audit.MessageType messageType) {
        this.messageType = messageType;
        return this;
    }

    @JsonProperty("object")
    public Optional<String> getObject() {
        return Optional.ofNullable(object);
    }

    @JsonProperty("object")
    public void setObject(String object) {
        this.object = object;
    }

    public TrackerSideEffectDataBundle withObject(String object) {
        this.object = object;
        return this;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public TrackerSideEffectDataBundle withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programInstance")
    public Optional<ProgramInstance> getProgramInstance() {
        return Optional.ofNullable(programInstance);
    }

    @JsonProperty("programInstance")
    public void setProgramInstance(ProgramInstance programInstance) {
        this.programInstance = programInstance;
    }

    public TrackerSideEffectDataBundle withProgramInstance(ProgramInstance programInstance) {
        this.programInstance = programInstance;
        return this;
    }

    @JsonProperty("programStageInstance")
    public Optional<ProgramStageInstance> getProgramStageInstance() {
        return Optional.ofNullable(programStageInstance);
    }

    @JsonProperty("programStageInstance")
    public void setProgramStageInstance(ProgramStageInstance programStageInstance) {
        this.programStageInstance = programStageInstance;
    }

    public TrackerSideEffectDataBundle withProgramStageInstance(ProgramStageInstance programStageInstance) {
        this.programStageInstance = programStageInstance;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public TrackerSideEffectDataBundle withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerSideEffectDataBundle withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("accessedBy".equals(name)) {
            if (value instanceof String) {
                setAccessedBy(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"accessedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("enrollmentRuleEffects".equals(name)) {
                if (value instanceof EnrollmentRuleEffects) {
                    setEnrollmentRuleEffects(((EnrollmentRuleEffects) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollmentRuleEffects\" is of type \"org.hisp.dhis.api.model.v2_38_1.EnrollmentRuleEffects\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("eventRuleEffects".equals(name)) {
                    if (value instanceof EventRuleEffects) {
                        setEventRuleEffects(((EventRuleEffects) value));
                    } else {
                        throw new IllegalArgumentException(("property \"eventRuleEffects\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventRuleEffects\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("importStrategy".equals(name)) {
                        if (value instanceof org.hisp.dhis.api.model.v2_38_1.TrackerImportParams.TrackerImportStrategy) {
                            setImportStrategy(((org.hisp.dhis.api.model.v2_38_1.TrackerImportParams.TrackerImportStrategy) value));
                        } else {
                            throw new IllegalArgumentException(("property \"importStrategy\" is of type \"org.hisp.dhis.api.model.v2_38_1.TrackerImportParams.TrackerImportStrategy\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("jobConfiguration".equals(name)) {
                            if (value instanceof JobConfiguration) {
                                setJobConfiguration(((JobConfiguration) value));
                            } else {
                                throw new IllegalArgumentException(("property \"jobConfiguration\" is of type \"org.hisp.dhis.api.model.v2_38_1.JobConfiguration\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("jobId".equals(name)) {
                                if (value instanceof String) {
                                    setJobId(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"jobId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("klass".equals(name)) {
                                    if (value instanceof String) {
                                        setKlass(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"klass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("messageType".equals(name)) {
                                        if (value instanceof org.hisp.dhis.api.model.v2_38_1.Audit.MessageType) {
                                            setMessageType(((org.hisp.dhis.api.model.v2_38_1.Audit.MessageType) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"messageType\" is of type \"org.hisp.dhis.api.model.v2_38_1.Audit.MessageType\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("object".equals(name)) {
                                            if (value instanceof String) {
                                                setObject(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"object\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("program".equals(name)) {
                                                if (value instanceof Program) {
                                                    setProgram(((Program) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_38_1.Program\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("programInstance".equals(name)) {
                                                    if (value instanceof ProgramInstance) {
                                                        setProgramInstance(((ProgramInstance) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"programInstance\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramInstance\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("programStageInstance".equals(name)) {
                                                        if (value instanceof ProgramStageInstance) {
                                                            setProgramStageInstance(((ProgramStageInstance) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"programStageInstance\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramStageInstance\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("uid".equals(name)) {
                                                            if (value instanceof String) {
                                                                setUid(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            return false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("accessedBy".equals(name)) {
            return getAccessedBy();
        } else {
            if ("enrollmentRuleEffects".equals(name)) {
                return getEnrollmentRuleEffects();
            } else {
                if ("eventRuleEffects".equals(name)) {
                    return getEventRuleEffects();
                } else {
                    if ("importStrategy".equals(name)) {
                        return getImportStrategy();
                    } else {
                        if ("jobConfiguration".equals(name)) {
                            return getJobConfiguration();
                        } else {
                            if ("jobId".equals(name)) {
                                return getJobId();
                            } else {
                                if ("klass".equals(name)) {
                                    return getKlass();
                                } else {
                                    if ("messageType".equals(name)) {
                                        return getMessageType();
                                    } else {
                                        if ("object".equals(name)) {
                                            return getObject();
                                        } else {
                                            if ("program".equals(name)) {
                                                return getProgram();
                                            } else {
                                                if ("programInstance".equals(name)) {
                                                    return getProgramInstance();
                                                } else {
                                                    if ("programStageInstance".equals(name)) {
                                                        return getProgramStageInstance();
                                                    } else {
                                                        if ("uid".equals(name)) {
                                                            return getUid();
                                                        } else {
                                                            return notFoundValue;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerSideEffectDataBundle.NOT_FOUND_VALUE);
        if (TrackerSideEffectDataBundle.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerSideEffectDataBundle with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerSideEffectDataBundle.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("accessedBy");
        sb.append('=');
        sb.append(((this.accessedBy == null)?"<null>":this.accessedBy));
        sb.append(',');
        sb.append("enrollmentRuleEffects");
        sb.append('=');
        sb.append(((this.enrollmentRuleEffects == null)?"<null>":this.enrollmentRuleEffects));
        sb.append(',');
        sb.append("eventRuleEffects");
        sb.append('=');
        sb.append(((this.eventRuleEffects == null)?"<null>":this.eventRuleEffects));
        sb.append(',');
        sb.append("importStrategy");
        sb.append('=');
        sb.append(((this.importStrategy == null)?"<null>":this.importStrategy));
        sb.append(',');
        sb.append("jobConfiguration");
        sb.append('=');
        sb.append(((this.jobConfiguration == null)?"<null>":this.jobConfiguration));
        sb.append(',');
        sb.append("jobId");
        sb.append('=');
        sb.append(((this.jobId == null)?"<null>":this.jobId));
        sb.append(',');
        sb.append("klass");
        sb.append('=');
        sb.append(((this.klass == null)?"<null>":this.klass));
        sb.append(',');
        sb.append("messageType");
        sb.append('=');
        sb.append(((this.messageType == null)?"<null>":this.messageType));
        sb.append(',');
        sb.append("object");
        sb.append('=');
        sb.append(((this.object == null)?"<null>":this.object));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programInstance");
        sb.append('=');
        sb.append(((this.programInstance == null)?"<null>":this.programInstance));
        sb.append(',');
        sb.append("programStageInstance");
        sb.append('=');
        sb.append(((this.programStageInstance == null)?"<null>":this.programStageInstance));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.eventRuleEffects == null)? 0 :this.eventRuleEffects.hashCode()));
        result = ((result* 31)+((this.programStageInstance == null)? 0 :this.programStageInstance.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.accessedBy == null)? 0 :this.accessedBy.hashCode()));
        result = ((result* 31)+((this.jobId == null)? 0 :this.jobId.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.programInstance == null)? 0 :this.programInstance.hashCode()));
        result = ((result* 31)+((this.messageType == null)? 0 :this.messageType.hashCode()));
        result = ((result* 31)+((this.klass == null)? 0 :this.klass.hashCode()));
        result = ((result* 31)+((this.jobConfiguration == null)? 0 :this.jobConfiguration.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importStrategy == null)? 0 :this.importStrategy.hashCode()));
        result = ((result* 31)+((this.enrollmentRuleEffects == null)? 0 :this.enrollmentRuleEffects.hashCode()));
        result = ((result* 31)+((this.object == null)? 0 :this.object.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerSideEffectDataBundle) == false) {
            return false;
        }
        TrackerSideEffectDataBundle rhs = ((TrackerSideEffectDataBundle) other);
        return (((((((((((((((this.eventRuleEffects == rhs.eventRuleEffects)||((this.eventRuleEffects!= null)&&this.eventRuleEffects.equals(rhs.eventRuleEffects)))&&((this.programStageInstance == rhs.programStageInstance)||((this.programStageInstance!= null)&&this.programStageInstance.equals(rhs.programStageInstance))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.accessedBy == rhs.accessedBy)||((this.accessedBy!= null)&&this.accessedBy.equals(rhs.accessedBy))))&&((this.jobId == rhs.jobId)||((this.jobId!= null)&&this.jobId.equals(rhs.jobId))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.programInstance == rhs.programInstance)||((this.programInstance!= null)&&this.programInstance.equals(rhs.programInstance))))&&((this.messageType == rhs.messageType)||((this.messageType!= null)&&this.messageType.equals(rhs.messageType))))&&((this.klass == rhs.klass)||((this.klass!= null)&&this.klass.equals(rhs.klass))))&&((this.jobConfiguration == rhs.jobConfiguration)||((this.jobConfiguration!= null)&&this.jobConfiguration.equals(rhs.jobConfiguration))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importStrategy == rhs.importStrategy)||((this.importStrategy!= null)&&this.importStrategy.equals(rhs.importStrategy))))&&((this.enrollmentRuleEffects == rhs.enrollmentRuleEffects)||((this.enrollmentRuleEffects!= null)&&this.enrollmentRuleEffects.equals(rhs.enrollmentRuleEffects))))&&((this.object == rhs.object)||((this.object!= null)&&this.object.equals(rhs.object))));
    }

}
