
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "lastPage",
    "nextPage",
    "page",
    "pageCount",
    "pageSize",
    "prevPage"
})
@Generated("jsonschema2pojo")
public class SlimPager implements Serializable
{

    @JsonProperty("lastPage")
    private Boolean lastPage;
    @JsonProperty("nextPage")
    private String nextPage;
    @JsonProperty("page")
    private Integer page;
    @JsonProperty("pageCount")
    private Integer pageCount;
    @JsonProperty("pageSize")
    private Integer pageSize;
    @JsonProperty("prevPage")
    private String prevPage;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3534969120630104834L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SlimPager() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SlimPager(SlimPager source) {
        super();
        this.lastPage = source.lastPage;
        this.nextPage = source.nextPage;
        this.page = source.page;
        this.pageCount = source.pageCount;
        this.pageSize = source.pageSize;
        this.prevPage = source.prevPage;
    }

    public SlimPager(Boolean lastPage, String nextPage, Integer page, Integer pageCount, Integer pageSize, String prevPage) {
        super();
        this.lastPage = lastPage;
        this.nextPage = nextPage;
        this.page = page;
        this.pageCount = pageCount;
        this.pageSize = pageSize;
        this.prevPage = prevPage;
    }

    @JsonProperty("lastPage")
    public Optional<Boolean> getLastPage() {
        return Optional.ofNullable(lastPage);
    }

    @JsonProperty("lastPage")
    public void setLastPage(Boolean lastPage) {
        this.lastPage = lastPage;
    }

    public SlimPager withLastPage(Boolean lastPage) {
        this.lastPage = lastPage;
        return this;
    }

    @JsonProperty("nextPage")
    public Optional<String> getNextPage() {
        return Optional.ofNullable(nextPage);
    }

    @JsonProperty("nextPage")
    public void setNextPage(String nextPage) {
        this.nextPage = nextPage;
    }

    public SlimPager withNextPage(String nextPage) {
        this.nextPage = nextPage;
        return this;
    }

    @JsonProperty("page")
    public Optional<Integer> getPage() {
        return Optional.ofNullable(page);
    }

    @JsonProperty("page")
    public void setPage(Integer page) {
        this.page = page;
    }

    public SlimPager withPage(Integer page) {
        this.page = page;
        return this;
    }

    @JsonProperty("pageCount")
    public Optional<Integer> getPageCount() {
        return Optional.ofNullable(pageCount);
    }

    @JsonProperty("pageCount")
    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public SlimPager withPageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @JsonProperty("pageSize")
    public Optional<Integer> getPageSize() {
        return Optional.ofNullable(pageSize);
    }

    @JsonProperty("pageSize")
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public SlimPager withPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @JsonProperty("prevPage")
    public Optional<String> getPrevPage() {
        return Optional.ofNullable(prevPage);
    }

    @JsonProperty("prevPage")
    public void setPrevPage(String prevPage) {
        this.prevPage = prevPage;
    }

    public SlimPager withPrevPage(String prevPage) {
        this.prevPage = prevPage;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SlimPager withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("lastPage".equals(name)) {
            if (value instanceof Boolean) {
                setLastPage(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"lastPage\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("nextPage".equals(name)) {
                if (value instanceof String) {
                    setNextPage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"nextPage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("page".equals(name)) {
                    if (value instanceof Integer) {
                        setPage(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"page\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("pageCount".equals(name)) {
                        if (value instanceof Integer) {
                            setPageCount(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"pageCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("pageSize".equals(name)) {
                            if (value instanceof Integer) {
                                setPageSize(((Integer) value));
                            } else {
                                throw new IllegalArgumentException(("property \"pageSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("prevPage".equals(name)) {
                                if (value instanceof String) {
                                    setPrevPage(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"prevPage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("lastPage".equals(name)) {
            return getLastPage();
        } else {
            if ("nextPage".equals(name)) {
                return getNextPage();
            } else {
                if ("page".equals(name)) {
                    return getPage();
                } else {
                    if ("pageCount".equals(name)) {
                        return getPageCount();
                    } else {
                        if ("pageSize".equals(name)) {
                            return getPageSize();
                        } else {
                            if ("prevPage".equals(name)) {
                                return getPrevPage();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SlimPager.NOT_FOUND_VALUE);
        if (SlimPager.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SlimPager with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SlimPager.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("lastPage");
        sb.append('=');
        sb.append(((this.lastPage == null)?"<null>":this.lastPage));
        sb.append(',');
        sb.append("nextPage");
        sb.append('=');
        sb.append(((this.nextPage == null)?"<null>":this.nextPage));
        sb.append(',');
        sb.append("page");
        sb.append('=');
        sb.append(((this.page == null)?"<null>":this.page));
        sb.append(',');
        sb.append("pageCount");
        sb.append('=');
        sb.append(((this.pageCount == null)?"<null>":this.pageCount));
        sb.append(',');
        sb.append("pageSize");
        sb.append('=');
        sb.append(((this.pageSize == null)?"<null>":this.pageSize));
        sb.append(',');
        sb.append("prevPage");
        sb.append('=');
        sb.append(((this.prevPage == null)?"<null>":this.prevPage));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.pageCount == null)? 0 :this.pageCount.hashCode()));
        result = ((result* 31)+((this.lastPage == null)? 0 :this.lastPage.hashCode()));
        result = ((result* 31)+((this.nextPage == null)? 0 :this.nextPage.hashCode()));
        result = ((result* 31)+((this.pageSize == null)? 0 :this.pageSize.hashCode()));
        result = ((result* 31)+((this.prevPage == null)? 0 :this.prevPage.hashCode()));
        result = ((result* 31)+((this.page == null)? 0 :this.page.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SlimPager) == false) {
            return false;
        }
        SlimPager rhs = ((SlimPager) other);
        return ((((((((this.pageCount == rhs.pageCount)||((this.pageCount!= null)&&this.pageCount.equals(rhs.pageCount)))&&((this.lastPage == rhs.lastPage)||((this.lastPage!= null)&&this.lastPage.equals(rhs.lastPage))))&&((this.nextPage == rhs.nextPage)||((this.nextPage!= null)&&this.nextPage.equals(rhs.nextPage))))&&((this.pageSize == rhs.pageSize)||((this.pageSize!= null)&&this.pageSize.equals(rhs.pageSize))))&&((this.prevPage == rhs.prevPage)||((this.prevPage!= null)&&this.prevPage.equals(rhs.prevPage))))&&((this.page == rhs.page)||((this.page!= null)&&this.page.equals(rhs.page))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
