
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "accessedBy",
    "created",
    "reason"
})
@Generated("jsonschema2pojo")
public class ProgramTempOwnershipAudit implements Serializable
{

    @JsonProperty("accessedBy")
    private String accessedBy;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("reason")
    private String reason;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8187620662503950387L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramTempOwnershipAudit() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramTempOwnershipAudit(ProgramTempOwnershipAudit source) {
        super();
        this.accessedBy = source.accessedBy;
        this.created = source.created;
        this.reason = source.reason;
    }

    public ProgramTempOwnershipAudit(String accessedBy, Date created, String reason) {
        super();
        this.accessedBy = accessedBy;
        this.created = created;
        this.reason = reason;
    }

    @JsonProperty("accessedBy")
    public Optional<String> getAccessedBy() {
        return Optional.ofNullable(accessedBy);
    }

    @JsonProperty("accessedBy")
    public void setAccessedBy(String accessedBy) {
        this.accessedBy = accessedBy;
    }

    public ProgramTempOwnershipAudit withAccessedBy(String accessedBy) {
        this.accessedBy = accessedBy;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramTempOwnershipAudit withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("reason")
    public Optional<String> getReason() {
        return Optional.ofNullable(reason);
    }

    @JsonProperty("reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    public ProgramTempOwnershipAudit withReason(String reason) {
        this.reason = reason;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramTempOwnershipAudit withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("accessedBy".equals(name)) {
            if (value instanceof String) {
                setAccessedBy(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"accessedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("created".equals(name)) {
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("reason".equals(name)) {
                    if (value instanceof String) {
                        setReason(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"reason\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("accessedBy".equals(name)) {
            return getAccessedBy();
        } else {
            if ("created".equals(name)) {
                return getCreated();
            } else {
                if ("reason".equals(name)) {
                    return getReason();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramTempOwnershipAudit.NOT_FOUND_VALUE);
        if (ProgramTempOwnershipAudit.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramTempOwnershipAudit with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramTempOwnershipAudit.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("accessedBy");
        sb.append('=');
        sb.append(((this.accessedBy == null)?"<null>":this.accessedBy));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("reason");
        sb.append('=');
        sb.append(((this.reason == null)?"<null>":this.reason));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.reason == null)? 0 :this.reason.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.accessedBy == null)? 0 :this.accessedBy.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramTempOwnershipAudit) == false) {
            return false;
        }
        ProgramTempOwnershipAudit rhs = ((ProgramTempOwnershipAudit) other);
        return (((((this.reason == rhs.reason)||((this.reason!= null)&&this.reason.equals(rhs.reason)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.accessedBy == rhs.accessedBy)||((this.accessedBy!= null)&&this.accessedBy.equals(rhs.accessedBy))));
    }

}
