
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataElement",
    "generated",
    "max",
    "min",
    "optionCombo",
    "source"
})
@Generated("jsonschema2pojo")
public class MinMaxDataElement implements Serializable
{

    @JsonProperty("dataElement")
    private DataElement dataElement;
    @JsonProperty("generated")
    private Boolean generated;
    @JsonProperty("max")
    private Integer max;
    @JsonProperty("min")
    private Integer min;
    @JsonProperty("optionCombo")
    private CategoryOptionCombo optionCombo;
    @JsonProperty("source")
    private OrganisationUnit source;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6933273459132579434L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MinMaxDataElement() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MinMaxDataElement(MinMaxDataElement source) {
        super();
        this.dataElement = source.dataElement;
        this.generated = source.generated;
        this.max = source.max;
        this.min = source.min;
        this.optionCombo = source.optionCombo;
        this.source = source.source;
    }

    public MinMaxDataElement(DataElement dataElement, Boolean generated, Integer max, Integer min, CategoryOptionCombo optionCombo, OrganisationUnit source) {
        super();
        this.dataElement = dataElement;
        this.generated = generated;
        this.max = max;
        this.min = min;
        this.optionCombo = optionCombo;
        this.source = source;
    }

    @JsonProperty("dataElement")
    public Optional<DataElement> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public MinMaxDataElement withDataElement(DataElement dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("generated")
    public Optional<Boolean> getGenerated() {
        return Optional.ofNullable(generated);
    }

    @JsonProperty("generated")
    public void setGenerated(Boolean generated) {
        this.generated = generated;
    }

    public MinMaxDataElement withGenerated(Boolean generated) {
        this.generated = generated;
        return this;
    }

    @JsonProperty("max")
    public Optional<Integer> getMax() {
        return Optional.ofNullable(max);
    }

    @JsonProperty("max")
    public void setMax(Integer max) {
        this.max = max;
    }

    public MinMaxDataElement withMax(Integer max) {
        this.max = max;
        return this;
    }

    @JsonProperty("min")
    public Optional<Integer> getMin() {
        return Optional.ofNullable(min);
    }

    @JsonProperty("min")
    public void setMin(Integer min) {
        this.min = min;
    }

    public MinMaxDataElement withMin(Integer min) {
        this.min = min;
        return this;
    }

    @JsonProperty("optionCombo")
    public Optional<CategoryOptionCombo> getOptionCombo() {
        return Optional.ofNullable(optionCombo);
    }

    @JsonProperty("optionCombo")
    public void setOptionCombo(CategoryOptionCombo optionCombo) {
        this.optionCombo = optionCombo;
    }

    public MinMaxDataElement withOptionCombo(CategoryOptionCombo optionCombo) {
        this.optionCombo = optionCombo;
        return this;
    }

    @JsonProperty("source")
    public Optional<OrganisationUnit> getSource() {
        return Optional.ofNullable(source);
    }

    @JsonProperty("source")
    public void setSource(OrganisationUnit source) {
        this.source = source;
    }

    public MinMaxDataElement withSource(OrganisationUnit source) {
        this.source = source;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MinMaxDataElement withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataElement".equals(name)) {
            if (value instanceof DataElement) {
                setDataElement(((DataElement) value));
            } else {
                throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataElement\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("generated".equals(name)) {
                if (value instanceof Boolean) {
                    setGenerated(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"generated\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("max".equals(name)) {
                    if (value instanceof Integer) {
                        setMax(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"max\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("min".equals(name)) {
                        if (value instanceof Integer) {
                            setMin(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"min\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("optionCombo".equals(name)) {
                            if (value instanceof CategoryOptionCombo) {
                                setOptionCombo(((CategoryOptionCombo) value));
                            } else {
                                throw new IllegalArgumentException(("property \"optionCombo\" is of type \"org.hisp.dhis.api.model.v2_38_1.CategoryOptionCombo\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("source".equals(name)) {
                                if (value instanceof OrganisationUnit) {
                                    setSource(((OrganisationUnit) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"source\" is of type \"org.hisp.dhis.api.model.v2_38_1.OrganisationUnit\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataElement".equals(name)) {
            return getDataElement();
        } else {
            if ("generated".equals(name)) {
                return getGenerated();
            } else {
                if ("max".equals(name)) {
                    return getMax();
                } else {
                    if ("min".equals(name)) {
                        return getMin();
                    } else {
                        if ("optionCombo".equals(name)) {
                            return getOptionCombo();
                        } else {
                            if ("source".equals(name)) {
                                return getSource();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MinMaxDataElement.NOT_FOUND_VALUE);
        if (MinMaxDataElement.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MinMaxDataElement with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MinMaxDataElement.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("generated");
        sb.append('=');
        sb.append(((this.generated == null)?"<null>":this.generated));
        sb.append(',');
        sb.append("max");
        sb.append('=');
        sb.append(((this.max == null)?"<null>":this.max));
        sb.append(',');
        sb.append("min");
        sb.append('=');
        sb.append(((this.min == null)?"<null>":this.min));
        sb.append(',');
        sb.append("optionCombo");
        sb.append('=');
        sb.append(((this.optionCombo == null)?"<null>":this.optionCombo));
        sb.append(',');
        sb.append("source");
        sb.append('=');
        sb.append(((this.source == null)?"<null>":this.source));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.min == null)? 0 :this.min.hashCode()));
        result = ((result* 31)+((this.generated == null)? 0 :this.generated.hashCode()));
        result = ((result* 31)+((this.max == null)? 0 :this.max.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.source == null)? 0 :this.source.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.optionCombo == null)? 0 :this.optionCombo.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MinMaxDataElement) == false) {
            return false;
        }
        MinMaxDataElement rhs = ((MinMaxDataElement) other);
        return ((((((((this.min == rhs.min)||((this.min!= null)&&this.min.equals(rhs.min)))&&((this.generated == rhs.generated)||((this.generated!= null)&&this.generated.equals(rhs.generated))))&&((this.max == rhs.max)||((this.max!= null)&&this.max.equals(rhs.max))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.source == rhs.source)||((this.source!= null)&&this.source.equals(rhs.source))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.optionCombo == rhs.optionCombo)||((this.optionCombo!= null)&&this.optionCombo.equals(rhs.optionCombo))));
    }

}
