
package org.hisp.dhis.api.model.v2_38_1;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

@Generated("jsonschema2pojo")
public enum JsonNodeType {

    OBJECT("OBJECT"),
    ARRAY("ARRAY"),
    STRING("STRING"),
    NUMBER("NUMBER"),
    BOOLEAN("BOOLEAN"),
    NULL("NULL");
    private final String value;
    private final static Map<String, JsonNodeType> CONSTANTS = new HashMap<String, JsonNodeType>();

    static {
        for (JsonNodeType c: values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    JsonNodeType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static JsonNodeType fromValue(String value) {
        JsonNodeType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        } else {
            return constant;
        }
    }

}
