
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "absoluteUrls",
    "anyFilter",
    "auto",
    "fields",
    "filters",
    "headless",
    "inverse",
    "orders",
    "pageOffset",
    "pageSize",
    "references",
    "total",
    "translate"
})
@Generated("jsonschema2pojo")
public class GistQuery implements Serializable
{

    @JsonProperty("absoluteUrls")
    private Boolean absoluteUrls;
    @JsonProperty("anyFilter")
    private Boolean anyFilter;
    @JsonProperty("auto")
    private GistAutoType auto;
    @JsonProperty("fields")
    private List<Field> fields;
    @JsonProperty("filters")
    private List<Filter> filters;
    @JsonProperty("headless")
    private Boolean headless;
    @JsonProperty("inverse")
    private Boolean inverse;
    @JsonProperty("orders")
    private List<Order> orders;
    @JsonProperty("pageOffset")
    private Integer pageOffset;
    @JsonProperty("pageSize")
    private Integer pageSize;
    @JsonProperty("references")
    private Boolean references;
    @JsonProperty("total")
    private Boolean total;
    @JsonProperty("translate")
    private Boolean translate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5867819660795723343L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GistQuery() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public GistQuery(GistQuery source) {
        super();
        this.absoluteUrls = source.absoluteUrls;
        this.anyFilter = source.anyFilter;
        this.auto = source.auto;
        this.fields = source.fields;
        this.filters = source.filters;
        this.headless = source.headless;
        this.inverse = source.inverse;
        this.orders = source.orders;
        this.pageOffset = source.pageOffset;
        this.pageSize = source.pageSize;
        this.references = source.references;
        this.total = source.total;
        this.translate = source.translate;
    }

    public GistQuery(Boolean absoluteUrls, Boolean anyFilter, GistAutoType auto, List<Field> fields, List<Filter> filters, Boolean headless, Boolean inverse, List<Order> orders, Integer pageOffset, Integer pageSize, Boolean references, Boolean total, Boolean translate) {
        super();
        this.absoluteUrls = absoluteUrls;
        this.anyFilter = anyFilter;
        this.auto = auto;
        this.fields = fields;
        this.filters = filters;
        this.headless = headless;
        this.inverse = inverse;
        this.orders = orders;
        this.pageOffset = pageOffset;
        this.pageSize = pageSize;
        this.references = references;
        this.total = total;
        this.translate = translate;
    }

    @JsonProperty("absoluteUrls")
    public Optional<Boolean> getAbsoluteUrls() {
        return Optional.ofNullable(absoluteUrls);
    }

    @JsonProperty("absoluteUrls")
    public void setAbsoluteUrls(Boolean absoluteUrls) {
        this.absoluteUrls = absoluteUrls;
    }

    public GistQuery withAbsoluteUrls(Boolean absoluteUrls) {
        this.absoluteUrls = absoluteUrls;
        return this;
    }

    @JsonProperty("anyFilter")
    public Optional<Boolean> getAnyFilter() {
        return Optional.ofNullable(anyFilter);
    }

    @JsonProperty("anyFilter")
    public void setAnyFilter(Boolean anyFilter) {
        this.anyFilter = anyFilter;
    }

    public GistQuery withAnyFilter(Boolean anyFilter) {
        this.anyFilter = anyFilter;
        return this;
    }

    @JsonProperty("auto")
    public Optional<GistAutoType> getAuto() {
        return Optional.ofNullable(auto);
    }

    @JsonProperty("auto")
    public void setAuto(GistAutoType auto) {
        this.auto = auto;
    }

    public GistQuery withAuto(GistAutoType auto) {
        this.auto = auto;
        return this;
    }

    @JsonProperty("fields")
    public Optional<List<Field>> getFields() {
        return Optional.ofNullable(fields);
    }

    @JsonProperty("fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public GistQuery withFields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    @JsonProperty("filters")
    public Optional<List<Filter>> getFilters() {
        return Optional.ofNullable(filters);
    }

    @JsonProperty("filters")
    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public GistQuery withFilters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    @JsonProperty("headless")
    public Optional<Boolean> getHeadless() {
        return Optional.ofNullable(headless);
    }

    @JsonProperty("headless")
    public void setHeadless(Boolean headless) {
        this.headless = headless;
    }

    public GistQuery withHeadless(Boolean headless) {
        this.headless = headless;
        return this;
    }

    @JsonProperty("inverse")
    public Optional<Boolean> getInverse() {
        return Optional.ofNullable(inverse);
    }

    @JsonProperty("inverse")
    public void setInverse(Boolean inverse) {
        this.inverse = inverse;
    }

    public GistQuery withInverse(Boolean inverse) {
        this.inverse = inverse;
        return this;
    }

    @JsonProperty("orders")
    public Optional<List<Order>> getOrders() {
        return Optional.ofNullable(orders);
    }

    @JsonProperty("orders")
    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public GistQuery withOrders(List<Order> orders) {
        this.orders = orders;
        return this;
    }

    @JsonProperty("pageOffset")
    public Optional<Integer> getPageOffset() {
        return Optional.ofNullable(pageOffset);
    }

    @JsonProperty("pageOffset")
    public void setPageOffset(Integer pageOffset) {
        this.pageOffset = pageOffset;
    }

    public GistQuery withPageOffset(Integer pageOffset) {
        this.pageOffset = pageOffset;
        return this;
    }

    @JsonProperty("pageSize")
    public Optional<Integer> getPageSize() {
        return Optional.ofNullable(pageSize);
    }

    @JsonProperty("pageSize")
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GistQuery withPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @JsonProperty("references")
    public Optional<Boolean> getReferences() {
        return Optional.ofNullable(references);
    }

    @JsonProperty("references")
    public void setReferences(Boolean references) {
        this.references = references;
    }

    public GistQuery withReferences(Boolean references) {
        this.references = references;
        return this;
    }

    @JsonProperty("total")
    public Optional<Boolean> getTotal() {
        return Optional.ofNullable(total);
    }

    @JsonProperty("total")
    public void setTotal(Boolean total) {
        this.total = total;
    }

    public GistQuery withTotal(Boolean total) {
        this.total = total;
        return this;
    }

    @JsonProperty("translate")
    public Optional<Boolean> getTranslate() {
        return Optional.ofNullable(translate);
    }

    @JsonProperty("translate")
    public void setTranslate(Boolean translate) {
        this.translate = translate;
    }

    public GistQuery withTranslate(Boolean translate) {
        this.translate = translate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GistQuery withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("absoluteUrls".equals(name)) {
            if (value instanceof Boolean) {
                setAbsoluteUrls(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"absoluteUrls\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("anyFilter".equals(name)) {
                if (value instanceof Boolean) {
                    setAnyFilter(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"anyFilter\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("auto".equals(name)) {
                    if (value instanceof GistAutoType) {
                        setAuto(((GistAutoType) value));
                    } else {
                        throw new IllegalArgumentException(("property \"auto\" is of type \"org.hisp.dhis.api.model.v2_38_1.GistAutoType\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("fields".equals(name)) {
                        if (value instanceof List) {
                            setFields(((List<Field> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"fields\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Field>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("filters".equals(name)) {
                            if (value instanceof List) {
                                setFilters(((List<Filter> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"filters\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Filter>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("headless".equals(name)) {
                                if (value instanceof Boolean) {
                                    setHeadless(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"headless\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("inverse".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setInverse(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"inverse\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("orders".equals(name)) {
                                        if (value instanceof List) {
                                            setOrders(((List<Order> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"orders\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Order>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("pageOffset".equals(name)) {
                                            if (value instanceof Integer) {
                                                setPageOffset(((Integer) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"pageOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("pageSize".equals(name)) {
                                                if (value instanceof Integer) {
                                                    setPageSize(((Integer) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"pageSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("references".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setReferences(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"references\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("total".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setTotal(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"total\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("translate".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setTranslate(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"translate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            return false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("absoluteUrls".equals(name)) {
            return getAbsoluteUrls();
        } else {
            if ("anyFilter".equals(name)) {
                return getAnyFilter();
            } else {
                if ("auto".equals(name)) {
                    return getAuto();
                } else {
                    if ("fields".equals(name)) {
                        return getFields();
                    } else {
                        if ("filters".equals(name)) {
                            return getFilters();
                        } else {
                            if ("headless".equals(name)) {
                                return getHeadless();
                            } else {
                                if ("inverse".equals(name)) {
                                    return getInverse();
                                } else {
                                    if ("orders".equals(name)) {
                                        return getOrders();
                                    } else {
                                        if ("pageOffset".equals(name)) {
                                            return getPageOffset();
                                        } else {
                                            if ("pageSize".equals(name)) {
                                                return getPageSize();
                                            } else {
                                                if ("references".equals(name)) {
                                                    return getReferences();
                                                } else {
                                                    if ("total".equals(name)) {
                                                        return getTotal();
                                                    } else {
                                                        if ("translate".equals(name)) {
                                                            return getTranslate();
                                                        } else {
                                                            return notFoundValue;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, GistQuery.NOT_FOUND_VALUE);
        if (GistQuery.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public GistQuery with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GistQuery.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("absoluteUrls");
        sb.append('=');
        sb.append(((this.absoluteUrls == null)?"<null>":this.absoluteUrls));
        sb.append(',');
        sb.append("anyFilter");
        sb.append('=');
        sb.append(((this.anyFilter == null)?"<null>":this.anyFilter));
        sb.append(',');
        sb.append("auto");
        sb.append('=');
        sb.append(((this.auto == null)?"<null>":this.auto));
        sb.append(',');
        sb.append("fields");
        sb.append('=');
        sb.append(((this.fields == null)?"<null>":this.fields));
        sb.append(',');
        sb.append("filters");
        sb.append('=');
        sb.append(((this.filters == null)?"<null>":this.filters));
        sb.append(',');
        sb.append("headless");
        sb.append('=');
        sb.append(((this.headless == null)?"<null>":this.headless));
        sb.append(',');
        sb.append("inverse");
        sb.append('=');
        sb.append(((this.inverse == null)?"<null>":this.inverse));
        sb.append(',');
        sb.append("orders");
        sb.append('=');
        sb.append(((this.orders == null)?"<null>":this.orders));
        sb.append(',');
        sb.append("pageOffset");
        sb.append('=');
        sb.append(((this.pageOffset == null)?"<null>":this.pageOffset));
        sb.append(',');
        sb.append("pageSize");
        sb.append('=');
        sb.append(((this.pageSize == null)?"<null>":this.pageSize));
        sb.append(',');
        sb.append("references");
        sb.append('=');
        sb.append(((this.references == null)?"<null>":this.references));
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(((this.total == null)?"<null>":this.total));
        sb.append(',');
        sb.append("translate");
        sb.append('=');
        sb.append(((this.translate == null)?"<null>":this.translate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.inverse == null)? 0 :this.inverse.hashCode()));
        result = ((result* 31)+((this.auto == null)? 0 :this.auto.hashCode()));
        result = ((result* 31)+((this.references == null)? 0 :this.references.hashCode()));
        result = ((result* 31)+((this.pageSize == null)? 0 :this.pageSize.hashCode()));
        result = ((result* 31)+((this.anyFilter == null)? 0 :this.anyFilter.hashCode()));
        result = ((result* 31)+((this.filters == null)? 0 :this.filters.hashCode()));
        result = ((result* 31)+((this.translate == null)? 0 :this.translate.hashCode()));
        result = ((result* 31)+((this.headless == null)? 0 :this.headless.hashCode()));
        result = ((result* 31)+((this.total == null)? 0 :this.total.hashCode()));
        result = ((result* 31)+((this.pageOffset == null)? 0 :this.pageOffset.hashCode()));
        result = ((result* 31)+((this.orders == null)? 0 :this.orders.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.absoluteUrls == null)? 0 :this.absoluteUrls.hashCode()));
        result = ((result* 31)+((this.fields == null)? 0 :this.fields.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GistQuery) == false) {
            return false;
        }
        GistQuery rhs = ((GistQuery) other);
        return (((((((((((((((this.inverse == rhs.inverse)||((this.inverse!= null)&&this.inverse.equals(rhs.inverse)))&&((this.auto == rhs.auto)||((this.auto!= null)&&this.auto.equals(rhs.auto))))&&((this.references == rhs.references)||((this.references!= null)&&this.references.equals(rhs.references))))&&((this.pageSize == rhs.pageSize)||((this.pageSize!= null)&&this.pageSize.equals(rhs.pageSize))))&&((this.anyFilter == rhs.anyFilter)||((this.anyFilter!= null)&&this.anyFilter.equals(rhs.anyFilter))))&&((this.filters == rhs.filters)||((this.filters!= null)&&this.filters.equals(rhs.filters))))&&((this.translate == rhs.translate)||((this.translate!= null)&&this.translate.equals(rhs.translate))))&&((this.headless == rhs.headless)||((this.headless!= null)&&this.headless.equals(rhs.headless))))&&((this.total == rhs.total)||((this.total!= null)&&this.total.equals(rhs.total))))&&((this.pageOffset == rhs.pageOffset)||((this.pageOffset!= null)&&this.pageOffset.equals(rhs.pageOffset))))&&((this.orders == rhs.orders)||((this.orders!= null)&&this.orders.equals(rhs.orders))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.absoluteUrls == rhs.absoluteUrls)||((this.absoluteUrls!= null)&&this.absoluteUrls.equals(rhs.absoluteUrls))))&&((this.fields == rhs.fields)||((this.fields!= null)&&this.fields.equals(rhs.fields))));
    }

}
