
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attribute",
    "dateFilter",
    "eq",
    "ew",
    "ge",
    "gt",
    "in",
    "le",
    "like",
    "lt",
    "sw"
})
@Generated("jsonschema2pojo")
public class AttributeValueFilter implements Serializable
{

    @JsonProperty("attribute")
    private String attribute;
    @JsonProperty("dateFilter")
    private DateFilterPeriod dateFilter;
    @JsonProperty("eq")
    private String eq;
    @JsonProperty("ew")
    private String ew;
    @JsonProperty("ge")
    private String ge;
    @JsonProperty("gt")
    private String gt;
    @JsonProperty("in")
    private List<String> in;
    @JsonProperty("le")
    private String le;
    @JsonProperty("like")
    private String like;
    @JsonProperty("lt")
    private String lt;
    @JsonProperty("sw")
    private String sw;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2472637530736814439L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AttributeValueFilter() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public AttributeValueFilter(AttributeValueFilter source) {
        super();
        this.attribute = source.attribute;
        this.dateFilter = source.dateFilter;
        this.eq = source.eq;
        this.ew = source.ew;
        this.ge = source.ge;
        this.gt = source.gt;
        this.in = source.in;
        this.le = source.le;
        this.like = source.like;
        this.lt = source.lt;
        this.sw = source.sw;
    }

    public AttributeValueFilter(String attribute, DateFilterPeriod dateFilter, String eq, String ew, String ge, String gt, List<String> in, String le, String like, String lt, String sw) {
        super();
        this.attribute = attribute;
        this.dateFilter = dateFilter;
        this.eq = eq;
        this.ew = ew;
        this.ge = ge;
        this.gt = gt;
        this.in = in;
        this.le = le;
        this.like = like;
        this.lt = lt;
        this.sw = sw;
    }

    @JsonProperty("attribute")
    public Optional<String> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public AttributeValueFilter withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty("dateFilter")
    public Optional<DateFilterPeriod> getDateFilter() {
        return Optional.ofNullable(dateFilter);
    }

    @JsonProperty("dateFilter")
    public void setDateFilter(DateFilterPeriod dateFilter) {
        this.dateFilter = dateFilter;
    }

    public AttributeValueFilter withDateFilter(DateFilterPeriod dateFilter) {
        this.dateFilter = dateFilter;
        return this;
    }

    @JsonProperty("eq")
    public Optional<String> getEq() {
        return Optional.ofNullable(eq);
    }

    @JsonProperty("eq")
    public void setEq(String eq) {
        this.eq = eq;
    }

    public AttributeValueFilter withEq(String eq) {
        this.eq = eq;
        return this;
    }

    @JsonProperty("ew")
    public Optional<String> getEw() {
        return Optional.ofNullable(ew);
    }

    @JsonProperty("ew")
    public void setEw(String ew) {
        this.ew = ew;
    }

    public AttributeValueFilter withEw(String ew) {
        this.ew = ew;
        return this;
    }

    @JsonProperty("ge")
    public Optional<String> getGe() {
        return Optional.ofNullable(ge);
    }

    @JsonProperty("ge")
    public void setGe(String ge) {
        this.ge = ge;
    }

    public AttributeValueFilter withGe(String ge) {
        this.ge = ge;
        return this;
    }

    @JsonProperty("gt")
    public Optional<String> getGt() {
        return Optional.ofNullable(gt);
    }

    @JsonProperty("gt")
    public void setGt(String gt) {
        this.gt = gt;
    }

    public AttributeValueFilter withGt(String gt) {
        this.gt = gt;
        return this;
    }

    @JsonProperty("in")
    public Optional<List<String>> getIn() {
        return Optional.ofNullable(in);
    }

    @JsonProperty("in")
    public void setIn(List<String> in) {
        this.in = in;
    }

    public AttributeValueFilter withIn(List<String> in) {
        this.in = in;
        return this;
    }

    @JsonProperty("le")
    public Optional<String> getLe() {
        return Optional.ofNullable(le);
    }

    @JsonProperty("le")
    public void setLe(String le) {
        this.le = le;
    }

    public AttributeValueFilter withLe(String le) {
        this.le = le;
        return this;
    }

    @JsonProperty("like")
    public Optional<String> getLike() {
        return Optional.ofNullable(like);
    }

    @JsonProperty("like")
    public void setLike(String like) {
        this.like = like;
    }

    public AttributeValueFilter withLike(String like) {
        this.like = like;
        return this;
    }

    @JsonProperty("lt")
    public Optional<String> getLt() {
        return Optional.ofNullable(lt);
    }

    @JsonProperty("lt")
    public void setLt(String lt) {
        this.lt = lt;
    }

    public AttributeValueFilter withLt(String lt) {
        this.lt = lt;
        return this;
    }

    @JsonProperty("sw")
    public Optional<String> getSw() {
        return Optional.ofNullable(sw);
    }

    @JsonProperty("sw")
    public void setSw(String sw) {
        this.sw = sw;
    }

    public AttributeValueFilter withSw(String sw) {
        this.sw = sw;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AttributeValueFilter withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attribute".equals(name)) {
            if (value instanceof String) {
                setAttribute(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"attribute\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dateFilter".equals(name)) {
                if (value instanceof DateFilterPeriod) {
                    setDateFilter(((DateFilterPeriod) value));
                } else {
                    throw new IllegalArgumentException(("property \"dateFilter\" is of type \"org.hisp.dhis.api.model.v2_38_1.DateFilterPeriod\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("eq".equals(name)) {
                    if (value instanceof String) {
                        setEq(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"eq\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("ew".equals(name)) {
                        if (value instanceof String) {
                            setEw(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"ew\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("ge".equals(name)) {
                            if (value instanceof String) {
                                setGe(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"ge\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("gt".equals(name)) {
                                if (value instanceof String) {
                                    setGt(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"gt\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("in".equals(name)) {
                                    if (value instanceof List) {
                                        setIn(((List<String> ) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"in\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("le".equals(name)) {
                                        if (value instanceof String) {
                                            setLe(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"le\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("like".equals(name)) {
                                            if (value instanceof String) {
                                                setLike(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"like\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("lt".equals(name)) {
                                                if (value instanceof String) {
                                                    setLt(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"lt\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("sw".equals(name)) {
                                                    if (value instanceof String) {
                                                        setSw(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"sw\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    return false;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attribute".equals(name)) {
            return getAttribute();
        } else {
            if ("dateFilter".equals(name)) {
                return getDateFilter();
            } else {
                if ("eq".equals(name)) {
                    return getEq();
                } else {
                    if ("ew".equals(name)) {
                        return getEw();
                    } else {
                        if ("ge".equals(name)) {
                            return getGe();
                        } else {
                            if ("gt".equals(name)) {
                                return getGt();
                            } else {
                                if ("in".equals(name)) {
                                    return getIn();
                                } else {
                                    if ("le".equals(name)) {
                                        return getLe();
                                    } else {
                                        if ("like".equals(name)) {
                                            return getLike();
                                        } else {
                                            if ("lt".equals(name)) {
                                                return getLt();
                                            } else {
                                                if ("sw".equals(name)) {
                                                    return getSw();
                                                } else {
                                                    return notFoundValue;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AttributeValueFilter.NOT_FOUND_VALUE);
        if (AttributeValueFilter.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AttributeValueFilter with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AttributeValueFilter.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("dateFilter");
        sb.append('=');
        sb.append(((this.dateFilter == null)?"<null>":this.dateFilter));
        sb.append(',');
        sb.append("eq");
        sb.append('=');
        sb.append(((this.eq == null)?"<null>":this.eq));
        sb.append(',');
        sb.append("ew");
        sb.append('=');
        sb.append(((this.ew == null)?"<null>":this.ew));
        sb.append(',');
        sb.append("ge");
        sb.append('=');
        sb.append(((this.ge == null)?"<null>":this.ge));
        sb.append(',');
        sb.append("gt");
        sb.append('=');
        sb.append(((this.gt == null)?"<null>":this.gt));
        sb.append(',');
        sb.append("in");
        sb.append('=');
        sb.append(((this.in == null)?"<null>":this.in));
        sb.append(',');
        sb.append("le");
        sb.append('=');
        sb.append(((this.le == null)?"<null>":this.le));
        sb.append(',');
        sb.append("like");
        sb.append('=');
        sb.append(((this.like == null)?"<null>":this.like));
        sb.append(',');
        sb.append("lt");
        sb.append('=');
        sb.append(((this.lt == null)?"<null>":this.lt));
        sb.append(',');
        sb.append("sw");
        sb.append('=');
        sb.append(((this.sw == null)?"<null>":this.sw));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.sw == null)? 0 :this.sw.hashCode()));
        result = ((result* 31)+((this.in == null)? 0 :this.in.hashCode()));
        result = ((result* 31)+((this.like == null)? 0 :this.like.hashCode()));
        result = ((result* 31)+((this.lt == null)? 0 :this.lt.hashCode()));
        result = ((result* 31)+((this.eq == null)? 0 :this.eq.hashCode()));
        result = ((result* 31)+((this.gt == null)? 0 :this.gt.hashCode()));
        result = ((result* 31)+((this.dateFilter == null)? 0 :this.dateFilter.hashCode()));
        result = ((result* 31)+((this.ew == null)? 0 :this.ew.hashCode()));
        result = ((result* 31)+((this.le == null)? 0 :this.le.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.ge == null)? 0 :this.ge.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AttributeValueFilter) == false) {
            return false;
        }
        AttributeValueFilter rhs = ((AttributeValueFilter) other);
        return (((((((((((((this.sw == rhs.sw)||((this.sw!= null)&&this.sw.equals(rhs.sw)))&&((this.in == rhs.in)||((this.in!= null)&&this.in.equals(rhs.in))))&&((this.like == rhs.like)||((this.like!= null)&&this.like.equals(rhs.like))))&&((this.lt == rhs.lt)||((this.lt!= null)&&this.lt.equals(rhs.lt))))&&((this.eq == rhs.eq)||((this.eq!= null)&&this.eq.equals(rhs.eq))))&&((this.gt == rhs.gt)||((this.gt!= null)&&this.gt.equals(rhs.gt))))&&((this.dateFilter == rhs.dateFilter)||((this.dateFilter!= null)&&this.dateFilter.equals(rhs.dateFilter))))&&((this.ew == rhs.ew)||((this.ew!= null)&&this.ew.equals(rhs.ew))))&&((this.le == rhs.le)||((this.le!= null)&&this.le.equals(rhs.le))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.ge == rhs.ge)||((this.ge!= null)&&this.ge.equals(rhs.ge))));
    }

}
