
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "categoryCombos",
    "code",
    "created",
    "createdBy",
    "dataElements",
    "dataSet",
    "description",
    "disableDataElementAutoGroup",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "greyedFields",
    "href",
    "id",
    "indicators",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "publicAccess",
    "sharing",
    "showColumnTotals",
    "showRowTotals",
    "sortOrder",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class Section implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("categoryCombos")
    private List<CategoryCombo> categoryCombos;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("dataElements")
    private List<DataElement> dataElements;
    @JsonProperty("dataSet")
    private DataSet dataSet;
    @JsonProperty("description")
    private String description;
    @JsonProperty("disableDataElementAutoGroup")
    private Boolean disableDataElementAutoGroup;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("greyedFields")
    private List<DataElementOperand> greyedFields;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("indicators")
    private List<Indicator> indicators;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("showColumnTotals")
    private Boolean showColumnTotals;
    @JsonProperty("showRowTotals")
    private Boolean showRowTotals;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6660221931252643767L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Section() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Section(Section source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.categoryCombos = source.categoryCombos;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataElements = source.dataElements;
        this.dataSet = source.dataSet;
        this.description = source.description;
        this.disableDataElementAutoGroup = source.disableDataElementAutoGroup;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.greyedFields = source.greyedFields;
        this.href = source.href;
        this.id = source.id;
        this.indicators = source.indicators;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.sharing = source.sharing;
        this.showColumnTotals = source.showColumnTotals;
        this.showRowTotals = source.showRowTotals;
        this.sortOrder = source.sortOrder;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public Section(Access access, List<AttributeValue> attributeValues, List<CategoryCombo> categoryCombos, String code, Date created, User createdBy, List<DataElement> dataElements, DataSet dataSet, String description, Boolean disableDataElementAutoGroup, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, List<DataElementOperand> greyedFields, String href, String id, List<Indicator> indicators, Date lastUpdated, User lastUpdatedBy, String name, String publicAccess, Sharing sharing, Boolean showColumnTotals, Boolean showRowTotals, Integer sortOrder, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.categoryCombos = categoryCombos;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.dataElements = dataElements;
        this.dataSet = dataSet;
        this.description = description;
        this.disableDataElementAutoGroup = disableDataElementAutoGroup;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.greyedFields = greyedFields;
        this.href = href;
        this.id = id;
        this.indicators = indicators;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.publicAccess = publicAccess;
        this.sharing = sharing;
        this.showColumnTotals = showColumnTotals;
        this.showRowTotals = showRowTotals;
        this.sortOrder = sortOrder;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Section withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Section withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("categoryCombos")
    public Optional<List<CategoryCombo>> getCategoryCombos() {
        return Optional.ofNullable(categoryCombos);
    }

    @JsonProperty("categoryCombos")
    public void setCategoryCombos(List<CategoryCombo> categoryCombos) {
        this.categoryCombos = categoryCombos;
    }

    public Section withCategoryCombos(List<CategoryCombo> categoryCombos) {
        this.categoryCombos = categoryCombos;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Section withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Section withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Section withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("dataElements")
    public Optional<List<DataElement>> getDataElements() {
        return Optional.ofNullable(dataElements);
    }

    @JsonProperty("dataElements")
    public void setDataElements(List<DataElement> dataElements) {
        this.dataElements = dataElements;
    }

    public Section withDataElements(List<DataElement> dataElements) {
        this.dataElements = dataElements;
        return this;
    }

    @JsonProperty("dataSet")
    public Optional<DataSet> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public Section withDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Section withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("disableDataElementAutoGroup")
    public Optional<Boolean> getDisableDataElementAutoGroup() {
        return Optional.ofNullable(disableDataElementAutoGroup);
    }

    @JsonProperty("disableDataElementAutoGroup")
    public void setDisableDataElementAutoGroup(Boolean disableDataElementAutoGroup) {
        this.disableDataElementAutoGroup = disableDataElementAutoGroup;
    }

    public Section withDisableDataElementAutoGroup(Boolean disableDataElementAutoGroup) {
        this.disableDataElementAutoGroup = disableDataElementAutoGroup;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Section withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Section withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Section withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Section withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("greyedFields")
    public Optional<List<DataElementOperand>> getGreyedFields() {
        return Optional.ofNullable(greyedFields);
    }

    @JsonProperty("greyedFields")
    public void setGreyedFields(List<DataElementOperand> greyedFields) {
        this.greyedFields = greyedFields;
    }

    public Section withGreyedFields(List<DataElementOperand> greyedFields) {
        this.greyedFields = greyedFields;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Section withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Section withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("indicators")
    public Optional<List<Indicator>> getIndicators() {
        return Optional.ofNullable(indicators);
    }

    @JsonProperty("indicators")
    public void setIndicators(List<Indicator> indicators) {
        this.indicators = indicators;
    }

    public Section withIndicators(List<Indicator> indicators) {
        this.indicators = indicators;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Section withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Section withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Section withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Section withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Section withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("showColumnTotals")
    public Optional<Boolean> getShowColumnTotals() {
        return Optional.ofNullable(showColumnTotals);
    }

    @JsonProperty("showColumnTotals")
    public void setShowColumnTotals(Boolean showColumnTotals) {
        this.showColumnTotals = showColumnTotals;
    }

    public Section withShowColumnTotals(Boolean showColumnTotals) {
        this.showColumnTotals = showColumnTotals;
        return this;
    }

    @JsonProperty("showRowTotals")
    public Optional<Boolean> getShowRowTotals() {
        return Optional.ofNullable(showRowTotals);
    }

    @JsonProperty("showRowTotals")
    public void setShowRowTotals(Boolean showRowTotals) {
        this.showRowTotals = showRowTotals;
    }

    public Section withShowRowTotals(Boolean showRowTotals) {
        this.showRowTotals = showRowTotals;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Section withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Section withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public Section withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Section withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Section withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Section withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_37_7.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("categoryCombos".equals(name)) {
                    if (value instanceof List) {
                        setCategoryCombos(((List<CategoryCombo> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"categoryCombos\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.CategoryCombo>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("code".equals(name)) {
                        if (value instanceof String) {
                            setCode(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdBy".equals(name)) {
                                if (value instanceof User) {
                                    setCreatedBy(((User) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("dataElements".equals(name)) {
                                    if (value instanceof List) {
                                        setDataElements(((List<DataElement> ) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"dataElements\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.DataElement>\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("dataSet".equals(name)) {
                                        if (value instanceof DataSet) {
                                            setDataSet(((DataSet) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"dataSet\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataSet\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("description".equals(name)) {
                                            if (value instanceof String) {
                                                setDescription(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("disableDataElementAutoGroup".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setDisableDataElementAutoGroup(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"disableDataElementAutoGroup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("displayName".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDisplayName(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFavorite(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("greyedFields".equals(name)) {
                                                                    if (value instanceof List) {
                                                                        setGreyedFields(((List<DataElementOperand> ) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"greyedFields\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.DataElementOperand>\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("href".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setHref(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("id".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setId(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("indicators".equals(name)) {
                                                                                if (value instanceof List) {
                                                                                    setIndicators(((List<Indicator> ) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"indicators\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Indicator>\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("lastUpdated".equals(name)) {
                                                                                    if (value instanceof Date) {
                                                                                        setLastUpdated(((Date) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                        if (value instanceof User) {
                                                                                            setLastUpdatedBy(((User) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("name".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setName(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("publicAccess".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setPublicAccess(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("sharing".equals(name)) {
                                                                                                    if (value instanceof Sharing) {
                                                                                                        setSharing(((Sharing) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_37_7.Sharing\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("showColumnTotals".equals(name)) {
                                                                                                        if (value instanceof Boolean) {
                                                                                                            setShowColumnTotals(((Boolean) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"showColumnTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("showRowTotals".equals(name)) {
                                                                                                            if (value instanceof Boolean) {
                                                                                                                setShowRowTotals(((Boolean) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"showRowTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("sortOrder".equals(name)) {
                                                                                                                if (value instanceof Integer) {
                                                                                                                    setSortOrder(((Integer) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("translations".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setTranslations(((List<Translation> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("user".equals(name)) {
                                                                                                                        if (value instanceof User) {
                                                                                                                            setUser(((User) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_37_7.User\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setUserAccesses(((List<UserAccess> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                if (value instanceof List) {
                                                                                                                                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("categoryCombos".equals(name)) {
                    return getCategoryCombos();
                } else {
                    if ("code".equals(name)) {
                        return getCode();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("createdBy".equals(name)) {
                                return getCreatedBy();
                            } else {
                                if ("dataElements".equals(name)) {
                                    return getDataElements();
                                } else {
                                    if ("dataSet".equals(name)) {
                                        return getDataSet();
                                    } else {
                                        if ("description".equals(name)) {
                                            return getDescription();
                                        } else {
                                            if ("disableDataElementAutoGroup".equals(name)) {
                                                return getDisableDataElementAutoGroup();
                                            } else {
                                                if ("displayName".equals(name)) {
                                                    return getDisplayName();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            return getFavorite();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("greyedFields".equals(name)) {
                                                                    return getGreyedFields();
                                                                } else {
                                                                    if ("href".equals(name)) {
                                                                        return getHref();
                                                                    } else {
                                                                        if ("id".equals(name)) {
                                                                            return getId();
                                                                        } else {
                                                                            if ("indicators".equals(name)) {
                                                                                return getIndicators();
                                                                            } else {
                                                                                if ("lastUpdated".equals(name)) {
                                                                                    return getLastUpdated();
                                                                                } else {
                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                        return getLastUpdatedBy();
                                                                                    } else {
                                                                                        if ("name".equals(name)) {
                                                                                            return getName();
                                                                                        } else {
                                                                                            if ("publicAccess".equals(name)) {
                                                                                                return getPublicAccess();
                                                                                            } else {
                                                                                                if ("sharing".equals(name)) {
                                                                                                    return getSharing();
                                                                                                } else {
                                                                                                    if ("showColumnTotals".equals(name)) {
                                                                                                        return getShowColumnTotals();
                                                                                                    } else {
                                                                                                        if ("showRowTotals".equals(name)) {
                                                                                                            return getShowRowTotals();
                                                                                                        } else {
                                                                                                            if ("sortOrder".equals(name)) {
                                                                                                                return getSortOrder();
                                                                                                            } else {
                                                                                                                if ("translations".equals(name)) {
                                                                                                                    return getTranslations();
                                                                                                                } else {
                                                                                                                    if ("user".equals(name)) {
                                                                                                                        return getUser();
                                                                                                                    } else {
                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                            return getUserAccesses();
                                                                                                                        } else {
                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                return getUserGroupAccesses();
                                                                                                                            } else {
                                                                                                                                return notFoundValue;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Section.NOT_FOUND_VALUE);
        if (Section.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Section with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Section.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryCombos");
        sb.append('=');
        sb.append(((this.categoryCombos == null)?"<null>":this.categoryCombos));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataElements");
        sb.append('=');
        sb.append(((this.dataElements == null)?"<null>":this.dataElements));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("disableDataElementAutoGroup");
        sb.append('=');
        sb.append(((this.disableDataElementAutoGroup == null)?"<null>":this.disableDataElementAutoGroup));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("greyedFields");
        sb.append('=');
        sb.append(((this.greyedFields == null)?"<null>":this.greyedFields));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("indicators");
        sb.append('=');
        sb.append(((this.indicators == null)?"<null>":this.indicators));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("showColumnTotals");
        sb.append('=');
        sb.append(((this.showColumnTotals == null)?"<null>":this.showColumnTotals));
        sb.append(',');
        sb.append("showRowTotals");
        sb.append('=');
        sb.append(((this.showRowTotals == null)?"<null>":this.showRowTotals));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.greyedFields == null)? 0 :this.greyedFields.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.disableDataElementAutoGroup == null)? 0 :this.disableDataElementAutoGroup.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.categoryCombos == null)? 0 :this.categoryCombos.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.dataElements == null)? 0 :this.dataElements.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        result = ((result* 31)+((this.showColumnTotals == null)? 0 :this.showColumnTotals.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.indicators == null)? 0 :this.indicators.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.showRowTotals == null)? 0 :this.showRowTotals.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Section) == false) {
            return false;
        }
        Section rhs = ((Section) other);
        return ((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.greyedFields == rhs.greyedFields)||((this.greyedFields!= null)&&this.greyedFields.equals(rhs.greyedFields))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.disableDataElementAutoGroup == rhs.disableDataElementAutoGroup)||((this.disableDataElementAutoGroup!= null)&&this.disableDataElementAutoGroup.equals(rhs.disableDataElementAutoGroup))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.categoryCombos == rhs.categoryCombos)||((this.categoryCombos!= null)&&this.categoryCombos.equals(rhs.categoryCombos))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.dataElements == rhs.dataElements)||((this.dataElements!= null)&&this.dataElements.equals(rhs.dataElements))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))))&&((this.showColumnTotals == rhs.showColumnTotals)||((this.showColumnTotals!= null)&&this.showColumnTotals.equals(rhs.showColumnTotals))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.indicators == rhs.indicators)||((this.indicators!= null)&&this.indicators.equals(rhs.indicators))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.showRowTotals == rhs.showRowTotals)||((this.showRowTotals!= null)&&this.showRowTotals.equals(rhs.showRowTotals))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
