
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "created",
    "expiryDate",
    "key",
    "ownerObject",
    "ownerUid",
    "value"
})
@Generated("jsonschema2pojo")
public class ReservedValue implements Serializable
{

    @JsonProperty("created")
    private Date created;
    @JsonProperty("expiryDate")
    private Date expiryDate;
    @JsonProperty("key")
    private String key;
    @JsonProperty("ownerObject")
    private String ownerObject;
    @JsonProperty("ownerUid")
    private String ownerUid;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5877198378312589361L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ReservedValue() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ReservedValue(ReservedValue source) {
        super();
        this.created = source.created;
        this.expiryDate = source.expiryDate;
        this.key = source.key;
        this.ownerObject = source.ownerObject;
        this.ownerUid = source.ownerUid;
        this.value = source.value;
    }

    public ReservedValue(Date created, Date expiryDate, String key, String ownerObject, String ownerUid, String value) {
        super();
        this.created = created;
        this.expiryDate = expiryDate;
        this.key = key;
        this.ownerObject = ownerObject;
        this.ownerUid = ownerUid;
        this.value = value;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ReservedValue withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("expiryDate")
    public Optional<Date> getExpiryDate() {
        return Optional.ofNullable(expiryDate);
    }

    @JsonProperty("expiryDate")
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public ReservedValue withExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @JsonProperty("key")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    public ReservedValue withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty("ownerObject")
    public Optional<String> getOwnerObject() {
        return Optional.ofNullable(ownerObject);
    }

    @JsonProperty("ownerObject")
    public void setOwnerObject(String ownerObject) {
        this.ownerObject = ownerObject;
    }

    public ReservedValue withOwnerObject(String ownerObject) {
        this.ownerObject = ownerObject;
        return this;
    }

    @JsonProperty("ownerUid")
    public Optional<String> getOwnerUid() {
        return Optional.ofNullable(ownerUid);
    }

    @JsonProperty("ownerUid")
    public void setOwnerUid(String ownerUid) {
        this.ownerUid = ownerUid;
    }

    public ReservedValue withOwnerUid(String ownerUid) {
        this.ownerUid = ownerUid;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public ReservedValue withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ReservedValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("created".equals(name)) {
            if (value instanceof Date) {
                setCreated(((Date) value));
            } else {
                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("expiryDate".equals(name)) {
                if (value instanceof Date) {
                    setExpiryDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"expiryDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("key".equals(name)) {
                    if (value instanceof String) {
                        setKey(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"key\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("ownerObject".equals(name)) {
                        if (value instanceof String) {
                            setOwnerObject(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"ownerObject\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("ownerUid".equals(name)) {
                            if (value instanceof String) {
                                setOwnerUid(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"ownerUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("value".equals(name)) {
                                if (value instanceof String) {
                                    setValue(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("created".equals(name)) {
            return getCreated();
        } else {
            if ("expiryDate".equals(name)) {
                return getExpiryDate();
            } else {
                if ("key".equals(name)) {
                    return getKey();
                } else {
                    if ("ownerObject".equals(name)) {
                        return getOwnerObject();
                    } else {
                        if ("ownerUid".equals(name)) {
                            return getOwnerUid();
                        } else {
                            if ("value".equals(name)) {
                                return getValue();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ReservedValue.NOT_FOUND_VALUE);
        if (ReservedValue.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ReservedValue with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReservedValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("expiryDate");
        sb.append('=');
        sb.append(((this.expiryDate == null)?"<null>":this.expiryDate));
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("ownerObject");
        sb.append('=');
        sb.append(((this.ownerObject == null)?"<null>":this.ownerObject));
        sb.append(',');
        sb.append("ownerUid");
        sb.append('=');
        sb.append(((this.ownerUid == null)?"<null>":this.ownerUid));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.expiryDate == null)? 0 :this.expiryDate.hashCode()));
        result = ((result* 31)+((this.ownerObject == null)? 0 :this.ownerObject.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.ownerUid == null)? 0 :this.ownerUid.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ReservedValue) == false) {
            return false;
        }
        ReservedValue rhs = ((ReservedValue) other);
        return ((((((((this.expiryDate == rhs.expiryDate)||((this.expiryDate!= null)&&this.expiryDate.equals(rhs.expiryDate)))&&((this.ownerObject == rhs.ownerObject)||((this.ownerObject!= null)&&this.ownerObject.equals(rhs.ownerObject))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.ownerUid == rhs.ownerUid)||((this.ownerUid!= null)&&this.ownerUid.equals(rhs.ownerUid))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))));
    }

}
