
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "enrollment",
    "event",
    "trackedEntityInstance"
})
@Generated("jsonschema2pojo")
public class RelationshipItem implements Serializable
{

    @JsonProperty("enrollment")
    private Enrollment enrollment;
    @JsonProperty("event")
    private Event event;
    @JsonProperty("trackedEntityInstance")
    private TrackedEntityInstance trackedEntityInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5921881019480779623L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RelationshipItem() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public RelationshipItem(RelationshipItem source) {
        super();
        this.enrollment = source.enrollment;
        this.event = source.event;
        this.trackedEntityInstance = source.trackedEntityInstance;
    }

    public RelationshipItem(Enrollment enrollment, Event event, TrackedEntityInstance trackedEntityInstance) {
        super();
        this.enrollment = enrollment;
        this.event = event;
        this.trackedEntityInstance = trackedEntityInstance;
    }

    @JsonProperty("enrollment")
    public Optional<Enrollment> getEnrollment() {
        return Optional.ofNullable(enrollment);
    }

    @JsonProperty("enrollment")
    public void setEnrollment(Enrollment enrollment) {
        this.enrollment = enrollment;
    }

    public RelationshipItem withEnrollment(Enrollment enrollment) {
        this.enrollment = enrollment;
        return this;
    }

    @JsonProperty("event")
    public Optional<Event> getEvent() {
        return Optional.ofNullable(event);
    }

    @JsonProperty("event")
    public void setEvent(Event event) {
        this.event = event;
    }

    public RelationshipItem withEvent(Event event) {
        this.event = event;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<TrackedEntityInstance> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(TrackedEntityInstance trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public RelationshipItem withTrackedEntityInstance(TrackedEntityInstance trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public RelationshipItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("enrollment".equals(name)) {
            if (value instanceof Enrollment) {
                setEnrollment(((Enrollment) value));
            } else {
                throw new IllegalArgumentException(("property \"enrollment\" is of type \"org.hisp.dhis.api.model.v2_37_7.Enrollment\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("event".equals(name)) {
                if (value instanceof Event) {
                    setEvent(((Event) value));
                } else {
                    throw new IllegalArgumentException(("property \"event\" is of type \"org.hisp.dhis.api.model.v2_37_7.Event\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("trackedEntityInstance".equals(name)) {
                    if (value instanceof TrackedEntityInstance) {
                        setTrackedEntityInstance(((TrackedEntityInstance) value));
                    } else {
                        throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"org.hisp.dhis.api.model.v2_37_7.TrackedEntityInstance\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("enrollment".equals(name)) {
            return getEnrollment();
        } else {
            if ("event".equals(name)) {
                return getEvent();
            } else {
                if ("trackedEntityInstance".equals(name)) {
                    return getTrackedEntityInstance();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, RelationshipItem.NOT_FOUND_VALUE);
        if (RelationshipItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public RelationshipItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RelationshipItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enrollment");
        sb.append('=');
        sb.append(((this.enrollment == null)?"<null>":this.enrollment));
        sb.append(',');
        sb.append("event");
        sb.append('=');
        sb.append(((this.event == null)?"<null>":this.event));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.event == null)? 0 :this.event.hashCode()));
        result = ((result* 31)+((this.enrollment == null)? 0 :this.enrollment.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RelationshipItem) == false) {
            return false;
        }
        RelationshipItem rhs = ((RelationshipItem) other);
        return (((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.event == rhs.event)||((this.event!= null)&&this.event.equals(rhs.event))))&&((this.enrollment == rhs.enrollment)||((this.enrollment!= null)&&this.enrollment.equals(rhs.enrollment))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
