
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "createdBy",
    "endDate",
    "entityInstance",
    "organisationUnit",
    "program",
    "startDate"
})
@Generated("jsonschema2pojo")
public class ProgramOwnershipHistory implements Serializable
{

    @JsonProperty("createdBy")
    private String createdBy;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("entityInstance")
    private TrackedEntityInstance__1 entityInstance;
    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("program")
    private Program program;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4621896005120093571L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramOwnershipHistory() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramOwnershipHistory(ProgramOwnershipHistory source) {
        super();
        this.createdBy = source.createdBy;
        this.endDate = source.endDate;
        this.entityInstance = source.entityInstance;
        this.organisationUnit = source.organisationUnit;
        this.program = source.program;
        this.startDate = source.startDate;
    }

    public ProgramOwnershipHistory(String createdBy, Date endDate, TrackedEntityInstance__1 entityInstance, OrganisationUnit organisationUnit, Program program, Date startDate) {
        super();
        this.createdBy = createdBy;
        this.endDate = endDate;
        this.entityInstance = entityInstance;
        this.organisationUnit = organisationUnit;
        this.program = program;
        this.startDate = startDate;
    }

    @JsonProperty("createdBy")
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramOwnershipHistory withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public ProgramOwnershipHistory withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("entityInstance")
    public Optional<TrackedEntityInstance__1> getEntityInstance() {
        return Optional.ofNullable(entityInstance);
    }

    @JsonProperty("entityInstance")
    public void setEntityInstance(TrackedEntityInstance__1 entityInstance) {
        this.entityInstance = entityInstance;
    }

    public ProgramOwnershipHistory withEntityInstance(TrackedEntityInstance__1 entityInstance) {
        this.entityInstance = entityInstance;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public ProgramOwnershipHistory withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public ProgramOwnershipHistory withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public ProgramOwnershipHistory withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramOwnershipHistory withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("createdBy".equals(name)) {
            if (value instanceof String) {
                setCreatedBy(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"createdBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("endDate".equals(name)) {
                if (value instanceof Date) {
                    setEndDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("entityInstance".equals(name)) {
                    if (value instanceof TrackedEntityInstance__1) {
                        setEntityInstance(((TrackedEntityInstance__1) value));
                    } else {
                        throw new IllegalArgumentException(("property \"entityInstance\" is of type \"org.hisp.dhis.api.model.v2_37_7.TrackedEntityInstance__1\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("organisationUnit".equals(name)) {
                        if (value instanceof OrganisationUnit) {
                            setOrganisationUnit(((OrganisationUnit) value));
                        } else {
                            throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_37_7.OrganisationUnit\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("program".equals(name)) {
                            if (value instanceof Program) {
                                setProgram(((Program) value));
                            } else {
                                throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_37_7.Program\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("startDate".equals(name)) {
                                if (value instanceof Date) {
                                    setStartDate(((Date) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("createdBy".equals(name)) {
            return getCreatedBy();
        } else {
            if ("endDate".equals(name)) {
                return getEndDate();
            } else {
                if ("entityInstance".equals(name)) {
                    return getEntityInstance();
                } else {
                    if ("organisationUnit".equals(name)) {
                        return getOrganisationUnit();
                    } else {
                        if ("program".equals(name)) {
                            return getProgram();
                        } else {
                            if ("startDate".equals(name)) {
                                return getStartDate();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramOwnershipHistory.NOT_FOUND_VALUE);
        if (ProgramOwnershipHistory.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramOwnershipHistory with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramOwnershipHistory.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("entityInstance");
        sb.append('=');
        sb.append(((this.entityInstance == null)?"<null>":this.entityInstance));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.entityInstance == null)? 0 :this.entityInstance.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramOwnershipHistory) == false) {
            return false;
        }
        ProgramOwnershipHistory rhs = ((ProgramOwnershipHistory) other);
        return ((((((((this.entityInstance == rhs.entityInstance)||((this.entityInstance!= null)&&this.entityInstance.equals(rhs.entityInstance)))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }

}
