
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataElementsAssignedToDataSetsWithDifferentPeriodTypes",
    "dataElementsInDataSetNotInForm",
    "dataElementsViolatingExclusiveGroupSets",
    "dataElementsWithoutDataSet",
    "dataElementsWithoutGroups",
    "dataSetsNotAssignedToOrganisationUnits",
    "duplicatePeriods",
    "indicatorsViolatingExclusiveGroupSets",
    "indicatorsWithIdenticalFormulas",
    "indicatorsWithoutGroups",
    "invalidCategoryCombos",
    "invalidIndicatorDenominators",
    "invalidIndicatorNumerators",
    "invalidProgramIndicatorExpressions",
    "invalidProgramIndicatorFilters",
    "invalidValidationRuleLeftSideExpressions",
    "invalidValidationRuleRightSideExpressions",
    "organisationUnitGroupsWithoutGroupSets",
    "organisationUnitsViolatingExclusiveGroupSets",
    "organisationUnitsWithCyclicReferences",
    "organisationUnitsWithoutGroups",
    "orphanedOrganisationUnits",
    "programIndicatorsWithNoExpression",
    "programRuleActionsWithNoDataObject",
    "programRuleActionsWithNoNotification",
    "programRuleActionsWithNoSectionId",
    "programRuleActionsWithNoStageId",
    "programRuleVariablesWithNoAttribute",
    "programRuleVariablesWithNoDataElement",
    "programRulesWithNoAction",
    "programRulesWithNoCondition",
    "programRulesWithNoPriority",
    "validationRulesWithoutGroups"
})
@Generated("jsonschema2pojo")
public class FlattenedDataIntegrityReport implements Serializable
{

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsAssignedToDataSetsWithDifferentPeriodTypes")
    private DataElementsAssignedToDataSetsWithDifferentPeriodTypes dataElementsAssignedToDataSetsWithDifferentPeriodTypes;
    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsInDataSetNotInForm")
    private DataElementsInDataSetNotInForm dataElementsInDataSetNotInForm;
    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsViolatingExclusiveGroupSets")
    private DataElementsViolatingExclusiveGroupSets dataElementsViolatingExclusiveGroupSets;
    @JsonProperty("dataElementsWithoutDataSet")
    private List<String> dataElementsWithoutDataSet;
    @JsonProperty("dataElementsWithoutGroups")
    private List<String> dataElementsWithoutGroups;
    @JsonProperty("dataSetsNotAssignedToOrganisationUnits")
    private List<String> dataSetsNotAssignedToOrganisationUnits;
    @JsonProperty("duplicatePeriods")
    private List<String> duplicatePeriods;
    /**
     * Undefined
     * 
     */
    @JsonProperty("indicatorsViolatingExclusiveGroupSets")
    private IndicatorsViolatingExclusiveGroupSets indicatorsViolatingExclusiveGroupSets;
    @JsonProperty("indicatorsWithIdenticalFormulas")
    private List<List<String>> indicatorsWithIdenticalFormulas;
    @JsonProperty("indicatorsWithoutGroups")
    private List<String> indicatorsWithoutGroups;
    @JsonProperty("invalidCategoryCombos")
    private List<String> invalidCategoryCombos;
    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidIndicatorDenominators")
    private InvalidIndicatorDenominators invalidIndicatorDenominators;
    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidIndicatorNumerators")
    private InvalidIndicatorNumerators invalidIndicatorNumerators;
    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidProgramIndicatorExpressions")
    private InvalidProgramIndicatorExpressions invalidProgramIndicatorExpressions;
    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidProgramIndicatorFilters")
    private InvalidProgramIndicatorFilters invalidProgramIndicatorFilters;
    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidValidationRuleLeftSideExpressions")
    private InvalidValidationRuleLeftSideExpressions invalidValidationRuleLeftSideExpressions;
    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidValidationRuleRightSideExpressions")
    private InvalidValidationRuleRightSideExpressions invalidValidationRuleRightSideExpressions;
    @JsonProperty("organisationUnitGroupsWithoutGroupSets")
    private List<String> organisationUnitGroupsWithoutGroupSets;
    /**
     * Undefined
     * 
     */
    @JsonProperty("organisationUnitsViolatingExclusiveGroupSets")
    private OrganisationUnitsViolatingExclusiveGroupSets organisationUnitsViolatingExclusiveGroupSets;
    @JsonProperty("organisationUnitsWithCyclicReferences")
    private List<String> organisationUnitsWithCyclicReferences;
    @JsonProperty("organisationUnitsWithoutGroups")
    private List<String> organisationUnitsWithoutGroups;
    @JsonProperty("orphanedOrganisationUnits")
    private List<String> orphanedOrganisationUnits;
    @JsonProperty("programIndicatorsWithNoExpression")
    private List<String> programIndicatorsWithNoExpression;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoDataObject")
    private ProgramRuleActionsWithNoDataObject programRuleActionsWithNoDataObject;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoNotification")
    private ProgramRuleActionsWithNoNotification programRuleActionsWithNoNotification;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoSectionId")
    private ProgramRuleActionsWithNoSectionId programRuleActionsWithNoSectionId;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoStageId")
    private ProgramRuleActionsWithNoStageId programRuleActionsWithNoStageId;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleVariablesWithNoAttribute")
    private ProgramRuleVariablesWithNoAttribute programRuleVariablesWithNoAttribute;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleVariablesWithNoDataElement")
    private ProgramRuleVariablesWithNoDataElement programRuleVariablesWithNoDataElement;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoAction")
    private ProgramRulesWithNoAction programRulesWithNoAction;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoCondition")
    private ProgramRulesWithNoCondition programRulesWithNoCondition;
    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoPriority")
    private ProgramRulesWithNoPriority programRulesWithNoPriority;
    @JsonProperty("validationRulesWithoutGroups")
    private List<String> validationRulesWithoutGroups;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4622392211637066039L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FlattenedDataIntegrityReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FlattenedDataIntegrityReport(FlattenedDataIntegrityReport source) {
        super();
        this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes = source.dataElementsAssignedToDataSetsWithDifferentPeriodTypes;
        this.dataElementsInDataSetNotInForm = source.dataElementsInDataSetNotInForm;
        this.dataElementsViolatingExclusiveGroupSets = source.dataElementsViolatingExclusiveGroupSets;
        this.dataElementsWithoutDataSet = source.dataElementsWithoutDataSet;
        this.dataElementsWithoutGroups = source.dataElementsWithoutGroups;
        this.dataSetsNotAssignedToOrganisationUnits = source.dataSetsNotAssignedToOrganisationUnits;
        this.duplicatePeriods = source.duplicatePeriods;
        this.indicatorsViolatingExclusiveGroupSets = source.indicatorsViolatingExclusiveGroupSets;
        this.indicatorsWithIdenticalFormulas = source.indicatorsWithIdenticalFormulas;
        this.indicatorsWithoutGroups = source.indicatorsWithoutGroups;
        this.invalidCategoryCombos = source.invalidCategoryCombos;
        this.invalidIndicatorDenominators = source.invalidIndicatorDenominators;
        this.invalidIndicatorNumerators = source.invalidIndicatorNumerators;
        this.invalidProgramIndicatorExpressions = source.invalidProgramIndicatorExpressions;
        this.invalidProgramIndicatorFilters = source.invalidProgramIndicatorFilters;
        this.invalidValidationRuleLeftSideExpressions = source.invalidValidationRuleLeftSideExpressions;
        this.invalidValidationRuleRightSideExpressions = source.invalidValidationRuleRightSideExpressions;
        this.organisationUnitGroupsWithoutGroupSets = source.organisationUnitGroupsWithoutGroupSets;
        this.organisationUnitsViolatingExclusiveGroupSets = source.organisationUnitsViolatingExclusiveGroupSets;
        this.organisationUnitsWithCyclicReferences = source.organisationUnitsWithCyclicReferences;
        this.organisationUnitsWithoutGroups = source.organisationUnitsWithoutGroups;
        this.orphanedOrganisationUnits = source.orphanedOrganisationUnits;
        this.programIndicatorsWithNoExpression = source.programIndicatorsWithNoExpression;
        this.programRuleActionsWithNoDataObject = source.programRuleActionsWithNoDataObject;
        this.programRuleActionsWithNoNotification = source.programRuleActionsWithNoNotification;
        this.programRuleActionsWithNoSectionId = source.programRuleActionsWithNoSectionId;
        this.programRuleActionsWithNoStageId = source.programRuleActionsWithNoStageId;
        this.programRuleVariablesWithNoAttribute = source.programRuleVariablesWithNoAttribute;
        this.programRuleVariablesWithNoDataElement = source.programRuleVariablesWithNoDataElement;
        this.programRulesWithNoAction = source.programRulesWithNoAction;
        this.programRulesWithNoCondition = source.programRulesWithNoCondition;
        this.programRulesWithNoPriority = source.programRulesWithNoPriority;
        this.validationRulesWithoutGroups = source.validationRulesWithoutGroups;
    }

    public FlattenedDataIntegrityReport(DataElementsAssignedToDataSetsWithDifferentPeriodTypes dataElementsAssignedToDataSetsWithDifferentPeriodTypes, DataElementsInDataSetNotInForm dataElementsInDataSetNotInForm, DataElementsViolatingExclusiveGroupSets dataElementsViolatingExclusiveGroupSets, List<String> dataElementsWithoutDataSet, List<String> dataElementsWithoutGroups, List<String> dataSetsNotAssignedToOrganisationUnits, List<String> duplicatePeriods, IndicatorsViolatingExclusiveGroupSets indicatorsViolatingExclusiveGroupSets, List<List<String>> indicatorsWithIdenticalFormulas, List<String> indicatorsWithoutGroups, List<String> invalidCategoryCombos, InvalidIndicatorDenominators invalidIndicatorDenominators, InvalidIndicatorNumerators invalidIndicatorNumerators, InvalidProgramIndicatorExpressions invalidProgramIndicatorExpressions, InvalidProgramIndicatorFilters invalidProgramIndicatorFilters, InvalidValidationRuleLeftSideExpressions invalidValidationRuleLeftSideExpressions, InvalidValidationRuleRightSideExpressions invalidValidationRuleRightSideExpressions, List<String> organisationUnitGroupsWithoutGroupSets, OrganisationUnitsViolatingExclusiveGroupSets organisationUnitsViolatingExclusiveGroupSets, List<String> organisationUnitsWithCyclicReferences, List<String> organisationUnitsWithoutGroups, List<String> orphanedOrganisationUnits, List<String> programIndicatorsWithNoExpression, ProgramRuleActionsWithNoDataObject programRuleActionsWithNoDataObject, ProgramRuleActionsWithNoNotification programRuleActionsWithNoNotification, ProgramRuleActionsWithNoSectionId programRuleActionsWithNoSectionId, ProgramRuleActionsWithNoStageId programRuleActionsWithNoStageId, ProgramRuleVariablesWithNoAttribute programRuleVariablesWithNoAttribute, ProgramRuleVariablesWithNoDataElement programRuleVariablesWithNoDataElement, ProgramRulesWithNoAction programRulesWithNoAction, ProgramRulesWithNoCondition programRulesWithNoCondition, ProgramRulesWithNoPriority programRulesWithNoPriority, List<String> validationRulesWithoutGroups) {
        super();
        this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes = dataElementsAssignedToDataSetsWithDifferentPeriodTypes;
        this.dataElementsInDataSetNotInForm = dataElementsInDataSetNotInForm;
        this.dataElementsViolatingExclusiveGroupSets = dataElementsViolatingExclusiveGroupSets;
        this.dataElementsWithoutDataSet = dataElementsWithoutDataSet;
        this.dataElementsWithoutGroups = dataElementsWithoutGroups;
        this.dataSetsNotAssignedToOrganisationUnits = dataSetsNotAssignedToOrganisationUnits;
        this.duplicatePeriods = duplicatePeriods;
        this.indicatorsViolatingExclusiveGroupSets = indicatorsViolatingExclusiveGroupSets;
        this.indicatorsWithIdenticalFormulas = indicatorsWithIdenticalFormulas;
        this.indicatorsWithoutGroups = indicatorsWithoutGroups;
        this.invalidCategoryCombos = invalidCategoryCombos;
        this.invalidIndicatorDenominators = invalidIndicatorDenominators;
        this.invalidIndicatorNumerators = invalidIndicatorNumerators;
        this.invalidProgramIndicatorExpressions = invalidProgramIndicatorExpressions;
        this.invalidProgramIndicatorFilters = invalidProgramIndicatorFilters;
        this.invalidValidationRuleLeftSideExpressions = invalidValidationRuleLeftSideExpressions;
        this.invalidValidationRuleRightSideExpressions = invalidValidationRuleRightSideExpressions;
        this.organisationUnitGroupsWithoutGroupSets = organisationUnitGroupsWithoutGroupSets;
        this.organisationUnitsViolatingExclusiveGroupSets = organisationUnitsViolatingExclusiveGroupSets;
        this.organisationUnitsWithCyclicReferences = organisationUnitsWithCyclicReferences;
        this.organisationUnitsWithoutGroups = organisationUnitsWithoutGroups;
        this.orphanedOrganisationUnits = orphanedOrganisationUnits;
        this.programIndicatorsWithNoExpression = programIndicatorsWithNoExpression;
        this.programRuleActionsWithNoDataObject = programRuleActionsWithNoDataObject;
        this.programRuleActionsWithNoNotification = programRuleActionsWithNoNotification;
        this.programRuleActionsWithNoSectionId = programRuleActionsWithNoSectionId;
        this.programRuleActionsWithNoStageId = programRuleActionsWithNoStageId;
        this.programRuleVariablesWithNoAttribute = programRuleVariablesWithNoAttribute;
        this.programRuleVariablesWithNoDataElement = programRuleVariablesWithNoDataElement;
        this.programRulesWithNoAction = programRulesWithNoAction;
        this.programRulesWithNoCondition = programRulesWithNoCondition;
        this.programRulesWithNoPriority = programRulesWithNoPriority;
        this.validationRulesWithoutGroups = validationRulesWithoutGroups;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsAssignedToDataSetsWithDifferentPeriodTypes")
    public Optional<DataElementsAssignedToDataSetsWithDifferentPeriodTypes> getDataElementsAssignedToDataSetsWithDifferentPeriodTypes() {
        return Optional.ofNullable(dataElementsAssignedToDataSetsWithDifferentPeriodTypes);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsAssignedToDataSetsWithDifferentPeriodTypes")
    public void setDataElementsAssignedToDataSetsWithDifferentPeriodTypes(DataElementsAssignedToDataSetsWithDifferentPeriodTypes dataElementsAssignedToDataSetsWithDifferentPeriodTypes) {
        this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes = dataElementsAssignedToDataSetsWithDifferentPeriodTypes;
    }

    public FlattenedDataIntegrityReport withDataElementsAssignedToDataSetsWithDifferentPeriodTypes(DataElementsAssignedToDataSetsWithDifferentPeriodTypes dataElementsAssignedToDataSetsWithDifferentPeriodTypes) {
        this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes = dataElementsAssignedToDataSetsWithDifferentPeriodTypes;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsInDataSetNotInForm")
    public Optional<DataElementsInDataSetNotInForm> getDataElementsInDataSetNotInForm() {
        return Optional.ofNullable(dataElementsInDataSetNotInForm);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsInDataSetNotInForm")
    public void setDataElementsInDataSetNotInForm(DataElementsInDataSetNotInForm dataElementsInDataSetNotInForm) {
        this.dataElementsInDataSetNotInForm = dataElementsInDataSetNotInForm;
    }

    public FlattenedDataIntegrityReport withDataElementsInDataSetNotInForm(DataElementsInDataSetNotInForm dataElementsInDataSetNotInForm) {
        this.dataElementsInDataSetNotInForm = dataElementsInDataSetNotInForm;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsViolatingExclusiveGroupSets")
    public Optional<DataElementsViolatingExclusiveGroupSets> getDataElementsViolatingExclusiveGroupSets() {
        return Optional.ofNullable(dataElementsViolatingExclusiveGroupSets);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("dataElementsViolatingExclusiveGroupSets")
    public void setDataElementsViolatingExclusiveGroupSets(DataElementsViolatingExclusiveGroupSets dataElementsViolatingExclusiveGroupSets) {
        this.dataElementsViolatingExclusiveGroupSets = dataElementsViolatingExclusiveGroupSets;
    }

    public FlattenedDataIntegrityReport withDataElementsViolatingExclusiveGroupSets(DataElementsViolatingExclusiveGroupSets dataElementsViolatingExclusiveGroupSets) {
        this.dataElementsViolatingExclusiveGroupSets = dataElementsViolatingExclusiveGroupSets;
        return this;
    }

    @JsonProperty("dataElementsWithoutDataSet")
    public Optional<List<String>> getDataElementsWithoutDataSet() {
        return Optional.ofNullable(dataElementsWithoutDataSet);
    }

    @JsonProperty("dataElementsWithoutDataSet")
    public void setDataElementsWithoutDataSet(List<String> dataElementsWithoutDataSet) {
        this.dataElementsWithoutDataSet = dataElementsWithoutDataSet;
    }

    public FlattenedDataIntegrityReport withDataElementsWithoutDataSet(List<String> dataElementsWithoutDataSet) {
        this.dataElementsWithoutDataSet = dataElementsWithoutDataSet;
        return this;
    }

    @JsonProperty("dataElementsWithoutGroups")
    public Optional<List<String>> getDataElementsWithoutGroups() {
        return Optional.ofNullable(dataElementsWithoutGroups);
    }

    @JsonProperty("dataElementsWithoutGroups")
    public void setDataElementsWithoutGroups(List<String> dataElementsWithoutGroups) {
        this.dataElementsWithoutGroups = dataElementsWithoutGroups;
    }

    public FlattenedDataIntegrityReport withDataElementsWithoutGroups(List<String> dataElementsWithoutGroups) {
        this.dataElementsWithoutGroups = dataElementsWithoutGroups;
        return this;
    }

    @JsonProperty("dataSetsNotAssignedToOrganisationUnits")
    public Optional<List<String>> getDataSetsNotAssignedToOrganisationUnits() {
        return Optional.ofNullable(dataSetsNotAssignedToOrganisationUnits);
    }

    @JsonProperty("dataSetsNotAssignedToOrganisationUnits")
    public void setDataSetsNotAssignedToOrganisationUnits(List<String> dataSetsNotAssignedToOrganisationUnits) {
        this.dataSetsNotAssignedToOrganisationUnits = dataSetsNotAssignedToOrganisationUnits;
    }

    public FlattenedDataIntegrityReport withDataSetsNotAssignedToOrganisationUnits(List<String> dataSetsNotAssignedToOrganisationUnits) {
        this.dataSetsNotAssignedToOrganisationUnits = dataSetsNotAssignedToOrganisationUnits;
        return this;
    }

    @JsonProperty("duplicatePeriods")
    public Optional<List<String>> getDuplicatePeriods() {
        return Optional.ofNullable(duplicatePeriods);
    }

    @JsonProperty("duplicatePeriods")
    public void setDuplicatePeriods(List<String> duplicatePeriods) {
        this.duplicatePeriods = duplicatePeriods;
    }

    public FlattenedDataIntegrityReport withDuplicatePeriods(List<String> duplicatePeriods) {
        this.duplicatePeriods = duplicatePeriods;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("indicatorsViolatingExclusiveGroupSets")
    public Optional<IndicatorsViolatingExclusiveGroupSets> getIndicatorsViolatingExclusiveGroupSets() {
        return Optional.ofNullable(indicatorsViolatingExclusiveGroupSets);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("indicatorsViolatingExclusiveGroupSets")
    public void setIndicatorsViolatingExclusiveGroupSets(IndicatorsViolatingExclusiveGroupSets indicatorsViolatingExclusiveGroupSets) {
        this.indicatorsViolatingExclusiveGroupSets = indicatorsViolatingExclusiveGroupSets;
    }

    public FlattenedDataIntegrityReport withIndicatorsViolatingExclusiveGroupSets(IndicatorsViolatingExclusiveGroupSets indicatorsViolatingExclusiveGroupSets) {
        this.indicatorsViolatingExclusiveGroupSets = indicatorsViolatingExclusiveGroupSets;
        return this;
    }

    @JsonProperty("indicatorsWithIdenticalFormulas")
    public Optional<List<List<String>>> getIndicatorsWithIdenticalFormulas() {
        return Optional.ofNullable(indicatorsWithIdenticalFormulas);
    }

    @JsonProperty("indicatorsWithIdenticalFormulas")
    public void setIndicatorsWithIdenticalFormulas(List<List<String>> indicatorsWithIdenticalFormulas) {
        this.indicatorsWithIdenticalFormulas = indicatorsWithIdenticalFormulas;
    }

    public FlattenedDataIntegrityReport withIndicatorsWithIdenticalFormulas(List<List<String>> indicatorsWithIdenticalFormulas) {
        this.indicatorsWithIdenticalFormulas = indicatorsWithIdenticalFormulas;
        return this;
    }

    @JsonProperty("indicatorsWithoutGroups")
    public Optional<List<String>> getIndicatorsWithoutGroups() {
        return Optional.ofNullable(indicatorsWithoutGroups);
    }

    @JsonProperty("indicatorsWithoutGroups")
    public void setIndicatorsWithoutGroups(List<String> indicatorsWithoutGroups) {
        this.indicatorsWithoutGroups = indicatorsWithoutGroups;
    }

    public FlattenedDataIntegrityReport withIndicatorsWithoutGroups(List<String> indicatorsWithoutGroups) {
        this.indicatorsWithoutGroups = indicatorsWithoutGroups;
        return this;
    }

    @JsonProperty("invalidCategoryCombos")
    public Optional<List<String>> getInvalidCategoryCombos() {
        return Optional.ofNullable(invalidCategoryCombos);
    }

    @JsonProperty("invalidCategoryCombos")
    public void setInvalidCategoryCombos(List<String> invalidCategoryCombos) {
        this.invalidCategoryCombos = invalidCategoryCombos;
    }

    public FlattenedDataIntegrityReport withInvalidCategoryCombos(List<String> invalidCategoryCombos) {
        this.invalidCategoryCombos = invalidCategoryCombos;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidIndicatorDenominators")
    public Optional<InvalidIndicatorDenominators> getInvalidIndicatorDenominators() {
        return Optional.ofNullable(invalidIndicatorDenominators);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidIndicatorDenominators")
    public void setInvalidIndicatorDenominators(InvalidIndicatorDenominators invalidIndicatorDenominators) {
        this.invalidIndicatorDenominators = invalidIndicatorDenominators;
    }

    public FlattenedDataIntegrityReport withInvalidIndicatorDenominators(InvalidIndicatorDenominators invalidIndicatorDenominators) {
        this.invalidIndicatorDenominators = invalidIndicatorDenominators;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidIndicatorNumerators")
    public Optional<InvalidIndicatorNumerators> getInvalidIndicatorNumerators() {
        return Optional.ofNullable(invalidIndicatorNumerators);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidIndicatorNumerators")
    public void setInvalidIndicatorNumerators(InvalidIndicatorNumerators invalidIndicatorNumerators) {
        this.invalidIndicatorNumerators = invalidIndicatorNumerators;
    }

    public FlattenedDataIntegrityReport withInvalidIndicatorNumerators(InvalidIndicatorNumerators invalidIndicatorNumerators) {
        this.invalidIndicatorNumerators = invalidIndicatorNumerators;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidProgramIndicatorExpressions")
    public Optional<InvalidProgramIndicatorExpressions> getInvalidProgramIndicatorExpressions() {
        return Optional.ofNullable(invalidProgramIndicatorExpressions);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidProgramIndicatorExpressions")
    public void setInvalidProgramIndicatorExpressions(InvalidProgramIndicatorExpressions invalidProgramIndicatorExpressions) {
        this.invalidProgramIndicatorExpressions = invalidProgramIndicatorExpressions;
    }

    public FlattenedDataIntegrityReport withInvalidProgramIndicatorExpressions(InvalidProgramIndicatorExpressions invalidProgramIndicatorExpressions) {
        this.invalidProgramIndicatorExpressions = invalidProgramIndicatorExpressions;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidProgramIndicatorFilters")
    public Optional<InvalidProgramIndicatorFilters> getInvalidProgramIndicatorFilters() {
        return Optional.ofNullable(invalidProgramIndicatorFilters);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidProgramIndicatorFilters")
    public void setInvalidProgramIndicatorFilters(InvalidProgramIndicatorFilters invalidProgramIndicatorFilters) {
        this.invalidProgramIndicatorFilters = invalidProgramIndicatorFilters;
    }

    public FlattenedDataIntegrityReport withInvalidProgramIndicatorFilters(InvalidProgramIndicatorFilters invalidProgramIndicatorFilters) {
        this.invalidProgramIndicatorFilters = invalidProgramIndicatorFilters;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidValidationRuleLeftSideExpressions")
    public Optional<InvalidValidationRuleLeftSideExpressions> getInvalidValidationRuleLeftSideExpressions() {
        return Optional.ofNullable(invalidValidationRuleLeftSideExpressions);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidValidationRuleLeftSideExpressions")
    public void setInvalidValidationRuleLeftSideExpressions(InvalidValidationRuleLeftSideExpressions invalidValidationRuleLeftSideExpressions) {
        this.invalidValidationRuleLeftSideExpressions = invalidValidationRuleLeftSideExpressions;
    }

    public FlattenedDataIntegrityReport withInvalidValidationRuleLeftSideExpressions(InvalidValidationRuleLeftSideExpressions invalidValidationRuleLeftSideExpressions) {
        this.invalidValidationRuleLeftSideExpressions = invalidValidationRuleLeftSideExpressions;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidValidationRuleRightSideExpressions")
    public Optional<InvalidValidationRuleRightSideExpressions> getInvalidValidationRuleRightSideExpressions() {
        return Optional.ofNullable(invalidValidationRuleRightSideExpressions);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("invalidValidationRuleRightSideExpressions")
    public void setInvalidValidationRuleRightSideExpressions(InvalidValidationRuleRightSideExpressions invalidValidationRuleRightSideExpressions) {
        this.invalidValidationRuleRightSideExpressions = invalidValidationRuleRightSideExpressions;
    }

    public FlattenedDataIntegrityReport withInvalidValidationRuleRightSideExpressions(InvalidValidationRuleRightSideExpressions invalidValidationRuleRightSideExpressions) {
        this.invalidValidationRuleRightSideExpressions = invalidValidationRuleRightSideExpressions;
        return this;
    }

    @JsonProperty("organisationUnitGroupsWithoutGroupSets")
    public Optional<List<String>> getOrganisationUnitGroupsWithoutGroupSets() {
        return Optional.ofNullable(organisationUnitGroupsWithoutGroupSets);
    }

    @JsonProperty("organisationUnitGroupsWithoutGroupSets")
    public void setOrganisationUnitGroupsWithoutGroupSets(List<String> organisationUnitGroupsWithoutGroupSets) {
        this.organisationUnitGroupsWithoutGroupSets = organisationUnitGroupsWithoutGroupSets;
    }

    public FlattenedDataIntegrityReport withOrganisationUnitGroupsWithoutGroupSets(List<String> organisationUnitGroupsWithoutGroupSets) {
        this.organisationUnitGroupsWithoutGroupSets = organisationUnitGroupsWithoutGroupSets;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("organisationUnitsViolatingExclusiveGroupSets")
    public Optional<OrganisationUnitsViolatingExclusiveGroupSets> getOrganisationUnitsViolatingExclusiveGroupSets() {
        return Optional.ofNullable(organisationUnitsViolatingExclusiveGroupSets);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("organisationUnitsViolatingExclusiveGroupSets")
    public void setOrganisationUnitsViolatingExclusiveGroupSets(OrganisationUnitsViolatingExclusiveGroupSets organisationUnitsViolatingExclusiveGroupSets) {
        this.organisationUnitsViolatingExclusiveGroupSets = organisationUnitsViolatingExclusiveGroupSets;
    }

    public FlattenedDataIntegrityReport withOrganisationUnitsViolatingExclusiveGroupSets(OrganisationUnitsViolatingExclusiveGroupSets organisationUnitsViolatingExclusiveGroupSets) {
        this.organisationUnitsViolatingExclusiveGroupSets = organisationUnitsViolatingExclusiveGroupSets;
        return this;
    }

    @JsonProperty("organisationUnitsWithCyclicReferences")
    public Optional<List<String>> getOrganisationUnitsWithCyclicReferences() {
        return Optional.ofNullable(organisationUnitsWithCyclicReferences);
    }

    @JsonProperty("organisationUnitsWithCyclicReferences")
    public void setOrganisationUnitsWithCyclicReferences(List<String> organisationUnitsWithCyclicReferences) {
        this.organisationUnitsWithCyclicReferences = organisationUnitsWithCyclicReferences;
    }

    public FlattenedDataIntegrityReport withOrganisationUnitsWithCyclicReferences(List<String> organisationUnitsWithCyclicReferences) {
        this.organisationUnitsWithCyclicReferences = organisationUnitsWithCyclicReferences;
        return this;
    }

    @JsonProperty("organisationUnitsWithoutGroups")
    public Optional<List<String>> getOrganisationUnitsWithoutGroups() {
        return Optional.ofNullable(organisationUnitsWithoutGroups);
    }

    @JsonProperty("organisationUnitsWithoutGroups")
    public void setOrganisationUnitsWithoutGroups(List<String> organisationUnitsWithoutGroups) {
        this.organisationUnitsWithoutGroups = organisationUnitsWithoutGroups;
    }

    public FlattenedDataIntegrityReport withOrganisationUnitsWithoutGroups(List<String> organisationUnitsWithoutGroups) {
        this.organisationUnitsWithoutGroups = organisationUnitsWithoutGroups;
        return this;
    }

    @JsonProperty("orphanedOrganisationUnits")
    public Optional<List<String>> getOrphanedOrganisationUnits() {
        return Optional.ofNullable(orphanedOrganisationUnits);
    }

    @JsonProperty("orphanedOrganisationUnits")
    public void setOrphanedOrganisationUnits(List<String> orphanedOrganisationUnits) {
        this.orphanedOrganisationUnits = orphanedOrganisationUnits;
    }

    public FlattenedDataIntegrityReport withOrphanedOrganisationUnits(List<String> orphanedOrganisationUnits) {
        this.orphanedOrganisationUnits = orphanedOrganisationUnits;
        return this;
    }

    @JsonProperty("programIndicatorsWithNoExpression")
    public Optional<List<String>> getProgramIndicatorsWithNoExpression() {
        return Optional.ofNullable(programIndicatorsWithNoExpression);
    }

    @JsonProperty("programIndicatorsWithNoExpression")
    public void setProgramIndicatorsWithNoExpression(List<String> programIndicatorsWithNoExpression) {
        this.programIndicatorsWithNoExpression = programIndicatorsWithNoExpression;
    }

    public FlattenedDataIntegrityReport withProgramIndicatorsWithNoExpression(List<String> programIndicatorsWithNoExpression) {
        this.programIndicatorsWithNoExpression = programIndicatorsWithNoExpression;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoDataObject")
    public Optional<ProgramRuleActionsWithNoDataObject> getProgramRuleActionsWithNoDataObject() {
        return Optional.ofNullable(programRuleActionsWithNoDataObject);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoDataObject")
    public void setProgramRuleActionsWithNoDataObject(ProgramRuleActionsWithNoDataObject programRuleActionsWithNoDataObject) {
        this.programRuleActionsWithNoDataObject = programRuleActionsWithNoDataObject;
    }

    public FlattenedDataIntegrityReport withProgramRuleActionsWithNoDataObject(ProgramRuleActionsWithNoDataObject programRuleActionsWithNoDataObject) {
        this.programRuleActionsWithNoDataObject = programRuleActionsWithNoDataObject;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoNotification")
    public Optional<ProgramRuleActionsWithNoNotification> getProgramRuleActionsWithNoNotification() {
        return Optional.ofNullable(programRuleActionsWithNoNotification);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoNotification")
    public void setProgramRuleActionsWithNoNotification(ProgramRuleActionsWithNoNotification programRuleActionsWithNoNotification) {
        this.programRuleActionsWithNoNotification = programRuleActionsWithNoNotification;
    }

    public FlattenedDataIntegrityReport withProgramRuleActionsWithNoNotification(ProgramRuleActionsWithNoNotification programRuleActionsWithNoNotification) {
        this.programRuleActionsWithNoNotification = programRuleActionsWithNoNotification;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoSectionId")
    public Optional<ProgramRuleActionsWithNoSectionId> getProgramRuleActionsWithNoSectionId() {
        return Optional.ofNullable(programRuleActionsWithNoSectionId);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoSectionId")
    public void setProgramRuleActionsWithNoSectionId(ProgramRuleActionsWithNoSectionId programRuleActionsWithNoSectionId) {
        this.programRuleActionsWithNoSectionId = programRuleActionsWithNoSectionId;
    }

    public FlattenedDataIntegrityReport withProgramRuleActionsWithNoSectionId(ProgramRuleActionsWithNoSectionId programRuleActionsWithNoSectionId) {
        this.programRuleActionsWithNoSectionId = programRuleActionsWithNoSectionId;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoStageId")
    public Optional<ProgramRuleActionsWithNoStageId> getProgramRuleActionsWithNoStageId() {
        return Optional.ofNullable(programRuleActionsWithNoStageId);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleActionsWithNoStageId")
    public void setProgramRuleActionsWithNoStageId(ProgramRuleActionsWithNoStageId programRuleActionsWithNoStageId) {
        this.programRuleActionsWithNoStageId = programRuleActionsWithNoStageId;
    }

    public FlattenedDataIntegrityReport withProgramRuleActionsWithNoStageId(ProgramRuleActionsWithNoStageId programRuleActionsWithNoStageId) {
        this.programRuleActionsWithNoStageId = programRuleActionsWithNoStageId;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleVariablesWithNoAttribute")
    public Optional<ProgramRuleVariablesWithNoAttribute> getProgramRuleVariablesWithNoAttribute() {
        return Optional.ofNullable(programRuleVariablesWithNoAttribute);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleVariablesWithNoAttribute")
    public void setProgramRuleVariablesWithNoAttribute(ProgramRuleVariablesWithNoAttribute programRuleVariablesWithNoAttribute) {
        this.programRuleVariablesWithNoAttribute = programRuleVariablesWithNoAttribute;
    }

    public FlattenedDataIntegrityReport withProgramRuleVariablesWithNoAttribute(ProgramRuleVariablesWithNoAttribute programRuleVariablesWithNoAttribute) {
        this.programRuleVariablesWithNoAttribute = programRuleVariablesWithNoAttribute;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleVariablesWithNoDataElement")
    public Optional<ProgramRuleVariablesWithNoDataElement> getProgramRuleVariablesWithNoDataElement() {
        return Optional.ofNullable(programRuleVariablesWithNoDataElement);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRuleVariablesWithNoDataElement")
    public void setProgramRuleVariablesWithNoDataElement(ProgramRuleVariablesWithNoDataElement programRuleVariablesWithNoDataElement) {
        this.programRuleVariablesWithNoDataElement = programRuleVariablesWithNoDataElement;
    }

    public FlattenedDataIntegrityReport withProgramRuleVariablesWithNoDataElement(ProgramRuleVariablesWithNoDataElement programRuleVariablesWithNoDataElement) {
        this.programRuleVariablesWithNoDataElement = programRuleVariablesWithNoDataElement;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoAction")
    public Optional<ProgramRulesWithNoAction> getProgramRulesWithNoAction() {
        return Optional.ofNullable(programRulesWithNoAction);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoAction")
    public void setProgramRulesWithNoAction(ProgramRulesWithNoAction programRulesWithNoAction) {
        this.programRulesWithNoAction = programRulesWithNoAction;
    }

    public FlattenedDataIntegrityReport withProgramRulesWithNoAction(ProgramRulesWithNoAction programRulesWithNoAction) {
        this.programRulesWithNoAction = programRulesWithNoAction;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoCondition")
    public Optional<ProgramRulesWithNoCondition> getProgramRulesWithNoCondition() {
        return Optional.ofNullable(programRulesWithNoCondition);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoCondition")
    public void setProgramRulesWithNoCondition(ProgramRulesWithNoCondition programRulesWithNoCondition) {
        this.programRulesWithNoCondition = programRulesWithNoCondition;
    }

    public FlattenedDataIntegrityReport withProgramRulesWithNoCondition(ProgramRulesWithNoCondition programRulesWithNoCondition) {
        this.programRulesWithNoCondition = programRulesWithNoCondition;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoPriority")
    public Optional<ProgramRulesWithNoPriority> getProgramRulesWithNoPriority() {
        return Optional.ofNullable(programRulesWithNoPriority);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("programRulesWithNoPriority")
    public void setProgramRulesWithNoPriority(ProgramRulesWithNoPriority programRulesWithNoPriority) {
        this.programRulesWithNoPriority = programRulesWithNoPriority;
    }

    public FlattenedDataIntegrityReport withProgramRulesWithNoPriority(ProgramRulesWithNoPriority programRulesWithNoPriority) {
        this.programRulesWithNoPriority = programRulesWithNoPriority;
        return this;
    }

    @JsonProperty("validationRulesWithoutGroups")
    public Optional<List<String>> getValidationRulesWithoutGroups() {
        return Optional.ofNullable(validationRulesWithoutGroups);
    }

    @JsonProperty("validationRulesWithoutGroups")
    public void setValidationRulesWithoutGroups(List<String> validationRulesWithoutGroups) {
        this.validationRulesWithoutGroups = validationRulesWithoutGroups;
    }

    public FlattenedDataIntegrityReport withValidationRulesWithoutGroups(List<String> validationRulesWithoutGroups) {
        this.validationRulesWithoutGroups = validationRulesWithoutGroups;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FlattenedDataIntegrityReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataElementsAssignedToDataSetsWithDifferentPeriodTypes".equals(name)) {
            if (value instanceof DataElementsAssignedToDataSetsWithDifferentPeriodTypes) {
                setDataElementsAssignedToDataSetsWithDifferentPeriodTypes(((DataElementsAssignedToDataSetsWithDifferentPeriodTypes) value));
            } else {
                throw new IllegalArgumentException(("property \"dataElementsAssignedToDataSetsWithDifferentPeriodTypes\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataElementsAssignedToDataSetsWithDifferentPeriodTypes\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataElementsInDataSetNotInForm".equals(name)) {
                if (value instanceof DataElementsInDataSetNotInForm) {
                    setDataElementsInDataSetNotInForm(((DataElementsInDataSetNotInForm) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementsInDataSetNotInForm\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataElementsInDataSetNotInForm\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataElementsViolatingExclusiveGroupSets".equals(name)) {
                    if (value instanceof DataElementsViolatingExclusiveGroupSets) {
                        setDataElementsViolatingExclusiveGroupSets(((DataElementsViolatingExclusiveGroupSets) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataElementsViolatingExclusiveGroupSets\" is of type \"org.hisp.dhis.api.model.v2_37_7.DataElementsViolatingExclusiveGroupSets\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("dataElementsWithoutDataSet".equals(name)) {
                        if (value instanceof List) {
                            setDataElementsWithoutDataSet(((List<String> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"dataElementsWithoutDataSet\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("dataElementsWithoutGroups".equals(name)) {
                            if (value instanceof List) {
                                setDataElementsWithoutGroups(((List<String> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"dataElementsWithoutGroups\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("dataSetsNotAssignedToOrganisationUnits".equals(name)) {
                                if (value instanceof List) {
                                    setDataSetsNotAssignedToOrganisationUnits(((List<String> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"dataSetsNotAssignedToOrganisationUnits\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("duplicatePeriods".equals(name)) {
                                    if (value instanceof List) {
                                        setDuplicatePeriods(((List<String> ) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"duplicatePeriods\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("indicatorsViolatingExclusiveGroupSets".equals(name)) {
                                        if (value instanceof IndicatorsViolatingExclusiveGroupSets) {
                                            setIndicatorsViolatingExclusiveGroupSets(((IndicatorsViolatingExclusiveGroupSets) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"indicatorsViolatingExclusiveGroupSets\" is of type \"org.hisp.dhis.api.model.v2_37_7.IndicatorsViolatingExclusiveGroupSets\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("indicatorsWithIdenticalFormulas".equals(name)) {
                                            if (value instanceof List) {
                                                setIndicatorsWithIdenticalFormulas(((List<List<String>> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"indicatorsWithIdenticalFormulas\" is of type \"java.util.List<java.util.List<java.lang.String>>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("indicatorsWithoutGroups".equals(name)) {
                                                if (value instanceof List) {
                                                    setIndicatorsWithoutGroups(((List<String> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"indicatorsWithoutGroups\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("invalidCategoryCombos".equals(name)) {
                                                    if (value instanceof List) {
                                                        setInvalidCategoryCombos(((List<String> ) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"invalidCategoryCombos\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("invalidIndicatorDenominators".equals(name)) {
                                                        if (value instanceof InvalidIndicatorDenominators) {
                                                            setInvalidIndicatorDenominators(((InvalidIndicatorDenominators) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"invalidIndicatorDenominators\" is of type \"org.hisp.dhis.api.model.v2_37_7.InvalidIndicatorDenominators\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("invalidIndicatorNumerators".equals(name)) {
                                                            if (value instanceof InvalidIndicatorNumerators) {
                                                                setInvalidIndicatorNumerators(((InvalidIndicatorNumerators) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"invalidIndicatorNumerators\" is of type \"org.hisp.dhis.api.model.v2_37_7.InvalidIndicatorNumerators\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("invalidProgramIndicatorExpressions".equals(name)) {
                                                                if (value instanceof InvalidProgramIndicatorExpressions) {
                                                                    setInvalidProgramIndicatorExpressions(((InvalidProgramIndicatorExpressions) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"invalidProgramIndicatorExpressions\" is of type \"org.hisp.dhis.api.model.v2_37_7.InvalidProgramIndicatorExpressions\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("invalidProgramIndicatorFilters".equals(name)) {
                                                                    if (value instanceof InvalidProgramIndicatorFilters) {
                                                                        setInvalidProgramIndicatorFilters(((InvalidProgramIndicatorFilters) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"invalidProgramIndicatorFilters\" is of type \"org.hisp.dhis.api.model.v2_37_7.InvalidProgramIndicatorFilters\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("invalidValidationRuleLeftSideExpressions".equals(name)) {
                                                                        if (value instanceof InvalidValidationRuleLeftSideExpressions) {
                                                                            setInvalidValidationRuleLeftSideExpressions(((InvalidValidationRuleLeftSideExpressions) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"invalidValidationRuleLeftSideExpressions\" is of type \"org.hisp.dhis.api.model.v2_37_7.InvalidValidationRuleLeftSideExpressions\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("invalidValidationRuleRightSideExpressions".equals(name)) {
                                                                            if (value instanceof InvalidValidationRuleRightSideExpressions) {
                                                                                setInvalidValidationRuleRightSideExpressions(((InvalidValidationRuleRightSideExpressions) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"invalidValidationRuleRightSideExpressions\" is of type \"org.hisp.dhis.api.model.v2_37_7.InvalidValidationRuleRightSideExpressions\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("organisationUnitGroupsWithoutGroupSets".equals(name)) {
                                                                                if (value instanceof List) {
                                                                                    setOrganisationUnitGroupsWithoutGroupSets(((List<String> ) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"organisationUnitGroupsWithoutGroupSets\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("organisationUnitsViolatingExclusiveGroupSets".equals(name)) {
                                                                                    if (value instanceof OrganisationUnitsViolatingExclusiveGroupSets) {
                                                                                        setOrganisationUnitsViolatingExclusiveGroupSets(((OrganisationUnitsViolatingExclusiveGroupSets) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"organisationUnitsViolatingExclusiveGroupSets\" is of type \"org.hisp.dhis.api.model.v2_37_7.OrganisationUnitsViolatingExclusiveGroupSets\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("organisationUnitsWithCyclicReferences".equals(name)) {
                                                                                        if (value instanceof List) {
                                                                                            setOrganisationUnitsWithCyclicReferences(((List<String> ) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"organisationUnitsWithCyclicReferences\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("organisationUnitsWithoutGroups".equals(name)) {
                                                                                            if (value instanceof List) {
                                                                                                setOrganisationUnitsWithoutGroups(((List<String> ) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"organisationUnitsWithoutGroups\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("orphanedOrganisationUnits".equals(name)) {
                                                                                                if (value instanceof List) {
                                                                                                    setOrphanedOrganisationUnits(((List<String> ) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"orphanedOrganisationUnits\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("programIndicatorsWithNoExpression".equals(name)) {
                                                                                                    if (value instanceof List) {
                                                                                                        setProgramIndicatorsWithNoExpression(((List<String> ) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"programIndicatorsWithNoExpression\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("programRuleActionsWithNoDataObject".equals(name)) {
                                                                                                        if (value instanceof ProgramRuleActionsWithNoDataObject) {
                                                                                                            setProgramRuleActionsWithNoDataObject(((ProgramRuleActionsWithNoDataObject) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"programRuleActionsWithNoDataObject\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRuleActionsWithNoDataObject\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("programRuleActionsWithNoNotification".equals(name)) {
                                                                                                            if (value instanceof ProgramRuleActionsWithNoNotification) {
                                                                                                                setProgramRuleActionsWithNoNotification(((ProgramRuleActionsWithNoNotification) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"programRuleActionsWithNoNotification\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRuleActionsWithNoNotification\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("programRuleActionsWithNoSectionId".equals(name)) {
                                                                                                                if (value instanceof ProgramRuleActionsWithNoSectionId) {
                                                                                                                    setProgramRuleActionsWithNoSectionId(((ProgramRuleActionsWithNoSectionId) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"programRuleActionsWithNoSectionId\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRuleActionsWithNoSectionId\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("programRuleActionsWithNoStageId".equals(name)) {
                                                                                                                    if (value instanceof ProgramRuleActionsWithNoStageId) {
                                                                                                                        setProgramRuleActionsWithNoStageId(((ProgramRuleActionsWithNoStageId) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"programRuleActionsWithNoStageId\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRuleActionsWithNoStageId\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("programRuleVariablesWithNoAttribute".equals(name)) {
                                                                                                                        if (value instanceof ProgramRuleVariablesWithNoAttribute) {
                                                                                                                            setProgramRuleVariablesWithNoAttribute(((ProgramRuleVariablesWithNoAttribute) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"programRuleVariablesWithNoAttribute\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRuleVariablesWithNoAttribute\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("programRuleVariablesWithNoDataElement".equals(name)) {
                                                                                                                            if (value instanceof ProgramRuleVariablesWithNoDataElement) {
                                                                                                                                setProgramRuleVariablesWithNoDataElement(((ProgramRuleVariablesWithNoDataElement) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"programRuleVariablesWithNoDataElement\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRuleVariablesWithNoDataElement\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("programRulesWithNoAction".equals(name)) {
                                                                                                                                if (value instanceof ProgramRulesWithNoAction) {
                                                                                                                                    setProgramRulesWithNoAction(((ProgramRulesWithNoAction) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"programRulesWithNoAction\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRulesWithNoAction\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("programRulesWithNoCondition".equals(name)) {
                                                                                                                                    if (value instanceof ProgramRulesWithNoCondition) {
                                                                                                                                        setProgramRulesWithNoCondition(((ProgramRulesWithNoCondition) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"programRulesWithNoCondition\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRulesWithNoCondition\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("programRulesWithNoPriority".equals(name)) {
                                                                                                                                        if (value instanceof ProgramRulesWithNoPriority) {
                                                                                                                                            setProgramRulesWithNoPriority(((ProgramRulesWithNoPriority) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"programRulesWithNoPriority\" is of type \"org.hisp.dhis.api.model.v2_37_7.ProgramRulesWithNoPriority\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("validationRulesWithoutGroups".equals(name)) {
                                                                                                                                            if (value instanceof List) {
                                                                                                                                                setValidationRulesWithoutGroups(((List<String> ) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"validationRulesWithoutGroups\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataElementsAssignedToDataSetsWithDifferentPeriodTypes".equals(name)) {
            return getDataElementsAssignedToDataSetsWithDifferentPeriodTypes();
        } else {
            if ("dataElementsInDataSetNotInForm".equals(name)) {
                return getDataElementsInDataSetNotInForm();
            } else {
                if ("dataElementsViolatingExclusiveGroupSets".equals(name)) {
                    return getDataElementsViolatingExclusiveGroupSets();
                } else {
                    if ("dataElementsWithoutDataSet".equals(name)) {
                        return getDataElementsWithoutDataSet();
                    } else {
                        if ("dataElementsWithoutGroups".equals(name)) {
                            return getDataElementsWithoutGroups();
                        } else {
                            if ("dataSetsNotAssignedToOrganisationUnits".equals(name)) {
                                return getDataSetsNotAssignedToOrganisationUnits();
                            } else {
                                if ("duplicatePeriods".equals(name)) {
                                    return getDuplicatePeriods();
                                } else {
                                    if ("indicatorsViolatingExclusiveGroupSets".equals(name)) {
                                        return getIndicatorsViolatingExclusiveGroupSets();
                                    } else {
                                        if ("indicatorsWithIdenticalFormulas".equals(name)) {
                                            return getIndicatorsWithIdenticalFormulas();
                                        } else {
                                            if ("indicatorsWithoutGroups".equals(name)) {
                                                return getIndicatorsWithoutGroups();
                                            } else {
                                                if ("invalidCategoryCombos".equals(name)) {
                                                    return getInvalidCategoryCombos();
                                                } else {
                                                    if ("invalidIndicatorDenominators".equals(name)) {
                                                        return getInvalidIndicatorDenominators();
                                                    } else {
                                                        if ("invalidIndicatorNumerators".equals(name)) {
                                                            return getInvalidIndicatorNumerators();
                                                        } else {
                                                            if ("invalidProgramIndicatorExpressions".equals(name)) {
                                                                return getInvalidProgramIndicatorExpressions();
                                                            } else {
                                                                if ("invalidProgramIndicatorFilters".equals(name)) {
                                                                    return getInvalidProgramIndicatorFilters();
                                                                } else {
                                                                    if ("invalidValidationRuleLeftSideExpressions".equals(name)) {
                                                                        return getInvalidValidationRuleLeftSideExpressions();
                                                                    } else {
                                                                        if ("invalidValidationRuleRightSideExpressions".equals(name)) {
                                                                            return getInvalidValidationRuleRightSideExpressions();
                                                                        } else {
                                                                            if ("organisationUnitGroupsWithoutGroupSets".equals(name)) {
                                                                                return getOrganisationUnitGroupsWithoutGroupSets();
                                                                            } else {
                                                                                if ("organisationUnitsViolatingExclusiveGroupSets".equals(name)) {
                                                                                    return getOrganisationUnitsViolatingExclusiveGroupSets();
                                                                                } else {
                                                                                    if ("organisationUnitsWithCyclicReferences".equals(name)) {
                                                                                        return getOrganisationUnitsWithCyclicReferences();
                                                                                    } else {
                                                                                        if ("organisationUnitsWithoutGroups".equals(name)) {
                                                                                            return getOrganisationUnitsWithoutGroups();
                                                                                        } else {
                                                                                            if ("orphanedOrganisationUnits".equals(name)) {
                                                                                                return getOrphanedOrganisationUnits();
                                                                                            } else {
                                                                                                if ("programIndicatorsWithNoExpression".equals(name)) {
                                                                                                    return getProgramIndicatorsWithNoExpression();
                                                                                                } else {
                                                                                                    if ("programRuleActionsWithNoDataObject".equals(name)) {
                                                                                                        return getProgramRuleActionsWithNoDataObject();
                                                                                                    } else {
                                                                                                        if ("programRuleActionsWithNoNotification".equals(name)) {
                                                                                                            return getProgramRuleActionsWithNoNotification();
                                                                                                        } else {
                                                                                                            if ("programRuleActionsWithNoSectionId".equals(name)) {
                                                                                                                return getProgramRuleActionsWithNoSectionId();
                                                                                                            } else {
                                                                                                                if ("programRuleActionsWithNoStageId".equals(name)) {
                                                                                                                    return getProgramRuleActionsWithNoStageId();
                                                                                                                } else {
                                                                                                                    if ("programRuleVariablesWithNoAttribute".equals(name)) {
                                                                                                                        return getProgramRuleVariablesWithNoAttribute();
                                                                                                                    } else {
                                                                                                                        if ("programRuleVariablesWithNoDataElement".equals(name)) {
                                                                                                                            return getProgramRuleVariablesWithNoDataElement();
                                                                                                                        } else {
                                                                                                                            if ("programRulesWithNoAction".equals(name)) {
                                                                                                                                return getProgramRulesWithNoAction();
                                                                                                                            } else {
                                                                                                                                if ("programRulesWithNoCondition".equals(name)) {
                                                                                                                                    return getProgramRulesWithNoCondition();
                                                                                                                                } else {
                                                                                                                                    if ("programRulesWithNoPriority".equals(name)) {
                                                                                                                                        return getProgramRulesWithNoPriority();
                                                                                                                                    } else {
                                                                                                                                        if ("validationRulesWithoutGroups".equals(name)) {
                                                                                                                                            return getValidationRulesWithoutGroups();
                                                                                                                                        } else {
                                                                                                                                            return notFoundValue;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FlattenedDataIntegrityReport.NOT_FOUND_VALUE);
        if (FlattenedDataIntegrityReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FlattenedDataIntegrityReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FlattenedDataIntegrityReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataElementsAssignedToDataSetsWithDifferentPeriodTypes");
        sb.append('=');
        sb.append(((this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes == null)?"<null>":this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes));
        sb.append(',');
        sb.append("dataElementsInDataSetNotInForm");
        sb.append('=');
        sb.append(((this.dataElementsInDataSetNotInForm == null)?"<null>":this.dataElementsInDataSetNotInForm));
        sb.append(',');
        sb.append("dataElementsViolatingExclusiveGroupSets");
        sb.append('=');
        sb.append(((this.dataElementsViolatingExclusiveGroupSets == null)?"<null>":this.dataElementsViolatingExclusiveGroupSets));
        sb.append(',');
        sb.append("dataElementsWithoutDataSet");
        sb.append('=');
        sb.append(((this.dataElementsWithoutDataSet == null)?"<null>":this.dataElementsWithoutDataSet));
        sb.append(',');
        sb.append("dataElementsWithoutGroups");
        sb.append('=');
        sb.append(((this.dataElementsWithoutGroups == null)?"<null>":this.dataElementsWithoutGroups));
        sb.append(',');
        sb.append("dataSetsNotAssignedToOrganisationUnits");
        sb.append('=');
        sb.append(((this.dataSetsNotAssignedToOrganisationUnits == null)?"<null>":this.dataSetsNotAssignedToOrganisationUnits));
        sb.append(',');
        sb.append("duplicatePeriods");
        sb.append('=');
        sb.append(((this.duplicatePeriods == null)?"<null>":this.duplicatePeriods));
        sb.append(',');
        sb.append("indicatorsViolatingExclusiveGroupSets");
        sb.append('=');
        sb.append(((this.indicatorsViolatingExclusiveGroupSets == null)?"<null>":this.indicatorsViolatingExclusiveGroupSets));
        sb.append(',');
        sb.append("indicatorsWithIdenticalFormulas");
        sb.append('=');
        sb.append(((this.indicatorsWithIdenticalFormulas == null)?"<null>":this.indicatorsWithIdenticalFormulas));
        sb.append(',');
        sb.append("indicatorsWithoutGroups");
        sb.append('=');
        sb.append(((this.indicatorsWithoutGroups == null)?"<null>":this.indicatorsWithoutGroups));
        sb.append(',');
        sb.append("invalidCategoryCombos");
        sb.append('=');
        sb.append(((this.invalidCategoryCombos == null)?"<null>":this.invalidCategoryCombos));
        sb.append(',');
        sb.append("invalidIndicatorDenominators");
        sb.append('=');
        sb.append(((this.invalidIndicatorDenominators == null)?"<null>":this.invalidIndicatorDenominators));
        sb.append(',');
        sb.append("invalidIndicatorNumerators");
        sb.append('=');
        sb.append(((this.invalidIndicatorNumerators == null)?"<null>":this.invalidIndicatorNumerators));
        sb.append(',');
        sb.append("invalidProgramIndicatorExpressions");
        sb.append('=');
        sb.append(((this.invalidProgramIndicatorExpressions == null)?"<null>":this.invalidProgramIndicatorExpressions));
        sb.append(',');
        sb.append("invalidProgramIndicatorFilters");
        sb.append('=');
        sb.append(((this.invalidProgramIndicatorFilters == null)?"<null>":this.invalidProgramIndicatorFilters));
        sb.append(',');
        sb.append("invalidValidationRuleLeftSideExpressions");
        sb.append('=');
        sb.append(((this.invalidValidationRuleLeftSideExpressions == null)?"<null>":this.invalidValidationRuleLeftSideExpressions));
        sb.append(',');
        sb.append("invalidValidationRuleRightSideExpressions");
        sb.append('=');
        sb.append(((this.invalidValidationRuleRightSideExpressions == null)?"<null>":this.invalidValidationRuleRightSideExpressions));
        sb.append(',');
        sb.append("organisationUnitGroupsWithoutGroupSets");
        sb.append('=');
        sb.append(((this.organisationUnitGroupsWithoutGroupSets == null)?"<null>":this.organisationUnitGroupsWithoutGroupSets));
        sb.append(',');
        sb.append("organisationUnitsViolatingExclusiveGroupSets");
        sb.append('=');
        sb.append(((this.organisationUnitsViolatingExclusiveGroupSets == null)?"<null>":this.organisationUnitsViolatingExclusiveGroupSets));
        sb.append(',');
        sb.append("organisationUnitsWithCyclicReferences");
        sb.append('=');
        sb.append(((this.organisationUnitsWithCyclicReferences == null)?"<null>":this.organisationUnitsWithCyclicReferences));
        sb.append(',');
        sb.append("organisationUnitsWithoutGroups");
        sb.append('=');
        sb.append(((this.organisationUnitsWithoutGroups == null)?"<null>":this.organisationUnitsWithoutGroups));
        sb.append(',');
        sb.append("orphanedOrganisationUnits");
        sb.append('=');
        sb.append(((this.orphanedOrganisationUnits == null)?"<null>":this.orphanedOrganisationUnits));
        sb.append(',');
        sb.append("programIndicatorsWithNoExpression");
        sb.append('=');
        sb.append(((this.programIndicatorsWithNoExpression == null)?"<null>":this.programIndicatorsWithNoExpression));
        sb.append(',');
        sb.append("programRuleActionsWithNoDataObject");
        sb.append('=');
        sb.append(((this.programRuleActionsWithNoDataObject == null)?"<null>":this.programRuleActionsWithNoDataObject));
        sb.append(',');
        sb.append("programRuleActionsWithNoNotification");
        sb.append('=');
        sb.append(((this.programRuleActionsWithNoNotification == null)?"<null>":this.programRuleActionsWithNoNotification));
        sb.append(',');
        sb.append("programRuleActionsWithNoSectionId");
        sb.append('=');
        sb.append(((this.programRuleActionsWithNoSectionId == null)?"<null>":this.programRuleActionsWithNoSectionId));
        sb.append(',');
        sb.append("programRuleActionsWithNoStageId");
        sb.append('=');
        sb.append(((this.programRuleActionsWithNoStageId == null)?"<null>":this.programRuleActionsWithNoStageId));
        sb.append(',');
        sb.append("programRuleVariablesWithNoAttribute");
        sb.append('=');
        sb.append(((this.programRuleVariablesWithNoAttribute == null)?"<null>":this.programRuleVariablesWithNoAttribute));
        sb.append(',');
        sb.append("programRuleVariablesWithNoDataElement");
        sb.append('=');
        sb.append(((this.programRuleVariablesWithNoDataElement == null)?"<null>":this.programRuleVariablesWithNoDataElement));
        sb.append(',');
        sb.append("programRulesWithNoAction");
        sb.append('=');
        sb.append(((this.programRulesWithNoAction == null)?"<null>":this.programRulesWithNoAction));
        sb.append(',');
        sb.append("programRulesWithNoCondition");
        sb.append('=');
        sb.append(((this.programRulesWithNoCondition == null)?"<null>":this.programRulesWithNoCondition));
        sb.append(',');
        sb.append("programRulesWithNoPriority");
        sb.append('=');
        sb.append(((this.programRulesWithNoPriority == null)?"<null>":this.programRulesWithNoPriority));
        sb.append(',');
        sb.append("validationRulesWithoutGroups");
        sb.append('=');
        sb.append(((this.validationRulesWithoutGroups == null)?"<null>":this.validationRulesWithoutGroups));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.invalidValidationRuleRightSideExpressions == null)? 0 :this.invalidValidationRuleRightSideExpressions.hashCode()));
        result = ((result* 31)+((this.programRulesWithNoPriority == null)? 0 :this.programRulesWithNoPriority.hashCode()));
        result = ((result* 31)+((this.duplicatePeriods == null)? 0 :this.duplicatePeriods.hashCode()));
        result = ((result* 31)+((this.programRuleActionsWithNoNotification == null)? 0 :this.programRuleActionsWithNoNotification.hashCode()));
        result = ((result* 31)+((this.organisationUnitsWithCyclicReferences == null)? 0 :this.organisationUnitsWithCyclicReferences.hashCode()));
        result = ((result* 31)+((this.invalidIndicatorNumerators == null)? 0 :this.invalidIndicatorNumerators.hashCode()));
        result = ((result* 31)+((this.dataElementsInDataSetNotInForm == null)? 0 :this.dataElementsInDataSetNotInForm.hashCode()));
        result = ((result* 31)+((this.programRulesWithNoCondition == null)? 0 :this.programRulesWithNoCondition.hashCode()));
        result = ((result* 31)+((this.indicatorsWithoutGroups == null)? 0 :this.indicatorsWithoutGroups.hashCode()));
        result = ((result* 31)+((this.programRuleActionsWithNoSectionId == null)? 0 :this.programRuleActionsWithNoSectionId.hashCode()));
        result = ((result* 31)+((this.organisationUnitsWithoutGroups == null)? 0 :this.organisationUnitsWithoutGroups.hashCode()));
        result = ((result* 31)+((this.dataElementsWithoutDataSet == null)? 0 :this.dataElementsWithoutDataSet.hashCode()));
        result = ((result* 31)+((this.programRuleActionsWithNoStageId == null)? 0 :this.programRuleActionsWithNoStageId.hashCode()));
        result = ((result* 31)+((this.orphanedOrganisationUnits == null)? 0 :this.orphanedOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.dataSetsNotAssignedToOrganisationUnits == null)? 0 :this.dataSetsNotAssignedToOrganisationUnits.hashCode()));
        result = ((result* 31)+((this.invalidProgramIndicatorExpressions == null)? 0 :this.invalidProgramIndicatorExpressions.hashCode()));
        result = ((result* 31)+((this.invalidValidationRuleLeftSideExpressions == null)? 0 :this.invalidValidationRuleLeftSideExpressions.hashCode()));
        result = ((result* 31)+((this.programRuleActionsWithNoDataObject == null)? 0 :this.programRuleActionsWithNoDataObject.hashCode()));
        result = ((result* 31)+((this.programRuleVariablesWithNoAttribute == null)? 0 :this.programRuleVariablesWithNoAttribute.hashCode()));
        result = ((result* 31)+((this.invalidIndicatorDenominators == null)? 0 :this.invalidIndicatorDenominators.hashCode()));
        result = ((result* 31)+((this.dataElementsWithoutGroups == null)? 0 :this.dataElementsWithoutGroups.hashCode()));
        result = ((result* 31)+((this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes == null)? 0 :this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes.hashCode()));
        result = ((result* 31)+((this.programIndicatorsWithNoExpression == null)? 0 :this.programIndicatorsWithNoExpression.hashCode()));
        result = ((result* 31)+((this.indicatorsWithIdenticalFormulas == null)? 0 :this.indicatorsWithIdenticalFormulas.hashCode()));
        result = ((result* 31)+((this.invalidCategoryCombos == null)? 0 :this.invalidCategoryCombos.hashCode()));
        result = ((result* 31)+((this.validationRulesWithoutGroups == null)? 0 :this.validationRulesWithoutGroups.hashCode()));
        result = ((result* 31)+((this.indicatorsViolatingExclusiveGroupSets == null)? 0 :this.indicatorsViolatingExclusiveGroupSets.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupsWithoutGroupSets == null)? 0 :this.organisationUnitGroupsWithoutGroupSets.hashCode()));
        result = ((result* 31)+((this.programRuleVariablesWithNoDataElement == null)? 0 :this.programRuleVariablesWithNoDataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.invalidProgramIndicatorFilters == null)? 0 :this.invalidProgramIndicatorFilters.hashCode()));
        result = ((result* 31)+((this.dataElementsViolatingExclusiveGroupSets == null)? 0 :this.dataElementsViolatingExclusiveGroupSets.hashCode()));
        result = ((result* 31)+((this.programRulesWithNoAction == null)? 0 :this.programRulesWithNoAction.hashCode()));
        result = ((result* 31)+((this.organisationUnitsViolatingExclusiveGroupSets == null)? 0 :this.organisationUnitsViolatingExclusiveGroupSets.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FlattenedDataIntegrityReport) == false) {
            return false;
        }
        FlattenedDataIntegrityReport rhs = ((FlattenedDataIntegrityReport) other);
        return (((((((((((((((((((((((((((((((((((this.invalidValidationRuleRightSideExpressions == rhs.invalidValidationRuleRightSideExpressions)||((this.invalidValidationRuleRightSideExpressions!= null)&&this.invalidValidationRuleRightSideExpressions.equals(rhs.invalidValidationRuleRightSideExpressions)))&&((this.programRulesWithNoPriority == rhs.programRulesWithNoPriority)||((this.programRulesWithNoPriority!= null)&&this.programRulesWithNoPriority.equals(rhs.programRulesWithNoPriority))))&&((this.duplicatePeriods == rhs.duplicatePeriods)||((this.duplicatePeriods!= null)&&this.duplicatePeriods.equals(rhs.duplicatePeriods))))&&((this.programRuleActionsWithNoNotification == rhs.programRuleActionsWithNoNotification)||((this.programRuleActionsWithNoNotification!= null)&&this.programRuleActionsWithNoNotification.equals(rhs.programRuleActionsWithNoNotification))))&&((this.organisationUnitsWithCyclicReferences == rhs.organisationUnitsWithCyclicReferences)||((this.organisationUnitsWithCyclicReferences!= null)&&this.organisationUnitsWithCyclicReferences.equals(rhs.organisationUnitsWithCyclicReferences))))&&((this.invalidIndicatorNumerators == rhs.invalidIndicatorNumerators)||((this.invalidIndicatorNumerators!= null)&&this.invalidIndicatorNumerators.equals(rhs.invalidIndicatorNumerators))))&&((this.dataElementsInDataSetNotInForm == rhs.dataElementsInDataSetNotInForm)||((this.dataElementsInDataSetNotInForm!= null)&&this.dataElementsInDataSetNotInForm.equals(rhs.dataElementsInDataSetNotInForm))))&&((this.programRulesWithNoCondition == rhs.programRulesWithNoCondition)||((this.programRulesWithNoCondition!= null)&&this.programRulesWithNoCondition.equals(rhs.programRulesWithNoCondition))))&&((this.indicatorsWithoutGroups == rhs.indicatorsWithoutGroups)||((this.indicatorsWithoutGroups!= null)&&this.indicatorsWithoutGroups.equals(rhs.indicatorsWithoutGroups))))&&((this.programRuleActionsWithNoSectionId == rhs.programRuleActionsWithNoSectionId)||((this.programRuleActionsWithNoSectionId!= null)&&this.programRuleActionsWithNoSectionId.equals(rhs.programRuleActionsWithNoSectionId))))&&((this.organisationUnitsWithoutGroups == rhs.organisationUnitsWithoutGroups)||((this.organisationUnitsWithoutGroups!= null)&&this.organisationUnitsWithoutGroups.equals(rhs.organisationUnitsWithoutGroups))))&&((this.dataElementsWithoutDataSet == rhs.dataElementsWithoutDataSet)||((this.dataElementsWithoutDataSet!= null)&&this.dataElementsWithoutDataSet.equals(rhs.dataElementsWithoutDataSet))))&&((this.programRuleActionsWithNoStageId == rhs.programRuleActionsWithNoStageId)||((this.programRuleActionsWithNoStageId!= null)&&this.programRuleActionsWithNoStageId.equals(rhs.programRuleActionsWithNoStageId))))&&((this.orphanedOrganisationUnits == rhs.orphanedOrganisationUnits)||((this.orphanedOrganisationUnits!= null)&&this.orphanedOrganisationUnits.equals(rhs.orphanedOrganisationUnits))))&&((this.dataSetsNotAssignedToOrganisationUnits == rhs.dataSetsNotAssignedToOrganisationUnits)||((this.dataSetsNotAssignedToOrganisationUnits!= null)&&this.dataSetsNotAssignedToOrganisationUnits.equals(rhs.dataSetsNotAssignedToOrganisationUnits))))&&((this.invalidProgramIndicatorExpressions == rhs.invalidProgramIndicatorExpressions)||((this.invalidProgramIndicatorExpressions!= null)&&this.invalidProgramIndicatorExpressions.equals(rhs.invalidProgramIndicatorExpressions))))&&((this.invalidValidationRuleLeftSideExpressions == rhs.invalidValidationRuleLeftSideExpressions)||((this.invalidValidationRuleLeftSideExpressions!= null)&&this.invalidValidationRuleLeftSideExpressions.equals(rhs.invalidValidationRuleLeftSideExpressions))))&&((this.programRuleActionsWithNoDataObject == rhs.programRuleActionsWithNoDataObject)||((this.programRuleActionsWithNoDataObject!= null)&&this.programRuleActionsWithNoDataObject.equals(rhs.programRuleActionsWithNoDataObject))))&&((this.programRuleVariablesWithNoAttribute == rhs.programRuleVariablesWithNoAttribute)||((this.programRuleVariablesWithNoAttribute!= null)&&this.programRuleVariablesWithNoAttribute.equals(rhs.programRuleVariablesWithNoAttribute))))&&((this.invalidIndicatorDenominators == rhs.invalidIndicatorDenominators)||((this.invalidIndicatorDenominators!= null)&&this.invalidIndicatorDenominators.equals(rhs.invalidIndicatorDenominators))))&&((this.dataElementsWithoutGroups == rhs.dataElementsWithoutGroups)||((this.dataElementsWithoutGroups!= null)&&this.dataElementsWithoutGroups.equals(rhs.dataElementsWithoutGroups))))&&((this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes == rhs.dataElementsAssignedToDataSetsWithDifferentPeriodTypes)||((this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes!= null)&&this.dataElementsAssignedToDataSetsWithDifferentPeriodTypes.equals(rhs.dataElementsAssignedToDataSetsWithDifferentPeriodTypes))))&&((this.programIndicatorsWithNoExpression == rhs.programIndicatorsWithNoExpression)||((this.programIndicatorsWithNoExpression!= null)&&this.programIndicatorsWithNoExpression.equals(rhs.programIndicatorsWithNoExpression))))&&((this.indicatorsWithIdenticalFormulas == rhs.indicatorsWithIdenticalFormulas)||((this.indicatorsWithIdenticalFormulas!= null)&&this.indicatorsWithIdenticalFormulas.equals(rhs.indicatorsWithIdenticalFormulas))))&&((this.invalidCategoryCombos == rhs.invalidCategoryCombos)||((this.invalidCategoryCombos!= null)&&this.invalidCategoryCombos.equals(rhs.invalidCategoryCombos))))&&((this.validationRulesWithoutGroups == rhs.validationRulesWithoutGroups)||((this.validationRulesWithoutGroups!= null)&&this.validationRulesWithoutGroups.equals(rhs.validationRulesWithoutGroups))))&&((this.indicatorsViolatingExclusiveGroupSets == rhs.indicatorsViolatingExclusiveGroupSets)||((this.indicatorsViolatingExclusiveGroupSets!= null)&&this.indicatorsViolatingExclusiveGroupSets.equals(rhs.indicatorsViolatingExclusiveGroupSets))))&&((this.organisationUnitGroupsWithoutGroupSets == rhs.organisationUnitGroupsWithoutGroupSets)||((this.organisationUnitGroupsWithoutGroupSets!= null)&&this.organisationUnitGroupsWithoutGroupSets.equals(rhs.organisationUnitGroupsWithoutGroupSets))))&&((this.programRuleVariablesWithNoDataElement == rhs.programRuleVariablesWithNoDataElement)||((this.programRuleVariablesWithNoDataElement!= null)&&this.programRuleVariablesWithNoDataElement.equals(rhs.programRuleVariablesWithNoDataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.invalidProgramIndicatorFilters == rhs.invalidProgramIndicatorFilters)||((this.invalidProgramIndicatorFilters!= null)&&this.invalidProgramIndicatorFilters.equals(rhs.invalidProgramIndicatorFilters))))&&((this.dataElementsViolatingExclusiveGroupSets == rhs.dataElementsViolatingExclusiveGroupSets)||((this.dataElementsViolatingExclusiveGroupSets!= null)&&this.dataElementsViolatingExclusiveGroupSets.equals(rhs.dataElementsViolatingExclusiveGroupSets))))&&((this.programRulesWithNoAction == rhs.programRulesWithNoAction)||((this.programRulesWithNoAction!= null)&&this.programRulesWithNoAction.equals(rhs.programRulesWithNoAction))))&&((this.organisationUnitsViolatingExclusiveGroupSets == rhs.organisationUnitsViolatingExclusiveGroupSets)||((this.organisationUnitsViolatingExclusiveGroupSets!= null)&&this.organisationUnitsViolatingExclusiveGroupSets.equals(rhs.organisationUnitsViolatingExclusiveGroupSets))));
    }

}
