
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorReports",
    "index",
    "trackerType",
    "uid"
})
@Generated("jsonschema2pojo")
public class TrackerObjectReport implements Serializable
{

    @JsonProperty("errorReports")
    private List<TrackerErrorReport> errorReports;
    @JsonProperty("index")
    private Integer index;
    @JsonProperty("trackerType")
    private TrackerErrorReport.TrackerType trackerType;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1761491302394090620L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerObjectReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerObjectReport(TrackerObjectReport source) {
        super();
        this.errorReports = source.errorReports;
        this.index = source.index;
        this.trackerType = source.trackerType;
        this.uid = source.uid;
    }

    public TrackerObjectReport(List<TrackerErrorReport> errorReports, Integer index, TrackerErrorReport.TrackerType trackerType, String uid) {
        super();
        this.errorReports = errorReports;
        this.index = index;
        this.trackerType = trackerType;
        this.uid = uid;
    }

    @JsonProperty("errorReports")
    public Optional<List<TrackerErrorReport>> getErrorReports() {
        return Optional.ofNullable(errorReports);
    }

    @JsonProperty("errorReports")
    public void setErrorReports(List<TrackerErrorReport> errorReports) {
        this.errorReports = errorReports;
    }

    public TrackerObjectReport withErrorReports(List<TrackerErrorReport> errorReports) {
        this.errorReports = errorReports;
        return this;
    }

    @JsonProperty("index")
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(index);
    }

    @JsonProperty("index")
    public void setIndex(Integer index) {
        this.index = index;
    }

    public TrackerObjectReport withIndex(Integer index) {
        this.index = index;
        return this;
    }

    @JsonProperty("trackerType")
    public Optional<TrackerErrorReport.TrackerType> getTrackerType() {
        return Optional.ofNullable(trackerType);
    }

    @JsonProperty("trackerType")
    public void setTrackerType(TrackerErrorReport.TrackerType trackerType) {
        this.trackerType = trackerType;
    }

    public TrackerObjectReport withTrackerType(TrackerErrorReport.TrackerType trackerType) {
        this.trackerType = trackerType;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public TrackerObjectReport withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerObjectReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("errorReports".equals(name)) {
            if (value instanceof List) {
                setErrorReports(((List<TrackerErrorReport> ) value));
            } else {
                throw new IllegalArgumentException(("property \"errorReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.TrackerErrorReport>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("index".equals(name)) {
                if (value instanceof Integer) {
                    setIndex(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"index\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("trackerType".equals(name)) {
                    if (value instanceof TrackerErrorReport.TrackerType) {
                        setTrackerType(((TrackerErrorReport.TrackerType) value));
                    } else {
                        throw new IllegalArgumentException(("property \"trackerType\" is of type \"org.hisp.dhis.api.model.v2_36_11.TrackerErrorReport.TrackerType\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("uid".equals(name)) {
                        if (value instanceof String) {
                            setUid(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("errorReports".equals(name)) {
            return getErrorReports();
        } else {
            if ("index".equals(name)) {
                return getIndex();
            } else {
                if ("trackerType".equals(name)) {
                    return getTrackerType();
                } else {
                    if ("uid".equals(name)) {
                        return getUid();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerObjectReport.NOT_FOUND_VALUE);
        if (TrackerObjectReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerObjectReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerObjectReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorReports");
        sb.append('=');
        sb.append(((this.errorReports == null)?"<null>":this.errorReports));
        sb.append(',');
        sb.append("index");
        sb.append('=');
        sb.append(((this.index == null)?"<null>":this.index));
        sb.append(',');
        sb.append("trackerType");
        sb.append('=');
        sb.append(((this.trackerType == null)?"<null>":this.trackerType));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.trackerType == null)? 0 :this.trackerType.hashCode()));
        result = ((result* 31)+((this.index == null)? 0 :this.index.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.errorReports == null)? 0 :this.errorReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerObjectReport) == false) {
            return false;
        }
        TrackerObjectReport rhs = ((TrackerObjectReport) other);
        return ((((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.trackerType == rhs.trackerType)||((this.trackerType!= null)&&this.trackerType.equals(rhs.trackerType))))&&((this.index == rhs.index)||((this.index!= null)&&this.index.equals(rhs.index))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.errorReports == rhs.errorReports)||((this.errorReports!= null)&&this.errorReports.equals(rhs.errorReports))));
    }

}
