
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "stats",
    "status",
    "typeReportMap"
})
@Generated("jsonschema2pojo")
public class TrackerBundleReport implements Serializable
{

    @JsonProperty("stats")
    private TrackerStats stats;
    @JsonProperty("status")
    private TrackerBundleReport.TrackerStatus status;
    /**
     * Undefined
     * 
     */
    @JsonProperty("typeReportMap")
    private TypeReportMap typeReportMap;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3050289354467151844L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerBundleReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerBundleReport(TrackerBundleReport source) {
        super();
        this.stats = source.stats;
        this.status = source.status;
        this.typeReportMap = source.typeReportMap;
    }

    public TrackerBundleReport(TrackerStats stats, TrackerBundleReport.TrackerStatus status, TypeReportMap typeReportMap) {
        super();
        this.stats = stats;
        this.status = status;
        this.typeReportMap = typeReportMap;
    }

    @JsonProperty("stats")
    public Optional<TrackerStats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(TrackerStats stats) {
        this.stats = stats;
    }

    public TrackerBundleReport withStats(TrackerStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty("status")
    public Optional<TrackerBundleReport.TrackerStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(TrackerBundleReport.TrackerStatus status) {
        this.status = status;
    }

    public TrackerBundleReport withStatus(TrackerBundleReport.TrackerStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("typeReportMap")
    public Optional<TypeReportMap> getTypeReportMap() {
        return Optional.ofNullable(typeReportMap);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("typeReportMap")
    public void setTypeReportMap(TypeReportMap typeReportMap) {
        this.typeReportMap = typeReportMap;
    }

    public TrackerBundleReport withTypeReportMap(TypeReportMap typeReportMap) {
        this.typeReportMap = typeReportMap;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerBundleReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("stats".equals(name)) {
            if (value instanceof TrackerStats) {
                setStats(((TrackerStats) value));
            } else {
                throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v2_36_11.TrackerStats\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("status".equals(name)) {
                if (value instanceof TrackerBundleReport.TrackerStatus) {
                    setStatus(((TrackerBundleReport.TrackerStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_36_11.TrackerBundleReport.TrackerStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("typeReportMap".equals(name)) {
                    if (value instanceof TypeReportMap) {
                        setTypeReportMap(((TypeReportMap) value));
                    } else {
                        throw new IllegalArgumentException(("property \"typeReportMap\" is of type \"org.hisp.dhis.api.model.v2_36_11.TypeReportMap\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("stats".equals(name)) {
            return getStats();
        } else {
            if ("status".equals(name)) {
                return getStatus();
            } else {
                if ("typeReportMap".equals(name)) {
                    return getTypeReportMap();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerBundleReport.NOT_FOUND_VALUE);
        if (TrackerBundleReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerBundleReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerBundleReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("typeReportMap");
        sb.append('=');
        sb.append(((this.typeReportMap == null)?"<null>":this.typeReportMap));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        result = ((result* 31)+((this.typeReportMap == null)? 0 :this.typeReportMap.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerBundleReport) == false) {
            return false;
        }
        TrackerBundleReport rhs = ((TrackerBundleReport) other);
        return (((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))))&&((this.typeReportMap == rhs.typeReportMap)||((this.typeReportMap!= null)&&this.typeReportMap.equals(rhs.typeReportMap))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum TrackerStatus {

        OK("OK"),
        WARNING("WARNING"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, TrackerBundleReport.TrackerStatus> CONSTANTS = new HashMap<String, TrackerBundleReport.TrackerStatus>();

        static {
            for (TrackerBundleReport.TrackerStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TrackerStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerBundleReport.TrackerStatus fromValue(String value) {
            TrackerBundleReport.TrackerStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
