
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorReports",
    "klass",
    "responseType",
    "uid"
})
@Generated("jsonschema2pojo")
public class ObjectReportWebMessageResponse implements Serializable
{

    @JsonProperty("errorReports")
    private List<ErrorReport> errorReports;
    @JsonProperty("klass")
    private String klass;
    @JsonProperty("responseType")
    private String responseType;
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7987792825447112367L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ObjectReportWebMessageResponse() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ObjectReportWebMessageResponse(ObjectReportWebMessageResponse source) {
        super();
        this.errorReports = source.errorReports;
        this.klass = source.klass;
        this.responseType = source.responseType;
        this.uid = source.uid;
    }

    public ObjectReportWebMessageResponse(List<ErrorReport> errorReports, String klass, String responseType, String uid) {
        super();
        this.errorReports = errorReports;
        this.klass = klass;
        this.responseType = responseType;
        this.uid = uid;
    }

    @JsonProperty("errorReports")
    public Optional<List<ErrorReport>> getErrorReports() {
        return Optional.ofNullable(errorReports);
    }

    @JsonProperty("errorReports")
    public void setErrorReports(List<ErrorReport> errorReports) {
        this.errorReports = errorReports;
    }

    public ObjectReportWebMessageResponse withErrorReports(List<ErrorReport> errorReports) {
        this.errorReports = errorReports;
        return this;
    }

    @JsonProperty("klass")
    public Optional<String> getKlass() {
        return Optional.ofNullable(klass);
    }

    @JsonProperty("klass")
    public void setKlass(String klass) {
        this.klass = klass;
    }

    public ObjectReportWebMessageResponse withKlass(String klass) {
        this.klass = klass;
        return this;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public ObjectReportWebMessageResponse withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public ObjectReportWebMessageResponse withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ObjectReportWebMessageResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("errorReports".equals(name)) {
            if (value instanceof List) {
                setErrorReports(((List<ErrorReport> ) value));
            } else {
                throw new IllegalArgumentException(("property \"errorReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.ErrorReport>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("klass".equals(name)) {
                if (value instanceof String) {
                    setKlass(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"klass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("responseType".equals(name)) {
                    if (value instanceof String) {
                        setResponseType(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("uid".equals(name)) {
                        if (value instanceof String) {
                            setUid(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("errorReports".equals(name)) {
            return getErrorReports();
        } else {
            if ("klass".equals(name)) {
                return getKlass();
            } else {
                if ("responseType".equals(name)) {
                    return getResponseType();
                } else {
                    if ("uid".equals(name)) {
                        return getUid();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ObjectReportWebMessageResponse.NOT_FOUND_VALUE);
        if (ObjectReportWebMessageResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ObjectReportWebMessageResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ObjectReportWebMessageResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorReports");
        sb.append('=');
        sb.append(((this.errorReports == null)?"<null>":this.errorReports));
        sb.append(',');
        sb.append("klass");
        sb.append('=');
        sb.append(((this.klass == null)?"<null>":this.klass));
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.klass == null)? 0 :this.klass.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.errorReports == null)? 0 :this.errorReports.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ObjectReportWebMessageResponse) == false) {
            return false;
        }
        ObjectReportWebMessageResponse rhs = ((ObjectReportWebMessageResponse) other);
        return ((((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType))))&&((this.klass == rhs.klass)||((this.klass!= null)&&this.klass.equals(rhs.klass))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.errorReports == rhs.errorReports)||((this.errorReports!= null)&&this.errorReports.equals(rhs.errorReports))));
    }

}
