
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "ab",
    "ad",
    "ds",
    "ou",
    "pe"
})
@Generated("jsonschema2pojo")
public class DataApprovalStateRequest implements Serializable
{

    @JsonProperty("ab")
    private String ab;
    @JsonProperty("ad")
    private Date ad;
    @JsonProperty("ds")
    private String ds;
    @JsonProperty("ou")
    private String ou;
    @JsonProperty("pe")
    private String pe;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4458481030322823536L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataApprovalStateRequest() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataApprovalStateRequest(DataApprovalStateRequest source) {
        super();
        this.ab = source.ab;
        this.ad = source.ad;
        this.ds = source.ds;
        this.ou = source.ou;
        this.pe = source.pe;
    }

    public DataApprovalStateRequest(String ab, Date ad, String ds, String ou, String pe) {
        super();
        this.ab = ab;
        this.ad = ad;
        this.ds = ds;
        this.ou = ou;
        this.pe = pe;
    }

    @JsonProperty("ab")
    public Optional<String> getAb() {
        return Optional.ofNullable(ab);
    }

    @JsonProperty("ab")
    public void setAb(String ab) {
        this.ab = ab;
    }

    public DataApprovalStateRequest withAb(String ab) {
        this.ab = ab;
        return this;
    }

    @JsonProperty("ad")
    public Optional<Date> getAd() {
        return Optional.ofNullable(ad);
    }

    @JsonProperty("ad")
    public void setAd(Date ad) {
        this.ad = ad;
    }

    public DataApprovalStateRequest withAd(Date ad) {
        this.ad = ad;
        return this;
    }

    @JsonProperty("ds")
    public Optional<String> getDs() {
        return Optional.ofNullable(ds);
    }

    @JsonProperty("ds")
    public void setDs(String ds) {
        this.ds = ds;
    }

    public DataApprovalStateRequest withDs(String ds) {
        this.ds = ds;
        return this;
    }

    @JsonProperty("ou")
    public Optional<String> getOu() {
        return Optional.ofNullable(ou);
    }

    @JsonProperty("ou")
    public void setOu(String ou) {
        this.ou = ou;
    }

    public DataApprovalStateRequest withOu(String ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty("pe")
    public Optional<String> getPe() {
        return Optional.ofNullable(pe);
    }

    @JsonProperty("pe")
    public void setPe(String pe) {
        this.pe = pe;
    }

    public DataApprovalStateRequest withPe(String pe) {
        this.pe = pe;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataApprovalStateRequest withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("ab".equals(name)) {
            if (value instanceof String) {
                setAb(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"ab\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("ad".equals(name)) {
                if (value instanceof Date) {
                    setAd(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"ad\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("ds".equals(name)) {
                    if (value instanceof String) {
                        setDs(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"ds\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("ou".equals(name)) {
                        if (value instanceof String) {
                            setOu(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"ou\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("pe".equals(name)) {
                            if (value instanceof String) {
                                setPe(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"pe\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("ab".equals(name)) {
            return getAb();
        } else {
            if ("ad".equals(name)) {
                return getAd();
            } else {
                if ("ds".equals(name)) {
                    return getDs();
                } else {
                    if ("ou".equals(name)) {
                        return getOu();
                    } else {
                        if ("pe".equals(name)) {
                            return getPe();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataApprovalStateRequest.NOT_FOUND_VALUE);
        if (DataApprovalStateRequest.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataApprovalStateRequest with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataApprovalStateRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("ab");
        sb.append('=');
        sb.append(((this.ab == null)?"<null>":this.ab));
        sb.append(',');
        sb.append("ad");
        sb.append('=');
        sb.append(((this.ad == null)?"<null>":this.ad));
        sb.append(',');
        sb.append("ds");
        sb.append('=');
        sb.append(((this.ds == null)?"<null>":this.ds));
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(((this.ou == null)?"<null>":this.ou));
        sb.append(',');
        sb.append("pe");
        sb.append('=');
        sb.append(((this.pe == null)?"<null>":this.pe));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.ab == null)? 0 :this.ab.hashCode()));
        result = ((result* 31)+((this.ad == null)? 0 :this.ad.hashCode()));
        result = ((result* 31)+((this.pe == null)? 0 :this.pe.hashCode()));
        result = ((result* 31)+((this.ou == null)? 0 :this.ou.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.ds == null)? 0 :this.ds.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataApprovalStateRequest) == false) {
            return false;
        }
        DataApprovalStateRequest rhs = ((DataApprovalStateRequest) other);
        return (((((((this.ab == rhs.ab)||((this.ab!= null)&&this.ab.equals(rhs.ab)))&&((this.ad == rhs.ad)||((this.ad!= null)&&this.ad.equals(rhs.ad))))&&((this.pe == rhs.pe)||((this.pe!= null)&&this.pe.equals(rhs.pe))))&&((this.ou == rhs.ou)||((this.ou!= null)&&this.ou.equals(rhs.ou))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.ds == rhs.ds)||((this.ds!= null)&&this.ds.equals(rhs.ds))));
    }

}
