
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "attributeDimensions",
    "attributeValues",
    "baseLineLabel",
    "baseLineValue",
    "category",
    "categoryDimensions",
    "categoryOptionGroupSetDimensions",
    "code",
    "columns",
    "completedOnly",
    "created",
    "createdBy",
    "cumulativeValues",
    "dataDimensionItems",
    "dataElementDimensions",
    "dataElementGroupSetDimensions",
    "description",
    "digitGroupSeparator",
    "displayBaseLineLabel",
    "displayDescription",
    "displayDomainAxisLabel",
    "displayFormName",
    "displayName",
    "displayRangeAxisLabel",
    "displayShortName",
    "displaySubtitle",
    "displayTargetLineLabel",
    "displayTitle",
    "domainAxisLabel",
    "endDate",
    "externalAccess",
    "favorite",
    "favorites",
    "filterDimensions",
    "filters",
    "formName",
    "hideEmptyRowItems",
    "hideLegend",
    "hideSubtitle",
    "hideTitle",
    "href",
    "id",
    "interpretations",
    "itemOrganisationUnitGroups",
    "lastUpdated",
    "lastUpdatedBy",
    "legendDisplayStrategy",
    "legendSet",
    "name",
    "noSpaceBetweenColumns",
    "orgUnitField",
    "organisationUnitGroupSetDimensions",
    "organisationUnitLevels",
    "organisationUnits",
    "parentGraphMap",
    "percentStackedValues",
    "periods",
    "programIndicatorDimensions",
    "publicAccess",
    "rangeAxisDecimals",
    "rangeAxisLabel",
    "rangeAxisMaxValue",
    "rangeAxisMinValue",
    "rangeAxisSteps",
    "regressionType",
    "relativePeriods",
    "rows",
    "series",
    "seriesItems",
    "sharing",
    "shortName",
    "showData",
    "sortOrder",
    "startDate",
    "subscribed",
    "subscribers",
    "subtitle",
    "targetLineLabel",
    "targetLineValue",
    "timeField",
    "title",
    "topLimit",
    "translations",
    "type",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "userOrgUnitType",
    "userOrganisationUnit",
    "userOrganisationUnitChildren",
    "userOrganisationUnitGrandChildren",
    "yearlySeries"
})
@Generated("jsonschema2pojo")
public class Chart implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("attributeDimensions")
    private List<TrackedEntityAttributeDimension> attributeDimensions;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("baseLineLabel")
    private String baseLineLabel;
    @JsonProperty("baseLineValue")
    private Double baseLineValue;
    @JsonProperty("category")
    private String category;
    @JsonProperty("categoryDimensions")
    private List<CategoryDimension> categoryDimensions;
    @JsonProperty("categoryOptionGroupSetDimensions")
    private List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions;
    @JsonProperty("code")
    private String code;
    @JsonProperty("columns")
    private List<Object> columns;
    @JsonProperty("completedOnly")
    private Boolean completedOnly;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("cumulativeValues")
    private Boolean cumulativeValues;
    @JsonProperty("dataDimensionItems")
    private List<DataDimensionItem> dataDimensionItems;
    @JsonProperty("dataElementDimensions")
    private List<TrackedEntityDataElementDimension> dataElementDimensions;
    @JsonProperty("dataElementGroupSetDimensions")
    private List<DataElementGroupSetDimension> dataElementGroupSetDimensions;
    @JsonProperty("description")
    private String description;
    @JsonProperty("digitGroupSeparator")
    private Chart.DigitGroupSeparator digitGroupSeparator;
    @JsonProperty("displayBaseLineLabel")
    private String displayBaseLineLabel;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayDomainAxisLabel")
    private String displayDomainAxisLabel;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayRangeAxisLabel")
    private String displayRangeAxisLabel;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("displaySubtitle")
    private String displaySubtitle;
    @JsonProperty("displayTargetLineLabel")
    private String displayTargetLineLabel;
    @JsonProperty("displayTitle")
    private String displayTitle;
    @JsonProperty("domainAxisLabel")
    private String domainAxisLabel;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("filterDimensions")
    private List<String> filterDimensions;
    @JsonProperty("filters")
    private List<Object> filters;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("hideEmptyRowItems")
    private Chart.HideEmptyItemStrategy hideEmptyRowItems;
    @JsonProperty("hideLegend")
    private Boolean hideLegend;
    @JsonProperty("hideSubtitle")
    private Boolean hideSubtitle;
    @JsonProperty("hideTitle")
    private Boolean hideTitle;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("interpretations")
    private List<Interpretation> interpretations;
    @JsonProperty("itemOrganisationUnitGroups")
    private List<OrganisationUnitGroup> itemOrganisationUnitGroups;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legendDisplayStrategy")
    private Chart.LegendDisplayStrategy legendDisplayStrategy;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("name")
    private String name;
    @JsonProperty("noSpaceBetweenColumns")
    private Boolean noSpaceBetweenColumns;
    @JsonProperty("orgUnitField")
    private String orgUnitField;
    @JsonProperty("organisationUnitGroupSetDimensions")
    private List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions;
    @JsonProperty("organisationUnitLevels")
    private List<Integer> organisationUnitLevels;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits;
    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    private ParentGraphMap parentGraphMap;
    @JsonProperty("percentStackedValues")
    private Boolean percentStackedValues;
    @JsonProperty("periods")
    private List<Period> periods;
    @JsonProperty("programIndicatorDimensions")
    private List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("rangeAxisDecimals")
    private Integer rangeAxisDecimals;
    @JsonProperty("rangeAxisLabel")
    private String rangeAxisLabel;
    @JsonProperty("rangeAxisMaxValue")
    private Double rangeAxisMaxValue;
    @JsonProperty("rangeAxisMinValue")
    private Double rangeAxisMinValue;
    @JsonProperty("rangeAxisSteps")
    private Integer rangeAxisSteps;
    @JsonProperty("regressionType")
    private Chart.RegressionType regressionType;
    @JsonProperty("relativePeriods")
    private RelativePeriods relativePeriods;
    @JsonProperty("rows")
    private List<Object> rows;
    @JsonProperty("series")
    private String series;
    @JsonProperty("seriesItems")
    private List<Series> seriesItems;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("showData")
    private Boolean showData;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("subscribed")
    private Boolean subscribed;
    @JsonProperty("subscribers")
    private List<String> subscribers;
    @JsonProperty("subtitle")
    private String subtitle;
    @JsonProperty("targetLineLabel")
    private String targetLineLabel;
    @JsonProperty("targetLineValue")
    private Double targetLineValue;
    @JsonProperty("timeField")
    private String timeField;
    @JsonProperty("title")
    private String title;
    @JsonProperty("topLimit")
    private Integer topLimit;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("type")
    private Chart.ChartType type;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess__1> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess__1> userGroupAccesses;
    @JsonProperty("userOrgUnitType")
    private Chart.UserOrgUnitType userOrgUnitType;
    @JsonProperty("userOrganisationUnit")
    private Boolean userOrganisationUnit;
    @JsonProperty("userOrganisationUnitChildren")
    private Boolean userOrganisationUnitChildren;
    @JsonProperty("userOrganisationUnitGrandChildren")
    private Boolean userOrganisationUnitGrandChildren;
    @JsonProperty("yearlySeries")
    private List<String> yearlySeries;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4290851069172945554L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Chart() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Chart(Chart source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.attributeDimensions = source.attributeDimensions;
        this.attributeValues = source.attributeValues;
        this.baseLineLabel = source.baseLineLabel;
        this.baseLineValue = source.baseLineValue;
        this.category = source.category;
        this.categoryDimensions = source.categoryDimensions;
        this.categoryOptionGroupSetDimensions = source.categoryOptionGroupSetDimensions;
        this.code = source.code;
        this.columns = source.columns;
        this.completedOnly = source.completedOnly;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.cumulativeValues = source.cumulativeValues;
        this.dataDimensionItems = source.dataDimensionItems;
        this.dataElementDimensions = source.dataElementDimensions;
        this.dataElementGroupSetDimensions = source.dataElementGroupSetDimensions;
        this.description = source.description;
        this.digitGroupSeparator = source.digitGroupSeparator;
        this.displayBaseLineLabel = source.displayBaseLineLabel;
        this.displayDescription = source.displayDescription;
        this.displayDomainAxisLabel = source.displayDomainAxisLabel;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayRangeAxisLabel = source.displayRangeAxisLabel;
        this.displayShortName = source.displayShortName;
        this.displaySubtitle = source.displaySubtitle;
        this.displayTargetLineLabel = source.displayTargetLineLabel;
        this.displayTitle = source.displayTitle;
        this.domainAxisLabel = source.domainAxisLabel;
        this.endDate = source.endDate;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filterDimensions = source.filterDimensions;
        this.filters = source.filters;
        this.formName = source.formName;
        this.hideEmptyRowItems = source.hideEmptyRowItems;
        this.hideLegend = source.hideLegend;
        this.hideSubtitle = source.hideSubtitle;
        this.hideTitle = source.hideTitle;
        this.href = source.href;
        this.id = source.id;
        this.interpretations = source.interpretations;
        this.itemOrganisationUnitGroups = source.itemOrganisationUnitGroups;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendDisplayStrategy = source.legendDisplayStrategy;
        this.legendSet = source.legendSet;
        this.name = source.name;
        this.noSpaceBetweenColumns = source.noSpaceBetweenColumns;
        this.orgUnitField = source.orgUnitField;
        this.organisationUnitGroupSetDimensions = source.organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = source.organisationUnitLevels;
        this.organisationUnits = source.organisationUnits;
        this.parentGraphMap = source.parentGraphMap;
        this.percentStackedValues = source.percentStackedValues;
        this.periods = source.periods;
        this.programIndicatorDimensions = source.programIndicatorDimensions;
        this.publicAccess = source.publicAccess;
        this.rangeAxisDecimals = source.rangeAxisDecimals;
        this.rangeAxisLabel = source.rangeAxisLabel;
        this.rangeAxisMaxValue = source.rangeAxisMaxValue;
        this.rangeAxisMinValue = source.rangeAxisMinValue;
        this.rangeAxisSteps = source.rangeAxisSteps;
        this.regressionType = source.regressionType;
        this.relativePeriods = source.relativePeriods;
        this.rows = source.rows;
        this.series = source.series;
        this.seriesItems = source.seriesItems;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.showData = source.showData;
        this.sortOrder = source.sortOrder;
        this.startDate = source.startDate;
        this.subscribed = source.subscribed;
        this.subscribers = source.subscribers;
        this.subtitle = source.subtitle;
        this.targetLineLabel = source.targetLineLabel;
        this.targetLineValue = source.targetLineValue;
        this.timeField = source.timeField;
        this.title = source.title;
        this.topLimit = source.topLimit;
        this.translations = source.translations;
        this.type = source.type;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userOrgUnitType = source.userOrgUnitType;
        this.userOrganisationUnit = source.userOrganisationUnit;
        this.userOrganisationUnitChildren = source.userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = source.userOrganisationUnitGrandChildren;
        this.yearlySeries = source.yearlySeries;
    }

    public Chart(Access access, AggregationType aggregationType, List<TrackedEntityAttributeDimension> attributeDimensions, List<AttributeValue> attributeValues, String baseLineLabel, Double baseLineValue, String category, List<CategoryDimension> categoryDimensions, List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions, String code, List<Object> columns, Boolean completedOnly, Date created, User createdBy, Boolean cumulativeValues, List<DataDimensionItem> dataDimensionItems, List<TrackedEntityDataElementDimension> dataElementDimensions, List<DataElementGroupSetDimension> dataElementGroupSetDimensions, String description, Chart.DigitGroupSeparator digitGroupSeparator, String displayBaseLineLabel, String displayDescription, String displayDomainAxisLabel, String displayFormName, String displayName, String displayRangeAxisLabel, String displayShortName, String displaySubtitle, String displayTargetLineLabel, String displayTitle, String domainAxisLabel, Date endDate, Boolean externalAccess, Boolean favorite, List<String> favorites, List<String> filterDimensions, List<Object> filters, String formName, Chart.HideEmptyItemStrategy hideEmptyRowItems, Boolean hideLegend, Boolean hideSubtitle, Boolean hideTitle, String href, String id, List<Interpretation> interpretations, List<OrganisationUnitGroup> itemOrganisationUnitGroups, Date lastUpdated, User lastUpdatedBy, Chart.LegendDisplayStrategy legendDisplayStrategy, LegendSet legendSet, String name, Boolean noSpaceBetweenColumns, String orgUnitField, List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions, List<Integer> organisationUnitLevels, List<OrganisationUnit> organisationUnits, ParentGraphMap parentGraphMap, Boolean percentStackedValues, List<Period> periods, List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions, String publicAccess, Integer rangeAxisDecimals, String rangeAxisLabel, Double rangeAxisMaxValue, Double rangeAxisMinValue, Integer rangeAxisSteps, Chart.RegressionType regressionType, RelativePeriods relativePeriods, List<Object> rows, String series, List<Series> seriesItems, Sharing sharing, String shortName, Boolean showData, Integer sortOrder, Date startDate, Boolean subscribed, List<String> subscribers, String subtitle, String targetLineLabel, Double targetLineValue, String timeField, String title, Integer topLimit, List<Translation> translations, Chart.ChartType type, User user, List<UserAccess__1> userAccesses, List<UserGroupAccess__1> userGroupAccesses, Chart.UserOrgUnitType userOrgUnitType, Boolean userOrganisationUnit, Boolean userOrganisationUnitChildren, Boolean userOrganisationUnitGrandChildren, List<String> yearlySeries) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.attributeDimensions = attributeDimensions;
        this.attributeValues = attributeValues;
        this.baseLineLabel = baseLineLabel;
        this.baseLineValue = baseLineValue;
        this.category = category;
        this.categoryDimensions = categoryDimensions;
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        this.code = code;
        this.columns = columns;
        this.completedOnly = completedOnly;
        this.created = created;
        this.createdBy = createdBy;
        this.cumulativeValues = cumulativeValues;
        this.dataDimensionItems = dataDimensionItems;
        this.dataElementDimensions = dataElementDimensions;
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        this.description = description;
        this.digitGroupSeparator = digitGroupSeparator;
        this.displayBaseLineLabel = displayBaseLineLabel;
        this.displayDescription = displayDescription;
        this.displayDomainAxisLabel = displayDomainAxisLabel;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayRangeAxisLabel = displayRangeAxisLabel;
        this.displayShortName = displayShortName;
        this.displaySubtitle = displaySubtitle;
        this.displayTargetLineLabel = displayTargetLineLabel;
        this.displayTitle = displayTitle;
        this.domainAxisLabel = domainAxisLabel;
        this.endDate = endDate;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filterDimensions = filterDimensions;
        this.filters = filters;
        this.formName = formName;
        this.hideEmptyRowItems = hideEmptyRowItems;
        this.hideLegend = hideLegend;
        this.hideSubtitle = hideSubtitle;
        this.hideTitle = hideTitle;
        this.href = href;
        this.id = id;
        this.interpretations = interpretations;
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendDisplayStrategy = legendDisplayStrategy;
        this.legendSet = legendSet;
        this.name = name;
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
        this.orgUnitField = orgUnitField;
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = organisationUnitLevels;
        this.organisationUnits = organisationUnits;
        this.parentGraphMap = parentGraphMap;
        this.percentStackedValues = percentStackedValues;
        this.periods = periods;
        this.programIndicatorDimensions = programIndicatorDimensions;
        this.publicAccess = publicAccess;
        this.rangeAxisDecimals = rangeAxisDecimals;
        this.rangeAxisLabel = rangeAxisLabel;
        this.rangeAxisMaxValue = rangeAxisMaxValue;
        this.rangeAxisMinValue = rangeAxisMinValue;
        this.rangeAxisSteps = rangeAxisSteps;
        this.regressionType = regressionType;
        this.relativePeriods = relativePeriods;
        this.rows = rows;
        this.series = series;
        this.seriesItems = seriesItems;
        this.sharing = sharing;
        this.shortName = shortName;
        this.showData = showData;
        this.sortOrder = sortOrder;
        this.startDate = startDate;
        this.subscribed = subscribed;
        this.subscribers = subscribers;
        this.subtitle = subtitle;
        this.targetLineLabel = targetLineLabel;
        this.targetLineValue = targetLineValue;
        this.timeField = timeField;
        this.title = title;
        this.topLimit = topLimit;
        this.translations = translations;
        this.type = type;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.userOrgUnitType = userOrgUnitType;
        this.userOrganisationUnit = userOrganisationUnit;
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
        this.yearlySeries = yearlySeries;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Chart withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public Chart withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeDimensions")
    public Optional<List<TrackedEntityAttributeDimension>> getAttributeDimensions() {
        return Optional.ofNullable(attributeDimensions);
    }

    @JsonProperty("attributeDimensions")
    public void setAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
    }

    public Chart withAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Chart withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("baseLineLabel")
    public Optional<String> getBaseLineLabel() {
        return Optional.ofNullable(baseLineLabel);
    }

    @JsonProperty("baseLineLabel")
    public void setBaseLineLabel(String baseLineLabel) {
        this.baseLineLabel = baseLineLabel;
    }

    public Chart withBaseLineLabel(String baseLineLabel) {
        this.baseLineLabel = baseLineLabel;
        return this;
    }

    @JsonProperty("baseLineValue")
    public Optional<Double> getBaseLineValue() {
        return Optional.ofNullable(baseLineValue);
    }

    @JsonProperty("baseLineValue")
    public void setBaseLineValue(Double baseLineValue) {
        this.baseLineValue = baseLineValue;
    }

    public Chart withBaseLineValue(Double baseLineValue) {
        this.baseLineValue = baseLineValue;
        return this;
    }

    @JsonProperty("category")
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    @JsonProperty("category")
    public void setCategory(String category) {
        this.category = category;
    }

    public Chart withCategory(String category) {
        this.category = category;
        return this;
    }

    @JsonProperty("categoryDimensions")
    public Optional<List<CategoryDimension>> getCategoryDimensions() {
        return Optional.ofNullable(categoryDimensions);
    }

    @JsonProperty("categoryDimensions")
    public void setCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
    }

    public Chart withCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
        return this;
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public Optional<List<CategoryOptionGroupSetDimension>> getCategoryOptionGroupSetDimensions() {
        return Optional.ofNullable(categoryOptionGroupSetDimensions);
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public void setCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
    }

    public Chart withCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Chart withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("columns")
    public Optional<List<Object>> getColumns() {
        return Optional.ofNullable(columns);
    }

    @JsonProperty("columns")
    public void setColumns(List<Object> columns) {
        this.columns = columns;
    }

    public Chart withColumns(List<Object> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty("completedOnly")
    public Optional<Boolean> getCompletedOnly() {
        return Optional.ofNullable(completedOnly);
    }

    @JsonProperty("completedOnly")
    public void setCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
    }

    public Chart withCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Chart withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Chart withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("cumulativeValues")
    public Optional<Boolean> getCumulativeValues() {
        return Optional.ofNullable(cumulativeValues);
    }

    @JsonProperty("cumulativeValues")
    public void setCumulativeValues(Boolean cumulativeValues) {
        this.cumulativeValues = cumulativeValues;
    }

    public Chart withCumulativeValues(Boolean cumulativeValues) {
        this.cumulativeValues = cumulativeValues;
        return this;
    }

    @JsonProperty("dataDimensionItems")
    public Optional<List<DataDimensionItem>> getDataDimensionItems() {
        return Optional.ofNullable(dataDimensionItems);
    }

    @JsonProperty("dataDimensionItems")
    public void setDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
    }

    public Chart withDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
        return this;
    }

    @JsonProperty("dataElementDimensions")
    public Optional<List<TrackedEntityDataElementDimension>> getDataElementDimensions() {
        return Optional.ofNullable(dataElementDimensions);
    }

    @JsonProperty("dataElementDimensions")
    public void setDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
    }

    public Chart withDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
        return this;
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public Optional<List<DataElementGroupSetDimension>> getDataElementGroupSetDimensions() {
        return Optional.ofNullable(dataElementGroupSetDimensions);
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public void setDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
    }

    public Chart withDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Chart withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("digitGroupSeparator")
    public Optional<Chart.DigitGroupSeparator> getDigitGroupSeparator() {
        return Optional.ofNullable(digitGroupSeparator);
    }

    @JsonProperty("digitGroupSeparator")
    public void setDigitGroupSeparator(Chart.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
    }

    public Chart withDigitGroupSeparator(Chart.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
        return this;
    }

    @JsonProperty("displayBaseLineLabel")
    public Optional<String> getDisplayBaseLineLabel() {
        return Optional.ofNullable(displayBaseLineLabel);
    }

    @JsonProperty("displayBaseLineLabel")
    public void setDisplayBaseLineLabel(String displayBaseLineLabel) {
        this.displayBaseLineLabel = displayBaseLineLabel;
    }

    public Chart withDisplayBaseLineLabel(String displayBaseLineLabel) {
        this.displayBaseLineLabel = displayBaseLineLabel;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public Chart withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayDomainAxisLabel")
    public Optional<String> getDisplayDomainAxisLabel() {
        return Optional.ofNullable(displayDomainAxisLabel);
    }

    @JsonProperty("displayDomainAxisLabel")
    public void setDisplayDomainAxisLabel(String displayDomainAxisLabel) {
        this.displayDomainAxisLabel = displayDomainAxisLabel;
    }

    public Chart withDisplayDomainAxisLabel(String displayDomainAxisLabel) {
        this.displayDomainAxisLabel = displayDomainAxisLabel;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public Chart withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Chart withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayRangeAxisLabel")
    public Optional<String> getDisplayRangeAxisLabel() {
        return Optional.ofNullable(displayRangeAxisLabel);
    }

    @JsonProperty("displayRangeAxisLabel")
    public void setDisplayRangeAxisLabel(String displayRangeAxisLabel) {
        this.displayRangeAxisLabel = displayRangeAxisLabel;
    }

    public Chart withDisplayRangeAxisLabel(String displayRangeAxisLabel) {
        this.displayRangeAxisLabel = displayRangeAxisLabel;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public Chart withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("displaySubtitle")
    public Optional<String> getDisplaySubtitle() {
        return Optional.ofNullable(displaySubtitle);
    }

    @JsonProperty("displaySubtitle")
    public void setDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
    }

    public Chart withDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
        return this;
    }

    @JsonProperty("displayTargetLineLabel")
    public Optional<String> getDisplayTargetLineLabel() {
        return Optional.ofNullable(displayTargetLineLabel);
    }

    @JsonProperty("displayTargetLineLabel")
    public void setDisplayTargetLineLabel(String displayTargetLineLabel) {
        this.displayTargetLineLabel = displayTargetLineLabel;
    }

    public Chart withDisplayTargetLineLabel(String displayTargetLineLabel) {
        this.displayTargetLineLabel = displayTargetLineLabel;
        return this;
    }

    @JsonProperty("displayTitle")
    public Optional<String> getDisplayTitle() {
        return Optional.ofNullable(displayTitle);
    }

    @JsonProperty("displayTitle")
    public void setDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
    }

    public Chart withDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
        return this;
    }

    @JsonProperty("domainAxisLabel")
    public Optional<String> getDomainAxisLabel() {
        return Optional.ofNullable(domainAxisLabel);
    }

    @JsonProperty("domainAxisLabel")
    public void setDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
    }

    public Chart withDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Chart withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Chart withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Chart withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Chart withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filterDimensions")
    public Optional<List<String>> getFilterDimensions() {
        return Optional.ofNullable(filterDimensions);
    }

    @JsonProperty("filterDimensions")
    public void setFilterDimensions(List<String> filterDimensions) {
        this.filterDimensions = filterDimensions;
    }

    public Chart withFilterDimensions(List<String> filterDimensions) {
        this.filterDimensions = filterDimensions;
        return this;
    }

    @JsonProperty("filters")
    public Optional<List<Object>> getFilters() {
        return Optional.ofNullable(filters);
    }

    @JsonProperty("filters")
    public void setFilters(List<Object> filters) {
        this.filters = filters;
    }

    public Chart withFilters(List<Object> filters) {
        this.filters = filters;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Chart withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("hideEmptyRowItems")
    public Optional<Chart.HideEmptyItemStrategy> getHideEmptyRowItems() {
        return Optional.ofNullable(hideEmptyRowItems);
    }

    @JsonProperty("hideEmptyRowItems")
    public void setHideEmptyRowItems(Chart.HideEmptyItemStrategy hideEmptyRowItems) {
        this.hideEmptyRowItems = hideEmptyRowItems;
    }

    public Chart withHideEmptyRowItems(Chart.HideEmptyItemStrategy hideEmptyRowItems) {
        this.hideEmptyRowItems = hideEmptyRowItems;
        return this;
    }

    @JsonProperty("hideLegend")
    public Optional<Boolean> getHideLegend() {
        return Optional.ofNullable(hideLegend);
    }

    @JsonProperty("hideLegend")
    public void setHideLegend(Boolean hideLegend) {
        this.hideLegend = hideLegend;
    }

    public Chart withHideLegend(Boolean hideLegend) {
        this.hideLegend = hideLegend;
        return this;
    }

    @JsonProperty("hideSubtitle")
    public Optional<Boolean> getHideSubtitle() {
        return Optional.ofNullable(hideSubtitle);
    }

    @JsonProperty("hideSubtitle")
    public void setHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
    }

    public Chart withHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
        return this;
    }

    @JsonProperty("hideTitle")
    public Optional<Boolean> getHideTitle() {
        return Optional.ofNullable(hideTitle);
    }

    @JsonProperty("hideTitle")
    public void setHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    public Chart withHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Chart withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Chart withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("interpretations")
    public Optional<List<Interpretation>> getInterpretations() {
        return Optional.ofNullable(interpretations);
    }

    @JsonProperty("interpretations")
    public void setInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
    }

    public Chart withInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
        return this;
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public Optional<List<OrganisationUnitGroup>> getItemOrganisationUnitGroups() {
        return Optional.ofNullable(itemOrganisationUnitGroups);
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public void setItemOrganisationUnitGroups(List<OrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
    }

    public Chart withItemOrganisationUnitGroups(List<OrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Chart withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Chart withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legendDisplayStrategy")
    public Optional<Chart.LegendDisplayStrategy> getLegendDisplayStrategy() {
        return Optional.ofNullable(legendDisplayStrategy);
    }

    @JsonProperty("legendDisplayStrategy")
    public void setLegendDisplayStrategy(Chart.LegendDisplayStrategy legendDisplayStrategy) {
        this.legendDisplayStrategy = legendDisplayStrategy;
    }

    public Chart withLegendDisplayStrategy(Chart.LegendDisplayStrategy legendDisplayStrategy) {
        this.legendDisplayStrategy = legendDisplayStrategy;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public Chart withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Chart withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("noSpaceBetweenColumns")
    public Optional<Boolean> getNoSpaceBetweenColumns() {
        return Optional.ofNullable(noSpaceBetweenColumns);
    }

    @JsonProperty("noSpaceBetweenColumns")
    public void setNoSpaceBetweenColumns(Boolean noSpaceBetweenColumns) {
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
    }

    public Chart withNoSpaceBetweenColumns(Boolean noSpaceBetweenColumns) {
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
        return this;
    }

    @JsonProperty("orgUnitField")
    public Optional<String> getOrgUnitField() {
        return Optional.ofNullable(orgUnitField);
    }

    @JsonProperty("orgUnitField")
    public void setOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
    }

    public Chart withOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
        return this;
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public Optional<List<OrganisationUnitGroupSetDimension>> getOrganisationUnitGroupSetDimensions() {
        return Optional.ofNullable(organisationUnitGroupSetDimensions);
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public void setOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
    }

    public Chart withOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        return this;
    }

    @JsonProperty("organisationUnitLevels")
    public Optional<List<Integer>> getOrganisationUnitLevels() {
        return Optional.ofNullable(organisationUnitLevels);
    }

    @JsonProperty("organisationUnitLevels")
    public void setOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
    }

    public Chart withOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public Chart withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    public Optional<ParentGraphMap> getParentGraphMap() {
        return Optional.ofNullable(parentGraphMap);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    public void setParentGraphMap(ParentGraphMap parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
    }

    public Chart withParentGraphMap(ParentGraphMap parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
        return this;
    }

    @JsonProperty("percentStackedValues")
    public Optional<Boolean> getPercentStackedValues() {
        return Optional.ofNullable(percentStackedValues);
    }

    @JsonProperty("percentStackedValues")
    public void setPercentStackedValues(Boolean percentStackedValues) {
        this.percentStackedValues = percentStackedValues;
    }

    public Chart withPercentStackedValues(Boolean percentStackedValues) {
        this.percentStackedValues = percentStackedValues;
        return this;
    }

    @JsonProperty("periods")
    public Optional<List<Period>> getPeriods() {
        return Optional.ofNullable(periods);
    }

    @JsonProperty("periods")
    public void setPeriods(List<Period> periods) {
        this.periods = periods;
    }

    public Chart withPeriods(List<Period> periods) {
        this.periods = periods;
        return this;
    }

    @JsonProperty("programIndicatorDimensions")
    public Optional<List<TrackedEntityProgramIndicatorDimension>> getProgramIndicatorDimensions() {
        return Optional.ofNullable(programIndicatorDimensions);
    }

    @JsonProperty("programIndicatorDimensions")
    public void setProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
    }

    public Chart withProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Chart withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("rangeAxisDecimals")
    public Optional<Integer> getRangeAxisDecimals() {
        return Optional.ofNullable(rangeAxisDecimals);
    }

    @JsonProperty("rangeAxisDecimals")
    public void setRangeAxisDecimals(Integer rangeAxisDecimals) {
        this.rangeAxisDecimals = rangeAxisDecimals;
    }

    public Chart withRangeAxisDecimals(Integer rangeAxisDecimals) {
        this.rangeAxisDecimals = rangeAxisDecimals;
        return this;
    }

    @JsonProperty("rangeAxisLabel")
    public Optional<String> getRangeAxisLabel() {
        return Optional.ofNullable(rangeAxisLabel);
    }

    @JsonProperty("rangeAxisLabel")
    public void setRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
    }

    public Chart withRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
        return this;
    }

    @JsonProperty("rangeAxisMaxValue")
    public Optional<Double> getRangeAxisMaxValue() {
        return Optional.ofNullable(rangeAxisMaxValue);
    }

    @JsonProperty("rangeAxisMaxValue")
    public void setRangeAxisMaxValue(Double rangeAxisMaxValue) {
        this.rangeAxisMaxValue = rangeAxisMaxValue;
    }

    public Chart withRangeAxisMaxValue(Double rangeAxisMaxValue) {
        this.rangeAxisMaxValue = rangeAxisMaxValue;
        return this;
    }

    @JsonProperty("rangeAxisMinValue")
    public Optional<Double> getRangeAxisMinValue() {
        return Optional.ofNullable(rangeAxisMinValue);
    }

    @JsonProperty("rangeAxisMinValue")
    public void setRangeAxisMinValue(Double rangeAxisMinValue) {
        this.rangeAxisMinValue = rangeAxisMinValue;
    }

    public Chart withRangeAxisMinValue(Double rangeAxisMinValue) {
        this.rangeAxisMinValue = rangeAxisMinValue;
        return this;
    }

    @JsonProperty("rangeAxisSteps")
    public Optional<Integer> getRangeAxisSteps() {
        return Optional.ofNullable(rangeAxisSteps);
    }

    @JsonProperty("rangeAxisSteps")
    public void setRangeAxisSteps(Integer rangeAxisSteps) {
        this.rangeAxisSteps = rangeAxisSteps;
    }

    public Chart withRangeAxisSteps(Integer rangeAxisSteps) {
        this.rangeAxisSteps = rangeAxisSteps;
        return this;
    }

    @JsonProperty("regressionType")
    public Optional<Chart.RegressionType> getRegressionType() {
        return Optional.ofNullable(regressionType);
    }

    @JsonProperty("regressionType")
    public void setRegressionType(Chart.RegressionType regressionType) {
        this.regressionType = regressionType;
    }

    public Chart withRegressionType(Chart.RegressionType regressionType) {
        this.regressionType = regressionType;
        return this;
    }

    @JsonProperty("relativePeriods")
    public Optional<RelativePeriods> getRelativePeriods() {
        return Optional.ofNullable(relativePeriods);
    }

    @JsonProperty("relativePeriods")
    public void setRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
    }

    public Chart withRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
        return this;
    }

    @JsonProperty("rows")
    public Optional<List<Object>> getRows() {
        return Optional.ofNullable(rows);
    }

    @JsonProperty("rows")
    public void setRows(List<Object> rows) {
        this.rows = rows;
    }

    public Chart withRows(List<Object> rows) {
        this.rows = rows;
        return this;
    }

    @JsonProperty("series")
    public Optional<String> getSeries() {
        return Optional.ofNullable(series);
    }

    @JsonProperty("series")
    public void setSeries(String series) {
        this.series = series;
    }

    public Chart withSeries(String series) {
        this.series = series;
        return this;
    }

    @JsonProperty("seriesItems")
    public Optional<List<Series>> getSeriesItems() {
        return Optional.ofNullable(seriesItems);
    }

    @JsonProperty("seriesItems")
    public void setSeriesItems(List<Series> seriesItems) {
        this.seriesItems = seriesItems;
    }

    public Chart withSeriesItems(List<Series> seriesItems) {
        this.seriesItems = seriesItems;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Chart withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Chart withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("showData")
    public Optional<Boolean> getShowData() {
        return Optional.ofNullable(showData);
    }

    @JsonProperty("showData")
    public void setShowData(Boolean showData) {
        this.showData = showData;
    }

    public Chart withShowData(Boolean showData) {
        this.showData = showData;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Chart withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Chart withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("subscribed")
    public Optional<Boolean> getSubscribed() {
        return Optional.ofNullable(subscribed);
    }

    @JsonProperty("subscribed")
    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    public Chart withSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
        return this;
    }

    @JsonProperty("subscribers")
    public Optional<List<String>> getSubscribers() {
        return Optional.ofNullable(subscribers);
    }

    @JsonProperty("subscribers")
    public void setSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
    }

    public Chart withSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
        return this;
    }

    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return Optional.ofNullable(subtitle);
    }

    @JsonProperty("subtitle")
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public Chart withSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @JsonProperty("targetLineLabel")
    public Optional<String> getTargetLineLabel() {
        return Optional.ofNullable(targetLineLabel);
    }

    @JsonProperty("targetLineLabel")
    public void setTargetLineLabel(String targetLineLabel) {
        this.targetLineLabel = targetLineLabel;
    }

    public Chart withTargetLineLabel(String targetLineLabel) {
        this.targetLineLabel = targetLineLabel;
        return this;
    }

    @JsonProperty("targetLineValue")
    public Optional<Double> getTargetLineValue() {
        return Optional.ofNullable(targetLineValue);
    }

    @JsonProperty("targetLineValue")
    public void setTargetLineValue(Double targetLineValue) {
        this.targetLineValue = targetLineValue;
    }

    public Chart withTargetLineValue(Double targetLineValue) {
        this.targetLineValue = targetLineValue;
        return this;
    }

    @JsonProperty("timeField")
    public Optional<String> getTimeField() {
        return Optional.ofNullable(timeField);
    }

    @JsonProperty("timeField")
    public void setTimeField(String timeField) {
        this.timeField = timeField;
    }

    public Chart withTimeField(String timeField) {
        this.timeField = timeField;
        return this;
    }

    @JsonProperty("title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    public Chart withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty("topLimit")
    public Optional<Integer> getTopLimit() {
        return Optional.ofNullable(topLimit);
    }

    @JsonProperty("topLimit")
    public void setTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
    }

    public Chart withTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Chart withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("type")
    public Optional<Chart.ChartType> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(Chart.ChartType type) {
        this.type = type;
    }

    public Chart withType(Chart.ChartType type) {
        this.type = type;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public Chart withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess__1>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess__1> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Chart withUserAccesses(List<UserAccess__1> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess__1>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess__1> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Chart withUserGroupAccesses(List<UserGroupAccess__1> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userOrgUnitType")
    public Optional<Chart.UserOrgUnitType> getUserOrgUnitType() {
        return Optional.ofNullable(userOrgUnitType);
    }

    @JsonProperty("userOrgUnitType")
    public void setUserOrgUnitType(Chart.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
    }

    public Chart withUserOrgUnitType(Chart.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
        return this;
    }

    @JsonProperty("userOrganisationUnit")
    public Optional<Boolean> getUserOrganisationUnit() {
        return Optional.ofNullable(userOrganisationUnit);
    }

    @JsonProperty("userOrganisationUnit")
    public void setUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
    }

    public Chart withUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
        return this;
    }

    @JsonProperty("userOrganisationUnitChildren")
    public Optional<Boolean> getUserOrganisationUnitChildren() {
        return Optional.ofNullable(userOrganisationUnitChildren);
    }

    @JsonProperty("userOrganisationUnitChildren")
    public void setUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
    }

    public Chart withUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        return this;
    }

    @JsonProperty("userOrganisationUnitGrandChildren")
    public Optional<Boolean> getUserOrganisationUnitGrandChildren() {
        return Optional.ofNullable(userOrganisationUnitGrandChildren);
    }

    @JsonProperty("userOrganisationUnitGrandChildren")
    public void setUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
    }

    public Chart withUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
        return this;
    }

    @JsonProperty("yearlySeries")
    public Optional<List<String>> getYearlySeries() {
        return Optional.ofNullable(yearlySeries);
    }

    @JsonProperty("yearlySeries")
    public void setYearlySeries(List<String> yearlySeries) {
        this.yearlySeries = yearlySeries;
    }

    public Chart withYearlySeries(List<String> yearlySeries) {
        this.yearlySeries = yearlySeries;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Chart withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_36_11.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("aggregationType".equals(name)) {
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_36_11.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeDimensions".equals(name)) {
                    if (value instanceof List) {
                        setAttributeDimensions(((List<TrackedEntityAttributeDimension> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.TrackedEntityAttributeDimension>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("attributeValues".equals(name)) {
                        if (value instanceof List) {
                            setAttributeValues(((List<AttributeValue> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.AttributeValue>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("baseLineLabel".equals(name)) {
                            if (value instanceof String) {
                                setBaseLineLabel(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"baseLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("baseLineValue".equals(name)) {
                                if (value instanceof Double) {
                                    setBaseLineValue(((Double) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"baseLineValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("category".equals(name)) {
                                    if (value instanceof String) {
                                        setCategory(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"category\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("categoryDimensions".equals(name)) {
                                        if (value instanceof List) {
                                            setCategoryDimensions(((List<CategoryDimension> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"categoryDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.CategoryDimension>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("categoryOptionGroupSetDimensions".equals(name)) {
                                            if (value instanceof List) {
                                                setCategoryOptionGroupSetDimensions(((List<CategoryOptionGroupSetDimension> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"categoryOptionGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.CategoryOptionGroupSetDimension>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("code".equals(name)) {
                                                if (value instanceof String) {
                                                    setCode(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("columns".equals(name)) {
                                                    if (value instanceof List) {
                                                        setColumns(((List<Object> ) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"columns\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("completedOnly".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setCompletedOnly(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"completedOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("created".equals(name)) {
                                                            if (value instanceof Date) {
                                                                setCreated(((Date) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("createdBy".equals(name)) {
                                                                if (value instanceof User) {
                                                                    setCreatedBy(((User) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_36_11.User\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("cumulativeValues".equals(name)) {
                                                                    if (value instanceof Boolean) {
                                                                        setCumulativeValues(((Boolean) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"cumulativeValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("dataDimensionItems".equals(name)) {
                                                                        if (value instanceof List) {
                                                                            setDataDimensionItems(((List<DataDimensionItem> ) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"dataDimensionItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.DataDimensionItem>\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("dataElementDimensions".equals(name)) {
                                                                            if (value instanceof List) {
                                                                                setDataElementDimensions(((List<TrackedEntityDataElementDimension> ) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"dataElementDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.TrackedEntityDataElementDimension>\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("dataElementGroupSetDimensions".equals(name)) {
                                                                                if (value instanceof List) {
                                                                                    setDataElementGroupSetDimensions(((List<DataElementGroupSetDimension> ) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"dataElementGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.DataElementGroupSetDimension>\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("description".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setDescription(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("digitGroupSeparator".equals(name)) {
                                                                                        if (value instanceof Chart.DigitGroupSeparator) {
                                                                                            setDigitGroupSeparator(((Chart.DigitGroupSeparator) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"digitGroupSeparator\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.DigitGroupSeparator\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("displayBaseLineLabel".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setDisplayBaseLineLabel(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"displayBaseLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("displayDescription".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setDisplayDescription(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("displayDomainAxisLabel".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setDisplayDomainAxisLabel(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"displayDomainAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("displayFormName".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setDisplayFormName(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("displayName".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setDisplayName(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("displayRangeAxisLabel".equals(name)) {
                                                                                                                if (value instanceof String) {
                                                                                                                    setDisplayRangeAxisLabel(((String) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"displayRangeAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("displayShortName".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setDisplayShortName(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("displaySubtitle".equals(name)) {
                                                                                                                        if (value instanceof String) {
                                                                                                                            setDisplaySubtitle(((String) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"displaySubtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("displayTargetLineLabel".equals(name)) {
                                                                                                                            if (value instanceof String) {
                                                                                                                                setDisplayTargetLineLabel(((String) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"displayTargetLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("displayTitle".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setDisplayTitle(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"displayTitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("domainAxisLabel".equals(name)) {
                                                                                                                                    if (value instanceof String) {
                                                                                                                                        setDomainAxisLabel(((String) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"domainAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("endDate".equals(name)) {
                                                                                                                                        if (value instanceof Date) {
                                                                                                                                            setEndDate(((Date) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("externalAccess".equals(name)) {
                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                setExternalAccess(((Boolean) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("favorite".equals(name)) {
                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                    setFavorite(((Boolean) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("favorites".equals(name)) {
                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                        setFavorites(((List<String> ) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("filterDimensions".equals(name)) {
                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                            setFilterDimensions(((List<String> ) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"filterDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("filters".equals(name)) {
                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                setFilters(((List<Object> ) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"filters\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("formName".equals(name)) {
                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                    setFormName(((String) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("hideEmptyRowItems".equals(name)) {
                                                                                                                                                                    if (value instanceof Chart.HideEmptyItemStrategy) {
                                                                                                                                                                        setHideEmptyRowItems(((Chart.HideEmptyItemStrategy) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"hideEmptyRowItems\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.HideEmptyItemStrategy\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("hideLegend".equals(name)) {
                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                            setHideLegend(((Boolean) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"hideLegend\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("hideSubtitle".equals(name)) {
                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                setHideSubtitle(((Boolean) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"hideSubtitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("hideTitle".equals(name)) {
                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                    setHideTitle(((Boolean) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"hideTitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("href".equals(name)) {
                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                        setHref(((String) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("id".equals(name)) {
                                                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                                                            setId(((String) value));
                                                                                                                                                                                        } else {
                                                                                                                                                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                        }
                                                                                                                                                                                        return true;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("interpretations".equals(name)) {
                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                setInterpretations(((List<Interpretation> ) value));
                                                                                                                                                                                            } else {
                                                                                                                                                                                                throw new IllegalArgumentException(("property \"interpretations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Interpretation>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                            }
                                                                                                                                                                                            return true;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("itemOrganisationUnitGroups".equals(name)) {
                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                    setItemOrganisationUnitGroups(((List<OrganisationUnitGroup> ) value));
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"itemOrganisationUnitGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.OrganisationUnitGroup>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                }
                                                                                                                                                                                                return true;
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                                                                                                                    if (value instanceof Date) {
                                                                                                                                                                                                        setLastUpdated(((Date) value));
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                    }
                                                                                                                                                                                                    return true;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                                                                                                                                        if (value instanceof User) {
                                                                                                                                                                                                            setLastUpdatedBy(((User) value));
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_36_11.User\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                        }
                                                                                                                                                                                                        return true;
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("legendDisplayStrategy".equals(name)) {
                                                                                                                                                                                                            if (value instanceof Chart.LegendDisplayStrategy) {
                                                                                                                                                                                                                setLegendDisplayStrategy(((Chart.LegendDisplayStrategy) value));
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"legendDisplayStrategy\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.LegendDisplayStrategy\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                            }
                                                                                                                                                                                                            return true;
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("legendSet".equals(name)) {
                                                                                                                                                                                                                if (value instanceof LegendSet) {
                                                                                                                                                                                                                    setLegendSet(((LegendSet) value));
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_36_11.LegendSet\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                }
                                                                                                                                                                                                                return true;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("name".equals(name)) {
                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                        setName(((String) value));
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("noSpaceBetweenColumns".equals(name)) {
                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                            setNoSpaceBetweenColumns(((Boolean) value));
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"noSpaceBetweenColumns\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("orgUnitField".equals(name)) {
                                                                                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                                                                                setOrgUnitField(((String) value));
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"orgUnitField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("organisationUnitGroupSetDimensions".equals(name)) {
                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                    setOrganisationUnitGroupSetDimensions(((List<OrganisationUnitGroupSetDimension> ) value));
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"organisationUnitGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.OrganisationUnitGroupSetDimension>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("organisationUnitLevels".equals(name)) {
                                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                                        setOrganisationUnitLevels(((List<Integer> ) value));
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"organisationUnitLevels\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("organisationUnits".equals(name)) {
                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                            setOrganisationUnits(((List<OrganisationUnit> ) value));
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.OrganisationUnit>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("parentGraphMap".equals(name)) {
                                                                                                                                                                                                                                            if (value instanceof ParentGraphMap) {
                                                                                                                                                                                                                                                setParentGraphMap(((ParentGraphMap) value));
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"parentGraphMap\" is of type \"org.hisp.dhis.api.model.v2_36_11.ParentGraphMap\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if ("percentStackedValues".equals(name)) {
                                                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                                                    setPercentStackedValues(((Boolean) value));
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"percentStackedValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                if ("periods".equals(name)) {
                                                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                                                        setPeriods(((List<Period> ) value));
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"periods\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Period>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    if ("programIndicatorDimensions".equals(name)) {
                                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                                            setProgramIndicatorDimensions(((List<TrackedEntityProgramIndicatorDimension> ) value));
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"programIndicatorDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.TrackedEntityProgramIndicatorDimension>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                                                                                                                setPublicAccess(((String) value));
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            if ("rangeAxisDecimals".equals(name)) {
                                                                                                                                                                                                                                                                if (value instanceof Integer) {
                                                                                                                                                                                                                                                                    setRangeAxisDecimals(((Integer) value));
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"rangeAxisDecimals\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                if ("rangeAxisLabel".equals(name)) {
                                                                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                                                                        setRangeAxisLabel(((String) value));
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"rangeAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    if ("rangeAxisMaxValue".equals(name)) {
                                                                                                                                                                                                                                                                        if (value instanceof Double) {
                                                                                                                                                                                                                                                                            setRangeAxisMaxValue(((Double) value));
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"rangeAxisMaxValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        if ("rangeAxisMinValue".equals(name)) {
                                                                                                                                                                                                                                                                            if (value instanceof Double) {
                                                                                                                                                                                                                                                                                setRangeAxisMinValue(((Double) value));
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"rangeAxisMinValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            if ("rangeAxisSteps".equals(name)) {
                                                                                                                                                                                                                                                                                if (value instanceof Integer) {
                                                                                                                                                                                                                                                                                    setRangeAxisSteps(((Integer) value));
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"rangeAxisSteps\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                if ("regressionType".equals(name)) {
                                                                                                                                                                                                                                                                                    if (value instanceof Chart.RegressionType) {
                                                                                                                                                                                                                                                                                        setRegressionType(((Chart.RegressionType) value));
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"regressionType\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.RegressionType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    if ("relativePeriods".equals(name)) {
                                                                                                                                                                                                                                                                                        if (value instanceof RelativePeriods) {
                                                                                                                                                                                                                                                                                            setRelativePeriods(((RelativePeriods) value));
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"relativePeriods\" is of type \"org.hisp.dhis.api.model.v2_36_11.RelativePeriods\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        if ("rows".equals(name)) {
                                                                                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                                                                                setRows(((List<Object> ) value));
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"rows\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            if ("series".equals(name)) {
                                                                                                                                                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                                                                                                                                                    setSeries(((String) value));
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"series\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                if ("seriesItems".equals(name)) {
                                                                                                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                                                                                                        setSeriesItems(((List<Series> ) value));
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"seriesItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Series>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                                                                                                                                                                                        if (value instanceof Sharing) {
                                                                                                                                                                                                                                                                                                            setSharing(((Sharing) value));
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_36_11.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        if ("shortName".equals(name)) {
                                                                                                                                                                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                setShortName(((String) value));
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            if ("showData".equals(name)) {
                                                                                                                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                    setShowData(((Boolean) value));
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"showData\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                if ("sortOrder".equals(name)) {
                                                                                                                                                                                                                                                                                                                    if (value instanceof Integer) {
                                                                                                                                                                                                                                                                                                                        setSortOrder(((Integer) value));
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    if ("startDate".equals(name)) {
                                                                                                                                                                                                                                                                                                                        if (value instanceof Date) {
                                                                                                                                                                                                                                                                                                                            setStartDate(((Date) value));
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        if ("subscribed".equals(name)) {
                                                                                                                                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                setSubscribed(((Boolean) value));
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"subscribed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            if ("subscribers".equals(name)) {
                                                                                                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                    setSubscribers(((List<String> ) value));
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"subscribers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                if ("subtitle".equals(name)) {
                                                                                                                                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                        setSubtitle(((String) value));
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"subtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    if ("targetLineLabel".equals(name)) {
                                                                                                                                                                                                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                            setTargetLineLabel(((String) value));
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"targetLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        if ("targetLineValue".equals(name)) {
                                                                                                                                                                                                                                                                                                                                            if (value instanceof Double) {
                                                                                                                                                                                                                                                                                                                                                setTargetLineValue(((Double) value));
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"targetLineValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            if ("timeField".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                                    setTimeField(((String) value));
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"timeField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                if ("title".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                                        setTitle(((String) value));
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"title\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    if ("topLimit".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                        if (value instanceof Integer) {
                                                                                                                                                                                                                                                                                                                                                            setTopLimit(((Integer) value));
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"topLimit\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                setTranslations(((List<Translation> ) value));
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            if ("type".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                if (value instanceof Chart.ChartType) {
                                                                                                                                                                                                                                                                                                                                                                    setType(((Chart.ChartType) value));
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.ChartType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                if ("user".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof User) {
                                                                                                                                                                                                                                                                                                                                                                        setUser(((User) value));
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_36_11.User\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                            setUserAccesses(((List<UserAccess__1> ) value));
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.UserAccess__1>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                                setUserGroupAccesses(((List<UserGroupAccess__1> ) value));
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.UserGroupAccess__1>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            if ("userOrgUnitType".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof Chart.UserOrgUnitType) {
                                                                                                                                                                                                                                                                                                                                                                                    setUserOrgUnitType(((Chart.UserOrgUnitType) value));
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"userOrgUnitType\" is of type \"org.hisp.dhis.api.model.v2_36_11.Chart.UserOrgUnitType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                if ("userOrganisationUnit".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                        setUserOrganisationUnit(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"userOrganisationUnit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    if ("userOrganisationUnitChildren".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                            setUserOrganisationUnitChildren(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"userOrganisationUnitChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        if ("userOrganisationUnitGrandChildren".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                                setUserOrganisationUnitGrandChildren(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"userOrganisationUnitGrandChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            if ("yearlySeries".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                                                    setYearlySeries(((List<String> ) value));
                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"yearlySeries\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("aggregationType".equals(name)) {
                return getAggregationType();
            } else {
                if ("attributeDimensions".equals(name)) {
                    return getAttributeDimensions();
                } else {
                    if ("attributeValues".equals(name)) {
                        return getAttributeValues();
                    } else {
                        if ("baseLineLabel".equals(name)) {
                            return getBaseLineLabel();
                        } else {
                            if ("baseLineValue".equals(name)) {
                                return getBaseLineValue();
                            } else {
                                if ("category".equals(name)) {
                                    return getCategory();
                                } else {
                                    if ("categoryDimensions".equals(name)) {
                                        return getCategoryDimensions();
                                    } else {
                                        if ("categoryOptionGroupSetDimensions".equals(name)) {
                                            return getCategoryOptionGroupSetDimensions();
                                        } else {
                                            if ("code".equals(name)) {
                                                return getCode();
                                            } else {
                                                if ("columns".equals(name)) {
                                                    return getColumns();
                                                } else {
                                                    if ("completedOnly".equals(name)) {
                                                        return getCompletedOnly();
                                                    } else {
                                                        if ("created".equals(name)) {
                                                            return getCreated();
                                                        } else {
                                                            if ("createdBy".equals(name)) {
                                                                return getCreatedBy();
                                                            } else {
                                                                if ("cumulativeValues".equals(name)) {
                                                                    return getCumulativeValues();
                                                                } else {
                                                                    if ("dataDimensionItems".equals(name)) {
                                                                        return getDataDimensionItems();
                                                                    } else {
                                                                        if ("dataElementDimensions".equals(name)) {
                                                                            return getDataElementDimensions();
                                                                        } else {
                                                                            if ("dataElementGroupSetDimensions".equals(name)) {
                                                                                return getDataElementGroupSetDimensions();
                                                                            } else {
                                                                                if ("description".equals(name)) {
                                                                                    return getDescription();
                                                                                } else {
                                                                                    if ("digitGroupSeparator".equals(name)) {
                                                                                        return getDigitGroupSeparator();
                                                                                    } else {
                                                                                        if ("displayBaseLineLabel".equals(name)) {
                                                                                            return getDisplayBaseLineLabel();
                                                                                        } else {
                                                                                            if ("displayDescription".equals(name)) {
                                                                                                return getDisplayDescription();
                                                                                            } else {
                                                                                                if ("displayDomainAxisLabel".equals(name)) {
                                                                                                    return getDisplayDomainAxisLabel();
                                                                                                } else {
                                                                                                    if ("displayFormName".equals(name)) {
                                                                                                        return getDisplayFormName();
                                                                                                    } else {
                                                                                                        if ("displayName".equals(name)) {
                                                                                                            return getDisplayName();
                                                                                                        } else {
                                                                                                            if ("displayRangeAxisLabel".equals(name)) {
                                                                                                                return getDisplayRangeAxisLabel();
                                                                                                            } else {
                                                                                                                if ("displayShortName".equals(name)) {
                                                                                                                    return getDisplayShortName();
                                                                                                                } else {
                                                                                                                    if ("displaySubtitle".equals(name)) {
                                                                                                                        return getDisplaySubtitle();
                                                                                                                    } else {
                                                                                                                        if ("displayTargetLineLabel".equals(name)) {
                                                                                                                            return getDisplayTargetLineLabel();
                                                                                                                        } else {
                                                                                                                            if ("displayTitle".equals(name)) {
                                                                                                                                return getDisplayTitle();
                                                                                                                            } else {
                                                                                                                                if ("domainAxisLabel".equals(name)) {
                                                                                                                                    return getDomainAxisLabel();
                                                                                                                                } else {
                                                                                                                                    if ("endDate".equals(name)) {
                                                                                                                                        return getEndDate();
                                                                                                                                    } else {
                                                                                                                                        if ("externalAccess".equals(name)) {
                                                                                                                                            return getExternalAccess();
                                                                                                                                        } else {
                                                                                                                                            if ("favorite".equals(name)) {
                                                                                                                                                return getFavorite();
                                                                                                                                            } else {
                                                                                                                                                if ("favorites".equals(name)) {
                                                                                                                                                    return getFavorites();
                                                                                                                                                } else {
                                                                                                                                                    if ("filterDimensions".equals(name)) {
                                                                                                                                                        return getFilterDimensions();
                                                                                                                                                    } else {
                                                                                                                                                        if ("filters".equals(name)) {
                                                                                                                                                            return getFilters();
                                                                                                                                                        } else {
                                                                                                                                                            if ("formName".equals(name)) {
                                                                                                                                                                return getFormName();
                                                                                                                                                            } else {
                                                                                                                                                                if ("hideEmptyRowItems".equals(name)) {
                                                                                                                                                                    return getHideEmptyRowItems();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("hideLegend".equals(name)) {
                                                                                                                                                                        return getHideLegend();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("hideSubtitle".equals(name)) {
                                                                                                                                                                            return getHideSubtitle();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("hideTitle".equals(name)) {
                                                                                                                                                                                return getHideTitle();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("href".equals(name)) {
                                                                                                                                                                                    return getHref();
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("id".equals(name)) {
                                                                                                                                                                                        return getId();
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("interpretations".equals(name)) {
                                                                                                                                                                                            return getInterpretations();
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("itemOrganisationUnitGroups".equals(name)) {
                                                                                                                                                                                                return getItemOrganisationUnitGroups();
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("lastUpdated".equals(name)) {
                                                                                                                                                                                                    return getLastUpdated();
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                                                                                                                                        return getLastUpdatedBy();
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("legendDisplayStrategy".equals(name)) {
                                                                                                                                                                                                            return getLegendDisplayStrategy();
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("legendSet".equals(name)) {
                                                                                                                                                                                                                return getLegendSet();
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("name".equals(name)) {
                                                                                                                                                                                                                    return getName();
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("noSpaceBetweenColumns".equals(name)) {
                                                                                                                                                                                                                        return getNoSpaceBetweenColumns();
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("orgUnitField".equals(name)) {
                                                                                                                                                                                                                            return getOrgUnitField();
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("organisationUnitGroupSetDimensions".equals(name)) {
                                                                                                                                                                                                                                return getOrganisationUnitGroupSetDimensions();
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("organisationUnitLevels".equals(name)) {
                                                                                                                                                                                                                                    return getOrganisationUnitLevels();
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("organisationUnits".equals(name)) {
                                                                                                                                                                                                                                        return getOrganisationUnits();
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("parentGraphMap".equals(name)) {
                                                                                                                                                                                                                                            return getParentGraphMap();
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if ("percentStackedValues".equals(name)) {
                                                                                                                                                                                                                                                return getPercentStackedValues();
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                if ("periods".equals(name)) {
                                                                                                                                                                                                                                                    return getPeriods();
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    if ("programIndicatorDimensions".equals(name)) {
                                                                                                                                                                                                                                                        return getProgramIndicatorDimensions();
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                                                                                                                                                                            return getPublicAccess();
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            if ("rangeAxisDecimals".equals(name)) {
                                                                                                                                                                                                                                                                return getRangeAxisDecimals();
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                if ("rangeAxisLabel".equals(name)) {
                                                                                                                                                                                                                                                                    return getRangeAxisLabel();
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    if ("rangeAxisMaxValue".equals(name)) {
                                                                                                                                                                                                                                                                        return getRangeAxisMaxValue();
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        if ("rangeAxisMinValue".equals(name)) {
                                                                                                                                                                                                                                                                            return getRangeAxisMinValue();
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            if ("rangeAxisSteps".equals(name)) {
                                                                                                                                                                                                                                                                                return getRangeAxisSteps();
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                if ("regressionType".equals(name)) {
                                                                                                                                                                                                                                                                                    return getRegressionType();
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    if ("relativePeriods".equals(name)) {
                                                                                                                                                                                                                                                                                        return getRelativePeriods();
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        if ("rows".equals(name)) {
                                                                                                                                                                                                                                                                                            return getRows();
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            if ("series".equals(name)) {
                                                                                                                                                                                                                                                                                                return getSeries();
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                if ("seriesItems".equals(name)) {
                                                                                                                                                                                                                                                                                                    return getSeriesItems();
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    if ("sharing".equals(name)) {
                                                                                                                                                                                                                                                                                                        return getSharing();
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        if ("shortName".equals(name)) {
                                                                                                                                                                                                                                                                                                            return getShortName();
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            if ("showData".equals(name)) {
                                                                                                                                                                                                                                                                                                                return getShowData();
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                if ("sortOrder".equals(name)) {
                                                                                                                                                                                                                                                                                                                    return getSortOrder();
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    if ("startDate".equals(name)) {
                                                                                                                                                                                                                                                                                                                        return getStartDate();
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        if ("subscribed".equals(name)) {
                                                                                                                                                                                                                                                                                                                            return getSubscribed();
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            if ("subscribers".equals(name)) {
                                                                                                                                                                                                                                                                                                                                return getSubscribers();
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                if ("subtitle".equals(name)) {
                                                                                                                                                                                                                                                                                                                                    return getSubtitle();
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    if ("targetLineLabel".equals(name)) {
                                                                                                                                                                                                                                                                                                                                        return getTargetLineLabel();
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        if ("targetLineValue".equals(name)) {
                                                                                                                                                                                                                                                                                                                                            return getTargetLineValue();
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            if ("timeField".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                return getTimeField();
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                if ("title".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                    return getTitle();
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    if ("topLimit".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                        return getTopLimit();
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                            return getTranslations();
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            if ("type".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                return getType();
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                if ("user".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                    return getUser();
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                        return getUserAccesses();
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                            return getUserGroupAccesses();
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            if ("userOrgUnitType".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                return getUserOrgUnitType();
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                if ("userOrganisationUnit".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                    return getUserOrganisationUnit();
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    if ("userOrganisationUnitChildren".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                        return getUserOrganisationUnitChildren();
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        if ("userOrganisationUnitGrandChildren".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                            return getUserOrganisationUnitGrandChildren();
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            if ("yearlySeries".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                return getYearlySeries();
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                return notFoundValue;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Chart.NOT_FOUND_VALUE);
        if (Chart.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Chart with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Chart.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeDimensions");
        sb.append('=');
        sb.append(((this.attributeDimensions == null)?"<null>":this.attributeDimensions));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("baseLineLabel");
        sb.append('=');
        sb.append(((this.baseLineLabel == null)?"<null>":this.baseLineLabel));
        sb.append(',');
        sb.append("baseLineValue");
        sb.append('=');
        sb.append(((this.baseLineValue == null)?"<null>":this.baseLineValue));
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(((this.category == null)?"<null>":this.category));
        sb.append(',');
        sb.append("categoryDimensions");
        sb.append('=');
        sb.append(((this.categoryDimensions == null)?"<null>":this.categoryDimensions));
        sb.append(',');
        sb.append("categoryOptionGroupSetDimensions");
        sb.append('=');
        sb.append(((this.categoryOptionGroupSetDimensions == null)?"<null>":this.categoryOptionGroupSetDimensions));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(((this.columns == null)?"<null>":this.columns));
        sb.append(',');
        sb.append("completedOnly");
        sb.append('=');
        sb.append(((this.completedOnly == null)?"<null>":this.completedOnly));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("cumulativeValues");
        sb.append('=');
        sb.append(((this.cumulativeValues == null)?"<null>":this.cumulativeValues));
        sb.append(',');
        sb.append("dataDimensionItems");
        sb.append('=');
        sb.append(((this.dataDimensionItems == null)?"<null>":this.dataDimensionItems));
        sb.append(',');
        sb.append("dataElementDimensions");
        sb.append('=');
        sb.append(((this.dataElementDimensions == null)?"<null>":this.dataElementDimensions));
        sb.append(',');
        sb.append("dataElementGroupSetDimensions");
        sb.append('=');
        sb.append(((this.dataElementGroupSetDimensions == null)?"<null>":this.dataElementGroupSetDimensions));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("digitGroupSeparator");
        sb.append('=');
        sb.append(((this.digitGroupSeparator == null)?"<null>":this.digitGroupSeparator));
        sb.append(',');
        sb.append("displayBaseLineLabel");
        sb.append('=');
        sb.append(((this.displayBaseLineLabel == null)?"<null>":this.displayBaseLineLabel));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayDomainAxisLabel");
        sb.append('=');
        sb.append(((this.displayDomainAxisLabel == null)?"<null>":this.displayDomainAxisLabel));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayRangeAxisLabel");
        sb.append('=');
        sb.append(((this.displayRangeAxisLabel == null)?"<null>":this.displayRangeAxisLabel));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("displaySubtitle");
        sb.append('=');
        sb.append(((this.displaySubtitle == null)?"<null>":this.displaySubtitle));
        sb.append(',');
        sb.append("displayTargetLineLabel");
        sb.append('=');
        sb.append(((this.displayTargetLineLabel == null)?"<null>":this.displayTargetLineLabel));
        sb.append(',');
        sb.append("displayTitle");
        sb.append('=');
        sb.append(((this.displayTitle == null)?"<null>":this.displayTitle));
        sb.append(',');
        sb.append("domainAxisLabel");
        sb.append('=');
        sb.append(((this.domainAxisLabel == null)?"<null>":this.domainAxisLabel));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filterDimensions");
        sb.append('=');
        sb.append(((this.filterDimensions == null)?"<null>":this.filterDimensions));
        sb.append(',');
        sb.append("filters");
        sb.append('=');
        sb.append(((this.filters == null)?"<null>":this.filters));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("hideEmptyRowItems");
        sb.append('=');
        sb.append(((this.hideEmptyRowItems == null)?"<null>":this.hideEmptyRowItems));
        sb.append(',');
        sb.append("hideLegend");
        sb.append('=');
        sb.append(((this.hideLegend == null)?"<null>":this.hideLegend));
        sb.append(',');
        sb.append("hideSubtitle");
        sb.append('=');
        sb.append(((this.hideSubtitle == null)?"<null>":this.hideSubtitle));
        sb.append(',');
        sb.append("hideTitle");
        sb.append('=');
        sb.append(((this.hideTitle == null)?"<null>":this.hideTitle));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("interpretations");
        sb.append('=');
        sb.append(((this.interpretations == null)?"<null>":this.interpretations));
        sb.append(',');
        sb.append("itemOrganisationUnitGroups");
        sb.append('=');
        sb.append(((this.itemOrganisationUnitGroups == null)?"<null>":this.itemOrganisationUnitGroups));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendDisplayStrategy");
        sb.append('=');
        sb.append(((this.legendDisplayStrategy == null)?"<null>":this.legendDisplayStrategy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("noSpaceBetweenColumns");
        sb.append('=');
        sb.append(((this.noSpaceBetweenColumns == null)?"<null>":this.noSpaceBetweenColumns));
        sb.append(',');
        sb.append("orgUnitField");
        sb.append('=');
        sb.append(((this.orgUnitField == null)?"<null>":this.orgUnitField));
        sb.append(',');
        sb.append("organisationUnitGroupSetDimensions");
        sb.append('=');
        sb.append(((this.organisationUnitGroupSetDimensions == null)?"<null>":this.organisationUnitGroupSetDimensions));
        sb.append(',');
        sb.append("organisationUnitLevels");
        sb.append('=');
        sb.append(((this.organisationUnitLevels == null)?"<null>":this.organisationUnitLevels));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("parentGraphMap");
        sb.append('=');
        sb.append(((this.parentGraphMap == null)?"<null>":this.parentGraphMap));
        sb.append(',');
        sb.append("percentStackedValues");
        sb.append('=');
        sb.append(((this.percentStackedValues == null)?"<null>":this.percentStackedValues));
        sb.append(',');
        sb.append("periods");
        sb.append('=');
        sb.append(((this.periods == null)?"<null>":this.periods));
        sb.append(',');
        sb.append("programIndicatorDimensions");
        sb.append('=');
        sb.append(((this.programIndicatorDimensions == null)?"<null>":this.programIndicatorDimensions));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("rangeAxisDecimals");
        sb.append('=');
        sb.append(((this.rangeAxisDecimals == null)?"<null>":this.rangeAxisDecimals));
        sb.append(',');
        sb.append("rangeAxisLabel");
        sb.append('=');
        sb.append(((this.rangeAxisLabel == null)?"<null>":this.rangeAxisLabel));
        sb.append(',');
        sb.append("rangeAxisMaxValue");
        sb.append('=');
        sb.append(((this.rangeAxisMaxValue == null)?"<null>":this.rangeAxisMaxValue));
        sb.append(',');
        sb.append("rangeAxisMinValue");
        sb.append('=');
        sb.append(((this.rangeAxisMinValue == null)?"<null>":this.rangeAxisMinValue));
        sb.append(',');
        sb.append("rangeAxisSteps");
        sb.append('=');
        sb.append(((this.rangeAxisSteps == null)?"<null>":this.rangeAxisSteps));
        sb.append(',');
        sb.append("regressionType");
        sb.append('=');
        sb.append(((this.regressionType == null)?"<null>":this.regressionType));
        sb.append(',');
        sb.append("relativePeriods");
        sb.append('=');
        sb.append(((this.relativePeriods == null)?"<null>":this.relativePeriods));
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        sb.append("series");
        sb.append('=');
        sb.append(((this.series == null)?"<null>":this.series));
        sb.append(',');
        sb.append("seriesItems");
        sb.append('=');
        sb.append(((this.seriesItems == null)?"<null>":this.seriesItems));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("showData");
        sb.append('=');
        sb.append(((this.showData == null)?"<null>":this.showData));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("subscribed");
        sb.append('=');
        sb.append(((this.subscribed == null)?"<null>":this.subscribed));
        sb.append(',');
        sb.append("subscribers");
        sb.append('=');
        sb.append(((this.subscribers == null)?"<null>":this.subscribers));
        sb.append(',');
        sb.append("subtitle");
        sb.append('=');
        sb.append(((this.subtitle == null)?"<null>":this.subtitle));
        sb.append(',');
        sb.append("targetLineLabel");
        sb.append('=');
        sb.append(((this.targetLineLabel == null)?"<null>":this.targetLineLabel));
        sb.append(',');
        sb.append("targetLineValue");
        sb.append('=');
        sb.append(((this.targetLineValue == null)?"<null>":this.targetLineValue));
        sb.append(',');
        sb.append("timeField");
        sb.append('=');
        sb.append(((this.timeField == null)?"<null>":this.timeField));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("topLimit");
        sb.append('=');
        sb.append(((this.topLimit == null)?"<null>":this.topLimit));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userOrgUnitType");
        sb.append('=');
        sb.append(((this.userOrgUnitType == null)?"<null>":this.userOrgUnitType));
        sb.append(',');
        sb.append("userOrganisationUnit");
        sb.append('=');
        sb.append(((this.userOrganisationUnit == null)?"<null>":this.userOrganisationUnit));
        sb.append(',');
        sb.append("userOrganisationUnitChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitChildren == null)?"<null>":this.userOrganisationUnitChildren));
        sb.append(',');
        sb.append("userOrganisationUnitGrandChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitGrandChildren == null)?"<null>":this.userOrganisationUnitGrandChildren));
        sb.append(',');
        sb.append("yearlySeries");
        sb.append('=');
        sb.append(((this.yearlySeries == null)?"<null>":this.yearlySeries));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementGroupSetDimensions == null)? 0 :this.dataElementGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.orgUnitField == null)? 0 :this.orgUnitField.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.baseLineValue == null)? 0 :this.baseLineValue.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitChildren == null)? 0 :this.userOrganisationUnitChildren.hashCode()));
        result = ((result* 31)+((this.displaySubtitle == null)? 0 :this.displaySubtitle.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.displayTitle == null)? 0 :this.displayTitle.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.subscribed == null)? 0 :this.subscribed.hashCode()));
        result = ((result* 31)+((this.displayTargetLineLabel == null)? 0 :this.displayTargetLineLabel.hashCode()));
        result = ((result* 31)+((this.attributeDimensions == null)? 0 :this.attributeDimensions.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.yearlySeries == null)? 0 :this.yearlySeries.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnit == null)? 0 :this.userOrganisationUnit.hashCode()));
        result = ((result* 31)+((this.filterDimensions == null)? 0 :this.filterDimensions.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.interpretations == null)? 0 :this.interpretations.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.domainAxisLabel == null)? 0 :this.domainAxisLabel.hashCode()));
        result = ((result* 31)+((this.subscribers == null)? 0 :this.subscribers.hashCode()));
        result = ((result* 31)+((this.cumulativeValues == null)? 0 :this.cumulativeValues.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.subtitle == null)? 0 :this.subtitle.hashCode()));
        result = ((result* 31)+((this.rangeAxisDecimals == null)? 0 :this.rangeAxisDecimals.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.topLimit == null)? 0 :this.topLimit.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitGrandChildren == null)? 0 :this.userOrganisationUnitGrandChildren.hashCode()));
        result = ((result* 31)+((this.columns == null)? 0 :this.columns.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.percentStackedValues == null)? 0 :this.percentStackedValues.hashCode()));
        result = ((result* 31)+((this.seriesItems == null)? 0 :this.seriesItems.hashCode()));
        result = ((result* 31)+((this.noSpaceBetweenColumns == null)? 0 :this.noSpaceBetweenColumns.hashCode()));
        result = ((result* 31)+((this.dataElementDimensions == null)? 0 :this.dataElementDimensions.hashCode()));
        result = ((result* 31)+((this.rangeAxisSteps == null)? 0 :this.rangeAxisSteps.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.periods == null)? 0 :this.periods.hashCode()));
        result = ((result* 31)+((this.categoryDimensions == null)? 0 :this.categoryDimensions.hashCode()));
        result = ((result* 31)+((this.displayRangeAxisLabel == null)? 0 :this.displayRangeAxisLabel.hashCode()));
        result = ((result* 31)+((this.hideTitle == null)? 0 :this.hideTitle.hashCode()));
        result = ((result* 31)+((this.series == null)? 0 :this.series.hashCode()));
        result = ((result* 31)+((this.displayBaseLineLabel == null)? 0 :this.displayBaseLineLabel.hashCode()));
        result = ((result* 31)+((this.showData == null)? 0 :this.showData.hashCode()));
        result = ((result* 31)+((this.parentGraphMap == null)? 0 :this.parentGraphMap.hashCode()));
        result = ((result* 31)+((this.itemOrganisationUnitGroups == null)? 0 :this.itemOrganisationUnitGroups.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.displayDomainAxisLabel == null)? 0 :this.displayDomainAxisLabel.hashCode()));
        result = ((result* 31)+((this.programIndicatorDimensions == null)? 0 :this.programIndicatorDimensions.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.rangeAxisLabel == null)? 0 :this.rangeAxisLabel.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.regressionType == null)? 0 :this.regressionType.hashCode()));
        result = ((result* 31)+((this.completedOnly == null)? 0 :this.completedOnly.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.hideEmptyRowItems == null)? 0 :this.hideEmptyRowItems.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dataDimensionItems == null)? 0 :this.dataDimensionItems.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupSetDimensions == null)? 0 :this.categoryOptionGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.hideSubtitle == null)? 0 :this.hideSubtitle.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupSetDimensions == null)? 0 :this.organisationUnitGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.hideLegend == null)? 0 :this.hideLegend.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.organisationUnitLevels == null)? 0 :this.organisationUnitLevels.hashCode()));
        result = ((result* 31)+((this.rangeAxisMinValue == null)? 0 :this.rangeAxisMinValue.hashCode()));
        result = ((result* 31)+((this.legendDisplayStrategy == null)? 0 :this.legendDisplayStrategy.hashCode()));
        result = ((result* 31)+((this.relativePeriods == null)? 0 :this.relativePeriods.hashCode()));
        result = ((result* 31)+((this.targetLineLabel == null)? 0 :this.targetLineLabel.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.timeField == null)? 0 :this.timeField.hashCode()));
        result = ((result* 31)+((this.targetLineValue == null)? 0 :this.targetLineValue.hashCode()));
        result = ((result* 31)+((this.filters == null)? 0 :this.filters.hashCode()));
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        result = ((result* 31)+((this.baseLineLabel == null)? 0 :this.baseLineLabel.hashCode()));
        result = ((result* 31)+((this.digitGroupSeparator == null)? 0 :this.digitGroupSeparator.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.userOrgUnitType == null)? 0 :this.userOrgUnitType.hashCode()));
        result = ((result* 31)+((this.rangeAxisMaxValue == null)? 0 :this.rangeAxisMaxValue.hashCode()));
        result = ((result* 31)+((this.category == null)? 0 :this.category.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Chart) == false) {
            return false;
        }
        Chart rhs = ((Chart) other);
        return ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.dataElementGroupSetDimensions == rhs.dataElementGroupSetDimensions)||((this.dataElementGroupSetDimensions!= null)&&this.dataElementGroupSetDimensions.equals(rhs.dataElementGroupSetDimensions)))&&((this.orgUnitField == rhs.orgUnitField)||((this.orgUnitField!= null)&&this.orgUnitField.equals(rhs.orgUnitField))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.baseLineValue == rhs.baseLineValue)||((this.baseLineValue!= null)&&this.baseLineValue.equals(rhs.baseLineValue))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.userOrganisationUnitChildren == rhs.userOrganisationUnitChildren)||((this.userOrganisationUnitChildren!= null)&&this.userOrganisationUnitChildren.equals(rhs.userOrganisationUnitChildren))))&&((this.displaySubtitle == rhs.displaySubtitle)||((this.displaySubtitle!= null)&&this.displaySubtitle.equals(rhs.displaySubtitle))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.displayTitle == rhs.displayTitle)||((this.displayTitle!= null)&&this.displayTitle.equals(rhs.displayTitle))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.subscribed == rhs.subscribed)||((this.subscribed!= null)&&this.subscribed.equals(rhs.subscribed))))&&((this.displayTargetLineLabel == rhs.displayTargetLineLabel)||((this.displayTargetLineLabel!= null)&&this.displayTargetLineLabel.equals(rhs.displayTargetLineLabel))))&&((this.attributeDimensions == rhs.attributeDimensions)||((this.attributeDimensions!= null)&&this.attributeDimensions.equals(rhs.attributeDimensions))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.yearlySeries == rhs.yearlySeries)||((this.yearlySeries!= null)&&this.yearlySeries.equals(rhs.yearlySeries))))&&((this.userOrganisationUnit == rhs.userOrganisationUnit)||((this.userOrganisationUnit!= null)&&this.userOrganisationUnit.equals(rhs.userOrganisationUnit))))&&((this.filterDimensions == rhs.filterDimensions)||((this.filterDimensions!= null)&&this.filterDimensions.equals(rhs.filterDimensions))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.interpretations == rhs.interpretations)||((this.interpretations!= null)&&this.interpretations.equals(rhs.interpretations))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.domainAxisLabel == rhs.domainAxisLabel)||((this.domainAxisLabel!= null)&&this.domainAxisLabel.equals(rhs.domainAxisLabel))))&&((this.subscribers == rhs.subscribers)||((this.subscribers!= null)&&this.subscribers.equals(rhs.subscribers))))&&((this.cumulativeValues == rhs.cumulativeValues)||((this.cumulativeValues!= null)&&this.cumulativeValues.equals(rhs.cumulativeValues))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.subtitle == rhs.subtitle)||((this.subtitle!= null)&&this.subtitle.equals(rhs.subtitle))))&&((this.rangeAxisDecimals == rhs.rangeAxisDecimals)||((this.rangeAxisDecimals!= null)&&this.rangeAxisDecimals.equals(rhs.rangeAxisDecimals))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.topLimit == rhs.topLimit)||((this.topLimit!= null)&&this.topLimit.equals(rhs.topLimit))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.userOrganisationUnitGrandChildren == rhs.userOrganisationUnitGrandChildren)||((this.userOrganisationUnitGrandChildren!= null)&&this.userOrganisationUnitGrandChildren.equals(rhs.userOrganisationUnitGrandChildren))))&&((this.columns == rhs.columns)||((this.columns!= null)&&this.columns.equals(rhs.columns))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.percentStackedValues == rhs.percentStackedValues)||((this.percentStackedValues!= null)&&this.percentStackedValues.equals(rhs.percentStackedValues))))&&((this.seriesItems == rhs.seriesItems)||((this.seriesItems!= null)&&this.seriesItems.equals(rhs.seriesItems))))&&((this.noSpaceBetweenColumns == rhs.noSpaceBetweenColumns)||((this.noSpaceBetweenColumns!= null)&&this.noSpaceBetweenColumns.equals(rhs.noSpaceBetweenColumns))))&&((this.dataElementDimensions == rhs.dataElementDimensions)||((this.dataElementDimensions!= null)&&this.dataElementDimensions.equals(rhs.dataElementDimensions))))&&((this.rangeAxisSteps == rhs.rangeAxisSteps)||((this.rangeAxisSteps!= null)&&this.rangeAxisSteps.equals(rhs.rangeAxisSteps))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.periods == rhs.periods)||((this.periods!= null)&&this.periods.equals(rhs.periods))))&&((this.categoryDimensions == rhs.categoryDimensions)||((this.categoryDimensions!= null)&&this.categoryDimensions.equals(rhs.categoryDimensions))))&&((this.displayRangeAxisLabel == rhs.displayRangeAxisLabel)||((this.displayRangeAxisLabel!= null)&&this.displayRangeAxisLabel.equals(rhs.displayRangeAxisLabel))))&&((this.hideTitle == rhs.hideTitle)||((this.hideTitle!= null)&&this.hideTitle.equals(rhs.hideTitle))))&&((this.series == rhs.series)||((this.series!= null)&&this.series.equals(rhs.series))))&&((this.displayBaseLineLabel == rhs.displayBaseLineLabel)||((this.displayBaseLineLabel!= null)&&this.displayBaseLineLabel.equals(rhs.displayBaseLineLabel))))&&((this.showData == rhs.showData)||((this.showData!= null)&&this.showData.equals(rhs.showData))))&&((this.parentGraphMap == rhs.parentGraphMap)||((this.parentGraphMap!= null)&&this.parentGraphMap.equals(rhs.parentGraphMap))))&&((this.itemOrganisationUnitGroups == rhs.itemOrganisationUnitGroups)||((this.itemOrganisationUnitGroups!= null)&&this.itemOrganisationUnitGroups.equals(rhs.itemOrganisationUnitGroups))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.displayDomainAxisLabel == rhs.displayDomainAxisLabel)||((this.displayDomainAxisLabel!= null)&&this.displayDomainAxisLabel.equals(rhs.displayDomainAxisLabel))))&&((this.programIndicatorDimensions == rhs.programIndicatorDimensions)||((this.programIndicatorDimensions!= null)&&this.programIndicatorDimensions.equals(rhs.programIndicatorDimensions))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.rangeAxisLabel == rhs.rangeAxisLabel)||((this.rangeAxisLabel!= null)&&this.rangeAxisLabel.equals(rhs.rangeAxisLabel))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.regressionType == rhs.regressionType)||((this.regressionType!= null)&&this.regressionType.equals(rhs.regressionType))))&&((this.completedOnly == rhs.completedOnly)||((this.completedOnly!= null)&&this.completedOnly.equals(rhs.completedOnly))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.hideEmptyRowItems == rhs.hideEmptyRowItems)||((this.hideEmptyRowItems!= null)&&this.hideEmptyRowItems.equals(rhs.hideEmptyRowItems))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.dataDimensionItems == rhs.dataDimensionItems)||((this.dataDimensionItems!= null)&&this.dataDimensionItems.equals(rhs.dataDimensionItems))))&&((this.categoryOptionGroupSetDimensions == rhs.categoryOptionGroupSetDimensions)||((this.categoryOptionGroupSetDimensions!= null)&&this.categoryOptionGroupSetDimensions.equals(rhs.categoryOptionGroupSetDimensions))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.hideSubtitle == rhs.hideSubtitle)||((this.hideSubtitle!= null)&&this.hideSubtitle.equals(rhs.hideSubtitle))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.organisationUnitGroupSetDimensions == rhs.organisationUnitGroupSetDimensions)||((this.organisationUnitGroupSetDimensions!= null)&&this.organisationUnitGroupSetDimensions.equals(rhs.organisationUnitGroupSetDimensions))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.hideLegend == rhs.hideLegend)||((this.hideLegend!= null)&&this.hideLegend.equals(rhs.hideLegend))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.organisationUnitLevels == rhs.organisationUnitLevels)||((this.organisationUnitLevels!= null)&&this.organisationUnitLevels.equals(rhs.organisationUnitLevels))))&&((this.rangeAxisMinValue == rhs.rangeAxisMinValue)||((this.rangeAxisMinValue!= null)&&this.rangeAxisMinValue.equals(rhs.rangeAxisMinValue))))&&((this.legendDisplayStrategy == rhs.legendDisplayStrategy)||((this.legendDisplayStrategy!= null)&&this.legendDisplayStrategy.equals(rhs.legendDisplayStrategy))))&&((this.relativePeriods == rhs.relativePeriods)||((this.relativePeriods!= null)&&this.relativePeriods.equals(rhs.relativePeriods))))&&((this.targetLineLabel == rhs.targetLineLabel)||((this.targetLineLabel!= null)&&this.targetLineLabel.equals(rhs.targetLineLabel))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.timeField == rhs.timeField)||((this.timeField!= null)&&this.timeField.equals(rhs.timeField))))&&((this.targetLineValue == rhs.targetLineValue)||((this.targetLineValue!= null)&&this.targetLineValue.equals(rhs.targetLineValue))))&&((this.filters == rhs.filters)||((this.filters!= null)&&this.filters.equals(rhs.filters))))&&((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows))))&&((this.baseLineLabel == rhs.baseLineLabel)||((this.baseLineLabel!= null)&&this.baseLineLabel.equals(rhs.baseLineLabel))))&&((this.digitGroupSeparator == rhs.digitGroupSeparator)||((this.digitGroupSeparator!= null)&&this.digitGroupSeparator.equals(rhs.digitGroupSeparator))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.userOrgUnitType == rhs.userOrgUnitType)||((this.userOrgUnitType!= null)&&this.userOrgUnitType.equals(rhs.userOrgUnitType))))&&((this.rangeAxisMaxValue == rhs.rangeAxisMaxValue)||((this.rangeAxisMaxValue!= null)&&this.rangeAxisMaxValue.equals(rhs.rangeAxisMaxValue))))&&((this.category == rhs.category)||((this.category!= null)&&this.category.equals(rhs.category))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum ChartType {

        COLUMN("COLUMN"),
        STACKED_COLUMN("STACKED_COLUMN"),
        BAR("BAR"),
        STACKED_BAR("STACKED_BAR"),
        STACKED_AREA("STACKED_AREA"),
        LINE("LINE"),
        AREA("AREA"),
        PIE("PIE"),
        RADAR("RADAR"),
        GAUGE("GAUGE"),
        YEAR_OVER_YEAR_LINE("YEAR_OVER_YEAR_LINE"),
        YEAR_OVER_YEAR_COLUMN("YEAR_OVER_YEAR_COLUMN"),
        SINGLE_VALUE("SINGLE_VALUE"),
        SCATTER("SCATTER"),
        BUBBLE("BUBBLE");
        private final String value;
        private final static Map<String, Chart.ChartType> CONSTANTS = new HashMap<String, Chart.ChartType>();

        static {
            for (Chart.ChartType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ChartType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Chart.ChartType fromValue(String value) {
            Chart.ChartType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DigitGroupSeparator {

        COMMA("COMMA"),
        SPACE("SPACE"),
        NONE("NONE");
        private final String value;
        private final static Map<String, Chart.DigitGroupSeparator> CONSTANTS = new HashMap<String, Chart.DigitGroupSeparator>();

        static {
            for (Chart.DigitGroupSeparator c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DigitGroupSeparator(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Chart.DigitGroupSeparator fromValue(String value) {
            Chart.DigitGroupSeparator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum HideEmptyItemStrategy {

        NONE("NONE"),
        BEFORE_FIRST("BEFORE_FIRST"),
        AFTER_LAST("AFTER_LAST"),
        BEFORE_FIRST_AFTER_LAST("BEFORE_FIRST_AFTER_LAST"),
        ALL("ALL");
        private final String value;
        private final static Map<String, Chart.HideEmptyItemStrategy> CONSTANTS = new HashMap<String, Chart.HideEmptyItemStrategy>();

        static {
            for (Chart.HideEmptyItemStrategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        HideEmptyItemStrategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Chart.HideEmptyItemStrategy fromValue(String value) {
            Chart.HideEmptyItemStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum LegendDisplayStrategy {

        FIXED("FIXED"),
        BY_DATA_ITEM("BY_DATA_ITEM");
        private final String value;
        private final static Map<String, Chart.LegendDisplayStrategy> CONSTANTS = new HashMap<String, Chart.LegendDisplayStrategy>();

        static {
            for (Chart.LegendDisplayStrategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        LegendDisplayStrategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Chart.LegendDisplayStrategy fromValue(String value) {
            Chart.LegendDisplayStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum RegressionType {

        NONE("NONE"),
        LINEAR("LINEAR"),
        POLYNOMIAL("POLYNOMIAL"),
        LOESS("LOESS");
        private final String value;
        private final static Map<String, Chart.RegressionType> CONSTANTS = new HashMap<String, Chart.RegressionType>();

        static {
            for (Chart.RegressionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        RegressionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Chart.RegressionType fromValue(String value) {
            Chart.RegressionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum UserOrgUnitType {

        DATA_CAPTURE("DATA_CAPTURE"),
        DATA_OUTPUT("DATA_OUTPUT"),
        TEI_SEARCH("TEI_SEARCH");
        private final String value;
        private final static Map<String, Chart.UserOrgUnitType> CONSTANTS = new HashMap<String, Chart.UserOrgUnitType>();

        static {
            for (Chart.UserOrgUnitType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        UserOrgUnitType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Chart.UserOrgUnitType fromValue(String value) {
            Chart.UserOrgUnitType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
