
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "atomicMode",
    "enrollments",
    "events",
    "flushMode",
    "identifiers",
    "importMode",
    "importStrategy",
    "relationships",
    "reportMode",
    "skipSideEffects",
    "skipTextPatternValidation",
    "trackedEntities",
    "userId",
    "username",
    "validationMode"
})
@Generated("jsonschema2pojo")
public class TrackerBundleParams implements Serializable
{

    @JsonProperty("atomicMode")
    private AtomicMode_ atomicMode;
    @JsonProperty("enrollments")
    private List<Enrollment__1> enrollments;
    @JsonProperty("events")
    private List<Event__1> events;
    @JsonProperty("flushMode")
    private FlushMode_ flushMode;
    @JsonProperty("identifiers")
    private TrackerIdentifierParams identifiers;
    @JsonProperty("importMode")
    private TrackerBundleMode importMode;
    @JsonProperty("importStrategy")
    private TrackerBundleParams.TrackerImportStrategy importStrategy;
    @JsonProperty("relationships")
    private List<Relationship__1> relationships;
    @JsonProperty("reportMode")
    private TrackerBundleParams.TrackerBundleReportMode reportMode;
    @JsonProperty("skipSideEffects")
    private Boolean skipSideEffects;
    @JsonProperty("skipTextPatternValidation")
    private Boolean skipTextPatternValidation;
    @JsonProperty("trackedEntities")
    private List<TrackedEntity> trackedEntities;
    @JsonProperty("userId")
    private String userId;
    @JsonProperty("username")
    private String username;
    @JsonProperty("validationMode")
    private TrackerBundleParams.ValidationMode validationMode;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8169987876509216443L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerBundleParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerBundleParams(TrackerBundleParams source) {
        super();
        this.atomicMode = source.atomicMode;
        this.enrollments = source.enrollments;
        this.events = source.events;
        this.flushMode = source.flushMode;
        this.identifiers = source.identifiers;
        this.importMode = source.importMode;
        this.importStrategy = source.importStrategy;
        this.relationships = source.relationships;
        this.reportMode = source.reportMode;
        this.skipSideEffects = source.skipSideEffects;
        this.skipTextPatternValidation = source.skipTextPatternValidation;
        this.trackedEntities = source.trackedEntities;
        this.userId = source.userId;
        this.username = source.username;
        this.validationMode = source.validationMode;
    }

    public TrackerBundleParams(AtomicMode_ atomicMode, List<Enrollment__1> enrollments, List<Event__1> events, FlushMode_ flushMode, TrackerIdentifierParams identifiers, TrackerBundleMode importMode, TrackerBundleParams.TrackerImportStrategy importStrategy, List<Relationship__1> relationships, TrackerBundleParams.TrackerBundleReportMode reportMode, Boolean skipSideEffects, Boolean skipTextPatternValidation, List<TrackedEntity> trackedEntities, String userId, String username, TrackerBundleParams.ValidationMode validationMode) {
        super();
        this.atomicMode = atomicMode;
        this.enrollments = enrollments;
        this.events = events;
        this.flushMode = flushMode;
        this.identifiers = identifiers;
        this.importMode = importMode;
        this.importStrategy = importStrategy;
        this.relationships = relationships;
        this.reportMode = reportMode;
        this.skipSideEffects = skipSideEffects;
        this.skipTextPatternValidation = skipTextPatternValidation;
        this.trackedEntities = trackedEntities;
        this.userId = userId;
        this.username = username;
        this.validationMode = validationMode;
    }

    @JsonProperty("atomicMode")
    public Optional<AtomicMode_> getAtomicMode() {
        return Optional.ofNullable(atomicMode);
    }

    @JsonProperty("atomicMode")
    public void setAtomicMode(AtomicMode_ atomicMode) {
        this.atomicMode = atomicMode;
    }

    public TrackerBundleParams withAtomicMode(AtomicMode_ atomicMode) {
        this.atomicMode = atomicMode;
        return this;
    }

    @JsonProperty("enrollments")
    public Optional<List<Enrollment__1>> getEnrollments() {
        return Optional.ofNullable(enrollments);
    }

    @JsonProperty("enrollments")
    public void setEnrollments(List<Enrollment__1> enrollments) {
        this.enrollments = enrollments;
    }

    public TrackerBundleParams withEnrollments(List<Enrollment__1> enrollments) {
        this.enrollments = enrollments;
        return this;
    }

    @JsonProperty("events")
    public Optional<List<Event__1>> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(List<Event__1> events) {
        this.events = events;
    }

    public TrackerBundleParams withEvents(List<Event__1> events) {
        this.events = events;
        return this;
    }

    @JsonProperty("flushMode")
    public Optional<FlushMode_> getFlushMode() {
        return Optional.ofNullable(flushMode);
    }

    @JsonProperty("flushMode")
    public void setFlushMode(FlushMode_ flushMode) {
        this.flushMode = flushMode;
    }

    public TrackerBundleParams withFlushMode(FlushMode_ flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    @JsonProperty("identifiers")
    public Optional<TrackerIdentifierParams> getIdentifiers() {
        return Optional.ofNullable(identifiers);
    }

    @JsonProperty("identifiers")
    public void setIdentifiers(TrackerIdentifierParams identifiers) {
        this.identifiers = identifiers;
    }

    public TrackerBundleParams withIdentifiers(TrackerIdentifierParams identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    @JsonProperty("importMode")
    public Optional<TrackerBundleMode> getImportMode() {
        return Optional.ofNullable(importMode);
    }

    @JsonProperty("importMode")
    public void setImportMode(TrackerBundleMode importMode) {
        this.importMode = importMode;
    }

    public TrackerBundleParams withImportMode(TrackerBundleMode importMode) {
        this.importMode = importMode;
        return this;
    }

    @JsonProperty("importStrategy")
    public Optional<TrackerBundleParams.TrackerImportStrategy> getImportStrategy() {
        return Optional.ofNullable(importStrategy);
    }

    @JsonProperty("importStrategy")
    public void setImportStrategy(TrackerBundleParams.TrackerImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
    }

    public TrackerBundleParams withImportStrategy(TrackerBundleParams.TrackerImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<Relationship__1>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<Relationship__1> relationships) {
        this.relationships = relationships;
    }

    public TrackerBundleParams withRelationships(List<Relationship__1> relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("reportMode")
    public Optional<TrackerBundleParams.TrackerBundleReportMode> getReportMode() {
        return Optional.ofNullable(reportMode);
    }

    @JsonProperty("reportMode")
    public void setReportMode(TrackerBundleParams.TrackerBundleReportMode reportMode) {
        this.reportMode = reportMode;
    }

    public TrackerBundleParams withReportMode(TrackerBundleParams.TrackerBundleReportMode reportMode) {
        this.reportMode = reportMode;
        return this;
    }

    @JsonProperty("skipSideEffects")
    public Optional<Boolean> getSkipSideEffects() {
        return Optional.ofNullable(skipSideEffects);
    }

    @JsonProperty("skipSideEffects")
    public void setSkipSideEffects(Boolean skipSideEffects) {
        this.skipSideEffects = skipSideEffects;
    }

    public TrackerBundleParams withSkipSideEffects(Boolean skipSideEffects) {
        this.skipSideEffects = skipSideEffects;
        return this;
    }

    @JsonProperty("skipTextPatternValidation")
    public Optional<Boolean> getSkipTextPatternValidation() {
        return Optional.ofNullable(skipTextPatternValidation);
    }

    @JsonProperty("skipTextPatternValidation")
    public void setSkipTextPatternValidation(Boolean skipTextPatternValidation) {
        this.skipTextPatternValidation = skipTextPatternValidation;
    }

    public TrackerBundleParams withSkipTextPatternValidation(Boolean skipTextPatternValidation) {
        this.skipTextPatternValidation = skipTextPatternValidation;
        return this;
    }

    @JsonProperty("trackedEntities")
    public Optional<List<TrackedEntity>> getTrackedEntities() {
        return Optional.ofNullable(trackedEntities);
    }

    @JsonProperty("trackedEntities")
    public void setTrackedEntities(List<TrackedEntity> trackedEntities) {
        this.trackedEntities = trackedEntities;
    }

    public TrackerBundleParams withTrackedEntities(List<TrackedEntity> trackedEntities) {
        this.trackedEntities = trackedEntities;
        return this;
    }

    @JsonProperty("userId")
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    @JsonProperty("userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public TrackerBundleParams withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public TrackerBundleParams withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty("validationMode")
    public Optional<TrackerBundleParams.ValidationMode> getValidationMode() {
        return Optional.ofNullable(validationMode);
    }

    @JsonProperty("validationMode")
    public void setValidationMode(TrackerBundleParams.ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public TrackerBundleParams withValidationMode(TrackerBundleParams.ValidationMode validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerBundleParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("atomicMode".equals(name)) {
            if (value instanceof AtomicMode_) {
                setAtomicMode(((AtomicMode_) value));
            } else {
                throw new IllegalArgumentException(("property \"atomicMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.AtomicMode_\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("enrollments".equals(name)) {
                if (value instanceof List) {
                    setEnrollments(((List<Enrollment__1> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollments\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Enrollment__1>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("events".equals(name)) {
                    if (value instanceof List) {
                        setEvents(((List<Event__1> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"events\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Event__1>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("flushMode".equals(name)) {
                        if (value instanceof FlushMode_) {
                            setFlushMode(((FlushMode_) value));
                        } else {
                            throw new IllegalArgumentException(("property \"flushMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.FlushMode_\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("identifiers".equals(name)) {
                            if (value instanceof TrackerIdentifierParams) {
                                setIdentifiers(((TrackerIdentifierParams) value));
                            } else {
                                throw new IllegalArgumentException(("property \"identifiers\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerIdentifierParams\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("importMode".equals(name)) {
                                if (value instanceof TrackerBundleMode) {
                                    setImportMode(((TrackerBundleMode) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"importMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerBundleMode\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("importStrategy".equals(name)) {
                                    if (value instanceof TrackerBundleParams.TrackerImportStrategy) {
                                        setImportStrategy(((TrackerBundleParams.TrackerImportStrategy) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"importStrategy\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerBundleParams.TrackerImportStrategy\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("relationships".equals(name)) {
                                        if (value instanceof List) {
                                            setRelationships(((List<Relationship__1> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Relationship__1>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("reportMode".equals(name)) {
                                            if (value instanceof TrackerBundleParams.TrackerBundleReportMode) {
                                                setReportMode(((TrackerBundleParams.TrackerBundleReportMode) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"reportMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerBundleParams.TrackerBundleReportMode\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("skipSideEffects".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setSkipSideEffects(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"skipSideEffects\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("skipTextPatternValidation".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setSkipTextPatternValidation(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"skipTextPatternValidation\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("trackedEntities".equals(name)) {
                                                        if (value instanceof List) {
                                                            setTrackedEntities(((List<TrackedEntity> ) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"trackedEntities\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.TrackedEntity>\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("userId".equals(name)) {
                                                            if (value instanceof String) {
                                                                setUserId(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"userId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("username".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setUsername(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("validationMode".equals(name)) {
                                                                    if (value instanceof TrackerBundleParams.ValidationMode) {
                                                                        setValidationMode(((TrackerBundleParams.ValidationMode) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"validationMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerBundleParams.ValidationMode\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    return false;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("atomicMode".equals(name)) {
            return getAtomicMode();
        } else {
            if ("enrollments".equals(name)) {
                return getEnrollments();
            } else {
                if ("events".equals(name)) {
                    return getEvents();
                } else {
                    if ("flushMode".equals(name)) {
                        return getFlushMode();
                    } else {
                        if ("identifiers".equals(name)) {
                            return getIdentifiers();
                        } else {
                            if ("importMode".equals(name)) {
                                return getImportMode();
                            } else {
                                if ("importStrategy".equals(name)) {
                                    return getImportStrategy();
                                } else {
                                    if ("relationships".equals(name)) {
                                        return getRelationships();
                                    } else {
                                        if ("reportMode".equals(name)) {
                                            return getReportMode();
                                        } else {
                                            if ("skipSideEffects".equals(name)) {
                                                return getSkipSideEffects();
                                            } else {
                                                if ("skipTextPatternValidation".equals(name)) {
                                                    return getSkipTextPatternValidation();
                                                } else {
                                                    if ("trackedEntities".equals(name)) {
                                                        return getTrackedEntities();
                                                    } else {
                                                        if ("userId".equals(name)) {
                                                            return getUserId();
                                                        } else {
                                                            if ("username".equals(name)) {
                                                                return getUsername();
                                                            } else {
                                                                if ("validationMode".equals(name)) {
                                                                    return getValidationMode();
                                                                } else {
                                                                    return notFoundValue;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerBundleParams.NOT_FOUND_VALUE);
        if (TrackerBundleParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerBundleParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerBundleParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("atomicMode");
        sb.append('=');
        sb.append(((this.atomicMode == null)?"<null>":this.atomicMode));
        sb.append(',');
        sb.append("enrollments");
        sb.append('=');
        sb.append(((this.enrollments == null)?"<null>":this.enrollments));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("flushMode");
        sb.append('=');
        sb.append(((this.flushMode == null)?"<null>":this.flushMode));
        sb.append(',');
        sb.append("identifiers");
        sb.append('=');
        sb.append(((this.identifiers == null)?"<null>":this.identifiers));
        sb.append(',');
        sb.append("importMode");
        sb.append('=');
        sb.append(((this.importMode == null)?"<null>":this.importMode));
        sb.append(',');
        sb.append("importStrategy");
        sb.append('=');
        sb.append(((this.importStrategy == null)?"<null>":this.importStrategy));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("reportMode");
        sb.append('=');
        sb.append(((this.reportMode == null)?"<null>":this.reportMode));
        sb.append(',');
        sb.append("skipSideEffects");
        sb.append('=');
        sb.append(((this.skipSideEffects == null)?"<null>":this.skipSideEffects));
        sb.append(',');
        sb.append("skipTextPatternValidation");
        sb.append('=');
        sb.append(((this.skipTextPatternValidation == null)?"<null>":this.skipTextPatternValidation));
        sb.append(',');
        sb.append("trackedEntities");
        sb.append('=');
        sb.append(((this.trackedEntities == null)?"<null>":this.trackedEntities));
        sb.append(',');
        sb.append("userId");
        sb.append('=');
        sb.append(((this.userId == null)?"<null>":this.userId));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("validationMode");
        sb.append('=');
        sb.append(((this.validationMode == null)?"<null>":this.validationMode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.importMode == null)? 0 :this.importMode.hashCode()));
        result = ((result* 31)+((this.identifiers == null)? 0 :this.identifiers.hashCode()));
        result = ((result* 31)+((this.trackedEntities == null)? 0 :this.trackedEntities.hashCode()));
        result = ((result* 31)+((this.atomicMode == null)? 0 :this.atomicMode.hashCode()));
        result = ((result* 31)+((this.reportMode == null)? 0 :this.reportMode.hashCode()));
        result = ((result* 31)+((this.userId == null)? 0 :this.userId.hashCode()));
        result = ((result* 31)+((this.validationMode == null)? 0 :this.validationMode.hashCode()));
        result = ((result* 31)+((this.enrollments == null)? 0 :this.enrollments.hashCode()));
        result = ((result* 31)+((this.flushMode == null)? 0 :this.flushMode.hashCode()));
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.skipSideEffects == null)? 0 :this.skipSideEffects.hashCode()));
        result = ((result* 31)+((this.skipTextPatternValidation == null)? 0 :this.skipTextPatternValidation.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importStrategy == null)? 0 :this.importStrategy.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerBundleParams) == false) {
            return false;
        }
        TrackerBundleParams rhs = ((TrackerBundleParams) other);
        return (((((((((((((((((this.importMode == rhs.importMode)||((this.importMode!= null)&&this.importMode.equals(rhs.importMode)))&&((this.identifiers == rhs.identifiers)||((this.identifiers!= null)&&this.identifiers.equals(rhs.identifiers))))&&((this.trackedEntities == rhs.trackedEntities)||((this.trackedEntities!= null)&&this.trackedEntities.equals(rhs.trackedEntities))))&&((this.atomicMode == rhs.atomicMode)||((this.atomicMode!= null)&&this.atomicMode.equals(rhs.atomicMode))))&&((this.reportMode == rhs.reportMode)||((this.reportMode!= null)&&this.reportMode.equals(rhs.reportMode))))&&((this.userId == rhs.userId)||((this.userId!= null)&&this.userId.equals(rhs.userId))))&&((this.validationMode == rhs.validationMode)||((this.validationMode!= null)&&this.validationMode.equals(rhs.validationMode))))&&((this.enrollments == rhs.enrollments)||((this.enrollments!= null)&&this.enrollments.equals(rhs.enrollments))))&&((this.flushMode == rhs.flushMode)||((this.flushMode!= null)&&this.flushMode.equals(rhs.flushMode))))&&((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships))))&&((this.skipSideEffects == rhs.skipSideEffects)||((this.skipSideEffects!= null)&&this.skipSideEffects.equals(rhs.skipSideEffects))))&&((this.skipTextPatternValidation == rhs.skipTextPatternValidation)||((this.skipTextPatternValidation!= null)&&this.skipTextPatternValidation.equals(rhs.skipTextPatternValidation))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importStrategy == rhs.importStrategy)||((this.importStrategy!= null)&&this.importStrategy.equals(rhs.importStrategy))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

    @Generated("jsonschema2pojo")
    public enum TrackerBundleReportMode {

        FULL("FULL"),
        ERRORS("ERRORS");
        private final String value;
        private final static Map<String, TrackerBundleParams.TrackerBundleReportMode> CONSTANTS = new HashMap<String, TrackerBundleParams.TrackerBundleReportMode>();

        static {
            for (TrackerBundleParams.TrackerBundleReportMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TrackerBundleReportMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerBundleParams.TrackerBundleReportMode fromValue(String value) {
            TrackerBundleParams.TrackerBundleReportMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum TrackerImportStrategy {

        CREATE("CREATE"),
        UPDATE("UPDATE"),
        PATCH("PATCH"),
        CREATE_AND_UPDATE("CREATE_AND_UPDATE"),
        DELETE("DELETE");
        private final String value;
        private final static Map<String, TrackerBundleParams.TrackerImportStrategy> CONSTANTS = new HashMap<String, TrackerBundleParams.TrackerImportStrategy>();

        static {
            for (TrackerBundleParams.TrackerImportStrategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TrackerImportStrategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerBundleParams.TrackerImportStrategy fromValue(String value) {
            TrackerBundleParams.TrackerImportStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ValidationMode {

        FULL("FULL"),
        FAIL_FAST("FAIL_FAST"),
        SKIP("SKIP");
        private final String value;
        private final static Map<String, TrackerBundleParams.ValidationMode> CONSTANTS = new HashMap<String, TrackerBundleParams.ValidationMode>();

        static {
            for (TrackerBundleParams.ValidationMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValidationMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerBundleParams.ValidationMode fromValue(String value) {
            TrackerBundleParams.ValidationMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
